<?php

namespace App;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use App\DevolucionObras;
use App\CambioObra;

class Credito extends Model
{
    protected $table = 'credito';
    protected $fillable = [
        'cuotainicial',
        'numcuotas',
        'montocuotas',
        'montocomision',
        'porcentajecomision',
        'saldo',
        'saldocuota',
        'cobrador_id',
        'numreporte',
        'valorcomisionable',
        'contrato_id',
        'numcuenta',
        'numdocumento',
        'tipodoc',
        'fechadoc',
        'montodoc',
        'fechacobranza',
        'cuentacomision',
        'estado',
        'fechacuotas',
        'dias',
        'saldo_inicial',
        'diacobrar',
        'vendedor_id',
        'valor_venta',
        'nombre_cliente',
        'tiene_contrato',
        'vendedor_nombre',
        'foto',
        'fecha_terminado'
    ];
    protected $dates = ['fechacobranza', 'fechadoc', 'fechacuotas', 'fecha_terminado'];
    public $timestamps = false;

    public function contrato()
    {
        return $this->belongsTo(Contrato::class, 'contrato_id');
    }
    public function getSaldoActualAttribute()
    {
        //        $pagos=Pago::where('model_type','pago-cobranza')
        //                    ->where('model_id',$this->id)
        //                     ->sum('monto');

        //        $devoluciones=DevolucionObras::where('procedencia','cobranza')
        //                                           ->where('num_cuenta',$this->numcuenta)
        //                                           ->sum('monto_saldo');
        return round($this->saldo, 2);
    }

    public function setFechadocAttribute($fecha)
    {
        $this->attributes['fechadoc'] = Carbon::createFromFormat('d/m/Y', $fecha);
    }

    public function setFechaTerminado($fecha)
    {
        $this->attributes['fecha_terminado'] = Carbon::createFromFormat('d/m/Y', $fecha);
    }

    public function setFechacobranzaAttribute($fecha)
    {
        $this->attributes['fechacobranza'] = Carbon::createFromFormat('d/m/Y', $fecha);
    }
    public function setFechacuotasAttribute($fecha)
    {
        $this->attributes['fechacuotas'] = Carbon::createFromFormat('d/m/Y', $fecha);
    }
    public function cobrador()
    {

        return $this->belongsTo(cobrador::class, 'cobrador_id');
    }

    public function PagosCuotainicial()
    {

        $sql = Pago::where('model_type', 'cuota_inicial')
            ->where('model_id', $this->id)
            ->get();
        return $sql;
    }
    public function saldoCuotaInicial()
    {
        $monto = Pago::where('model_type', 'cuota_inicial')->where('model_id', $this->id)->sum('monto');
        $saldo = $this->cuotainicial;
        if ($monto > 0) {
            $saldo = $this->cuotainicial - $monto;
        }
        return $saldo;
    }
   public function getNumCuenta()
    {
        $numcuenta = DB::table('numcuenta')->max('id') + 1;
        $credito = Credito::where('numcuenta', $numcuenta)->first();

        if (!is_null($credito)) {

            $valid_numcuenta = false;
            $cont = (int) $credito->numcuenta;
            while (!$valid_numcuenta) {
                $cont++;
                $credito = Credito::where('numcuenta', $cont)->first();
                if (is_null($credito)) {
                    $valid_numcuenta = true;
                }
            }
            return $cont;
        }

        return $numcuenta;
    }
    public function ref()
    {
        return $this->hasOne(Referencias::class, 'credito_id', 'id');
    }
    public function getPagos()
    {
        $pagos = Pago::where('model_type', 'pago-cobranza')
            ->where('model_id', $this->id)
            ->orderBy('fecha', 'ASC')
            ->get();
        return $pagos;
    }

    public function saldoMesAnio($mes, $anio)
    {

        $monto_pagos = Pago::whereMonth('fecha', '=', $mes)
            ->whereYear('fecha', '=', $anio)
            ->where('model_id', $this->id)
            ->where('model_type', 'pago-cobranza')
            ->select('monto', 'id', 'fecha', 'numrecibo', 'num_reporte')
            ->sum('monto');

        $porcentaje = \App\Helper\Helper::porcentajeCobro($monto_pagos, $this->montocuotas);


        return ['saldo' => $this->saldo_inicial - $monto_pagos, 'porcentaje' => $this->montocuotas];
    }

    public function calcularCanceladas(Carbon $fecha)
    {
        $result = true;




        if ($this->estado == 'T' || $this->estado == 'I' || $this->saldo <= 0) {


            if (isset($this->fecha_terminado) && !is_null($this->fecha_terminado)) {

                $diff = $this->fecha_terminado->diffInDays($fecha, false);

                if ($diff < 0) {
                    $result = true;
                } else {
                    if ($diff > 31) {
                        $result = false;
                    }
                    $result = false;
                }
            } else {


                if ($this->saldo <= 0) {
                    $result = false;
                } else {

                    $result = true;
                }
            }
        }


        return $result;
    }

    public function calcularSaldoMes($fecha)
    {
        $saldo = $this->saldo_inicial;

        // return dd($fecha);


        if ($this->fecha_terminado != '') {

            $fecha1 = new \DateTime($fecha);
            $fecha2 = new \DateTime($this->fecha_terminado);
            if ($fecha2 <= $fecha1) {
                return true;
            }
        }

        // $fecha2 = $fecha->format('Y-m-d');

        $incobrable = Deudor::where('credito_id', $this->id)
            ->where('fecha_ingreso_vencida', '<=', $fecha)
            ->get();
        if (!is_null($incobrable) && count($incobrable) > 0) {
            return true;
        }


        $cambioObra = CambioObra::where('fecha', '<=', $fecha)
            ->where('estado', 'PROCESADO')
            ->where('credito_id', $this->id)
            ->where('saldo', '<=', 0)
            ->select('saldo')
            ->get();

        if (!is_null($cambioObra) && count($cambioObra) > 0) {
            return true;
        }


        $pagos = Pago::where('model_id', $this->id)
            ->where('model_type', 'pago-cobranza')
            ->where('fecha', '<=', $fecha)
            ->select('monto', 'id');


        foreach ($pagos as $key => $p) {

            $desc = Descuento::where('pago_id', $p->id)->sum('monto');
            $saldo -= $p->monto + $desc;
        }
        if ($saldo <= 0) {
            return true;
        }

        $devoluciones = DevolucionObras::where('fecha', '<=', $fecha)
            ->where('estado', 'PROCESADO')
            ->where('procedencia', 'COBRANZA')
            ->where('num_cuenta', $this->numcuenta)
            ->sum('monto_devolucion');

        $saldo -= $devoluciones;
        if ($saldo <= 0) {
            return true;
        }

        return false;
    }



    public function saldoMesAnio2($mes, $anio)
    {

        $porcentaje = 0;


        $pagos = Pago::whereMonth('fecha', '=', $mes)
            ->whereYear('fecha', '=', $anio)
            ->where('model_id', $this->id)
            ->where('model_type', 'pago-cobranza')
            ->select('monto', 'id', 'fecha', 'numrecibo', 'num_reporte')
            ->orderBy('fecha', 'DESC')->get();

        $descuentos = 0;
        if (count($pagos) > 0) {

            foreach ($pagos as $k => $p) {
                $porcentaje = \App\Helper\Helper::porcentajeCobro($p->monto, $this->montocuotas);
                $descuentos += Descuento::where('pago_id', $p->id)->sum('monto');
            }

            $fup = $pagos->first()->fecha->format('d-m-Y');
            $monto = $pagos->first()->monto;
            $saldo = $this->saldo_inicial - $pagos->sum('monto');
            $monto_cobrado = $pagos->sum('monto') + $descuentos;

            $numrecibo = $pagos->first()->numrecibo;
            $numreporte = $pagos->first()->num_reporte;
        } else {
            $fup = '';
            $monto = 0;
            $saldo = $this->saldo_inicial;
            $monto_cobrado = 0;
            $numrecibo = '';
            $numreporte = '';
        }

        $devoluciones = DevolucionObras::where('procedencia', 'COBRANZA')
            ->where('estado', 'PROCESADO')
            ->whereMonth('fecha', '=', $mes)
            ->whereYear('fecha', '=', $anio)
            ->where('num_cuenta', $this->numcuenta)
            ->orderBy('fecha', 'DESC')
            ->sum('monto_devolucion');




        if (is_null($devoluciones)) {
            $devoluciones = 0;
        }

        $sum_cambio_obra = 0;

        // if($this->id==2632)
        // {

        $cambio = CambioObra::where('estado', 'PROCESADO')
            ->whereMonth('fecha', '=', $mes)
            ->whereYear('fecha', '=', $anio)
            ->where('credito_id', $this->id)
            ->where('monto_tipo_saldo', '>', 0)
            ->whereIn('tipo_saldo', ['DISMINUYE', 'AUMENTA'])
            ->orderBy('fecha', 'DESC')
            ->get();

        if (count($cambio) > 0) {
            foreach ($cambio as $c) {
                if ($c->tipo_saldo == 'DISMINUYE') {
                    $sum_cambio_obra += $c->monto_tipo_saldo;
                } else {
                    $sum_cambio_obra -= $c->monto_tipo_saldo;
                }
            }
        }


        // }
        // if($this->numcuenta=='1653')
        //      {
        //          return dd([
        //    'devoluciones'=>$devoluciones,
        //    'cambio'=>$sum_cambio_obra,
        //     'saldo' => $saldo-$devoluciones+$sum_cambio_obra,
        //     'fup' => $fup,
        //     'ultimo_monto' => $monto,
        //     'monto_cobrado' => $monto_cobrado,
        //     'numrecibo' => $numrecibo,
        //     'numreporte' => $numreporte,
        //     'porcentaje' => $porcentaje
        //          ]);
        //      }   
        if ($devoluciones > $saldo) {
            $diff = 0;
        } else {
            $diff = $saldo - $devoluciones;
        }

        return [
            'devoluciones' => $devoluciones,
            'cambio' => $sum_cambio_obra,
            'saldo' => $diff + $sum_cambio_obra,
            'fup' => $fup,
            'ultimo_monto' => $monto,
            'monto_cobrado' => $monto_cobrado,
            'numrecibo' => $numrecibo,
            'numreporte' => $numreporte,
            'porcentaje' => $porcentaje
        ];
    }

    public function saldoAcumuladoMesAnio($mes, $anio)
    {


        //return dd($mes);
        $fecha = $anio . '-' . $mes . '-31';


        $pagos = Pago::whereBetween('fecha', ['2013-01-01', $fecha])
            ->where('model_id', $this->id)
            ->where('model_type', 'pago-cobranza')
            ->select('monto', 'id', 'fecha', 'numrecibo', 'num_reporte')
            ->orderBy('fecha', 'DESC')->get();

        $devoluciones = DevolucionObras::where('procedencia', 'COBRANZA')
            ->where('estado', 'PROCESADO')
            ->whereBetween('fecha', ['2013-01-01', $fecha])
            ->where('num_cuenta', $this->numcuenta)
            ->sum('monto_devolucion');


        $sum_cambio_obra = 0;

        // if($this->id==2632)
        // {

        $cambio = CambioObra::where('estado', 'PROCESADO')
            ->whereBetween('fecha', ['2013-01-01', $fecha])
            ->where('credito_id', $this->id)
            ->where('monto_tipo_saldo', '>', 0)
            ->whereIn('tipo_saldo', ['DISMINUYE', 'AUMENTA'])
            ->orderBy('fecha', 'DESC')
            ->get();

        if (count($cambio) > 0) {
            foreach ($cambio as $c) {
                if ($c->tipo_saldo == 'DISMINUYE') {
                    $sum_cambio_obra += $c->monto_tipo_saldo;
                } else {
                    $sum_cambio_obra -= $c->monto_tipo_saldo;
                }
            }
        }


        if (count($pagos) > 0) {
            $sum = 0;

            foreach ($pagos as $p) {
                $sum += $desc = Descuento::where('pago_id', $p->id)->sum('monto');
            }

            $fup = $pagos->first()->fecha->format('d-m-Y');
            $monto = $pagos->first()->monto;
            $saldo = (float) $this->saldo_inicial - ($pagos->sum('monto') + $sum + (float) $devoluciones + (float) $sum_cambio_obra);

            $monto_cobrado = $pagos->sum('monto');
        } else {
            $fup = '';
            $monto = 0;
            $saldo = $this->saldo_inicial - ((float) $devoluciones +  (float) $sum_cambio_obra);
            $monto_cobrado = 0;
        }
        if ($saldo < 0) {
            $saldo = 0;
        }

        // if($this->numcuenta=='1653')
        // {

        // return dd(['saldo' => $saldo, 'fup' => $fup, 'ultimo_monto' => $monto, 'monto_cobrado' => $monto_cobrado]);
        return (['saldo' => $saldo, 'fup' => $fup, 'ultimo_monto' => $monto, 'monto_cobrado' => $monto_cobrado]);
        // }
    }

    public function saldoAcumuladoMesAnioDescuento($fecha, $pago_id)
    {



        $pagos = Pago::whereBetween('fecha', ['2013-01-01', $fecha])
            ->where('model_id', $this->id)
            ->where('model_type', 'pago-cobranza')
            ->select('monto', 'id', 'fecha', 'numrecibo', 'num_reporte')
            ->orderBy('fecha', 'DESC')
            ->get();



        if (count($pagos) > 0) {
            $sum = 0;

            foreach ($pagos as $p) {
                $sum += $desc = Descuento::where('pago_id', $p->id)->sum('monto');
            }
            $fup = $pagos->first()->fecha->format('d-m-Y');
            $monto = $pagos->first()->monto;
            $saldo = $this->saldo_inicial - ($pagos->sum('monto') + $sum);
            $monto_cobrado = $pagos->sum('monto');
        } else {
            $fup = $this->fechadoc->format('d-m-Y');
            $monto = 0;
            $saldo = $this->$this->saldo_inicial;
            $monto_cobrado = 0;
        }


        return ['saldo' => $saldo, 'fup' => $fup, 'ultimo_monto' => $monto, 'monto_cobrado' => $monto_cobrado];
    }
}