<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Descuento extends Model
{
    protected  $table='descuentos';
    protected  $fillable=[
            'monto',
            'fecha',
            'credito_id',
            'tipo',
            'pago_id',
    ];
    public $timestamps=false;

    protected $dates=['fecha'];

    public function pago(){
        return $this->belongsTo(Pago::class,'pago_id');
    }

    public function credito(){
        return $this->belongsTo(Credito::class,'credito_id');
    }
}
