<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class DetalleRemision extends Model
{
    protected $table = 'detalle_remision';
    protected $fillable = [
        'obs',
        'cantidad',
        'remision_id',
        'libro_id',
        'codigo',
        'titulo',
        'volumen',

    ];
    public $timestamps = false;


    public function remision()
    {
        return $this->belongsTo(NotasRemision::class, 'remision_id');
    }
    public function libro(){
        return $this->belongsTo(Libro::class,'libro_id');
    }
}
