<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Deudor extends Model
{
    protected  $table = 'deudores';
    protected  $fillable = [
        'nombres',
        'apellidos',
        'tipo_documento',
        'num_documento',
        'lugar_doc',
        'ape_casado',
        'tipo_operacion',
        'tipo_cambio',
        'moneda',
        'monto_original_deuda',
        'concepto',
        'tipo_doc_deuda',
        'num_doc_deuda',
        'saldo_deuda_vigente',
        'saldo_deuda_vencida',
        'cobrador',
        'fecha_ingreso_vencida',
        'razon_social',
        'obs',
        'credito_id',
        'estado',
        'fecha_cancelado'
    ];
    protected $dates = ['fecha_ingreso_vencida'];
    public $timestamps = false;

    public function getNombreCompletoAttribute()
    {
        return $this->nombres . ' ' . $this->apellidos;
    }
}