<?php

namespace App\Exports;

use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;

class KardexMayorExport implements FromView
{

    private $data;
    private $mes;
    private $anio;
    private $codigo;
    private $saldo_ant;
    private $saldo_act;
    private $libro;
    private $ventas_ant;
    private $diferidos_ant;
    function __construct($data, $mes, $anio, $codigo, $saldo_ant, $saldo_act, $libro, $ventas_ant, $diferidos_ant)
    {
        $this->data = $data;
        $this->mes = $mes;
        $this->fecha2 = $anio;
        $this->codigo = $codigo;
        $this->saldo_ant = $saldo_ant;
        $this->saldo_act = $saldo_act;
        $this->libro = $libro;
        $this->ventas_ant = $ventas_ant;
        $this->diferidos_ant = $diferidos_ant;
    }
    public function view(): View
    {
        return view(
            'almacen.reportes.tabla-kardexmayor',
            [
                'datos' => $this->data,
                'estilos' => false,
                'mes' => $this->mes,
                'anio' => $this->anio,
                'codigo' => $this->codigo,
                'saldo_ant' => $this->saldo_ant,
                'saldo_act' => $this->saldo_act,
                'libro' => $this->libro,
                'ventas_ant' => $this->ventas_ant,
                'diferidos_ant' => $this->diferidos_ant
            ]
        );
    }
}
