<?php

namespace App;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class Factura extends Model
{

protected $table='facturas';
protected  $fillable=[
            'fecha',
        'monto',
        'nombres',
        'cinit',
        'descripcion',
        'numero',
        'model_id',
        'model_type',

];
public $timestamps=false;

    public $dates=['fecha'];
    public function setFechaAttribute($fecha)
    {
        $this->attributes['fecha']=Carbon::createFromFormat('d/m/Y',$fecha);
    }

public function  pago(){
    return $this->hasOne(Pago::class,'id','model_id');
}

public static function pagosCuotaInicial($pago_id){
    $sql=self::where('model_type','pagos')
             ->where('model_id',$pago_id)
            ->first();
    return $sql;
}



}
