<?php

namespace App\Http\Controllers;

use App\Categoria;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Barryvdh\DomPDF\Facade as PDF;
use App\Exports\CategoriasExport;


class CategoriaController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {

        $categorias =Categoria::orderBy('codigo','ASC')->get();

        if(isset($request->exportar)){
        if($request->exportar=='excel') {
            return \Excel::download(new CategoriasExport($categorias), 'lista-categorias.xlsx');

        }
        elseif ($request->exportar=='pdf'){
            $pdf = PDF::loadView('categorias.exportar',[
                'categorias' => $categorias,
                'estilos'=>true,

            ]);
            $pdf->setPaper('a4', 'portrait');
//            $pdf->setPaper([0, 0,650, 270], 'portrait');
//            $pdf->output();
//            $dom_pdf = $pdf->getDomPDF();
//            $pdf->set_paper(array(0,0,1000,3000));

//            return $pdf->download('saldos_socios.pdf');

            return $pdf->stream('Categorias');

        }
    }
        return  view('categorias.index',[
            'categorias'=>$categorias
        ]);

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try{
            if(isset($request->id))
                $categoria=Categoria::find($request->id);
            else
                $categoria= new Categoria();


            $categoria->codigo=$request->codigo;
            $categoria->descripcion=$request->descripcion;
            $categoria->save();

            Session::flash('success','La categoria se guardo correctamente.');

        }
        catch (\Exception $e){
            Session::flash('error','Existio un error al guardar la Categoria');


        }

        return redirect('categorias');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Categoria  $categoria
     * @return \Illuminate\Http\Response
     */
    public function show(Categoria $categoria)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Categoria  $categoria
     * @return \Illuminate\Http\Response
     */
    public function edit(Categoria $categoria)
    {

        return view('categorias.create_edit',[
            'categoria'=>$categoria,

        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Categoria  $categoria
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Categoria $categoria)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Categoria  $categoria
     * @return \Illuminate\Http\Response
     */
    public function destroy(Categoria $categoria)
    {
        try{
            $categoria->libros()->delete();
            $categoria->delete();
            Session::flash('success','La categoria se Elimino correctamente');

        }
        catch (\Exception $e){
            Session::flash('error','Exisitio un error al borrar la categoria');
        }

        return  redirect('categorias');
    }
}
