<?php

namespace App\Http\Controllers;

use App\Deudor;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use App\Recibo;
use App\Pago;
use Illuminate\Support\Facades\DB;

class CentralRiesgoController extends Controller
{

    public function mantenimiento(Request $request)
    {


        if (isset($request->deuda_id)) {

            $deuda = Deudor::find($request->deuda_id);
            $credito = null;
            $pagos = null;
            $devoluciones = null;
            $descuentos = [];


            if ($deuda->credito_id != '') {
                $credito = \App\Credito::find($deuda->credito_id);
                $pagos = \App\Pago::where('model_type', 'pago-cobranza')
                    ->where('model_id', $request->credito_id)
                    ->orderBy('fecha', 'ASC')
                    ->get();



                $descuentos = \App\Descuento::where('credito_id', $credito->id)->orderBy('fecha', 'ASC')->get();

                $devoluciones = \App\DevolucionObras::where('procedencia', 'COBRANZA')->where('num_cuenta', $credito->numcuenta)->orderBy('fecha', 'ASC')->get();
            }


            return view('central_riesgo.mantenimiento', [
                'deuda' => $deuda,
                'credito' => $credito,
                'pagos' => $pagos,
                'devoluciones' => $devoluciones,
                'descuentos' => $descuentos,

            ]);
        }

        return view('central_riesgo.mantenimiento');
    }
    public function pagoStore(Request $request)
    {

        try {

            DB::beginTransaction();
            $p = new Pago();
            $p->fecha = $request->fecha;
            $p->num_reporte = $request->reporte;
            $p->estado = 'T';
            $p->numrecibo = $request->numrecibo;
            $p->terminado = 1;
            $p->obs = $request->obs;
            $p->model_type = 'pago-deuda';
            $p->model_id = $request->deuda_id;
            $p->tipo_documento = 'RECIBO';
            $p->monto = $request->monto;
            $p->save();

            $recibo = new Recibo();
            $recibo->monto = $request->monto;
            $recibo->fecha = $request->fecha;
            $recibo->descripcion = 'PAGO DEUDA';
            $recibo->nombres = $request->nombres;
            $recibo->numero = $request->numrecibo;
            $recibo->model_id = $p->id;
            $recibo->model_type = 'pagos';
            $recibo->save();

            $deuda = Deudor::find($request->deuda_id);
            $deuda->estado = 'T';
            $deuda->save();
            $deuda->fecha_cancelado = $p->fecha;
            $deuda->save();



            DB::commit();
            session()->flash('success', 'El pago se registro correctamente!!!');
        } catch (\Exception $e) {
            DB::rollBack();
            session()->flash('error', 'Ocurrio un error al registrar el pago.');
        }

        return redirect()->back();
    }

    public function index()
    {
        $deudores = Deudor::orderBy('apellidos', 'ASC')->get();
        return view('central_riesgo.index', [
            'deudores' => $deudores
        ]);
    }
    public function store(Request $request)
    {
        try {
            if (isset($request->id)) {
                $deudor = Deudor::find($request->id);
            } else {
                $deudor = new Deudor();
            }
            $deudor->nombres = $request->nombres;
            $deudor->apellidos = $request->apellidos;
            $deudor->tipo_documento = "CARNET";
            // $deudor->tipo_documento = $request->tipo_documento;
            $deudor->num_documento = $request->num_documento;
            $deudor->lugar_doc = $request->lugar_doc;
            $deudor->ape_casado = $request->ape_casado;
            $deudor->tipo_operacion = $request->tipo_operacion;
            // $deudor->moneda = $request->moneda;
            $deudor->monto_original_deuda = $request->monto_original_deuda;
            // $deudor->concepto = $request->concepto;
            // $deudor->tipo_doc_deuda = $request->tipo_doc_deuda;
            $deudor->tipo_doc_deuda = "CONTRATO";
            $deudor->num_doc_deuda = $request->num_doc_deuda;
            $deudor->saldo_deuda_vigente = $request->saldo_deuda_vigente;
            $deudor->saldo_deuda_vencida = $request->saldo_deuda_vencida;
            // $deudor->cobrador = $request->cobrador;
            $deudor->fecha_ingreso_vencida = Carbon::createFromFormat('d/m/Y', $request->fecha_ingreso_vencida)->format('Y-m-d');
            // $deudor->razon_social = $request->razon_social;
            $deudor->obs = $request->obs;
            $deudor->estado = 'A';
            $deudor->save();
            Session::flash('success', 'Se Guardo correctamente el registro');
        } catch (\Exception $e) {
            Session::flash('error', 'Ocurrio un error');
        }
        return redirect('central-riesgos');
    }
    public function edit(Deudor $deudor)
    {

        return view('central_riesgo.create_edit', [
            'deudor' => $deudor,


        ]);
    }
    public function delete(Deudor $deudor)
    {
        try {
            $deudor->delete();
            Session::flash('success', 'El registro se elimino correctamente');
        } catch (\Exception $e) {
            Session::flash('error', 'Ocurrio un error');
        }
        return redirect('central-riesgos');
    }

    public function importar(Request $request)
    {
        $file = $request->file('file');


        //obtenemos el nombre del archivo
        $nombre = $file->getClientOriginalName();

        //indicamos que queremos guardar un nuevo archivo en el disco local
        \Storage::disk('imports')->put($nombre,  \File::get($file));


        \Excel::load(\Storage::disk('imports')->path('/' . $nombre), function ($reader) {

            foreach ($reader->get() as $fila) {
                try {
                    // dd($fila);
                    if (isset($fila->nro_ci) && trim($fila->nro_ci) != "" && !is_null($fila->mora_desde)) {

                        \Illuminate\Support\Facades\DB::beginTransaction();



                        $d = new \App\Deudor();
                        $d->nombres = $fila->primer_nombre . ' ' . $fila->segundo_nombre . ' ' . $fila->tercer_nombre;
                        $d->apellidos = $fila->apellido_paterno . ' ' . $fila->apellido_materno;
                        $d->tipo_documento = 'CARNET';
                        $d->num_documento = $fila->nro_ci;
                        $d->lugar_doc = $fila->ext;
                        $d->ape_casado = $fila->apellido_casada;
                        $d->tipo_operacion = $fila->cuenta;
                        //$d->tipo_cambio = $fila->tipo_cambio;
                        //$d->moneda = $fila->moneda;
                        $d->monto_original_deuda = $fila->monto_original;
                        //$d->concepto = $fila->concepto;
                        //$d->tipo_doc_deuda = $fila->tipo_doc_deuda;
                        $d->num_doc_deuda = $fila->nro_contrato;
                        $d->saldo_deuda_vigente = $fila->valor_deuda;
                        $d->saldo_deuda_vencida = $fila->valor_deuda;
                        //$d->fecha_ingreso_vencida =  \Carbon\Carbon::createFromFormat("d/m/y", $fila->mora_desde);
                        $d->fecha_ingreso_vencida =   $fila->mora_desde->format('Y-m-d');
                        $d->obs =   $fila->observaciones;
                        // $d->razon_social = $fila->razon_social;
                        $d->estado = 'A';
                        $d->save();
                        \DB::commit();
                    } else {
                        continue;
                    }
                } catch (Exception $e) {

                    \DB::rollBack();
                    Session::flash('error', 'Ocurrio un error');
                }
            }
        });
        Session::flash('success', 'se importo correctamente el archivo');
        return redirect('central-riesgos');
    }
}