<?php

namespace App\Http\Controllers;

use App\CierreApertura;
use Illuminate\Http\Request;

class CierreAperturaController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
    
        $datos=CierreApertura::orderBy('mes','DESC')->orderBy('anio','DESC')->get();
        return view('cierres.index',[
          'datos'=>$datos
        ]);

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if(isset($request->id)){
            $cierre=CierreApertura::find($request->id);

        }
        else{
            $cierre= new CierreApertura();
        }

        $cierre->mes=$request->mes;
      $cierre->anio=$request->anio;
      $cierre->estado=$request->estado;
      $cierre->modulo=$request->modulo;
      $cierre->save();

      session()->flash('success','El registro se guardo correctamente');

      return  redirect('cierres');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\CierreApertura  $cierreApertura
     * @return \Illuminate\Http\Response
     */
    public function show(CierreApertura $cierreApertura)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\CierreApertura  $cierreApertura
     * @return \Illuminate\Http\Response
     */
    public function edit(CierreApertura $cierre)
    {
        return view('cierres.create_edit',[
             'cierre'=>$cierre
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\CierreApertura  $cierreApertura
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, CierreApertura $cierreApertura)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\CierreApertura  $cierreApertura
     * @return \Illuminate\Http\Response
     */
    public function destroy(CierreApertura $cierre)
    {
        $cierre->delete();
        session()->flash('success','El registro se elimino correctamente');

      return  redirect('cierres');
    }
}
