<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Str;


class ConfiguracionController extends Controller
{
    //

    public function index(){

        $config=\DB::table('config')->where('id',1)->first();
        return view('configuraciones.index',[
            'config'=>$config
        ]);
    }

    public function store(Request $request){
    
               $validator = \Validator::make($request->all(), [
                       'logo' => 'image|mimes:jpeg,png,jpg,gif,svg|max:2048',

        ]);


        if ($validator->fails()) {
         session()->flash('error','La imagen es muy grande o no tiene el formato requerido');

        
               return redirect()->back();
                     
        }

        try{
            if($request->hasFile('logo')){

         $nombre = Str::random(3).'.'.$request->logo->getClientOriginalExtension();

         $request->logo->move(public_path('assets/images/'), $nombre);
            

         \DB::table('config')->where('id',1)->update([
             'logo'=>$nombre,
             'nombre_empresa'=>$request->nombre_empresa,
             'cobranza_estandar'=>$request->cobranza_estandar,
         ]);
            }
            else{
               \DB::table('config')->where('id',1)->update([
            
             'nombre_empresa'=>$request->nombre_empresa,
             'cobranza_estandar'=>$request->cobranza_estandar,
         ]);  
            }
         
         

         
            
            session()->flash('success','Los datos se guardaron correctamente');
             return redirect('referencias')->with($request);


        }
        catch(\Exception $e){

            // return dd($e);
              session()->flash('error','Ocurrio un error');

            return redirect()->back();

        }

    }
}
