<?php
namespace App\Http\Controllers;
use App\cobrador;
use App\Contrato;
use App\Credito;
use App\Cuota;
use App\DetalleContrato;
use App\DetalleDevolucionObras;
use App\Deudor;
use App\DevolucionObras;
use App\Factura;
use App\Helper\Helper;
use App\Kardex;
use App\Libro;
use App\NotasRemision;
use App\Pago;
use App\Recibo;
use App\Vendedor;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use PHPUnit\Framework\MockObject\Stub\Exception;
use App\CierreApertura;
class ContratoController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function verKardex(Contrato $contrato)
    {
    }
    public function diferidosStore(Request $request)
    {
        //return dd($request->all());
        try {
            DB::beginTransaction();
            $saldo = (float) $request->precio_total - (float) $request->cuota_ini;
            if ($request->contrato_id) {
                $c = Contrato::find($request->contrato_id);
                $c->detalle()->delete();
                $cre = $c->credito;
                try {
                    if ($c->terminado == 0 && $c->estado == '') {
                        if ($c->idchofer == $c->idvendedor) {
                            Kardex::where('contrato_id', $c->id)
                                ->where('vendedor_id', $c->idchofer)
                                ->where('estado', 'Diferido')
                                ->whereIn('cargo', [0, 1])
                                ->update([
                                    'estado' => 'Remitido',
                                    'contrato_id' => null,
                                    'traspaso' => 0,
                                    'num_contrato' => ''
                                ]);
                            // DB::commit();
                            // return dd('update diferidos');
                        } else {
                            Kardex::where('contrato_id', $c->id)
                                ->where('vendedor_id', $c->idchofer)
                                ->update([
                                    'estado' => 'Remitido',
                                    'contrato_id' => null,
                                    'traspaso' => 0,
                                    'num_contrato' => ''
                                ]);
                            Kardex::where('contrato_id', $c->id)
                                ->where('vendedor_id', $c->idvendedor)
                                ->delete();
                        }
                    }
                } catch (Exception $e) {
                    DB::rollback();
                    Session::flash('error', 'Existio al guardar el contrato');
                    return redirect()->back();
                }
            } else {
                $cre = new Credito();
                $c = new Contrato();
            }
            $c->numcontrato = $request->numcontrato;
            $c->tipocontrato = 'DIFERIDO';
            $c->fechacontrato = $request->fecha;
            $c->localidad = strtoupper($request->localidad);
            $c->preciototal = $request->precio_total;
            $c->tipoventa = $request->tipo;
            $c->idvendedor = $request->vendedor_id;
            $c->idchofer = $request->chofer_id;
            $c->nombres = strtoupper($request->nombres);
            $c->apellidopaterno = strtoupper($request->paterno);
            $c->apellidomaterno = strtoupper($request->materno);
            $c->ci = $request->carnet;
            if ($request->contrato_id) {
                if ($c->estado == 'procesado' && $c->terminado == 1) {
                    $c->terminado = 1;
                }
            } else {
                $c->terminado = 0;
            }
            $c->user_id = auth()->user()->id;
            $c->save();
            $sw = true;
            foreach ($request->libro_id as $k => $v) {
                $d = new DetalleContrato();
                $libro = Libro::find($v);
                $d->cantidad = $request->cant[$k];
                $d->codigo = $libro->codigo;
                $d->titulo = $libro->titulo;
                $d->volumen = $libro->tomo;
                $d->precio_unitario = $request->pu[$k];
                $d->contrato_id = $c->id;
                $d->libros_id = $v;
                $d->sw = 0;
                $d->save();
                if ($c->terminado == 0 && $c->estado == '') {
                    $asignacion = Kardex::asignarDiferido($d->codigo, $d->cantidad, $c);
                    if (!$asignacion) {
                        $sw = false;
                        break;
                    }
                }
            }
            if (!$sw) {
                DB::rollBack();
                Session::flash('error', 'Existio un error en la asignacion de los items a estado Diferido   en el kardex del vendedor .');
                return redirect()->back();
            }
            if ($request->tipo == 'credito') {
                if ($request->tipocomisioncredito == "P") {
                    $cre->montocomision = $request->valorcomisioncredito * $request->comisionable_credito / 100;
                    $cre->porcentajecomision = $request->valorcomisioncredito;
                }
                if ($request->tipocomisioncredito == "M") {
                    $cre->montocomision = $request->valorcomisioncredito;
                    $cre->porcentajecomision = ($request->valorcomisioncredito / $request->comisionable_credito) * 100;
                }
                $cre->cuotainicial = $request->cuota_ini;
                $cre->numcuotas = $request->num_pagos;
                $cre->valorcomisionable = $request->comisionable_credito;
                $cre->saldo = $saldo;
                if ($cre->saldo > 0) {
                    //    $montocuotas= round($cre->saldo/$cre->numcuotas,0, PHP_ROUND_HALF_UP);
                    $montocuotas = ceil($cre->saldo / $cre->numcuotas);
                }
                $cre->montocuotas = $montocuotas;
                $cre->cuentacomision = $request->cuentacomision;
                $cre->saldocuota = $request->cuota_ini;
                $cre->cobrador_id = $request->cobrador_id;
                $cre->fechacobranza = $request->fecha_cobro;
                $cre->cuentacomision = $request->cuenta_comision;
            }
            if ($request->tipo == 'contado') {
                $saldo_contado = (float) $request->precio_total - (float) $request->cancelado_contado;
                $cre->cuotainicial = $request->cancelado_contado;
                $cre->numcuotas = 1;
                if ($request->tipocomisioncontado == "P") {
                    $cre->montocomision = ($request->valorcomisioncontado * $request->comisionable_contado) / 100;
                    $cre->porcentajecomision = $request->valorcomisioncontado;
                }
                if ($request->tipocomisioncontado == "M") {
                    $cre->montocomision = $request->valorcomisioncontado;
                    $cre->porcentajecomision = ($request->valorcomisioncontado / $request->comisionable_contado) * 100;
                }
                $cre->saldo = $saldo_contado;
                $cre->saldocuota = 0;
                $cre->cobrador_id = 0;
                $cre->numreporte = "";
                $cre->fechacobranza = $request->fecha;
                $cre->valorcomisionable = $request->comisionable_contado;
                $cre->cuentacomision = $request->cuentacomision_contado;
            }
            $cre->contrato_id = $c->id;
            $cre->estado = 'G';
            $cre->save();
            DB::commit();
            Session::flash('success', 'El contrato se guardo correctamente');
        } catch (\Exception $e) {
            DB::rollBack();
            Session::flash('error', 'Ocurrio un error al guardar el contrato');
            return dd($e);
        }
        $url = "diferidos?tipo=mes&mes=" . $c->fechacontrato->month . "&anio=" . $c->fechacontrato->year . "&fecha_ini=&fecha_fin=&fecha_acumulado=&buscar=buscar";
        return redirect($url);
    }
    public function diferidosCreate(Request $request)
    {
        $vendedor = Vendedor::find($request->vendedor);
        $chofer = Vendedor::find($request->chofer);
        $cobradores = cobrador::orderBy('nombres', 'ASC')->get();
        $edit = false;
        $fecha = Carbon::createFromFormat('d/m/Y', $request->fecha);
        $libros = Kardex::CargosVendedorDevolucion($chofer->id, $fecha->month, $fecha->year);
        return view('ventas.diferidos.create_edit', [
            'fecha' => $fecha,
            'vendedor' => $vendedor,
            'chofer' => $chofer,
            'libros' => $libros,
            'edit' => $edit,
            'cobradores' => $cobradores,
            'numcontrato' => $request->num_contrato,
            'carnet' => $request->num_carnet,
            'procesado' => false
        ]);
    }
    public function diferidosBorrar(Contrato $contrato)
    {
        try {
        
            DB::beginTransaction();
            if ($contrato->idchofer == $contrato->idvendedor) {
              
                Kardex::where('contrato_id', $contrato->id)
                    ->where('vendedor_id', $contrato->idchofer)
                    ->update([
                        'estado' => 'Remitido',
                        'contrato_id' => null,
                        'traspaso' => 0,
                        'num_contrato' => ''
                    ]);
            } else {
                Kardex::where('contrato_id', $contrato->id)
                    ->where('vendedor_id', $contrato->idchofer)
                    ->update([
                        'estado' => 'Remitido',
                        'contrato_id' => null,
                        'traspaso' => 0,
                        'num_contrato' => ''
                    ]);
                Kardex::where('contrato_id', $contrato->id)
                    ->where('vendedor_id', $contrato->idvendedor)
                    ->delete();
            }
            $contrato->detalle()->delete();
            $contrato->delete();
            DB::commit();
            Session::flash('success', 'El contrato elimino correctamente');
            return redirect()->back();
        } catch (\Exception $e) {
            DB::rollBack();
            Session::flash('error', 'Ocurrio un error al eliminar el contrato');
            return redirect()->back();
        }
    }
    public function diferidosEditar(Contrato $contrato)
    {
        $cobradores = cobrador::orderBy('nombres', 'ASC')->get();
        $edit = true;
        $fecha = $contrato->fechacontrato;
        $procesado = false;
        $libros = Kardex::CargosVendedorDevolucion($contrato->chofer->id, $fecha->month, $fecha->year);
        if ($contrato->estado == 'procesado' && $contrato->terminado == 1) {
            $procesado = true;
        }
        return view('ventas.diferidos.create_edit', [
            'libros' => $libros,
            'edit' => $edit,
            'cobradores' => $cobradores,
            'numcontrato' => $contrato->numcontrato,
            'carnet' => $contrato->ci,
            'contrato' => $contrato,
            'fecha' => $fecha,
            'vendedor' => $contrato->vendedor,
            'chofer' => $contrato->chofer,
            'credito' => $contrato->credito,
            'procesado' => $procesado
        ]);
    }
    public function validarNumContrato($num)
    {
        $sql = Contrato::where('numcontrato', $num)->where('tipocontrato', '!=', 'BAJA')->first();
        $status = false;
        $datos = [];
        if (!is_null($sql)) {
            $status = true;
            $datos = $sql;
        }
        return response()->json([
            'status' => $status,
            'datos' => $sql
        ]);
    }
    public function validarCarnet($num)
    {
        $sql = Deudor::where('num_documento', $num)->where('estado', 'A')->first();
        $status = false;
        $datos = [];
        if (!is_null($sql)) {
            $status = true;
            $datos = $sql;
        }
        return response()->json([
            'status' => $status,
            'datos' => $datos
        ], 200);
    }
    public function diferidos(Request $request)
    {
        $datos = [];
        $tipo = "mes";
        $fecha_ini = Carbon::now();
        $fecha_fin = Carbon::now();
        $fecha_acumulado = Carbon::now();
        $mes = date('m');
        $anio = date('Y');
        if ($request->buscar == 'buscar') {
            $tipo = $request->tipo;
            if ($request->tipo == 'mes') {
                $mes = $request->mes;
                $anio = $request->anio;
                $datos = Contrato::where('tipocontrato', 'DIFERIDO')
                    ->whereMonth('fechacontrato', '=', $request->mes)
                    ->whereYear('fechacontrato', '=', $request->anio)
                    ->orderBy('updated_at', 'DESC')->get();
            }
            if ($request->tipo == 'rango') {
                $fecha_ini = Carbon::createFromFormat('d/m/Y', $request->fecha_ini);
                $fecha_fin = Carbon::createFromFormat('d/m/Y', $request->fecha_fin);
                $datos = Contrato::where('tipocontrato', 'DIFERIDO')
                    ->whereBetween('fechacontrato', [$fecha_ini->format('Y-m-d'), $fecha_fin->format('Y-m-d')])
                    ->orderBy('updated_at', 'DESC')->get();
            }
            if ($request->tipo == 'acumulado') {
                $fecha = '2013-01-01';
                $fecha_acumulado = Carbon::createFromFormat('d/m/Y', $request->fecha_acumulado);
                $datos = Contrato::where('tipocontrato', 'DIFERIDO')
                    ->whereBetween('fechacontrato', [$fecha, $fecha_acumulado->format('Y-m-d')])
                    ->orderBy('updated_at', 'DESC')->get();
            }
        } else {
            $fecha_actual = Carbon::now();
            $mes = $fecha_actual->month;
            $anio = $fecha_actual->year;
            $datos = Contrato::where('tipocontrato', 'DIFERIDO')
                ->whereMonth('fechacontrato', '=', $mes)
                ->whereYear('fechacontrato', '=', $anio)
                ->orderBy('updated_at', 'DESC')
                ->get();
        }
        $vendedores = Vendedor::orderBy('nombres', 'ASC')->get();
        return view('ventas.diferidos.index', [
            'vendedores' => $vendedores,
            'datos' => $datos,
            'tipo' => $tipo,
            'mes' => $mes,
            'anio' => $anio,
            'fecha_ini' => $fecha_ini,
            'fecha_fin' => $fecha_fin,
            'fecha_acumulado' => $fecha_acumulado,
        ]);
    }
    public function diferidosVer(Contrato $contrato)
    {
        return view('ventas.diferidos.ver', [
            'contrato' => $contrato
        ]);
    }
    public function diferidosVerNumContrato($contrato)
    {
        $contrato = Contrato::where('numcontrato', $contrato)->first();
        return view('ventas.diferidos.ver', [
            'contrato' => $contrato
        ]);
    }
    public function diferidosDevolucionCreate(Contrato $contrato)
    {
        return view('ventas.diferidos.devolucion_create', [
            'contrato' => $contrato
        ]);
    }
    public function diferidosDevolucionStore(Request $request)
    {
        try {
            // return dd($request->all());
            DB::beginTransaction();
            $dev = new DevolucionObras();
            $dev->fecha = $request->fecha;
            $dev->estado = 'almacen';
            $dev->tipo_devolucion = $request->tipo;
            $dev->obs = $request->obs;
            $dev->user_id = Auth::user()->id;
            $dev->contrato_id = $request->contrato_id;
            $dev->procedencia = 'VENTAS';
            if ($request->tipo == 'PARCIAL') {
                $dev->fecha_remision = Carbon::createFromFormat('d/m/Y', $request->fecha)->format('Y-m-d');
            }
            $dev->save();
            $contrato = Contrato::find($request->contrato_id);
            $contrato->estado = 'ALMACEN';
            $contrato->save();
            foreach ($request->libros_id as $k => $v) {
                $detalle = new DetalleDevolucionObras();
                $detalle->cantidad = $request->cantidad[$k];
                $detalle->codigo = $request->codigo[$k];
                $detalle->titulo = $request->titulo[$k];
                $detalle->volumen = 1;
                $detalle->precio_unitario = $request->precio_unitario[$k];
                $detalle->precio_total = $request->precio_total[$k];
                $detalle->libro_id = $v;
                $detalle->devolucionobras_id = $dev->id;
                if (in_array($v, $request->cb)) {
                    $detalle->sw = 1;
                } else {
                    $detalle->sw = 0;
                }
                //    if(isset($request->cb[$k]) && !is_null($request->cb[$k])){
                //         $detalle->sw =1;
                //     }
                //     else{
                //        $detalle->sw=0;
                //     }
                $detalle->save();
            }
            DB::commit();
            Session::flash('success', 'La devolucion se ha registrado Exitosamente');
        } catch (\Exception $e) {
            Session::flash('error', 'Ocurrio un error al registrar la devolucion. Intente nuevamente porfavor.');
            DB::rollBack();
            return dd($e);
            return redirect()->back();
        }
        return redirect('devolucion-contratos/' . $dev->id . '/ver-notas');
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }
    public function validarDisponible(Contrato $contrato)
    {
        // $faltantes = $contrato->validarDisponibles();
        // if (!empty($faltantes)) {
        //     return response()->json([
        //         'status' => false,
        //         'datos' => $faltantes
        //     ], 200);
        // } else {
        return response()->json([
            'status' => true,
            'credito' => $contrato->credito->toArray(),
            'contrato' => $contrato->toArray(),
        ], 200);
        // }
    }
    public function asignarVentaKardex($numcontrato)
    {
        try {
            DB::beginTransaction();
            $contrato = Contrato::where('numcontrato', $numcontrato)->first();
            // return dd($contrato);
            if (isset($contrato)) {
                foreach ($contrato->detalle as $d) {
                    $result = true;
                    $filas_kardex = Kardex::select('cod_libro', 'fechakardex', 'fecha_remision', 'id')
                        ->where('vendedor_id', $contrato->idchofer)
                        ->where('cod_libro', $d->codigo)
                        ->whereMonth('fechakardex', '=', $contrato->fechacontrato->month)
                        ->whereYear('fechakardex', '=', $contrato->fechacontrato->year)
                        ->where('estado', 'Remitido')
                        ->whereIn('cargo', [1, 0])
                        ->take($d->cantidad)
                        ->orderBy('fecha_remision', 'ASC')
                        ->get();
                    if (count($filas_kardex) > 0 && count($filas_kardex) == $d->cantidad) {
                        if ($contrato->idchofer == $contrato->idvendedor) {
                            foreach ($filas_kardex as $f) {
                                $kardex = Kardex::find($f->id);
                                $kardex->num_contrato = $contrato->numcontrato;
                                $kardex->estado = 'Venta';
                                $kardex->contrato_id = $contrato->id;
                                $kardex->save();
                            }
                        } else {
                            foreach ($filas_kardex as $f) {
                                $kardex = Kardex::find($f->id);
                                $k2 = $kardex->replicate();
                                $kardex->num_contrato = $contrato->numcontrato;
                                $kardex->estado = 'Venta';
                                $kardex->contrato_id = $contrato->id;
                                $kardex->vendedor_id = $contrato->idvendedor;
                                $kardex->save();
                                $k2->estado = 'Traspaso';
                                $k2->num_contrato = $contrato->numcontrato;
                                $k2->contrato_id = $contrato->id;
                                $k2->traspaso = 1;
                                $k2->save();
                            }
                        }
                    }
                }
                DB::commit();
                return "procesado:" . $numcontrato;
            }
        } catch (\Exception $e) {
            DB::rollBack();
            return dd($e);
        }
    }
    public function procesarDiferido(Request $request)
    {
        $contrato = Contrato::find($request->contrato_id);
        $url = "diferidos?tipo=mes&mes=" . $contrato->fechacontrato->month . "&anio=" . $contrato->fechacontrato->year . "&fecha_ini=&fecha_fin=&fecha_acumulado=&buscar=buscar&id=" . $contrato->id;
        try {
            $sw = true;
            DB::beginTransaction();
            $contrato->estado = 'procesado';
            $contrato->terminado = 1;
            $contrato->save();
            Session::flash('success', 'Esl contrato se proceso  correctamente.');
            DB::commit();
        } catch (\Exception $e) {
            return dd($e);
            Session::flash('error', 'Existio un error al procesar la nota. Intente nuevamente porfavor.');
            DB::rollBack();
        }
        return redirect($url);
    }
    public function procesar(Contrato $contrato, Request $request)
    {
        $url = "diferidos?tipo=mes&mes=" . $contrato->fechacontrato->month . "&anio=" . $contrato->fechacontrato->year . "&fecha_ini=&fecha_fin=&fecha_acumulado=&buscar=buscar";
        try {
            if ($request->method() == 'POST') {
                $contrato = Contrato::find($request->contrato_id);
            }
            $sw = true;
            DB::beginTransaction();
            foreach ($contrato->detalle as $k => $d) {
                $asignacion = Kardex::asignarDiferido($d->codigo, $d->cantidad, $contrato);
                if (!$asignacion) {
                    $sw = false;
                    break;
                }
            }
            if (!$sw) {
                DB::rollBack();
                Session::flash('error', 'Existio un error en la asignacion de los items a estado Diferido   en el kardex del vendedor .');
                return redirect($url);
            }
            $contrato->estado = 'procesado';
            $contrato->terminado = 1;
            $contrato->save();
            Session::flash('success', 'El contrato se proceso  correctamente.');
            DB::commit();
        } catch (\Exception $e) {
            return dd($e);
            Session::flash('error', 'Existio un error al procesar la nota. Intente nuevamente porfavor.');
            DB::rollBack();
        }
        //        return redirect($url);
    }
    public function eliminarPago(Pago $pago)
    {
        try {
            $pago->delete();
            Session::flash('success', 'El Pago se elimino correctamente');
        } catch (\Exception $e) {
            Session::flash('success', 'Ocurrio un error al eliminar el pago');
        }
        return redirect()->back();
    }
    public function registrarVenta(Contrato $contrato)
    {
        if ($contrato->tipocontrato != 'DIFERIDO' && $contrato->terminado != 1) {
            Session::flash('warning', 'No se puede registrar la venta. Procese el contrato');
            return redirect()->back();
        }
        return view('ventas.registrar_venta', [
            'contrato' => $contrato
        ]);
    }
    public function procesarVentaPost(Request $request)
    {
        try {
            DB::beginTransaction();
            $contrato = Contrato::find($request->contrato_id);
            $pago = new Pago();
            $pago->monto = $request->montoventa;
            $pago->fecha = $request->fechaventa;
            $pago->num_reporte = $request->num_reporte;
            $pago->tipo_documento = $request->tipodocventa;
            $pago->model_type = 'cuota_inicial';
            $pago->model_id = $request->idcredito;
            $pago->estado = 'T';
            $pago->terminado = 1;
            $pago->save();
            $numdocumento = '';
            if ($request->tipodocventa == 'RECIBO') {
                $recibo = new Recibo();
                $recibo->monto = $request->montoventa;
                $recibo->fecha = $request->fechaventa;
                $recibo->nombres = $request->nombres;
                $recibo->numero = $request->numero;
                $recibo->model_id = $pago->id;
                $recibo->model_type = 'pagos';
                $recibo->save();
                $numdocumento = $recibo->numero;
            } elseif ($request->tipodocventa == 'FACTURA') {
                $factura = new Factura();
                $factura->fecha = $request->fechaventa;
                $factura->monto = $request->montoventa;
                $factura->nombres = $request->nombres;
                $factura->cinit = $request->ci;
                $factura->descripcion = 'Pago cuota inicial';
                $factura->numero = $request->numero;
                $factura->model_id = $pago->id;
                $factura->model_type = 'pagos';
                $factura->save();
                $numdocumento = $factura->numero;
            }
            $url = "diferidos?tipo=mes&mes=" . $contrato->fechacontrato->month . "&anio=" . $contrato->fechacontrato->year . "&fecha_ini=&fecha_fin=&fecha_acumulado=&buscar=buscar";
            $credito = $contrato->credito;
            $numcuenta_result = $credito->getNumCuenta();
            if (!$numcuenta_result) {
                DB::rollBack();
                Session::flash('error', 'Error de duplicidad de numero de cuenta intente nuevamente porfavor' . $numcuenta_result);
                return redirect($url);
            }
            if ($contrato->tipoventa == 'contado') {
                // return dd($request->all());
                //$credito = $contrato->credito;
                $credito->numcuenta = $numcuenta_result;
                $credito->numdocumento = $numdocumento;
                $credito->numreporte = $pago->num_reporte;
                $credito->montodoc = $pago->monto;
                $credito->fechadoc = $request->fechaventa;
                $credito->fechacuotas = $request->fechaventa;
                $credito->tipodoc = $request->tipodocventa;
                $credito->estado = 'T';
                $credito->saldo_inicial = 0;
                $credito->nombre_cliente = $contrato->nombre_completo;
                $credito->vendedor_id = $contrato->idvendedor;
                $credito->valor_venta = $contrato->preciototal;
                $credito->tiene_contrato = 1;
                $credito->vendedor_nombre = $contrato->vendedor->nombre_completo;
                $credito->save();
            } else {
                //$credito = $contrato->credito;
                $credito->numcuenta = $numcuenta_result;
                $credito->numdocumento = $numdocumento;
                $credito->numreporte = $pago->num_reporte;
                $credito->montodoc = $pago->monto;
                $credito->fechadoc = $pago->fecha->format('d/m/Y');
                $credito->fechacuotas = $pago->fecha->format('d/m/Y');
                $credito->tipodoc = $request->tipodocventa;
                $credito->estado = 'C';
                $credito->saldo_inicial = $credito->saldo;
                $credito->diacobrar = $request->diacobrar;
                $credito->nombre_cliente = $contrato->nombre_completo;
                $credito->vendedor_id = $contrato->idvendedor;
                $credito->valor_venta = $contrato->preciototal;
                $credito->tiene_contrato = 1;
                $credito->vendedor_nombre = $contrato->vendedor->nombre_completo;
                $credito->save();
            }
            DB::table('numcuenta')->insert([
                'credito_id' => $credito->id
            ]);
            $sw = Kardex::asignarVentaDirecta2($contrato, $credito->numcuenta);
            if (!$sw) {
                DB::rollBack();
                Session::flash('error', 'Existio un error en la asignacion de los items a estado Venta en el kardex del vendedor .');
                return redirect($url);
            }
            $contrato->estado = 'VENTA';
            $contrato->terminado = 1;
            $contrato->tipocontrato = 'VENTA';
            $contrato->save();
            if ($contrato->tipoventa == 'credito') {
                $array_cuotas = Helper::planPagos($credito->fechadoc, 0, $credito->numcuotas * 30, $credito->numcuotas, $credito->saldo);
                foreach ($array_cuotas as $r) {
                    $cuota = new Cuota();
                    $cuota->fechavence = $r["fecha"];
                    $cuota->numcuota = $r["numcuota"];
                    $cuota->monto = $r["monto"];
                    $cuota->credito_id = $credito->id;
                    $cuota->estado = 1;
                    $cuota->sw = 1;
                    $cuota->save();
                }
            }
            DB::commit();
            Session::flash('success', 'El contrato se ha procesado correctamente');
        } catch (\Exception $e) {
            return dd($e);
            DB::rollBack();
            Session::flash('error', 'Ocurrio un error. intentelo nuevamente por favor');
        }
        $url = "contratos-venta?tipo=mes&mes=" . $credito->fechadoc->month . "&anio=" . $credito->fechadoc->year . "&fecha_ini=&fecha_fin=&fecha_acumulado=&buscar=buscar&id=" . $contrato->id;
        return redirect($url);
    }
    public function procesarVenta(Request $request)
    {
        try {
            DB::beginTransaction();
            $pago = new Pago();
            $pago->monto = $request->montoventa;
            $pago->fecha = $request->fechaventa;
            $pago->num_reporte = $request->num_reporte;
            $pago->tipo_documento = $request->tipodocventa;
            $pago->model_type = 'cuota_inicial';
            $pago->model_id = $request->idcredito;
            $pago->estado = 'T';
            $pago->terminado = 1;
            $pago->save();
            $numdocumento = '';
            if ($request->tipodocventa == 'RECIBO') {
                $recibo = new Recibo();
                $recibo->monto = $request->montoventa;
                $recibo->fecha = $request->fechaventa;
                $recibo->nombres = $request->nombres;
                $recibo->numero = $request->numero;
                $recibo->model_id = $pago->id;
                $recibo->model_type = 'pagos';
                $recibo->save();
                $numdocumento = $recibo->numero;
            } elseif ($request->tipodocventa == 'FACTURA') {
                $factura = new Factura();
                $factura->fecha = $request->fechaventa;
                $factura->monto = $request->montoventa;
                $factura->nombres = $request->nombres;
                $factura->cinit = $request->ci;
                $factura->descripcion = 'Pago cuota inicial';
                $factura->numero = $request->numero;
                $factura->model_id = $pago->id;
                $factura->model_type = 'pagos';
                $factura->save();
                $numdocumento = $factura->numero;
            }
            $contrato = Contrato::find($request->contrato_id);
            $url = "diferidos?tipo=mes&mes=" . $contrato->fechacontrato->month . "&anio=" . $contrato->fechacontrato->year . "&fecha_ini=&fecha_fin=&fecha_acumulado=&buscar=buscar";
            $credito = $contrato->credito;
            $credito->numcuenta = $credito->getNumCuenta();
            $credito->numdocumento = $numdocumento;
            $credito->numreporte = $pago->num_reporte;
            $credito->montodoc = $pago->monto;
            $credito->fechadoc = $pago->fecha->format('d/m/Y');
            $credito->tipodoc = $request->tipodocventa;
            $credito->cobrador_id = $request->idcobrador;
            $credito->estado = 'C';
            $credito->save();
            \DB::table('numcuenta')->insert([
                'credito_id' => $credito->id
            ]);
            $sw = true;
            foreach ($contrato->detalle as $d) {
                $asignacion = Kardex::asignarVenta($d->codigo, $d->cantidad, $contrato);
                if (!$asignacion) {
                    $sw = false;
                    break;
                }
            }
            if (!$sw) {
                DB::rollBack();
                Session::flash('error', 'Existio un error en la asignacion de los items a estado Venta en el kardex del vendedor .');
                return redirect($url);
            }
            $contrato->estado = 'VENTA';
            $contrato->terminado = 1;
            $contrato->tipocontrato = 'VENTA';
            $contrato->save();
            if ($contrato->tipoventa == 'credito') {
                $array_cuotas = Helper::planPagos($credito->fechadoc, 0, $credito->numcuotas * 30, $credito->numcuotas, $credito->saldo);
                foreach ($array_cuotas as $r) {
                    $cuota = new Cuota();
                    $cuota->fechavence = $r["fecha"];
                    $cuota->numcuota = $r["numcuota"];
                    $cuota->monto = $r["monto"];
                    $cuota->credito_id = $credito->id;
                    $cuota->estado = 1;
                    $cuota->sw = 1;
                    $cuota->save();
                }
            }
            DB::commit();
            Session::flash('success', 'El contrato se ha procesado correctamente');
        } catch (\Exception $e) {
            return dd($e);
            DB::rollBack();
            Session::flash('error', 'Ocurrio un error. intentelo nuevamente por favor');
        }
        $url = "diferidos?tipo=mes&mes=" . $contrato->fechacontrato->month . "&anio=" . $contrato->fechacontrato->year . "&fecha_ini=&fecha_fin=&fecha_acumulado=&buscar=buscar";
        return redirect($url);
    }
    public function registrarPagoCuotaInicial(Request $request)
    {
        try {
            $contrato = Contrato::find($request->contrato_id);
            $procesar = 0;
            // dd($request->all(),$contrato->credito->saldoCuotaInicial(),$contrato->credito->toArray());
            if ($request->monto >= $contrato->credito->saldoCuotaInicial() && !isset($request->cuota_inicial)) {
                if ($request->numrecibo == '' || $request->num_reporte == '' || $request->fecha == '') {
                    session()->flash('error', 'Es necesario llenar todo los campos');
                    return redirect()->back();
                }
                $procesar = 1;
            }
            DB::beginTransaction();
            if ($procesar == 1) {
                $pago = new Pago();
                $pago->monto = $request->monto;
                $pago->fecha = $request->fecha;
                $pago->num_reporte = $request->num_reporte;
                $pago->estado = 'T';
                $pago->numrecibo = $request->numrecibo;
                $pago->terminado = 1;
                $pago->model_type = 'cuota_inicial';
                $pago->model_id = $request->credito_idcredito;
                $pago->tipo_documento = $request->tipodoc;
                $pago->save();
                $numdocumento = '';
                if ($request->tipodoc == 'RECIBO') {
                    $recibo = new Recibo();
                    $recibo->monto = $request->monto;
                    $recibo->fecha = $request->fecha;
                    $recibo->descripcion = $request->descripcionrecibo;
                    $recibo->nombres = $request->nombresrecibo;
                    $recibo->numero = $request->numrecibo;
                    $recibo->model_id = $pago->id;
                    $recibo->model_type = 'pagos';
                    $recibo->save();
                    $numdocumento = $recibo->numero;
                } elseif ($request->tipodoc == 'FACTURA') {
                    $factura = new Factura();
                    $factura->fecha = $request->fecha;
                    $factura->monto = $request->monto;
                    $factura->nombres = $request->nombresfactura;
                    $factura->cinit = $request->carnetfactura;
                    $factura->descripcion = $request->descripcionfactura;
                    $factura->numero = $request->numfactura;
                    $factura->model_id = $pago->id;
                    $factura->model_type = 'pagos';
                    $factura->save();
                    $numdocumento = $factura->numero;
                }
                $url = "diferidos?tipo=mes&mes=" . $contrato->fechacontrato->month . "&anio=" . $contrato->fechacontrato->year . "&fecha_ini=&fecha_fin=&fecha_acumulado=&buscar=buscar";
                if ($contrato->tipoventa == 'contado') {
                    // return dd($request->all());
                    $credito = $contrato->credito;
                    $credito->numcuenta = $credito->getNumCuenta();
                    $credito->numdocumento = $numdocumento;
                    $credito->numreporte = $pago->num_reporte;
                    $credito->montodoc = $pago->monto;
                    $credito->fechadoc = $request->fecha;
                    $credito->fechacuotas = $request->fecha;
                    $credito->tipodoc = $request->tipodocventa;
                    //            $credito->cobrador_id=$request->idcobrador;
                    $credito->estado = 'T';
                    $credito->saldo_inicial = 0;
                    $credito->nombre_cliente = $contrato->nombre_completo;
                    $credito->vendedor_id = $contrato->idvendedor;
                    $credito->valor_venta = $contrato->preciototal;
                    $credito->tiene_contrato = 1;
                    $credito->vendedor_nombre = $contrato->vendedor->nombre_completo;
                    $credito->save();
                } else {
                    $credito = $contrato->credito;
                    $credito->numcuenta = $credito->getNumCuenta();
                    $credito->numdocumento = $numdocumento;
                    $credito->numreporte = $pago->num_reporte;
                    $credito->montodoc = $pago->monto;
                    $credito->fechadoc = $pago->fecha->format('d/m/Y');
                    $credito->fechacuotas = $pago->fecha->format('d/m/Y');
                    $credito->tipodoc = $request->tipodocventa;
                    $credito->estado = 'C';
                    $credito->saldo_inicial = $credito->saldo;
                    $credito->diacobrar = $request->diacobrar;
                    $credito->nombre_cliente = $contrato->nombre_completo;
                    $credito->vendedor_id = $contrato->idvendedor;
                    $credito->valor_venta = $contrato->preciototal;
                    $credito->tiene_contrato = 1;
                    $credito->vendedor_nombre = $contrato->vendedor->nombre_completo;
                    $credito->save();
                }
                DB::table('numcuenta')->insert([
                    'credito_id' => $credito->id
                ]);
                $sw = true;
                $sw = Kardex::asignarVenta($contrato);
                if (!$sw) {
                    DB::rollBack();
                    Session::flash('error', 'Existio un error en la asignacion de los items a estado Venta en el kardex del vendedor .');
                    return redirect()->back();
                }
                $contrato->estado = 'VENTA';
                $contrato->terminado = 1;
                $contrato->tipocontrato = 'VENTA';
                $contrato->save();
                if ($contrato->tipoventa == 'credito') {
                    $array_cuotas = Helper::planPagos($credito->fechadoc, 0, $credito->numcuotas * 30, $credito->numcuotas, $credito->saldo);
                    foreach ($array_cuotas as $r) {
                        $cuota = new Cuota();
                        $cuota->fechavence = $r["fecha"];
                        $cuota->numcuota = $r["numcuota"];
                        $cuota->monto = $r["monto"];
                        $cuota->credito_id = $credito->id;
                        $cuota->estado = 1;
                        $cuota->sw = 1;
                        $cuota->save();
                    }
                }
                DB::commit();
                Session::flash('success', 'El contrato se ha procesado como VENTA. correctamente');
                $url = "contratos-venta?tipo=mes&mes=" . $credito->fechadoc->month . "&anio=" . $credito->fechadoc->year . "&fecha_ini=&fecha_fin=&fecha_acumulado=&buscar=buscar&id=" . $contrato->id;
                return redirect($url);
            } else if (isset($request->cuota_inicial)) {
                $url = "diferidos?tipo=mes&mes=" . $contrato->fechacontrato->month . "&anio=" . $contrato->fechacontrato->year . "&fecha_ini=&fecha_fin=&fecha_acumulado=&buscar=buscar";
                if ($contrato->tipoventa == 'contado') {
                    // return dd($request->all());
                    $credito = $contrato->credito;
                    $credito->numcuenta = $credito->getNumCuenta();
                    $credito->numdocumento = $numdocumento;
                    $credito->numreporte = '';
                    $credito->montodoc = 0;
                    $credito->fechadoc = Null;
                    $credito->fechacuotas = $request->fecha;
                    $credito->tipodoc = '';
                    //            $credito->cobrador_id=$request->idcobrador;
                    $credito->estado = 'T';
                    $credito->saldo_inicial = 0;
                    $credito->nombre_cliente = $contrato->nombre_completo;
                    $credito->vendedor_id = $contrato->idvendedor;
                    $credito->valor_venta = $contrato->preciototal;
                    $credito->tiene_contrato = 1;
                    $credito->vendedor_nombre = $contrato->vendedor->nombre_completo;
                    $credito->save();
                } else {
                    $credito = $contrato->credito;
                    $credito->numcuenta = $credito->getNumCuenta();
                    $credito->numdocumento = '';
                    $credito->numreporte = '';
                    $credito->montodoc = 0;
                    $credito->fechadoc = $request->fecha;
                    $credito->fechacuotas = $request->fecha;
                    $credito->tipodoc = '';
                    $credito->estado = 'C';
                    $credito->saldo_inicial = $credito->saldo;
                    $credito->diacobrar = $request->diacobrar;
                    $credito->nombre_cliente = $contrato->nombre_completo;
                    $credito->vendedor_id = $contrato->idvendedor;
                    $credito->valor_venta = $contrato->preciototal;
                    $credito->tiene_contrato = 1;
                    $credito->vendedor_nombre = $contrato->vendedor->nombre_completo;
                    $credito->save();
                }
                DB::table('numcuenta')->insert([
                    'credito_id' => $credito->id
                ]);
                $sw = true;
                $sw = Kardex::asignarVenta($contrato);
                if (!$sw) {
                    DB::rollBack();
                    Session::flash('error', 'Existio un error en la asignacion de los items a estado Venta en el kardex del vendedor .');
                    return redirect()->back();
                }
                $contrato->estado = 'VENTA';
                $contrato->terminado = 1;
                $contrato->tipocontrato = 'VENTA';
                $contrato->save();
                if ($contrato->tipoventa == 'credito') {
                    $array_cuotas = Helper::planPagos($credito->fechadoc, 0, $credito->numcuotas * 30, $credito->numcuotas, $credito->saldo);
                    foreach ($array_cuotas as $r) {
                        $cuota = new Cuota();
                        $cuota->fechavence = $r["fecha"];
                        $cuota->numcuota = $r["numcuota"];
                        $cuota->monto = $r["monto"];
                        $cuota->credito_id = $credito->id;
                        $cuota->estado = 1;
                        $cuota->sw = 1;
                        $cuota->save();
                    }
                }
                DB::commit();
                Session::flash('success', 'El contrato se ha procesado como VENTA. correctamente');
                $url = "contratos-venta?tipo=mes&mes=" . $credito->fechadoc->month . "&anio=" . $credito->fechadoc->year . "&fecha_ini=&fecha_fin=&fecha_acumulado=&buscar=buscar&id=" . $contrato->id;
                return redirect($url);
            } else {
                $pago = new Pago();
                $pago->monto = $request->monto;
                $pago->fecha = $request->fecha;
                $pago->num_reporte = $request->num_reporte;
                $pago->estado = 'T';
                $pago->numrecibo = $request->numrecibo;
                $pago->terminado = 1;
                $pago->model_type = 'cuota_inicial';
                $pago->model_id = $request->credito_idcredito;
                $pago->tipo_documento = $request->tipodoc;
                $pago->save();
                $numdocumento = '';
                if ($request->tipodoc == 'RECIBO') {
                    $recibo = new Recibo();
                    $recibo->monto = $request->monto;
                    $recibo->fecha = $request->fecha;
                    $recibo->descripcion = $request->descripcionrecibo;
                    $recibo->nombres = $request->nombresrecibo;
                    $recibo->numero = $request->numrecibo;
                    $recibo->model_id = $pago->id;
                    $recibo->model_type = 'pagos';
                    $recibo->save();
                    $numdocumento = $recibo->numero;
                } elseif ($request->tipodoc == 'FACTURA') {
                    $factura = new Factura();
                    $factura->fecha = $request->fecha;
                    $factura->monto = $request->monto;
                    $factura->nombres = $request->nombresfactura;
                    $factura->cinit = $request->carnetfactura;
                    $factura->descripcion = $request->descripcionfactura;
                    $factura->numero = $request->numfactura;
                    $factura->model_id = $pago->id;
                    $factura->model_type = 'pagos';
                    $factura->save();
                    $numdocumento = $factura->numero;
                }
                $url = "/diferidos/{$contrato->id}/registrarventa";
            }
            DB::commit();
            Session::flash('success', 'El pago se registro correctamente');
            return redirect($url);
        } catch (\Exception $e) {
            DB::rollBack();
            return dd($e);
            Session::flash('error', 'Ocurrio un error en el servidor');
        }
        return back();
    }
    public function diferidosBaja(Contrato $contrato)
    {
        try {
            DB::beginTransaction();
            if ($contrato->idvendedor == $contrato->idchofer) {
                Kardex::where('contrato_id', $contrato->id)
                    ->where('estado', 'Diferido')
                    ->update([
                        'contrato_id' => 0,
                        'estado' => 'Remitido',
                        'num_contrato' => '',
                    ]);
            } else {
                Kardex::where('contrato_id', $contrato->id)
                    ->where('estado', 'Traspaso')
                    ->where('vendedor_id', $contrato->idchofer)
                    ->update([
                        'contrato_id' => 0,
                        'estado' => 'Remitido',
                        'num_contrato' => '',
                    ]);
                Kardex::where('contrato_id', $contrato->id)
                    ->where('estado', 'Diferido')
                    ->where('vendedor_id', $contrato->idvendedor)
                    ->delete();
            }
            $contrato->tipocontrato = 'BAJA';
            $contrato->estado = 'BAJA';
            $contrato->save();
            DB::commit();
            Session::flash('success', 'el contrao se dio de baja correctamente');
        } catch (\Exception $e) {
            DB::rollBack();
            return dd($e);
            Session::flash('error', 'Ocurrio un error. intentelo nuevamente porfavor');
        }
        $url = "diferidos?tipo=mes&mes=" . $contrato->fechacontrato->month . "&anio=" . $contrato->fechacontrato->year . "&fecha_ini=&fecha_fin=&fecha_acumulado=&buscar=buscar";
        return redirect($url);
    }
    //    CONTRATOS VENTA
    public function contratosVenta(Request $request)
    {
        $datos = [];
        $tipo = "";
        $fecha_ini = Carbon::now();
        $fecha_fin = Carbon::now();
        $fecha_acumulado = Carbon::now();
        $mes = date('m');
        $anio = date('Y');
        if ($request->buscar == 'buscar') {
            $tipo = $request->tipo;
            if ($request->tipo == 'mes') {
                $mes = $request->mes;
                $anio = $request->anio;
                $datos = Contrato::join('credito as c', 'c.contrato_id', '=', 'contratos.id')
                    ->whereIn('contratos.tipocontrato', ['VENTA', 'DEVUELTO-COBRANZA'])
                    ->where('contratos.terminado', 1)
                    ->select('contratos.*')
                    ->whereMonth('c.fechadoc', '=', $request->mes)
                    ->whereYear('c.fechadoc', '=', $request->anio)
                    ->orderBy('c.fechadoc', 'DESC')->get();
            }
            if ($request->tipo == 'rango') {
                $fecha_ini = Carbon::createFromFormat('d/m/Y', $request->fecha_ini);
                $fecha_fin = Carbon::createFromFormat('d/m/Y', $request->fecha_fin);
                $datos = Contrato::join('credito as c', 'c.contrato_id', '=', 'contratos.id')
                    ->whereIn('contratos.tipocontrato', ['VENTA', 'DEVUELTO-COBRANZA'])
                    ->where('terminado', 1)
                    ->whereBetween('c.fechadoc', [$fecha_ini->format('Y-m-d'), $fecha_fin->format('Y-m-d')])
                    ->select('contratos.*')
                    ->orderBy('c.fechadoc', 'DESC')->get();
            }
            if ($request->tipo == 'acumulado') {
                $fecha = '2013-01-01';
                $fecha_acumulado = Carbon::createFromFormat('d/m/Y', $request->fecha_acumulado);
                $datos = Contrato::join('credito as c', 'c.contrato_id', '=', 'contratos.id')
                    ->whereIn('contratos.tipocontrato', ['VENTA', 'DEVUELTO-COBRANZA'])
                    ->where('terminado', 1)
                    ->whereBetween('c.fechadoc', [$fecha, $fecha_acumulado->format('Y-m-d')])
                    ->select('contratos.*')
                    ->orderBy('c.fechadoc', 'DESC')->get();
            }
        } else {
            $fecha_actual = Carbon::now();
            $mes = $fecha_actual->month;
            $anio = $fecha_actual->year;
            $datos = Contrato::join('credito as c', 'c.contrato_id', '=', 'contratos.id')
                ->whereIn('contratos.tipocontrato', ['VENTA', 'DEVUELTO-COBRANZA'])
                ->where('terminado', 1)
                ->whereMonth('c.fechadoc', '=', $mes)
                ->whereYear('c.fechadoc', '=', $anio)
                ->select('contratos.*')
                ->orderBy('c.fechadoc', 'DESC')
                ->get();
        }
        return view('ventas.contratos_venta.index', [
            'datos' => $datos,
            'tipo' => $request->tipo,
            'mes' => $mes,
            'anio' => $anio,
            'fecha_ini' => $fecha_ini,
            'fecha_fin' => $fecha_fin,
            'fecha_acumulado' => $fecha_acumulado,
        ]);
    }
    //CONTRATOS ANULADOS
    public function contratosAnulados(Request $request)
    {
        $datos = [];
        $tipo = "";
        $fecha_ini = Carbon::now();
        $fecha_fin = Carbon::now();
        $fecha_acumulado = Carbon::now();
        $mes = date('m');
        $anio = date('Y');
        if ($request->buscar == 'buscar') {
            $tipo = $request->tipo;
            if ($request->tipo == 'mes') {
                $mes = $request->mes;
                $anio = $request->anio;
                $datos = Contrato::where('tipocontrato', 'BAJA')
                    ->where('estado', 'BAJA')
                    ->whereMonth('fechacontrato', '=', $request->mes)
                    ->whereYear('fechacontrato', '=', $request->anio)
                    ->orderBy('fechacontrato', 'DESC')->get();
            }
            if ($request->tipo == 'rango') {
                $fecha_ini = Carbon::createFromFormat('d/m/Y', $request->fecha_ini);
                $fecha_fin = Carbon::createFromFormat('d/m/Y', $request->fecha_fin);
                $datos = Contrato::where('tipocontrato', 'BAJA')
                    ->where('estado', 'BAJA')
                    ->whereBetween('fechacontrato', [$fecha_ini->format('Y-m-d'), $fecha_fin->format('Y-m-d')])
                    ->orderBy('fechacontrato', 'DESC')->get();
            }
            if ($request->tipo == 'acumulado') {
                $fecha = '2013-01-01';
                $fecha_acumulado = Carbon::createFromFormat('d/m/Y', $request->fecha_acumulado);
                $datos = Contrato::where('tipocontrato', 'BAJA')
                    ->where('estado', 'BAJA')
                    ->whereBetween('fechacontrato', [$fecha, $fecha_acumulado->format('Y-m-d')])
                    ->orderBy('fechacontrato', 'DESC')->get();
            }
        } else {
            $fecha_actual = Carbon::now();
            $mes = $fecha_actual->month;
            $anio = $fecha_actual->year;
            $datos = Contrato::where('tipocontrato', 'BAJA')
                ->where('estado', 'BAJA')
                ->whereMonth('fechacontrato', '=', $mes)
                ->whereYear('fechacontrato', '=', $anio)
                ->orderBy('fechacontrato', 'DESC')
                ->get();
        }
        return view('ventas.anulados.index', [
            'datos' => $datos,
            'tipo' => $request->tipo,
            'mes' => $mes,
            'anio' => $anio,
            'fecha_ini' => $fecha_ini,
            'fecha_fin' => $fecha_fin,
            'fecha_acumulado' => $fecha_acumulado,
        ]);
    }
    public function verNotaDevolucion(Contrato $contrato)
    {
        return view('ventas.includes.nota_devolucionventa', [
            'dev' => $contrato->devolucion
        ]);
    }
    //CONTRATOS DE BAJA
    public function contratosBaja(Request $request)
    {
        $datos = [];
        $tipo = "";
        $fecha_ini = Carbon::now();
        $fecha_fin = Carbon::now();
        $fecha_acumulado = Carbon::now();
        $mes = date('m');
        $anio = date('Y');
        if ($request->buscar == 'buscar') {
            $tipo = $request->tipo;
            if ($request->tipo == 'mes') {
                $mes = $request->mes;
                $anio = $request->anio;
                $datos = Contrato::where('tipocontrato', 'BAJA')
                    ->where('terminado', 1)
                    ->whereMonth('fechacontrato', '=', $request->mes)
                    ->whereYear('fechacontrato', '=', $request->anio)
                    ->orderBy('fechacontrato', 'DESC')->get();
            }
            if ($request->tipo == 'rango') {
                $fecha_ini = Carbon::createFromFormat('d/m/Y', $request->fecha_ini);
                $fecha_fin = Carbon::createFromFormat('d/m/Y', $request->fecha_fin);
                $datos = Contrato::where('tipocontrato', 'BAJA')
                    ->where('terminado', 1)
                    ->whereBetween('fechacontrato', [$fecha_ini->format('Y-m-d'), $fecha_fin->format('Y-m-d')])
                    ->orderBy('fechacontrato', 'DESC')->get();
            }
            if ($request->tipo == 'acumulado') {
                $fecha = '2013-01-01';
                $fecha_acumulado = Carbon::createFromFormat('d/m/Y', $request->fecha_acumulado);
                $datos = Contrato::where('tipocontrato', 'BAJA')
                    ->where('terminado', 1)
                    ->whereBetween('fechacontrato', [$fecha, $fecha_acumulado->format('Y-m-d')])
                    ->orderBy('fechacontrato', 'DESC')->get();
            }
        } else {
            $fecha_actual = Carbon::now();
            $mes = $fecha_actual->month;
            $anio = $fecha_actual->year;
            $datos = Contrato::where('tipocontrato', 'BAJA')
                ->where('terminado', 1)
                ->whereMonth('fechacontrato', '=', $mes)
                ->whereYear('fechacontrato', '=', $anio)
                ->orderBy('fechacontrato', 'DESC')
                ->get();
        }
        return view('ventas.baja.index', [
            'datos' => $datos,
            'tipo' => $request->tipo,
            'mes' => $mes,
            'anio' => $anio,
            'fecha_ini' => $fecha_ini,
            'fecha_fin' => $fecha_fin,
            'fecha_acumulado' => $fecha_acumulado,
        ]);
    }
}
