<?php

namespace App\Http\Controllers;

use App\CambioObra;
use App\Contrato;
use App\Credito;
use App\DetalleContrato;
use App\DetalleDevolucionObras;
use App\DetalleIngreso;
use App\DevolucionObras;
use App\Helper\Helper;
use App\NotasIngreso;
use App\Pago;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;

class DevolucionCobranzaController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $tipo = 'mes';
        $mes = date('m');
        $anio = date('Y');
        $fecha_ini = Carbon::now();
        $fecha_fin = Carbon::now();
        $fecha_acumulado = Carbon::now();
        $numcuenta = '';
        $datos = [];

        if ($request->buscar == 'buscar') {

            $tipo = $request->tipo;
            if ($request->tipo == 'mes') {

                $mes = $request->mes;
                $anio = $request->anio;
                $datos = DevolucionObras::where('procedencia', 'cobranza')
                    ->whereMonth('fecha', '=', $request->mes)
                    ->whereYear('fecha', '=', $request->anio)
                    ->orderBy('fecha', 'DESC')->get();

            }
            if ($request->tipo == 'rango') {
                $fecha_ini = Carbon::createFromFormat('d/m/Y', $request->fecha_ini);
                $fecha_fin = Carbon::createFromFormat('d/m/Y', $request->fecha_fin);
                $datos = DevolucionObras::where('procedencia', 'cobranza')
                    ->whereBetween('fecha', [$fecha_ini->format('Y-m-d'), $fecha_fin->format('Y-m-d')])
                    ->orderBy('fecha', 'DESC')->get();

            }
            if ($request->tipo == 'acumulado') {
                $fecha = '2013-01-01';
                $fecha_acumulado = Carbon::createFromFormat('d/m/Y', $request->fecha_acumulado);
                $datos = DevolucionObras::where('procedencia', 'cobranza')
                    ->whereBetween('fecha', [$fecha, $fecha_acumulado->format('Y-m-d')])
                    ->orderBy('fecha', 'DESC')->get();
            }

        } else {
            $datos = DevolucionObras::where('procedencia', 'cobranza')
                ->whereMonth('fecha', '=', $mes)
                ->whereYear('fecha', '=', $anio)
                ->orderBy('fecha', 'DESC')
                ->get();
        }
        return view('cobranza.devolucion.index', [
            'datos' => $datos,
            'tipo' => $tipo,
            'mes' => $mes,
            'anio' => $anio,
            'fecha_ini' => $fecha_ini,
            'fecha_fin' => $fecha_fin,
            'fecha_acumulado' => $fecha_acumulado,
        ]);

    }

    public function create()
    {


        return view('cobranza.devolucion.create_edit');

    }
    public function createPost(Request $request)
    {

        $credito = Credito::where('id', $request->credito_id)->with('contrato')->first();

        if ($credito->contrato_id=='' && $credito->tiene_contrato==0) {
            Session::flash('info', 'Esta cuenta no tiene contrato registrado');
            return redirect()->back();
        }

        // if ($credito->contrato->tipocontrato != 'VENTA') {
        //     Session::flash('info', 'Este contrato no esta facturado');
        //     return redirect()->back();
        // }
        $pagos = Pago::where('model_type', 'pago-cobranza')
            ->where('model_id', $request->credito_id)
            ->orderBy('fecha', 'ASC')
            ->get();
        $cuotas = Helper::planPagos($credito->fechadoc, 0, $credito->numcuotas * 30, $credito->numcuotas, $credito->saldo);

        $devoluciones=\App\DevolucionObras::where('num_cuenta',$credito->numcuenta)
        ->where('procedencia','COBRANZA')
        ->orderBy('fecha','DESC')->get();
        return view('cobranza.devolucion.create_edit', [
            'credito' => $credito,
            'pagos' => $pagos,
            'cuotas' => $cuotas,
            'criterio' => $request->numcuenta,
            'tipo' => $request->tipo,
            'devoluciones'=>$devoluciones
        ]);

    }





    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
// return dd($request->all());

        try {
            DB::beginTransaction();
            $credito = Credito::find($request->credito_id);
            $credito->estado = 'D';
            $credito->save();

            $dev = new DevolucionObras();
            $dev->fecha = $request->fecha;
            $dev->estado = 'almacen';
            $dev->monto_devolucion = $credito->saldo - $request->saldo_actual;


            if ($request->saldo_actual <= 0) {
                $dev->tipo_devolucion = 'TOTAL';
                $dev->monto_saldo = 0;
            } else {
                $dev->tipo_devolucion = 'PARCIAL';
                $dev->monto_saldo = $request->saldo_actual;
            }
            $dev->obs = $request->obs;
            $dev->user_id = Auth::user()->id;
            $dev->contrato_id = $credito->contrato->id;
            $dev->procedencia = 'COBRANZA';
            $dev->num_cuenta = $credito->numcuenta;


            $dev->save();
            $contrato = Contrato::find($credito->contrato->id);
            $contrato->estado = 'ALMACEN';
            $contrato->save();

            foreach ($request->libros_id as $k => $v) {
                $detalle = new DetalleDevolucionObras();
                $detalle->cantidad = $request->cantidad[$k];
                $detalle->codigo = $request->codigo[$k];
                $detalle->titulo = $request->titulo[$k];
                $detalle->volumen = 1;
                $detalle->precio_unitario = $request->precio_unitario[$k];
                $detalle->precio_total = $request->precio_unitario[$k] * $request->cantidad[$k];
                $detalle->libro_id = $v;
                $detalle->devolucionobras_id = $dev->id;

                if (\in_array($v, $request->cb)) {
                    $detalle->sw = 1;
                } else {
                    $detalle->sw = 0;
                }
                // if(isset($request->cb[$k]) && $request->cb[$k]==$k){
                //     $detalle->sw =1;
                // }
                // else{
                //     $detalle->sw=0;
                // }


                $detalle->save();
            }
            DB::commit();
            Session::flash('success', 'La devolucion se ha registrado Exitosamente');
        } catch (\Exception $e) {

            DB::rollBack();
            return dd($e);
        }

        return redirect('devolucion-cobranza?tipo=mes&mes=' . $dev->fecha->month . '&anio=' . $dev->fecha->year);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function devolucionVentasAlmacen()
    {


        $devoluciones = DevolucionObras::where('estado', 'almacen')->where('procedencia', 'COBRANZA')->orderBy('fecha', 'DESC')->get();
        return view('almacen.devolucionobras.devolucioncobranza', [
            'devoluciones' => $devoluciones
        ]);

    }

    public function ingresoCreate(DevolucionObras $devolucion)
    {
        return view('almacen.devolucionobras.create_ingreso', [
            'devolucion' => $devolucion
        ]);
    }

    public function ingresoStore(Request $request)
    {

//        return dd($request->all());
        try {
            DB::beginTransaction();

            $i = new NotasIngreso();


            $i->recibe = 'ALMACEN CENTRAL';
            $i->envia = 'COBRANZA';
            $i->fecha = $request->fecha;
            $i->concepto = 'DEVOLUCION REGISTRO VENTA';
            $i->cant_total = $request->ingreso_cant_total;
            $i->glosa = strtoupper($request->glosa);
            $i->estado = 'T';
            $i->precio_total = $request->ingreso_precio_total;
            $i->user_id = Auth::user()->id;
            $i->terminado = 1;
//            $i->moneda=$request->;
//            $i->valor_cambio=$request->;
            $i->obs = $request->obs;
            $i->save();

            foreach ($request->ingreso_detalle_libro_id as $k => $v) {
                $det = new DetalleIngreso();

                $det->cantidad = $request->ingreso_detalle_cantidad[$k];
                $det->codigo = $request->ingreso_detalle_codigo[$k];
                $det->titulo = $request->ingreso_detalle_titulo[$k];
                $det->volumen = $request->ingreso_detalle_volumen[$k];
                $det->precio_unitario = $request->ingreso_detalle_preciounitario[$k];
                $det->precio_total = $request->ingreso_detalle_preciototal[$k];
                $det->libro_id = $v;
                $det->ingreso_id = $i->id;
                $det->obs = $request->ingreso_obs_detalle[$k];
                $det->save();

                $libro = \App\Libro::find($det->libro_id);
                if (!is_null($libro)) {
                    $new_stock = $libro->stock + $det->cantidad;

                    $libro->stock = $new_stock;
                    $libro->save();
                }
            }
            $devolucionObras = DevolucionObras::find($request->devolucion_id);
            $devolucionObras->estado = 'PROCESADO';
            $devolucionObras->num_contrato = $devolucionObras->contrato->numcontrato;
            $devolucionObras->ingreso_id = $i->id;
            $devolucionObras->save();
            $contrato = Contrato::find($request->contrato_id);
            $contrato->tipocontrato = 'DEVUELTO-COBRANZA';
            $contrato->estado = 'DEVUELTO-COBRANZA';
            $contrato->save();
            $credito = Credito::where('contrato_id', $contrato->id)->where('numcuenta', $devolucionObras->num_cuenta)->first();
            $credito->saldo = $devolucionObras->monto_saldo;
            if (isset($credito)) {
                if ($credito->saldo <= 0) {
                    $credito->estado = 'T';
                    $credito->fecha_terminado = $devolucionObras->fecha;
                    $credito->tipo_terminado = 'devolucion';
                    $credito->id_terminado = $devolucionObras->id;
                    $credito->estado = 'T';
                    $credito->save();
                } else {
                    $credito->estado = 'C';
                }
                $credito->save();
            } 
            else {
                DB::rollBack();

                Session::flash('error', 'No se encuentra la en numero de cuenta. Intentelo nuevamnete porfavor');
                return redirect('/almacen/devolucion-cobranza');
            }
            $credito->save();


            DB::commit();
            Session::flash('success', 'La nota de Ingreso se guardo correctamente.');
        } catch (\Exception $e) {
            return dd($e);
            DB::rollBack();
            Session::flash('error', 'Ocurrio un error en el servidor. Intente nuevamente por favor');

        }

        return redirect('/almacen/devolucion-cobranza');
    }

    public function delete(DevolucionObras $devolucion)
    {
        try {
            DB::beginTransaction();
            $credito = Credito::where('numcuenta', $devolucion->num_cuenta)->first();

            if ($credito) {
                $credito->estado = 'C';
                $credito->save();
                $devolucion->detalle()->delete();
                $devolucion->delete();
                DB::commit();
            }




        } catch (\Exception $e) {

            DB::rollBack();
            Session::flash('error', 'Ocurrio un error en el servidor. Intente nuevamente por favor');

        }
        Session::flash('success', 'La Devolucion se elimino  correctamente.');
        return redirect()->back();
    }

    public function rechazar(DevolucionObras $devolucion)
    {
        try {
            DB::beginTransaction();
            $credito = Credito::where('numcuenta', $devolucion->num_cuenta)->first();

            if ($credito) {
                $credito->estado = 'C';
                $credito->save();
                $devolucion->estado = 'RECHAZADO';
                $devolucion->save();
                DB::commit();
            }




        } catch (\Exception $e) {

            DB::rollBack();
            Session::flash('error', 'Ocurrio un error en el servidor. Intente nuevamente por favor');

        }
        Session::flash('success', 'La Devolucion se envio a Cobranza.');
        return redirect()->back();
    }

    public function ver(DevolucionObras $devolucion)
    {
        $credito = Credito::where('numcuenta', $devolucion->num_cuenta)->first();
        return view('cobranza.devolucion.ver', [
            'devolucion' => $devolucion,
            'credito' => $credito
        ]);
    }
}
