<?php

namespace App\Http\Controllers;

use App\Editorial;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Barryvdh\DomPDF\Facade as PDF;
use App\Exports\EditorialesExport;




class EditorialController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $editoriales= Editorial::orderBy('nombre')->get();
        if(isset($request->exportar)){



            if($request->exportar=='excel') {

                // \Excel::create($editoriales, function ($excel) use ($editoriales) {
                //     $excel->sheet('Editoriales', function ($sheet) use ($editoriales) {
                //         $sheet->loadView('editoriales.exportar', [
                //                 'editoriales' => $editoriales,
                //                 'estilos' => false,
                //             ]
                //         );
                //     });
                // })->download('xlsx');
                return \Excel::download(new EditorialesExport($editoriales), 'lista-editoriales.xlsx');

            }



            elseif ($request->exportar=='pdf'){
                $pdf = PDF::loadView('editoriales.exportar',[
                    'editoriales' => $editoriales,
                    'estilos'=>true,

                ]);
                $pdf->setPaper('a4', 'portrait');
                return $pdf->stream('Editoriales');

            }


        }
        return view('editoriales.index',['editoriales'=>$editoriales]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try{
            if(isset($request->id))
                $editorial=Editorial::find($request->id);
            else
                $editorial= new Editorial();


            $editorial->nombre=$request->nombre;
            $editorial->direccion=$request->direccion;
            $editorial->telefono=$request->telefono;
            $editorial->email=$request->email;
            $editorial->save();

            Session::flash('success','La editorial se guardo correctamente.');

        }
        catch (\Exception $e){
            Session::flash('error','Existio un error al guardar la Categoria');


        }

        return redirect('editoriales');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Editorial  $editorial
     * @return \Illuminate\Http\Response
     */
    public function show(Editorial $editorial)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Editorial  $editorial
     * @return \Illuminate\Http\Response
     */
    public function edit(Editorial $editorial)
    {

        return view('editoriales.create_edit',[
            'editorial'=>$editorial,

        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Editorial  $editorial
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Editorial $editorial)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Editorial  $editorial
     * @return \Illuminate\Http\Response
     */
    public function destroy(Editorial $editorial)
    {
        try{
            $editorial->delete();
            Session::flash('success','La editorial se Elimino correctamente');

        }
        catch (\Exception $e){
            Session::flash('error','Exisitio un error al borrar la editorial');
        }

        return  redirect('editoriales');
    }
}
