<?php

namespace App\Http\Controllers;

use App\Categoria;
use App\Editorial;
use App\Libro;
use App\Exports\LibroExport;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Barryvdh\DomPDF\Facade as PDF;

class LibroController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public  function  validarCodigo(Request $request)
    {

        $sql = Libro::where('codigo', $request->codigo)->first();
        if ($sql)
            return response()->json([
                'status' => true,
            ], 200);
        else
            return response()->json([
                'status' => false,
            ], 200);
    }
    public function index(Request $request)
    {

        $categorias = Categoria::orderBy('codigo', 'ASC')->get();
        $editoriales = Editorial::orderBy('nombre', 'ASC')->get();
        $libros = Libro::orderBy('codigo', 'ASC')->get();

        if (isset($request->exportar)) {



            if ($request->exportar == 'excel') {
                // dd($libros);

                // return view(
                //     'libros.exportar',
                //     [
                //         'libros' => $libros,
                //         'estilos' => false,
                //     ]
                // );
                return \Excel::download(new LibroExport($libros), 'lista-libros.xlsx');

                // \Excel::download($libros, function ($excel) use ($libros) {
                //     $excel->sheet('Libros', function ($sheet) use ($libros) {
                //         $sheet->loadView('libros.exportar', [
                //                 'libros' => $libros,
                //                 'estilos' => false,
                //             ]
                //         );
                //     });
                // })->download('xlsx');
            } elseif ($request->exportar == 'pdf') {
                $pdf = PDF::loadView('libros.exportar', [
                    'libros' => $libros,
                    'estilos' => true,

                ]);
                $pdf->setPaper('a4', 'portrait');
                return $pdf->stream('Libros');
            }
        }

        return view('libros.index', [
            'editoriales' => $editoriales,
            'categorias' => $categorias,
            'libros' => $libros
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        //    return dd( $request->file('foto'));
        try {

            if (isset($request->id)) {
                $libro = Libro::find($request->id);
            } else {
                $libro = new Libro();
            }

            $libro->codigo = $request->codigo;
            $libro->titulo = $request->titulo;
            $libro->categoria_id = $request->categoria_id;
            $libro->editorial_id = $request->editorial_id;
            $libro->precio_base = round($request->precio_base, 2);
            $libro->precio_final = round($request->precio_final, 2);
            $libro->tomo = $request->tomo;
            if ($request->hasFile('foto')) {
                $file = $request->file('foto');
                $path = $file->storeAs(
                    'local', $file->getClientOriginalName()
                );
                $libro->foto=$file->getClientOriginalName();

                
            }


            $libro->save();
            Session::flash('success', 'El  registro se guardo  correctamente.');
        } catch (\Exception $e) {
            return dd($e);
            Session::flash('error', 'No se pudo guardar el registro. Ocurrio un error inesperado');
        }
        return redirect('libros');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Libro  $libro
     * @return \Illuminate\Http\Response
     */
    public function show(Libro $libro)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Libro  $libro
     * @return \Illuminate\Http\Response
     */
    public function edit(Libro $libro)
    {

        $categorias = Categoria::orderBy('codigo', 'ASC')->get();
        $editoriales = Editorial::orderBy('nombre', 'ASC')->get();


        return view('libros.create_edit', [
            'libro' => $libro,
            'categorias' => $categorias,
            'editoriales' => $editoriales
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Libro  $libro
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Libro $libro)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Libro  $libro
     * @return \Illuminate\Http\Response
     */
    public function destroy(Libro $libro)
    {
        try {
            $libro->delete();
            Session::flash('success', 'Se Elimino el registro exitosamente');
        } catch (\Exception $e) {
            //            return dd($e);
            session()->flash('error', 'No se puede eliminar el registro.  Ocurrio un error');
        }
        return redirect('libros');
    }
}
