<?php

namespace App\Http\Controllers;

use App\DetalleDevolucion;
use App\Kardex;
use App\Libro;
use App\NotasDevolucion;
use App\Vendedor;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Barryvdh\DomPDF\Facade as PDF;
use App\Exports\RelacionNotasDevolucionExport;



class NotasDevolucionController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $mes = date('m');
        $anio = date('Y');
        $datos = [];
        $imprimir=false;
        $id_nota=0;
        if (isset($request->mes)) {
            $mes = $request->mes;
            $anio = $request->anio;


        }
        if(isset($request->i) &&  isset($request->d)){
            $imprimir=$request->i;
            $id_nota=$request->d;
        }

        $datos = NotasDevolucion::whereMonth('fecha', '=', $mes)
            ->whereYear('fecha', '=', $anio)
            ->orderBy('created_at', 'DESC')
            ->get();


        $vendedores = Vendedor::orderBy('nombres', 'ASC')->get();
          return view('almacen.devolucion.index',[
              'datos'=>$datos,
              'mes'=>$mes,
              'anio'=>$anio,
              'vendedores'=>$vendedores,
              'imprimir'=>$imprimir,
              'id_nota'=>$id_nota
          ]);

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {

        $vendedor=Vendedor::find($request->vendedor);
        $fecha=$request->fecha;
        $fecha2=Carbon::createFromFormat('d/m/Y',$fecha);
         $libros=[];
         $devolucion=[];
         $edit=false;

         $libros=Kardex::CargosVendedorDevolucion($vendedor->id,$fecha2->month,$fecha2->year);

        return view('almacen.devolucion.create_edit',[
            'libros'=>$libros,
            'vendedor'=>$vendedor,
            'fecha'=>$fecha2,
            'devolucion'=>$devolucion,
            'edit'=>$edit,

        ]);

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

//        return dd($request->all());
        try{
            DB::beginTransaction();
            if(isset($request->devolucion_id)){
                $dev=NotasDevolucion::find($request->devolucion_id);
                $dev->detalle()->delete();
            }
            else{
                $dev=new NotasDevolucion();
            }

            $dev->fecha=$request->fecha;
            $dev->cant_total=$request->cant_total;
            $dev->estado='G';
            $dev->vendedor_id=$request->vendedor_id;
            $dev->almacen_id=0;
            $dev->user_id=Auth::user()->id;
            $dev->obs=$request->obs;
            $dev->terminado=0;

            $dev->save();

            foreach($request->libro_id as $k=>$v){

                $detalle=new DetalleDevolucion();
                $libro=Libro::find($v);
                $detalle->cantidad=$request->cant[$k];
                $detalle->codigo=$libro->codigo;
                $detalle->titulo=$libro->titulo;
                $detalle->volumen=$libro->tomo;
                $detalle->obs=$request->observacion[$k];
                $detalle->libro_id=$v;
                $detalle->devolucion_id=$dev->id;
                $detalle->save();

            }

            DB::commit();
            Session::flash('success','La nota de devolucion de registro correctamente.');


        }
        catch (\Exception $e){
            return dd($e);

            DB::rollBack();
            Session::flash('error','Ocurrio un error inesperado.');

        }
        return redirect('notas-devolucion?mes='.$dev->fecha->format('m').'&anio='.$dev->fecha->format('Y').'&d='.$dev->id.'&i=true');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\NotasDevolucion  $notasDevolucion
     * @return \Illuminate\Http\Response
     */
    public function show(NotasDevolucion $devolucion)
    {
        return view('almacen.partials.nota_devolucion',[
            'dev'=>$devolucion
        ]);
    }



    public function validarDisponibles( NotasDevolucion $devolucion){


        $faltantes=$devolucion->validarDisponibles();


        if(!empty($faltantes)){
            return  response()->json([
                'status'=>false,
                'datos'=>$faltantes
            ],200);
        }
        else{
            return  response()->json([
                'status'=>true
            ],200);
        }

    }

    public function relacion(Request $request){
        $mes=date('m');
        $anio=date('Y');


        if(isset($request->mes)){
            $mes=$request->mes;
            $anio=$request->anio;
        }

        $datos=DB::table('view_devolucion_detalle')->whereMonth('fecha','=',$mes)
            ->whereYear('fecha','=',$anio)
            ->where('estado', 'T')
            ->orderBy('id','ASC')->orderBy('codigo','ASC')->get();

        if(isset($request->tipo)){
            $tipo=$request->tipo;

            $nombrearchivo='relacion-notas-devolucion al 31-'.$mes.'-'.$anio;

            if($tipo=='excel') {
                return \Excel::download(new RelacionNotasDevolucionExport($datos, $mes, $anio), $nombrearchivo.'.xlsx');

            }
            elseif ($tipo=='pdf'){
                $pdf = PDF::loadView('almacen.devolucion.relacion-exportar',[
                    'datos' => $datos,
                    'estilos' => true,
                    'mes'=>$mes,
                    'anio'=>$anio
                ]);
                $pdf->setPaper('a4', 'portrait');
//            $pdf->setPaper([0, 0,650, 270], 'portrait');
//            $pdf->output();
//            $dom_pdf = $pdf->getDomPDF();
//            $pdf->set_paper(array(0,0,1000,3000));

//            return $pdf->download('saldos_socios.pdf');

                return $pdf->stream($nombrearchivo);

            }

        }


        return view('almacen.devolucion.relacion',[
            'datos'=>$datos,
            'mes'=>$mes,
            'anio'=>$anio
        ]);

    }

    public function procesar(NotasDevolucion $devolucion){


        $faltantes=$devolucion->validarDisponibles();


        if(!empty($faltantes)){
           Session::flash('warning','No hay suficientes items para procesar la nota. Intente nuevamente porfavor.');
            return redirect('notas-devolucion?mes='.$devolucion->fecha->format('m').'&anio='.$devolucion->fecha->format('Y'));

        }

        $sw=true;

        try{
            DB::beginTransaction();
             foreach($devolucion->detalle as $k=>$d){
                    $libro=Libro::find($d->libro_id);
                if(!is_null($libro)){
                    $libro->stock=$libro->stock+$d->cantidad;
                    $libro->save();
                }

                    // if($k>0){
                $asignacion= Kardex::asignarDevolucion($d->codigo,$d->cantidad,$devolucion);
                if(!$asignacion){
                    return dd('mal');
                    $sw=false;
                    break;
            //    }
            }

             }
             if(!$sw){
                 DB::rollBack();
                 Session::flash('error','Existio111 un error al procesar la nota. Intente nuevamente porfavor.');
                 return redirect('notas-devolucion?mes='.$devolucion->fecha->format('m').'&anio='.$devolucion->fecha->format('Y'));
             }

             
             $devolucion->estado='T';
             $devolucion->terminado=1;
             $devolucion->save();


            Session::flash('success','La nota  de devolucion se proceso correctamente.');

            DB::commit();
        }
        catch (\Exception $e){
            Session::flash('error','Existio un error al procesar la nota. Intente nuevamente porfavor.');

            DB::rollBack();
            return dd($e);
        }
        return redirect('notas-devolucion?mes='.$devolucion->fecha->format('m').'&anio='.$devolucion->fecha->format('Y'));


    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\NotasDevolucion  $notasDevolucion
     * @return \Illuminate\Http\Response
     */

     public function anular(NotasDevolucion $devolucion){
         try{
             DB::beginTransaction();
            $kardex=Kardex::where('devolucion_id',$devolucion->id)->update([
                'estado'=>'Remitido',
                'fecha_devolucion'=>null,
                'devolucion_id'=>null,

            ]);


            $devolucion->estado='A';
            $devolucion->save();
             DB::commit();
             Session::flash('success','La nota de Devolucion se anulo correctamente.');


         }
         catch(\Exception $e){
             return dd($e);
             DB::rollBack();
             Session::flash('error','Exisitio un error en el servidor');

         }

         return redirect('notas-devolucion?mes='.$devolucion->fecha->format('m').'&anio='.$devolucion->fecha->format('Y'));

     }
    public function edit(NotasDevolucion $devolucion)
    {
            $edit=true;
            $vendedor=Vendedor::find($devolucion->vendedor_id);
            $fecha=$devolucion->fecha->format('d/m/Y');
            $fecha2=$devolucion->fecha;
        $libros=Kardex::CargosVendedorDevolucion($vendedor->id,$fecha2->month,$fecha2->year);


        return view('almacen.devolucion.create_edit',[
            'libros'=>$libros,
            'vendedor'=>$vendedor,
            'fecha'=>$fecha2,
            'devolucion'=>$devolucion,
            'edit'=>$edit,

        ]);

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\NotasDevolucion  $notasDevolucion
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, NotasDevolucion $notasDevolucion)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\NotasDevolucion  $notasDevolucion
     * @return \Illuminate\Http\Response
     */
    public function destroy(NotasDevolucion $notasDevolucion)
    {
        //
    }
}
