<?php

namespace App\Http\Controllers;

use App\DetalleEgreso;
use App\Libro;
use App\NotasEgreso;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Barryvdh\DomPDF\Facade as PDF;
use App\Exports\RelacionNotasEgresoExport;



class NotasEgresoController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {

        $mes = date('m');
        $anio = date('Y');
        $id_nota = 0;
        $imprimir = false;
        if (isset($request->mes) || ($request->anio)) {
            $mes = $request->mes;
            $anio = $request->anio;
        }
        if (isset($request->i) &&  isset($request->n)) {
            $imprimir = $request->i;
            $id_nota = $request->n;
        }
        $datos = NotasEgreso::whereMonth('fecha', '=', $mes)
            ->whereYear('fecha', '=', $anio)
            ->orderBy('created_at', 'DESC')
            ->get();

        return view('almacen.egreso.index', [
            'datos' => $datos,
            'mes' => $mes,
            'anio' => $anio,
            'imprimir' => $imprimir,
            'id_nota' => $id_nota
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $libros = Libro::orderBy('codigo', 'ASC')->get();
        return view('almacen.egreso.create_edit', [
            'libros' => $libros
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        //        return dd($request->all());
        try {
            DB::beginTransaction();
            if (isset($request->id)) {
                $egreso = NotasEgreso::find($request->id);
                $egreso->detalle()->delete();
            } else {
                $egreso = new NotasEgreso();
            }
            $egreso->envia = 'ALMACEN CENTRAL';
            $egreso->recibe = $request->recibe;
            $egreso->fecha = $request->fecha;
            $egreso->destino = $request->destino;
            $egreso->cant_total = $request->cant_total;
            $egreso->estado = 'G';
            $egreso->precio_total = $request->precio_total;
            $egreso->user_id = auth()->user()->id;
            $egreso->terminado = 0;
            //            $egreso->moneda=$request->;
            //            $egreso->valor_cambio=$request->;
            $egreso->obs = $request->obs;
            $egreso->save();

            foreach ($request->libro_id as $k => $v) {
                $det = new DetalleEgreso();
                $libro = Libro::find($v);
                $det->cantidad = $request->cant[$k];
                $det->codigo = $libro->codigo;
                $det->titulo = $libro->titulo;
                $det->volumen = $libro->tomo;
                $det->precio_unitario = $request->precio_unitario[$k];
                $det->precio_total = round($request->cant[$k] * $request->precio_unitario[$k]);
                $det->libro_id = $v;
                $det->egreso_id = $egreso->id;
                $det->obs = $request->observacion[$k];
                $det->save();
            }


            DB::commit();
            Session::flash('success', 'La nota de Egreso se guardo correctamente.');
        } catch (\Exception $e) {
            return dd($e);
            DB::rollBack();
            Session::flash('error', 'Ocurrio un error en el servidor. Intente nuevamente por favor');
        }

        return redirect('/notas-egreso?mes=' . $egreso->fecha->month . '&anio=' . $egreso->fecha->year . '&n=' . $egreso->id . '&i=true');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\NotasEgreso  $notasEgreso
     * @return \Illuminate\Http\Response
     */
    public function show(NotasEgreso $egreso)
    {
        return view('almacen.partials.nota_egreso', [
            'egreso' => $egreso
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\NotasEgreso  $notasEgreso
     * @return \Illuminate\Http\Response
     */
    public function edit(NotasEgreso $egreso)
    {
        $libros = Libro::orderBy('codigo', 'ASC')->get();
        return view('almacen.egreso.create_edit', [
            'libros' => $libros,
            'egreso' => $egreso
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\NotasEgreso  $notasEgreso
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, NotasEgreso $notasEgreso)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\NotasEgreso  $notasEgreso
     * @return \Illuminate\Http\Response
     */

    public function procesar(NotasEgreso $egreso)
    {
        try {
            DB::beginTransaction();
            $errors = [];

            foreach ($egreso->detalle as $d) {
                $libro = Libro::find($d->libro_id);
                if (!is_null($libro)) {
                    if ($d->cantidad <= $libro->stock) {
                        $libro->stock = $libro->stock - $d->cantidad;
                        $libro->save();
                    } else {
                        $errors[] = ['libro' => $libro, 'overqty' => $d->cantidad - $libro->stock];
                    }
                }
            }
            if(count($errors)>0){
                DB::rollBack();
                Session::flash('error', 'No se puede procesar la nota porque existen algunos libros que ya no tienen inventario');
                Session::flash('errorLibros', $errors);
                return redirect('/notas-egreso?mes=' . $egreso->fecha->month . '&anio=' . $egreso->fecha->year);
            }
            $egreso->terminado = 1;
            $egreso->estado = 'T';
            $egreso->save();

            DB::commit();
            Session::flash('success', 'La nota de  egreso se proceso correctamente');
        } catch (\Exception $e) {
            DB::rollBack();
            Session::flash('error', 'Ocurrio un error en el servidor. Intente nuevamente porfavor');
        }
        return redirect('/notas-egreso?mes=' . $egreso->fecha->month . '&anio=' . $egreso->fecha->year);
    }
    public function relacion(Request $request)
    {
        $mes = date('m');
        $anio = date('Y');


        if (isset($request->mes)) {
            $mes = $request->mes;
            $anio = $request->anio;
        }

        $datos = DB::table('view_egreso_detalle')->whereMonth('fecha', '=', $mes)
            ->whereYear('fecha', '=', $anio)
            ->where('estado', 'T')
            ->orderBy('id', 'ASC')->orderBy('codigo', 'ASC')->get();

        if (isset($request->tipo)) {
            $tipo = $request->tipo;

            $nombrearchivo = 'relacion-notas-egreso al 31-' . $mes . '-' . $anio;

            if ($tipo == 'excel') {
                return \Excel::download(new RelacionNotasEgresoExport($datos, $mes, $anio), $nombrearchivo . '.xlsx');
            } elseif ($tipo == 'pdf') {
                $pdf = PDF::loadView('almacen.egreso.relacion-exportar', [
                    'datos' => $datos,
                    'estilos' => true,
                    'mes' => $mes,
                    'anio' => $anio
                ]);
                $pdf->setPaper('a4', 'landscape');
                //            $pdf->setPaper([0, 0,650, 270], 'portrait');
                //            $pdf->output();
                //            $dom_pdf = $pdf->getDomPDF();
                //            $pdf->set_paper(array(0,0,1000,3000));

                //            return $pdf->download('saldos_socios.pdf');

                return $pdf->stream($nombrearchivo);
            }
        }


        return view('almacen.egreso.relacion', [
            'datos' => $datos,
            'mes' => $mes,
            'anio' => $anio
        ]);
    }

    public function anular(NotasEgreso $egreso)
    {
        try {
            DB::beginTransaction();

            foreach ($egreso->detalle as $d) {
                $l = Libro::find($d->libro_id);
                $l->stock = $l->stock + $d->cantidad;
                $l->save();
            }

            $egreso->estado = 'A';
            $egreso->save();
            DB::commit();
            Session::flash('success', 'La nota de Egreso se anulo correctamente.');
        } catch (\Exception $e) {
            return dd($e);
            DB::rollBack();
            Session::flash('error', 'Exisitio un error en el servidor');
        }

        return redirect('notas-egreso?mes=' . $egreso->fecha->format('m') . '&anio=' . $egreso->fecha->format('Y'));
    }


    public function destroy(NotasEgreso $egreso)
    {
        try {
            DB::beginTransaction();
            $egreso->detalle()->delete();
            $egreso->delete();

            DB::commit();
            Session::flash('success', 'La nota de egreso se elimino correctamente.');
        } catch (\Exception $e) {
            DB::rollBack();
            Session::flash('error', 'Ocurrio un error en el servidor. Intente nuevamente porfavor.');
        }
        return redirect('/notas-egreso?mes=' . $egreso->fecha->month . '&anio=' . $egreso->fecha->year);
    }
}
