<?php

namespace App\Http\Controllers;

use App\DetalleIngreso;
use App\Libro;
use App\NotasIngreso;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Barryvdh\DomPDF\Facade as PDF;
use App\Exports\RelacionNotasIngresoExport;



class NotasIngresoController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $mes = date('m');
        $anio = date('Y');
        $id_nota = 0;
        $imprimir = false;
        if (isset($request->mes) || ($request->anio)) {
            $mes = $request->mes;
            $anio = $request->anio;
        }
        if (isset($request->i) &&  isset($request->n)) {
            $imprimir = $request->i;
            $id_nota = $request->n;
        }

        $datos = NotasIngreso::whereMonth('fecha', '=', $mes)
            ->whereYear('fecha', '=', $anio)
            ->orderBy('created_at', 'DESC')
            ->get();

        return view('almacen.ingreso.index', [
            'datos' => $datos,
            'mes' => $mes,
            'anio' => $anio,
            'imprimir' => $imprimir,
            'id_nota' => $id_nota
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $libros = Libro::orderBy('codigo', 'ASC')->get();
        return view('almacen.ingreso.create_edit', [
            'libros' => $libros
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //       return dd($request->all());

        try {
            DB::beginTransaction();
            if (isset($request->id)) {
                $i = NotasIngreso::find($request->id);
                $i->detalle()->delete();
            } else {
                $i = new NotasIngreso();
            }
            $i->recibe = 'ALMACEN CENTRAL';
            $i->envia = $request->envia;
            $i->fecha = $request->fecha;
            $i->concepto = $request->concepto;
            $i->cant_total = $request->cant_total;
            $i->glosa = strtoupper($request->glosa);
            $i->estado = 'G';
            $i->precio_total = $request->precio_total;
            $i->user_id = Auth::user()->id;
            $i->terminado = 0;
            //            $i->moneda=$request->;
            //            $i->valor_cambio=$request->;
            $i->obs = $request->obs;
            $i->save();

            foreach ($request->libro_id as $k => $v) {
                $det = new DetalleIngreso();
                $libro = Libro::find($v);
                $det->cantidad = $request->cant[$k];
                $det->codigo = $libro->codigo;
                $det->titulo = $libro->titulo;
                $det->volumen = $libro->tomo;
                $det->precio_unitario = $request->precio_unitario[$k];
                $det->precio_total = $request->precio_unitario[$k] * $request->cant[$k];
                $det->libro_id = $v;
                $det->ingreso_id = $i->id;
                $det->obs = $request->observacion[$k];
                $det->save();
            }


            DB::commit();
            Session::flash('success', 'La nota de Ingreso se guardo correctamente.');
        } catch (\Exception $e) {
            return dd($e);
            DB::rollBack();
            Session::flash('error', 'Ocurrio un error en el servidor. Intente nuevamente por favor');
        }

        return redirect('/notas-ingreso?mes=' . $i->fecha->month . '&anio=' . $i->fecha->year . '&n=' . $i->id . '&i=true');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\NotasIngreso  $notasIngreso
     * @return \Illuminate\Http\Response
     */
    public function show(NotasIngreso $ingreso)
    {

        $contrato = [];

        $devolucion = \App\DevolucionObras::where('ingreso_id', $ingreso->id)
            ->where('procedencia', 'COBRANZA')
            ->first();
        $credito = [];



        if (!is_null($devolucion)) {
            $contrato = $devolucion->contrato;
            $credito = \App\Credito::where('contrato_id', $contrato->id)->first();
        }


        return view(
            'almacen.partials.nota_ingreso',
            [
                'ingreso' => $ingreso,
                'contrato' => $contrato,
                'credito' => $credito,
            ]
        );
    }
    public function relacion(Request $request)
    {
        $mes = date('m');
        $anio = date('Y');


        if (isset($request->mes)) {
            $mes = $request->mes;
            $anio = $request->anio;
        }

        $datos = DB::table('view_ingreso_detalle')->whereMonth('fecha', '=', $mes)
            ->whereYear('fecha', '=', $anio)
            ->where('estado', 'T')
            ->orderBy('id', 'ASC')->orderBy('codigo', 'ASC')->get();

        if (isset($request->tipo)) {
            $tipo = $request->tipo;

            $nombrearchivo = 'relacion-notas-ingreso al 31-' . $mes . '-' . $anio;

            if ($tipo == 'excel') {
                return \Excel::download(new RelacionNotasIngresoExport($datos, $mes, $anio), $nombrearchivo.'.xlsx');

 
            } elseif ($tipo == 'pdf') {
                $pdf = PDF::loadView('almacen.ingreso.relacion-exportar', [
                    'datos' => $datos,
                    'estilos' => true,
                    'mes' => $mes,
                    'anio' => $anio
                ]);
                $pdf->setPaper('a4', 'landscape');
                return $pdf->stream($nombrearchivo);
            }
        }
        return view('almacen.ingreso.relacion', [
            'datos' => $datos,
            'mes' => $mes,
            'anio' => $anio
        ]);
    }


    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\NotasIngreso  $notasIngreso
     * @return \Illuminate\Http\Response
     */
    public function anular(NotasIngreso $ingreso)
    {
        try {
            DB::beginTransaction();
            $sw = true;

            foreach ($ingreso->detalle as $k => $v) {

                // $ingresos=\DB::table('view_ingreso_detalle')
                //     ->where('terminado','1')
                //     ->where('codigo',$v->codigo)
                //     ->whereMonth('fecha','=',$ingreso->fecha->month)
                //     ->whereYear('fecha','=',$ingreso->fecha->year)
                //     ->where('estado','T')->sum('cantidad');
                // $egresos=\DB::table('view_egreso_detalle')
                //     ->where('terminado','1')
                //     ->where('codigo',$v->codigo)
                //     ->whereMonth('fecha','=',$ingreso->fecha->month)
                //     ->whereYear('fecha','=',$ingreso->fecha->year)
                //     ->where('estado','T')->sum('cantidad');
                // $devoluciones=\DB::table('view_devolucion_detalle')
                //     ->where('terminado','1')
                //     ->where('codigo',$v->codigo)
                //     ->whereMonth('fecha','=',$ingreso->fecha->month)
                //     ->whereYear('fecha','=',$ingreso->fecha->year)
                //     ->where('estado','T')->sum('cantidad');

                // $remisiones=\DB::table('view_remision_detalle')

                //     ->where('codigo',$v->codigo)
                //     ->whereMonth('fecha','=',$ingreso->fecha->month)
                //     ->whereYear('fecha','=',$ingreso->fecha->year)
                //     ->where('estado','T')->sum('cantidad');
                // $stock=($ingresos+$devoluciones)-($remisiones+$egresos);
                $libro = Libro::where('codigo', $v->codigo)->first();

                $stock = $libro->stock;
                if (($stock - $v->cantidad) < 0) {
                    $sw = false;
                    break;
                }
            }

            if (!$sw) {
                Session::flash('warning', 'No se puede Anular este Ingreso originaria  en un saldo negativo en el inventario');
                return  redirect('notas-ingreso?mes=' . $ingreso->fecha->month . '&anio=' . $ingreso->fecha->year);
            }





            foreach ($ingreso->detalle as $d) {
                $l = Libro::find($d->libro_id);
                $l->stock = $l->stock - $d->cantidad;
                $l->save();
            }

            $ingreso->estado = 'A';
            $ingreso->save();
            DB::commit();
            Session::flash('success', 'La nota de Ingreso se anulo correctamente.');
        } catch (\Exception $e) {
            return dd($e);
            DB::rollBack();
            Session::flash('error', 'Exisitio un error en el servidor');
        }

        return redirect('notas-ingreso?mes=' . $ingreso->fecha->format('m') . '&anio=' . $ingreso->fecha->format('Y'));
    }


    public function procesar(NotasIngreso $ingreso)
    {
        try {
            DB::beginTransaction();

            foreach ($ingreso->detalle as $d) {
                $libro = Libro::find($d->libro_id);
                if (!is_null($libro)) {
                    if ($d->precio_unitario > $libro->precio_base) {
                        $libro->precio_base = $d->precio_unitario;
                        $libro->save();
                    }
                    $libro->stock += $d->cantidad;
                    $libro->save();
                }
            }
            $ingreso->terminado = 1;
            $ingreso->estado = 'T';
            $ingreso->save();
            DB::commit();
            Session::flash('sucess', 'La nota de  ingreso se proceso correctamente');
        } catch (\Exception $e) {
            DB::rollBack();
            Session::flash('error', 'Ocurrio un error en el servidor. Intente nuevamente porfavor');
        }
        return redirect('/notas-ingreso?mes=' . $ingreso->fecha->month . '&anio=' . $ingreso->fecha->year);
    }
    public function edit(NotasIngreso $ingreso)
    {
        $libros = Libro::orderBy('codigo', 'ASC')->get();
        return view('almacen.ingreso.create_edit', [
            'libros' => $libros,
            'ingreso' => $ingreso
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\NotasIngreso  $notasIngreso
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, NotasIngreso $notasIngreso)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\NotasIngreso  $notasIngreso
     * @return \Illuminate\Http\Response
     */
    public function destroy(NotasIngreso $ingreso)
    {
        try {
            DB::beginTransaction();
            $ingreso->detalle()->delete();
            $ingreso->delete();

            DB::commit();
            Session::flash('success', 'La nota de ingreso se elimino correctamente.');
        } catch (\Exception $e) {
            DB::rollBack();
            Session::flash('error', 'Ocurrio un error en el servidor. Intente nuevamente porfavor.');
        }
        return redirect('/notas-ingreso?mes=' . $ingreso->fecha->month . '&anio=' . $ingreso->fecha->year);
    }
}