<?php

namespace App\Http\Controllers;

use App\cobrador;
use App\Credito;
use App\Helper\Helper;
use App\Pago;
use App\Vendedor;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Excel;
use Barryvdh\DomPDF\Facade as PDF;
use Illuminate\Support\Collection;
use App\Deudor;
use App\CambioObra;
use App\Exports\CobranzaAsignacionesCobradorExport;
use App\Exports\CobranzaAsignacionDiariaExport;
use App\Exports\CobranzaCuadroProduccionExport;
use App\Exports\CobranzaConsolidadoCarteraExport;
use App\Exports\CobranzaRelacionCuentasNuevasExport;
use App\Exports\CobranzaCuentasCanceladasExport;
use App\Exports\CobranzaDevolucionesExport;
use App\Exports\CobranzaRelacionProntoPagoExport;
use App\Exports\CobranzaCuentasNuevasCobradasExport;
use App\Exports\CobranzaIncobrablesExport;
use App\Exports\CobranzaCambioObrasExport;

class ReporteCobranzaController extends Controller
{
    public function index()
    {
        return view('cobranza.reportes.index');
    }
    public function asignacionesCobrador(Request $request)
    {
        $filtro = 'MES';
        $cobrador = '';
        $vendedor = '';
        $mes = date('m');
        $anio = date('Y');
        $cobradores = cobrador::orderBy('nombres', 'ASC')->get();
        $vendedores = \DB::table('view_vendedores_cobranza')->orderBy('vendedor_nombre', 'ASC')->get();
        $datos = [];
        if (isset($request->consultar)) {
            $filtro = $request->filtro;
            $cobrador = $request->cobrador;
            $vendedor = $request->vendedor;
            $mes = $request->mes;
            $anio = $request->anio;
            $ultima_fecha_mes = Carbon::createFromDate($anio, $mes, 1)->endOfMonth();
            $mes_anterior = Carbon::createFromDate($anio, $mes, 1)
                ->addMonth(-1)
                ->endOfMonth();
            $mes_anterior2 = Carbon::createFromDate($anio, $mes, 1)->addmonth(-1);
            if ($vendedor != '' && $cobrador == '') {
                $sql = Credito::where('fechadoc', '<=', $mes_anterior2->endOfMonth()->format('Y-m-d'))
                    ->where('cobrador_id', '!=', '')
                    ->where('vendedor_nombre', $vendedor)
                    ->where('numcuenta', '!=', '')
                    ->where('saldo_inicial', '>', '0')
                    ->where('estado', '!=', 'A')
                    ->select('id', 'fechadoc', 'estado', 'fecha_terminado', 'valor_venta', 'vendedor_nombre', 'nombre_cliente', 'numcuenta', 'cobrador_id', 'saldo', 'saldo_inicial', 'diacobrar', 'montocuotas')
                    ->orderBy('fechadoc', 'DESC')
                    ->get();
                $sql = $sql->filter(function ($c, $key) use ($mes_anterior2) {
                    return $c->calcularCanceladas($mes_anterior2->endOfMonth());
                });
            } elseif ($vendedor == '' && $cobrador != '') {
                $sql = Credito::where('fechadoc', '<=', $mes_anterior2->endOfMonth()->format('Y-m-d'))
                    ->where('cobrador_id', $cobrador)
                    ->where('numcuenta', '!=', '')
                    // ->where('numcuenta', '=', '1882')
                    ->where('saldo_inicial', '>', '0')
                    ->where('estado', '!=', 'A')
                    ->select('id', 'fechadoc', 'estado', 'fecha_terminado', 'valor_venta', 'vendedor_nombre', 'nombre_cliente', 'numcuenta', 'cobrador_id', 'saldo', 'saldo_inicial', 'diacobrar', 'montocuotas')
                    ->orderBy('fechadoc', 'DESC')
                    ->get();
                $sql = $sql->filter(function ($c, $key) use ($mes_anterior2) {
                    return $c->calcularCanceladas($mes_anterior2->endOfMonth());
                });
            } elseif ($vendedor != '' && $cobrador != '') {
                $sql = Credito::where('fechadoc', '<=', $mes_anterior2->endOfMonth()->format('Y-m-d'))
                    ->where('cobrador_id', $cobrador)
                    ->where('vendedor_nombre', $vendedor)
                    ->where('numcuenta', '!=', '')
                    ->where('saldo_inicial', '>', '0')
                    ->where('estado', '!=', 'A')
                    ->select('id', 'fechadoc', 'estado', 'fecha_terminado', 'valor_venta', 'vendedor_nombre', 'nombre_cliente', 'numcuenta', 'cobrador_id', 'saldo', 'saldo_inicial', 'diacobrar', 'montocuotas')
                    ->orderBy('fechadoc', 'DESC')
                    ->get();
                $sql = $sql->filter(function ($c, $key) use ($mes_anterior2) {
                    return $c->calcularCanceladas($mes_anterior2->endOfMonth());
                });
            } elseif ($vendedor == '' && $cobrador == '') {
                $sql = Credito::where('fechadoc', '<=', $mes_anterior2->endOfMonth()->format('Y-m-d'))
                    ->where('cobrador_id', '!=', '')
                    ->where('numcuenta', '!=', '')
                    ->where('saldo_inicial', '>', '0')
                    ->where('estado', '!=', 'A')
                    ->select('id', 'fechadoc', 'estado', 'fecha_terminado', 'valor_venta', 'vendedor_nombre', 'nombre_cliente', 'numcuenta', 'cobrador_id', 'saldo', 'saldo_inicial', 'diacobrar', 'montocuotas')
                    ->orderBy('fechadoc', 'DESC')
                    ->get();
                $sql = $sql->filter(function ($c, $key) use ($mes_anterior2) {
                    return $c->calcularCanceladas($mes_anterior2->endOfMonth());
                });
            }
            if (count($sql) > 0) {
                foreach ($sql as $k => $v) {
                    $fup = '';
                    $fecha_cobranza = '';
                    $numrecibo = '';
                    $numreporte = '';
                    $credito = $v;
                    $pagos_anteriores = $credito->saldoAcumuladoMesAnio($mes_anterior->month, $mes_anterior->year);
                    // if ($credito->numcuenta == '3266') {
                    //     dd($pagos_anteriores);
                    // }
                    $saldo = $pagos_anteriores['saldo'];
                    $saldo_actual = 0;
                    if ($request->filtro == 'FINAL') {
                        $pago_actual = $credito->saldoMesAnio2($mes, $anio);
                        if (count($pago_actual) > 0) {
                            $saldo_actual = $saldo - $pago_actual['monto_cobrado'];
                            $fecha_cobranza = $pago_actual['fup'];
                            $numrecibo = $pago_actual['numrecibo'];
                            $numreporte = $pago_actual['numreporte'];
                            $monto_cobrado = $pago_actual['monto_cobrado'];
                        } else {
                            $saldo_actual = $saldo;
                        }
                    } else {
                        $saldo_actual = $saldo;
                        $fecha_cobranza = '';
                        $numrecibo = '';
                        $numreporte = '';
                        $monto_cobrado = 0;
                    }
                    $obser = '';
                    if ($saldo_actual <= 0) {
                        $obser = 'CANCELADO';
                    }
                    if (isset($pagos_anteriores)) {
                        $fup = $pagos_anteriores['fup'];
                    }
                    $dias_atrazo = Helper::diasAtrazo($fup, $ultima_fecha_mes);
                    $cobradornombre = '';
                    if (isset($v->cobrador)) {
                        $cobradornombre = $v->cobrador->nombre_completo;
                    }
                    $mon_cuotas = $v->montocuotas;
                    if ($saldo_actual < $v->montocuotas && $v->saldo_actual > 0) {
                        $mon_cuotas = $v->saldo_actual;
                    }
                    $datos[] = [
                        'cod_cl' => $v->numcuenta,
                        'vendedor' => $v->vendedor_nombre,
                        'cliente' => $v->nombre_cliente,
                        'fecha_venta' => $v->fechadoc->format('d-m-Y'),
                        'valor_venta' => $v->valor_venta,
                        'saldo_anterior_fecha' => $mes_anterior->format('d-m-Y'),
                        'saldo_anterior_monto' => $saldo,
                        'dia_cobranza' => $v->diacobrar,
                        'fup' => $fup,
                        'cuota_mensual' => $mon_cuotas,
                        'importe_cobrado' => $monto_cobrado,
                        'fecha_cobranza' => $fecha_cobranza,
                        'saldo_actual_fecha' => '31-' . $mes . '-' . $anio,
                        'saldo_actual_monto' => $saldo_actual,
                        'porcentaje' => Helper::porcentajeCobro($monto_cobrado, $v->montocuotas),
                        'obser' => $obser,
                        'numrecibo' => $numrecibo,
                        'numreporte' => $numreporte,
                        'dias_atrazo' => $dias_atrazo['atrazo'],
                        'numdias_atrazo' => $dias_atrazo['dias'],
                        'cobrador_nombre' => $cobradornombre,
                        'cobrador' => $cobrador
                    ];
                }
            }
        }
        if (isset($request->tipoexportacion)) {
            $tipo = $request->tipoexportacion;
            $detalles = [
                'mes' => $mes,
                'anio' => $anio,
                'filtro' => $filtro,
                'vendedor' => $vendedor,
                'cobrador' => $cobrador
            ];
            $nombrearchivo = "AsignacionCobrador" . $mes . "-" . $anio;
            if ($tipo == 'excel') {
                return \Excel::download(new CobranzaAsignacionesCobradorExport(Collection::make($datos), $detalles), $nombrearchivo . '.xlsx');
            } elseif ($tipo == 'pdf') {
                $pdf = PDF::loadView('cobranza.reportes.asignaciones.exportar', [
                    'datos' => Collection::make($datos),
                    'estilos' => true,
                    'detalles' => $detalles
                ]);
                $pdf->setPaper('a4', 'landscape');
                return $pdf->stream($nombrearchivo);
            }
        }
        return view('cobranza.reportes.asignaciones.index', [
            'filtro' => $filtro,
            'cobrador' => $cobrador,
            'vendedor' => $vendedor,
            'mes' => $mes,
            'anio' => $anio,
            'cobradores' => $cobradores,
            'vendedores' => $vendedores,
            'datos' => \Illuminate\Support\Collection::make($datos),
        ]);
    }
    public function asignacionesDiaria(Request $request)
    {
        $cobrador = 0;
        $vendedor = '';
        $mes = date('m');
        $anio = date('Y');
        $dias = '';
        $cobradores = cobrador::orderBy('nombres', 'ASC')->get();
        $vendedores = \DB::table('view_vendedores_cobranza')->orderBy('vendedor_nombre', 'ASC')->get();
        $datos = [];
        if (isset($request->consultar)) {
            //   return dd($request->all());
            $mes = $request->mes;
            $anio = $request->anio;
            $cobrador = $request->cobrador;
            $vendedor = $request->vendedor;
            $dias = $request->dia;
            $fecha_ini = $anio . '-' . $mes . '-1';
            $fecha_consulta = $anio . '-' . $mes . '-31';
            if ($dias != '' || ($dias > 0 && $dias < 32)) {
                $fecha_consulta = $anio . '-' . $mes . '-' . $dias;
            } else {
                $dias = 31;
            }
            $mes_anterior = Carbon::createFromDate($anio, $mes, 1)
                ->addMonth(-1)
                ->endOfMonth()
                ->toDateString();
            // return dd($mes_anterior);
            $ultima_fecha_mes = $fecha_consulta;
            if ($vendedor == '' && $cobrador == '') {
                $cuentas = Credito::where('credito.diacobrar', '<=', $dias)
                    ->where('credito.estado', 'C')
                    ->where('numcuenta', '!=', '')
                    ->where('saldo_inicial', '>', '0')
                    ->select('id', 'fechadoc', 'valor_venta', 'vendedor_nombre', 'nombre_cliente', 'numcuenta', 'cobrador_id', 'saldo', 'saldo_inicial', 'diacobrar', 'montocuotas')
                    ->get();
            }
            if ($vendedor != '' && $cobrador == '') {
                $cuentas = Credito::where('credito.diacobrar', '<=', $dias)
                    ->where('credito.estado', 'C')
                    ->where('numcuenta', '!=', '')
                    ->where('saldo_inicial', '>', '0')
                    ->where('credito.vendedor_nombre', $vendedor)
                    ->select('id', 'fechadoc', 'valor_venta', 'vendedor_nombre', 'nombre_cliente', 'numcuenta', 'cobrador_id', 'saldo', 'saldo_inicial', 'diacobrar', 'montocuotas')
                    ->get();
            }
            if ($vendedor == '' && $cobrador != '') {
                //   return dd($cobrador);
                $cuentas = Credito::where('credito.diacobrar', '<=', $dias)
                    ->where('credito.estado', 'C')
                    ->where('numcuenta', '!=', '')
                    ->where('saldo_inicial', '>', '0')
                    ->where('credito.cobrador_id', $cobrador)
                    ->select('id', 'fechadoc', 'valor_venta', 'vendedor_nombre', 'nombre_cliente', 'numcuenta', 'cobrador_id', 'saldo', 'saldo_inicial', 'diacobrar', 'montocuotas')
                    ->get();
            }
            if ($vendedor != '' && $cobrador != '') {
                $cuentas = Credito::where('credito.diacobrar', '<=', $dias)
                    ->where('credito.estado', 'C')
                    ->where('numcuenta', '!=', '')
                    ->where('saldo_inicial', '>', '0')
                    ->where('credito.vendedor_nombre', $vendedor)
                    ->where('credito.cobrador_id', $cobrador)
                    ->select('id', 'fechadoc', 'valor_venta', 'vendedor_nombre', 'nombre_cliente', 'numcuenta', 'cobrador_id', 'saldo', 'saldo_inicial', 'diacobrar', 'montocuotas')
                    ->get();
            }
            foreach ($cuentas as $v) {
                $pagos = Pago::where('model_id', $v->id)
                    ->where('model_type', 'pago-cobranza')
                    ->whereMonth('fecha', '=', $mes)
                    ->whereYear('fecha', '=', $anio)
                    ->get();
                if (count($pagos) <= 0) {
                    $sql_pago = Pago::where('model_id', $v->id)
                        ->where('model_type', 'pago-cobranza')
                        ->orderBy('fecha', 'DESC')
                        ->first();
                    if (is_null($sql_pago)) {
                        $fup = $v->fechadoc->format('d-m-Y');
                    } else {
                        $fup = $sql_pago->fecha->format('d-m-Y');
                    }
                    $cobrador = '';
                    if (isset($v->cobrador)) {
                        $cobrador = $v->cobrador->nombre_completo;
                    }
                    $fecha = '';
                    if (isset($v->fechadoc))
                        $fecha = $v->fechadoc->format('d-m-Y');
                    $dias_atrazo = Helper::diasAtrazo($fup, Carbon::createFromFormat('Y-m-d', $ultima_fecha_mes));
                    $mon_cuotas = $v->montocuotas;
                    if ($v->saldo < $v->montocuotas) {
                        $mon_cuotas = $v->saldo;
                    }
                    $datos[] = [
                        'cod_cl' => $v->numcuenta,
                        'vendedor' => $v->vendedor_nombre,
                        'cliente' => $v->nombre_cliente,
                        'fecha_venta' => $fecha,
                        'valor_venta' => $v->valor_venta,
                        'saldo_anterior_fecha' => $mes_anterior,
                        'saldo_anterior_monto' => $v->saldo,
                        'dia_cobranza' => $v->diacobrar,
                        'fup' => $fup,
                        'cuota_mensual' => $mon_cuotas,
                        'importe_cobrado' => 0,
                        'fecha_cobranza' => '',
                        'saldo_actual_fecha' => '31-' . $mes . '-' . $anio,
                        'saldo_actual_monto' => $v->saldo,
                        'porcentaje' => Helper::porcentajeCobro(0, $v->montocuotas),
                        'obser' => '',
                        'numrecibo' => '',
                        'numreporte' => '',
                        'dias_atrazo' => $dias_atrazo['atrazo'],
                        'numdias_atrazo' => $dias_atrazo['dias'],
                        'cobrador' => $cobrador
                    ];
                }
            }
            if (isset($request->tipoexportacion)) {
                $tipo = $request->tipoexportacion;
                $nombrearchivo = 'asignacionDiaria-' . $mes . '-' . $anio;
                $detalles = [
                    'mes' => $mes,
                    'anio' => $anio,
                    'cobrador' => $cobrador,
                    'vendedor' => $vendedor,
                    'dias' => $dias,
                ];
                if ($tipo == 'excel') {
                    return \Excel::download(new CobranzaAsignacionDiariaExport($datos, $detalles), $nombrearchivo . '.xlsx');
                } elseif ($tipo == 'pdf') {
                    $pdf = PDF::loadView('cobranza.reportes.asignacion-diaria.exportar', [
                        'datos' => $datos,
                        'estilos' => true,
                        'detalles' => $detalles
                    ]);
                    $pdf->setPaper('a4', 'portrait');
                    return $pdf->stream($nombrearchivo);
                }
            }
        }
        return view('cobranza.reportes.asignacion-diaria.index', [
            'cobrador' => $cobrador,
            'vendedor' => $vendedor,
            'mes' => $mes,
            'anio' => $anio,
            'cobradores' => $cobradores,
            'vendedores' => $vendedores,
            'datos' => \Illuminate\Support\Collection::make($datos),
            'dias' => $dias,
        ]);
    }
    public function cuadroProduccion(Request $request)
    {
        $mes = date('m');
        $anio = date('Y');
        $fecha_ref = Carbon::now();
        $cobranza_estandar = 0;
        $datos = [];
        $config = \Illuminate\Support\Facades\DB::table('config')->first();
        if (!is_null($config) && $config->cobranza_estandar != '') {
            $cobranza_estandar = $config->cobranza_estandar / 100;
        }
        if (isset($request->consultar)) {
            //   return dd($request->all());
            $mes = $request->mes;
            $anio = $request->anio;
            $fecha_mes_anterior = Carbon::createFromDate($anio, $mes, 1)->addmonth(-2);
            $fecha_mes_anterior2 = Carbon::createFromDate($anio, $mes, 1)->addmonth(-1);
            $fecha_consulta = $anio . '-' . $mes . '-31';
            $fecha_actual = Carbon::createFromDate($anio, $mes)->endOfMonth();
            $fecha_ref = Carbon::createFromFormat('d/m/Y', $request->fecha_referencia);
            $diff_fechas = $fecha_actual->diffInDays($fecha_ref, false);
            $cuentas3 = Credito::where('fechadoc', '<=', $fecha_mes_anterior2->endOfMonth()->format('Y-m-d'))
                ->where('cobrador_id', '!=', '')
                // ->where('cobrador_id', '=', '17')
                ->where('numcuenta', '!=', '')
                ->where('saldo_inicial', '>', '0')
                ->where('estado', '!=', 'A')
                ->select('id', 'fechadoc', 'estado', 'fecha_terminado', 'valor_venta', 'vendedor_nombre', 'nombre_cliente', 'numcuenta', 'cobrador_id', 'saldo', 'saldo_inicial', 'diacobrar', 'montocuotas')
                ->orderBy('fechadoc', 'DESC')
                ->get();
            // return dd($cuentas3);
            $cuentas3 = $cuentas3->filter(function ($c, $key) use ($fecha_mes_anterior2) {
                return $c->calcularCanceladas($fecha_mes_anterior2->endOfMonth());
            });
            $cuentas3 = $cuentas3->groupBy('cobrador_id');
            // return dd($cuentas3->pluck('valor_venta'));
            foreach ($cuentas3 as $k => $cuenta) {
                $debito_total = 0;
                $numcuentascobradas = 0;
                $bolivianoscobrados = 0;
                $numcuentascobrar = 0;
                $monto_cuotas = 0;
                $aux = [];
                // dd($cuenta->pluck('numcuenta'));
                foreach ($cuenta as $k1 => $p) {
                    $aux2 = 0;
                    if ($p->saldo_actual < $p->montocuotas && $p->saldo_actual > 0) {
                        $aux2 = $p->saldo_actual;
                    } else {
                        $aux2 = $p->montocuotas;
                    }
                    $monto_cuotas += $aux2;
                    // $debito = $p->saldoAcumuladoMesAnio($fecha_mes_anterior2->month, $fecha_mes_anterior->year);
                    $debito = $p->saldoAcumuladoMesAnio($fecha_mes_anterior2->month, $fecha_mes_anterior2->year);
                    $debito2 = $p->saldoMesAnio2($mes, $anio);
                    // echo '<br>' . $p->numcuenta . '=' . $debito['saldo'] . '<br>';
                    $debito_total += $debito['saldo'];
                    // $debito_total += $p->valor_venta;
                    $numcuentascobradas += 1;
                    $bolivianoscobrados += $debito2['monto_cobrado'];
                    $numcuentascobrar += $debito2['porcentaje'];
                }
                $bolivianoscobrar = $monto_cuotas;
                $cobranzaestandar = round($bolivianoscobrar * $cobranza_estandar, 2);
                $bsquefaltancobrar = $cobranzaestandar - $bolivianoscobrados;
                try {
                    $bscobrarpordia = round($bsquefaltancobrar / $diff_fechas, 2);
                } catch (\Exception $e) {
                    $bscobrarpordia = 0;
                }
                if ($numcuentascobrar <= 0) {
                    $numcuentas91 = 0;
                    $cuentasquefaltacobrar91 = $numcuentas91 - $numcuentascobradas;
                    try {
                        $cuentaspordia91 = round($cuentasquefaltacobrar91 / $diff_fechas, 2);
                    } catch (\Exception $e) {
                        $cuentaspordia91 = 0;
                    }
                    $cuentasparaobjetivo = 0;
                } else {
                    $numcuentas91 = round($numcuentascobrar * $cobranza_estandar, 2);
                    $cuentasquefaltacobrar91 = $numcuentas91 - $numcuentascobradas;
                    try {
                        $cuentaspordia91 = round($cuentasquefaltacobrar91 / $diff_fechas, 2);
                    } catch (\Exception $e) {
                        $cuentaspordia91 = 0;
                    }
                    try {
                        $cuentasparaobjetivo = round(($cuentasquefaltacobrar91 * 100) / $numcuentas91, 2);
                    } catch (\Exception $e) {
                        $cuentasparaobjetivo = 0;
                    }
                }
                $datos[] = [
                    'cobrador' => cobrador::find($p->cobrador_id)->nombre_completo,
                    'debito_total' => $debito_total,
                    'bolivianoscobrar' => $bolivianoscobrar,
                    'bolivianoscobrados' => $bolivianoscobrados,
                    'porcentaje1' => round(($bolivianoscobrados * 100) / $bolivianoscobrar, 2),
                    'numcuentasporcobrar' => $numcuentascobradas,
                    'numcuentascobradas' => $numcuentascobrar,
                    'porcentaje2' => round(($numcuentascobrar * 100) / $numcuentascobradas, 2),
                    'cobranzaestandar' => $cobranzaestandar,
                    'bsquefaltancobrar' => $bsquefaltancobrar,
                    'bsquefaltancobrardia' => $bscobrarpordia,
                    'porcentaje3' => round(($bscobrarpordia * 100) / $cobranzaestandar, 2),
                    'numcuentas91' => $numcuentas91,
                    'cuentasquefaltacobrar91' => $cuentasquefaltacobrar91,
                    'cuentaspordia91' => $cuentaspordia91,
                    'cuentasparaobjetivo' => $cuentasparaobjetivo
                ];
            }
            if (isset($request->tipoexportacion)) {
                $tipo = $request->tipoexportacion;
                $nombrearchivo = 'cuadroProduccion-' . $mes . '-' . $anio;
                $detalles = [
                    'mes' => $mes,
                    'anio' => $anio,
                    'fecha_ref' => $fecha_ref->format('d/m/Y'),
                ];
                if ($tipo == 'excel') {
                    return \Excel::download(new CobranzaCuadroProduccionExport( \Illuminate\Support\Collection::make($datos), $detalles,$config), $nombrearchivo . '.xlsx');
                } elseif ($tipo == 'pdf') {
                    $pdf = PDF::loadView('cobranza.reportes.cuadroproducciongeneral.exportar', [
                        'datos' => \Illuminate\Support\Collection::make($datos),
                        'estilos' => true,
                        'detalles' => $detalles,
                        'config'=>$config
                    ]);
                    $pdf->setPaper('a4', 'landscape');
                    return $pdf->stream($nombrearchivo);
                }
            }
        }
        return view('cobranza.reportes.cuadroproducciongeneral.index', [
            'mes' => $mes,
            'anio' => $anio,
            'datos' => \Illuminate\Support\Collection::make($datos),
            'fecha_referencia' => $fecha_ref->format('d/m/Y'),
            'config'=>$config
        ]);
    }
    public function consolidadoCartera(Request $request)
    {
        $cobrador = 0;
        $vendedor = '';
        $mes = date('m');
        $anio = date('Y');
        $cobradores = cobrador::orderBy('nombres', 'ASC')->get();
        $vendedores = \DB::table('view_vendedores_cobranza')->orderBy('vendedor_nombre', 'ASC')->get();
        $datos = [];
        $tipo_cierre = 'INICIO';
        if (isset($request->consultar)) {
            $cobrador = $request->cobrador;
            $vendedor = $request->vendedor;
            $mes = $request->mes;
            $anio = $request->anio;
            $tipo_cierre = $request->tipo;
            $ultima_fecha_mes = Carbon::createFromDate($anio, $mes, 1)->endOfMonth();
            $mes_anterior = Carbon::createFromDate($anio, $mes, 1)
                ->addMonth(-2)
                ->endOfMonth();
            $mes_anterior2 = Carbon::createFromDate($anio, $mes, 1)->addmonth(-1);
            if ($vendedor != '' && $cobrador == '') {
                $sql2 = Credito::where('fechadoc', '<=', $mes_anterior2->endOfMonth()->format('Y-m-d'))
                    ->where('cobrador_id', "!=", '')
                    ->where('vendedor_nombre', $vendedor)
                    ->where('numcuenta', '!=', '')
                    ->select('id', 'fechadoc', 'estado', 'fecha_terminado', 'valor_venta', 'vendedor_nombre', 'nombre_cliente', 'numcuenta', 'cobrador_id', 'saldo', 'saldo_inicial', 'diacobrar', 'montocuotas')
                    ->orderBy('fechadoc', 'DESC')
                    ->get();
                $filtradas = $sql2->filter(function ($c, $key) use ($mes_anterior2) {
                    return $c->calcularCanceladas($mes_anterior2->endOfMonth());
                });
            } elseif ($vendedor == '' && $cobrador != '') {
                $sql2 = Credito::where('fechadoc', '<=', $mes_anterior2->endOfMonth()->format('Y-m-d'))
                    ->where('cobrador_id', $cobrador)
                    ->where('numcuenta', '!=', '')
                    ->select('id', 'fechadoc', 'estado', 'fecha_terminado', 'valor_venta', 'vendedor_nombre', 'nombre_cliente', 'numcuenta', 'cobrador_id', 'saldo', 'saldo_inicial', 'diacobrar', 'montocuotas')
                    ->orderBy('fechadoc', 'DESC')
                    ->get();
                $filtradas = $sql2->filter(function ($c, $key) use ($mes_anterior2) {
                    return $c->calcularCanceladas($mes_anterior2->endOfMonth());
                });
            } elseif ($vendedor != '' && $cobrador != '') {
                $sql2 = Credito::where('fechadoc', '<=', $mes_anterior2->endOfMonth()->format('Y-m-d'))
                    ->where('cobrador_id', $cobrador)
                    ->where('vendedor_nombre', $vendedor)
                    ->where('numcuenta', '!=', '')
                    ->select('id', 'fechadoc', 'estado', 'fecha_terminado', 'valor_venta', 'vendedor_nombre', 'nombre_cliente', 'numcuenta', 'cobrador_id', 'saldo', 'saldo_inicial', 'diacobrar', 'montocuotas')
                    ->orderBy('fechadoc', 'DESC')
                    ->get();
                $filtradas = $sql2->filter(function ($c, $key) use ($mes_anterior2) {
                    return $c->calcularCanceladas($mes_anterior2->endOfMonth());
                });
            } elseif ($vendedor == '' && $cobrador == '') {
                $sql2 = Credito::where('fechadoc', '<=', $mes_anterior2->endOfMonth()->format('Y-m-d'))
                    ->where('cobrador_id', '!=', '')
                    ->where('numcuenta', '!=', '')
                    ->select('id', 'fechadoc', 'estado', 'fecha_terminado', 'valor_venta', 'vendedor_nombre', 'nombre_cliente', 'numcuenta', 'cobrador_id', 'saldo', 'saldo_inicial', 'diacobrar', 'montocuotas')
                    ->orderBy('fechadoc', 'DESC')
                    ->get();
                $filtradas = $sql2->filter(function ($c, $key) use ($mes_anterior2) {
                    return $c->calcularCanceladas($mes_anterior2->endOfMonth());
                });
                // $sql = $filtradas;
            }
            foreach ($filtradas as $k => $c) {
                $credito = Credito::find($c->id);
                $saldo_mes_anterior = $credito->saldoAcumuladoMesAnio($mes_anterior->month, $mes_anterior->year);
                $saldo_mes_actual = $credito->saldoMesAnio2($mes, $anio);
                $monto_cobrado = $saldo_mes_actual['monto_cobrado'];
                $fecha_cobranza = '';
                $saldo_actual = $saldo_mes_anterior['saldo'];
                $porcentaje = 0;
                $obs = '';
                $num_recibo = '';
                $num_reporte = '';
                $dias30 = '';
                $dias60 = '';
                $dias90 = '';
                $dias120 = '';
                if ($monto_cobrado > 0) {
                    $fecha_cobranza = $saldo_mes_actual['fup'];
                    $saldo_actual = round($saldo_mes_anterior['saldo'] - $saldo_mes_actual['monto_cobrado'], 2);
                    $porcentaje = Helper::porcentajeCobro($monto_cobrado, $c->montocuotas);
                    if ($saldo_actual <= 0) {
                        $obs = 'CANCELADO';
                    }
                    $num_recibo = $saldo_mes_actual['numrecibo'];
                    $num_reporte = $saldo_mes_actual['numreporte'];
                }
                $dias_atrazo = Helper::diasAtrazo($saldo_mes_anterior['fup'], $ultima_fecha_mes);
                if ($dias_atrazo['dias'] == 30) {
                    $dias30 = 1;
                }
                if ($dias_atrazo['dias'] == 60) {
                    $dias30 = 1;
                }
                if ($dias_atrazo['dias'] == 90) {
                    $dias90 = 1;
                }
                if ($dias_atrazo['dias'] == 120) {
                    $dias120 = 1;
                }
                //    return dd($tipo_cierre);
                $datos[] = [
                    'cod_cli' => $c->numcuenta,
                    'vendedor' => $c->vendedor_nombre,
                    'cliente' => $c->nombre_cliente,
                    'fechaventa' => $c->fechadoc,
                    'valorventa' => $c->valor_venta,
                    'saldo_anterior' => $saldo_mes_anterior['saldo'],
                    'dia_cobranza' => $c->diacobrar,
                    'fup' => $saldo_mes_anterior['fup'],
                    'cuotamensual' => $c->montocuotas,
                    'monto' => $saldo_mes_actual['monto_cobrado'],
                    'fecha_cobranza' => $saldo_mes_actual['fup'],
                    'saldo_actual' => $saldo_actual,
                    'porcentaje' => $porcentaje,
                    'obs' => $obs,
                    'numrecibo' => $num_recibo,
                    'numreporte' => $num_reporte,
                    'diasatrazo' => $dias_atrazo['atrazo'],
                    'dias30' => $dias30,
                    'dias60' => $dias60,
                    'dias90' => $dias90,
                    'dias120' => $dias120,
                    'cobrador' => $c->cobrador->nombre_completo,
                    'saldo_anterior_fecha' => $mes_anterior->format('d-m-Y'),
                    'saldo_actual_fecha' => $ultima_fecha_mes->format('d-m-Y'),
                    'tipocierre' => $tipo_cierre
                ];
            }
            if (isset($request->tipoexportacion)) {
                $tipo = $request->tipoexportacion;
                $tipo_cierre = $request->tipo;
                $nombrearchivo = 'Consolidado-' . $mes . '-' . $anio;
                $detalles = [
                    'mes' => $mes,
                    'anio' => $anio,
                    'cobrador' => $cobrador,
                    'vendedor' => $vendedor,
                ];
                if ($tipo == 'excel') {
                    return \Excel::download(new CobranzaConsolidadoCarteraExport(\Illuminate\Support\Collection::make($datos), $detalles, $tipo_cierre), $nombrearchivo . '.xlsx');
                } elseif ($tipo == 'pdf') {
                    $pdf = PDF::loadView('cobranza.reportes.consolidado.exportar', [
                        'datos' => \Illuminate\Support\Collection::make($datos),
                        'estilos' => true,
                        'detalles' => $detalles
                    ]);
                    $pdf->setPaper('a4', 'landscape');
                    return $pdf->download($nombrearchivo);
                }
            }
        }
        return view('cobranza.reportes.consolidado.index', [
            'datos' => \Illuminate\Support\Collection::make($datos),
            'mes' => $mes,
            'anio' => $anio,
            'vendedores' => $vendedores,
            'cobradores' => $cobradores,
            'vendedor' => $vendedor,
            'cobrador' => $cobrador,
            'tipo_cierre' => $tipo_cierre
        ]);
    }
    public function relacionNuevas(Request $request)
    {
        $cobrador = 0;
        $vendedor = '';
        $mes = date('m');
        $anio = date('Y');
        $cobradores = cobrador::orderBy('nombres', 'ASC')->get();
        $vendedores = \DB::table('view_vendedores_cobranza')->orderBy('vendedor_nombre', 'ASC')->get();
        $datos = [];
        if (isset($request->consultar)) {
            $cobrador = $request->cobrador;
            $vendedor = $request->vendedor;
            $mes = $request->mes;
            $anio = $request->anio;
            $ultima_fecha_mes = Carbon::createFromDate($anio, $mes, 1)->endOfMonth();
            $mes_anterior = Carbon::createFromDate($anio, $mes, 1)
                ->addMonth(-1)
                ->endOfMonth();
            if ($vendedor != '' && $cobrador == '') {
                $sql = Credito::where('estado', 'C')
                    ->where('vendedor_nombre', $vendedor)
                    ->whereMonth('fechadoc', '=', $mes)
                    ->whereYear('fechadoc', '=', $anio)
                    ->where('cobrador_id', '!=', '')
                    ->orderBy('fechadoc', 'ASC')
                    ->get();
            } elseif ($vendedor == '' && $cobrador != '') {
                $sql = Credito::where('estado', 'C')
                    ->where('cobrador_id', $cobrador)
                    ->whereMonth('fechadoc', '=', $mes)
                    ->whereYear('fechadoc', '=', $anio)
                    ->orderBy('fechadoc', 'ASC')
                    ->get();
            } elseif ($vendedor != '' && $cobrador != '') {
                $sql = Credito::where('estado', 'C')
                    ->where('cobrador_id', $cobrador)
                    ->whereMonth('fechadoc', '=', $mes)
                    ->whereYear('fechadoc', '=', $anio)
                    ->where('vendedor_nombre', $vendedor)
                    ->orderBy('fechadoc', 'ASC')
                    ->get();
            } elseif ($vendedor == '' && $cobrador == '') {
                $sql = Credito::where('estado', 'C')
                    ->where('cobrador_id', '!=', '')
                    ->whereMonth('fechadoc', '=', $mes)
                    ->whereYear('fechadoc', '=', $anio)
                    ->orderBy('fechadoc', 'ASC')
                    ->get();
            }
            foreach ($sql as $f) {
                $datos[] = [
                    'codcl' => $f->numcuenta,
                    'vendedor' => $f->vendedor_nombre,
                    'cliente' => $f->nombre_cliente,
                    'fecha_venta' => $f->fechadoc->format('d-m-Y'),
                    'saldo' => $f->saldo_inicial,
                    'valorventa' => $f->valor_venta,
                    'diacobrar' => $f->diacobrar,
                    'fup' => $f->fechadoc->format('d-m-Y'),
                    'cuota' => $f->montocuotas,
                    'cobrador' => $f->cobrador->nombre_completo
                ];
            }
            if (isset($request->tipoexportacion)) {
                $tipo = $request->tipoexportacion;
                $nombrearchivo = 'CuentasNuevas-' . $mes . '-' . $anio;
                $detalles = [
                    'mes' => $mes,
                    'anio' => $anio,
                ];
                if ($tipo == 'excel') {
                    return \Excel::download(new CobranzaRelacionCuentasNuevasExport($datos, $detalles), $nombrearchivo . '.xlsx');
                } elseif ($tipo == 'pdf') {
                    $pdf = PDF::loadView('cobranza.reportes.relacionnuevas.exportar', [
                        'datos' => \Illuminate\Support\Collection::make($datos),
                        'estilos' => true,
                        'detalles' => $detalles
                    ]);
                    $pdf->setPaper('a4', 'portrait');
                    return $pdf->stream($nombrearchivo);
                }
            }
        }
        return view('cobranza.reportes.relacionnuevas.index', [
            'datos' => \Illuminate\Support\Collection::make($datos),
            'mes' => $mes,
            'anio' => $anio,
            'vendedores' => $vendedores,
            'cobradores' => $cobradores,
            'vendedor' => $vendedor,
            'cobrador' => $cobrador
        ]);
    }
    public function cuentasCanceladas(Request $request)
    {
        $cobrador = 0;
        $vendedor = '';
        $mes = date('m');
        $anio = date('Y');
        $cobradores = cobrador::orderBy('nombres', 'ASC')->get();
        $vendedores = \DB::table('view_vendedores_cobranza')->orderBy('vendedor_nombre', 'ASC')->get();
        $datos = [];
        if (isset($request->consultar)) {
            $cobrador = $request->cobrador;
            $vendedor = $request->vendedor;
            $mes = $request->mes;
            $anio = $request->anio;
            $ultima_fecha_mes = Carbon::createFromDate($anio, $mes, 1)->endOfMonth();
            $mes_anterior = Carbon::createFromDate($anio, $mes, 1)
                ->addMonth(-1)
                ->endOfMonth();
            if ($vendedor != '' && $cobrador == '') {
                $sql = Credito::where('estado', 'T')
                    ->where('vendedor_nombre', $vendedor)
                    ->where('tipo_terminado', 'pago')
                    ->whereMonth('fecha_terminado', '=', $mes)
                    ->whereYear('fecha_terminado', '=', $anio)
                    ->where('cobrador_id', '!=', '')
                    ->orderBy('fechadoc', 'ASC')
                    ->get();
            } elseif ($vendedor == '' && $cobrador != '') {
                $sql = Credito::where('estado', 'T')
                    ->where('cobrador_id', $cobrador)
                    ->where('tipo_terminado', 'pago')
                    ->whereMonth('fecha_terminado', '=', $mes)
                    ->whereYear('fecha_terminado', '=', $anio)
                    ->orderBy('fechadoc', 'ASC')
                    ->get();
            } elseif ($vendedor != '' && $cobrador != '') {
                $sql = Credito::where('estado', 'T')
                    ->where('cobrador_id', $cobrador)
                    ->where('vendedor_nombre', $vendedor)
                    ->where('tipo_terminado', 'pago')
                    ->whereMonth('fecha_terminado', '=', $mes)
                    ->whereYear('fecha_terminado', '=', $anio)
                    ->orderBy('fechadoc', 'ASC')
                    ->get();
            } elseif ($vendedor == '' && $cobrador == '') {
                $sql = Credito::where('estado', 'T')
                    ->where('cobrador_id', '!=', '')
                    ->where('tipo_terminado', 'pago')
                    ->whereMonth('fecha_terminado', '=', $mes)
                    ->whereYear('fecha_terminado', '=', $anio)
                    ->orderBy('fechadoc', 'ASC')
                    ->get();
            }
            foreach ($sql as $f) {
                $credito = Credito::find($f->id);
                $saldo_anterior = $credito->saldoAcumuladoMesAnio($mes, $mes_anterior->year);
                $pago_actual = $credito->saldoMesAnio2($mes, $anio);
                $datos[] = [
                    'codcl' => $f->numcuenta,
                    'vendedor' => $f->vendedor_nombre,
                    'cliente' => $f->nombre_cliente,
                    'fecha_venta' => $f->fechadoc->format('d-m-Y'),
                    'valorventa' => $f->valor_venta,
                    'saldo' => $saldo_anterior['saldo'],
                    'diacobrar' => $f->diacobrar,
                    'fup' => $saldo_anterior['fup'],
                    'cuota' => $f->montocuotas,
                    'mes' => $mes,
                    'monto_pago' => $pago_actual['monto_cobrado'],
                    'fecha_pago' => $pago_actual['fup'],
                    'saldo_final' => round($saldo_anterior['saldo'] - $pago_actual['monto_cobrado'], 2),
                    'cobrador' => $f->cobrador->nombre_completo
                ];
            }
            if (isset($request->tipoexportacion)) {
                $tipo = $request->tipoexportacion;
                $nombrearchivo = 'CuentasCanceladas-' . $mes . '-' . $anio;
                $detalles = [
                    'mes' => $mes_anterior->month,
                    'anio' => $mes_anterior->year,
                ];
                if ($tipo == 'excel') {

                    return \Excel::download(new CobranzaCuentasCanceladasExport($datos, $detalles), $nombrearchivo . '.xlsx');
                } elseif ($tipo == 'pdf') {
                    $pdf = PDF::loadView('cobranza.reportes.cuentascanceladas.exportar', [
                        'datos' => \Illuminate\Support\Collection::make($datos),
                        'estilos' => true,
                        'detalles' => $detalles
                    ]);
                    $pdf->setPaper('a4', 'portrait');
                    return $pdf->stream($nombrearchivo);
                }
            }
        }
        return view('cobranza.reportes.cuentascanceladas.index', [
            'datos' => \Illuminate\Support\Collection::make($datos),
            'mes' => $mes,
            'anio' => $anio,
            'vendedores' => $vendedores,
            'cobradores' => $cobradores,
            'vendedor' => $vendedor,
            'cobrador' => $cobrador
        ]);
    }
    public function relacionDevoluciones(Request $request)
    {
        $cobrador = 0;
        $vendedor = '';
        $mes = date('m');
        $anio = date('Y');
        $cobradores = cobrador::orderBy('nombres', 'ASC')->get();
        $vendedores = \DB::table('view_vendedores_cobranza')->orderBy('vendedor_nombre', 'ASC')->get();
        $datos = [];
        $tipo = '';
        if (isset($request->consultar)) {
            $cobrador = $request->cobrador;
            $vendedor = $request->vendedor;
            $mes = $request->mes;
            $anio = $request->anio;
            $tipo = $request->tipo;
            $ultima_fecha_mes = Carbon::createFromDate($anio, $mes, 1)->endOfMonth();
            $mes_anterior = Carbon::createFromDate($anio, $mes, 1)
                ->addMonth(-1)
                ->endOfMonth();
            if ($cobrador == '' && $vendedor == '') {
                if ($tipo == '') {
                    $devoluciones = \App\DevolucionObras::join('credito as c', 'c.numcuenta', '=', 'devolucionobras.num_cuenta')
                        ->where('devolucionobras.procedencia', 'COBRANZA')
                        ->where('devolucionobras.estado', 'PROCESADO')
                        ->whereMonth('devolucionobras.fecha', $mes)
                        ->whereYear('devolucionobras.fecha', $anio)
                        ->where('c.cobrador_id', '!=', '')
                        ->select(
                            'devolucionobras.fecha',
                            'c.numcuenta',
                            'c.cobrador_id',
                            'devolucionobras.tipo_devolucion',
                            'c.nombre_cliente',
                            'c.vendedor_nombre',
                            'c.id as credito_id',
                            'c.fechadoc',
                            'c.valor_venta',
                            'c.cuotainicial',
                            'c.numcuotas',
                            'c.montocuotas',
                            'devolucionobras.id as dev_id',
                            'devolucionobras.ingreso_id',
                            'devolucionobras.monto_devolucion'
                        )
                        ->orderBy('devolucionobras.fecha', 'ASC')
                        ->get();
                } elseif ($tipo == 'PARCIAL') {
                    $devoluciones = \App\DevolucionObras::join('credito as c', 'c.numcuenta', '=', 'devolucionobras.num_cuenta')
                        ->where('devolucionobras.procedencia', 'COBRANZA')
                        ->where('devolucionobras.estado', 'PROCESADO')
                        ->where('c.cobrador_id', '!=', '')
                        ->whereMonth('devolucionobras.fecha', $mes)
                        ->whereYear('devolucionobras.fecha', $anio)
                        ->where('devolucionobras.tipo_devolucion', 'PARCIAL')
                        ->select(
                            'devolucionobras.fecha',
                            'c.numcuenta',
                            'c.cobrador_id',
                            'devolucionobras.tipo_devolucion',
                            'c.nombre_cliente',
                            'c.vendedor_nombre',
                            'c.id as credito_id',
                            'c.fechadoc',
                            'c.valor_venta',
                            'c.cuotainicial',
                            'c.numcuotas',
                            'c.montocuotas',
                            'devolucionobras.id as dev_id',
                            'devolucionobras.ingreso_id',
                            'devolucionobras.monto_devolucion'
                        )
                        ->orderBy('devolucionobras.fecha', 'ASC')
                        ->get();
                } elseif ($tipo == 'TOTAL') {
                    $devoluciones = \App\DevolucionObras::join('credito as c', 'c.numcuenta', '=', 'devolucionobras.num_cuenta')
                        ->where('devolucionobras.procedencia', 'COBRANZA')
                        ->where('devolucionobras.estado', 'PROCESADO')
                        ->whereMonth('devolucionobras.fecha', $mes)
                        ->where('c.cobrador_id', '!=', '')
                        ->whereYear('devolucionobras.fecha', $anio)
                        ->where('devolucionobras.tipo_devolucion', 'TOTAL')
                        ->select(
                            'devolucionobras.fecha',
                            'c.numcuenta',
                            'c.cobrador_id',
                            'devolucionobras.tipo_devolucion',
                            'c.nombre_cliente',
                            'c.vendedor_nombre',
                            'c.id as credito_id',
                            'c.fechadoc',
                            'c.valor_venta',
                            'c.cuotainicial',
                            'c.numcuotas',
                            'c.montocuotas',
                            'devolucionobras.id as dev_id',
                            'devolucionobras.ingreso_id',
                            'devolucionobras.monto_devolucion'
                        )
                        ->orderBy('devolucionobras.fecha', 'ASC')
                        ->get();
                }
            }
            if ($cobrador != '' && $vendedor == '') {
                if ($tipo == '') {
                    $devoluciones = \App\DevolucionObras::join('credito as c', 'c.numcuenta', '=', 'devolucionobras.num_cuenta')
                        ->where('devolucionobras.procedencia', 'COBRANZA')
                        ->where('devolucionobras.estado', 'PROCESADO')
                        ->where('c.cobrador_id', $cobrador)
                        ->whereMonth('devolucionobras.fecha', $mes)
                        ->whereYear('devolucionobras.fecha', $anio)
                        ->select(
                            'devolucionobras.fecha',
                            'c.numcuenta',
                            'c.cobrador_id',
                            'devolucionobras.tipo_devolucion',
                            'c.nombre_cliente',
                            'c.vendedor_nombre',
                            'c.id as credito_id',
                            'c.fechadoc',
                            'c.valor_venta',
                            'c.cuotainicial',
                            'c.numcuotas',
                            'c.montocuotas',
                            'devolucionobras.id as dev_id',
                            'devolucionobras.ingreso_id',
                            'devolucionobras.monto_devolucion'
                        )
                        ->orderBy('devolucionobras.fecha', 'ASC')->get();
                } elseif ($tipo == 'PARCIAL') {
                    $devoluciones = \App\DevolucionObras::join('credito as c', 'c.numcuenta', '=', 'devolucionobras.num_cuenta')
                        ->where('devolucionobras.procedencia', 'COBRANZA')
                        ->where('devolucionobras.estado', 'PROCESADO')
                        ->where('c.cobrador_id', $cobrador)
                        ->whereMonth('devolucionobras.fecha', $mes)
                        ->whereYear('devolucionobras.fecha', $anio)
                        ->where('devolucionobras.tipo_devolucion', 'PARCIAL')
                        ->select(
                            'devolucionobras.fecha',
                            'c.numcuenta',
                            'c.cobrador_id',
                            'devolucionobras.tipo_devolucion',
                            'c.nombre_cliente',
                            'c.vendedor_nombre',
                            'c.id as credito_id',
                            'c.fechadoc',
                            'c.valor_venta',
                            'c.cuotainicial',
                            'c.numcuotas',
                            'c.montocuotas',
                            'devolucionobras.id as dev_id',
                            'devolucionobras.ingreso_id',
                            'devolucionobras.monto_devolucion'
                        )
                        ->orderBy('devolucionobras.fecha', 'ASC')->get();
                } elseif ($tipo == 'TOTAL') {
                    $devoluciones = \App\DevolucionObras::join('credito as c', 'c.numcuenta', '=', 'devolucionobras.num_cuenta')
                        ->where('devolucionobras.procedencia', 'COBRANZA')
                        ->where('devolucionobras.estado', 'PROCESADO')
                        ->where('c.cobrador_id', $cobrador)
                        ->whereMonth('devolucionobras.fecha', $mes)
                        ->whereYear('devolucionobras.fecha', $anio)
                        ->where('devolucionobras.tipo_devolucion', 'TOTAL')
                        ->select(
                            'devolucionobras.fecha',
                            'c.numcuenta',
                            'c.cobrador_id',
                            'devolucionobras.tipo_devolucion',
                            'c.nombre_cliente',
                            'c.vendedor_nombre',
                            'c.id as credito_id',
                            'c.fechadoc',
                            'c.valor_venta',
                            'c.cuotainicial',
                            'c.numcuotas',
                            'c.montocuotas',
                            'devolucionobras.id as dev_id',
                            'devolucionobras.ingreso_id',
                            'devolucionobras.monto_devolucion'
                        )
                        ->orderBy('devolucionobras.fecha', 'ASC')->get();
                }
            }
            if ($cobrador != '' && $vendedor != '') {
                if ($tipo == '') {
                    $devoluciones = \App\DevolucionObras::join('credito as c', 'c.numcuenta', '=', 'devolucionobras.num_cuenta')
                        ->where('devolucionobras.procedencia', 'COBRANZA')
                        ->where('devolucionobras.estado', 'PROCESADO')
                        ->where('c.cobrador_id', $cobrador)
                        ->where('vendedor_nombre', $vendedor)
                        ->whereMonth('devolucionobras.fecha', $mes)
                        ->whereYear('devolucionobras.fecha', $anio)
                        ->select(
                            'devolucionobras.fecha',
                            'c.numcuenta',
                            'c.cobrador_id',
                            'devolucionobras.tipo_devolucion',
                            'c.nombre_cliente',
                            'c.vendedor_nombre',
                            'c.id as credito_id',
                            'c.fechadoc',
                            'c.valor_venta',
                            'c.cuotainicial',
                            'c.numcuotas',
                            'c.montocuotas',
                            'devolucionobras.id as dev_id',
                            'devolucionobras.ingreso_id',
                            'devolucionobras.monto_devolucion'
                        )
                        ->orderBy('devolucionobras.fecha', 'ASC')->get();
                } elseif ($tipo == 'PARCIAL') {
                    $devoluciones = \App\DevolucionObras::join('credito as c', 'c.numcuenta', '=', 'devolucionobras.num_cuenta')
                        ->where('devolucionobras.procedencia', 'COBRANZA')
                        ->where('devolucionobras.estado', 'PROCESADO')
                        ->where('c.cobrador_id', $cobrador)
                        ->where('vendedor_nombre', $vendedor)
                        ->whereMonth('devolucionobras.fecha', $mes)
                        ->whereYear('devolucionobras.fecha', $anio)
                        ->where('devolucionobras.tipo_devolucion', 'PARCIAL')
                        ->select(
                            'devolucionobras.fecha',
                            'c.numcuenta',
                            'c.cobrador_id',
                            'devolucionobras.tipo_devolucion',
                            'c.nombre_cliente',
                            'c.vendedor_nombre',
                            'c.id as credito_id',
                            'c.fechadoc',
                            'c.valor_venta',
                            'c.cuotainicial',
                            'c.numcuotas',
                            'c.montocuotas',
                            'devolucionobras.id as dev_id',
                            'devolucionobras.ingreso_id',
                            'devolucionobras.monto_devolucion'
                        )
                        ->orderBy('devolucionobras.fecha', 'ASC')->get();
                } elseif ($tipo == 'TOTAL') {
                    $devoluciones = \App\DevolucionObras::join('credito as c', 'c.numcuenta', '=', 'devolucionobras.num_cuenta')
                        ->where('devolucionobras.procedencia', 'COBRANZA')
                        ->where('devolucionobras.estado', 'PROCESADO')
                        ->where('c.cobrador_id', $cobrador)
                        ->where('vendedor_nombre', $vendedor)
                        ->whereMonth('devolucionobras.fecha', $mes)
                        ->whereYear('devolucionobras.fecha', $anio)
                        ->where('devolucionobras.tipo_devolucion', 'TOTAL')
                        ->select(
                            'devolucionobras.fecha',
                            'c.numcuenta',
                            'c.cobrador_id',
                            'devolucionobras.tipo_devolucion',
                            'c.nombre_cliente',
                            'c.vendedor_nombre',
                            'c.id as credito_id',
                            'c.fechadoc',
                            'c.valor_venta',
                            'c.cuotainicial',
                            'c.numcuotas',
                            'c.montocuotas',
                            'devolucionobras.id as dev_id',
                            'devolucionobras.ingreso_id',
                            'devolucionobras.monto_devolucion'
                        )
                        ->orderBy('devolucionobras.fecha', 'ASC')->get();
                }
            }
            if ($cobrador == '' && $vendedor != '') {
                if ($tipo == '') {
                    $devoluciones = \App\DevolucionObras::join('credito as c', 'c.numcuenta', '=', 'devolucionobras.num_cuenta')
                        ->where('devolucionobras.procedencia', 'COBRANZA')
                        ->where('devolucionobras.estado', 'PROCESADO')
                        ->where('vendedor_nombre', $vendedor)
                        ->whereMonth('devolucionobras.fecha', $mes)
                        ->whereYear('devolucionobras.fecha', $anio)
                        ->select(
                            'devolucionobras.fecha',
                            'c.numcuenta',
                            'c.cobrador_id',
                            'devolucionobras.tipo_devolucion',
                            'c.nombre_cliente',
                            'c.vendedor_nombre',
                            'c.id as credito_id',
                            'c.fechadoc',
                            'c.valor_venta',
                            'c.cuotainicial',
                            'c.numcuotas',
                            'c.montocuotas',
                            'devolucionobras.id as dev_id',
                            'devolucionobras.ingreso_id',
                            'devolucionobras.monto_devolucion'
                        )
                        ->orderBy('devolucionobras.fecha', 'ASC')->get();
                } elseif ($tipo == 'PARCIAL') {
                    $devoluciones = \App\DevolucionObras::join('credito as c', 'c.numcuenta', '=', 'devolucionobras.num_cuenta')
                        ->where('devolucionobras.procedencia', 'COBRANZA')
                        ->where('devolucionobras.estado', 'PROCESADO')
                        ->where('vendedor_nombre', $vendedor)
                        ->whereMonth('devolucionobras.fecha', $mes)
                        ->whereYear('devolucionobras.fecha', $anio)
                        ->where('devolucionobras.tipo_devolucion', 'PARCIAL')
                        ->select(
                            'devolucionobras.fecha',
                            'c.numcuenta',
                            'c.cobrador_id',
                            'devolucionobras.tipo_devolucion',
                            'c.nombre_cliente',
                            'c.vendedor_nombre',
                            'c.id as credito_id',
                            'c.fechadoc',
                            'c.valor_venta',
                            'c.cuotainicial',
                            'c.numcuotas',
                            'c.montocuotas',
                            'devolucionobras.id as dev_id',
                            'devolucionobras.ingreso_id',
                            'devolucionobras.monto_devolucion'
                        )
                        ->orderBy('devolucionobras.fecha', 'ASC')->get();
                } elseif ($tipo == 'TOTAL') {
                    $devoluciones = \App\DevolucionObras::join('credito as c', 'c.numcuenta', '=', 'devolucionobras.num_cuenta')
                        ->where('devolucionobras.procedencia', 'COBRANZA')
                        ->where('devolucionobras.estado', 'PROCESADO')
                        ->where('vendedor_nombre', $vendedor)
                        ->whereMonth('devolucionobras.fecha', $mes)
                        ->whereYear('devolucionobras.fecha', $anio)
                        ->where('devolucionobras.tipo_devolucion', 'TOTAL')
                        ->select(
                            'devolucionobras.fecha',
                            'c.numcuenta',
                            'c.cobrador_id',
                            'devolucionobras.tipo_devolucion',
                            'c.nombre_cliente',
                            'c.vendedor_nombre',
                            'c.id as credito_id',
                            'c.fechadoc',
                            'c.valor_venta',
                            'c.cuotainicial',
                            'c.numcuotas',
                            'c.montocuotas',
                            'devolucionobras.id as dev_id',
                            'devolucionobras.ingreso_id',
                            'devolucionobras.monto_devolucion'
                        )
                        ->orderBy('devolucionobras.fecha', 'ASC')->get();
                }
            }
            foreach ($devoluciones as $d) {
                $credito = Credito::find($d->credito_id);
                $saldo_anterior = $credito->saldoAcumuladoMesAnio($mes_anterior->month, $mes_anterior->year);
                $pagosactual = $credito->saldoMesAnio2($mes, $anio);
                $datos[] = [
                    'codcl' => $d->numcuenta,
                    'fecha' => $d->fecha->format('d-m-Y'),
                    'cobrador' => cobrador::find($d->cobrador_id)->nombre_completo,
                    'detalle' => $d->tipo_devolucion,
                    'cliente' => $d->nombre_cliente,
                    'ingreso_id' => $d->ingreso_id,
                    'vendedor' => $d->vendedor_nombre,
                    'fechaventa' => $d->fechadoc,
                    'precioventa' => $d->valor_venta,
                    'ci' => $d->cuotainicial,
                    'saldo' => $saldo_anterior['saldo'],
                    'condiciones' => $d->numcuotas . 'x' . $d->montocuotas,
                    'pagoscuenta' => $pagosactual['monto_cobrado'],
                    'valor_devolucion' => $d->monto_devolucion,
                    'saldo_final' => $saldo_anterior['saldo'] - ($pagosactual['monto_cobrado'] + $d->monto_devolucion),
                ];
            }
        }
        if (isset($request->tipoexportacion)) {
            $tipo = $request->tipoexportacion;
            $nombrearchivo = 'CuentasCanceladas-' . $mes . '-' . $anio;
            $detalles = [
                'cobrador' => $request->cobrador,
                'vendedor' => $request->vendedor,
                'mes' => $request->mes,
                'anio' => $request->anio,
                'tipo' => $request->tipo
            ];
            if ($tipo == 'excel') {

                return \Excel::download(new CobranzaDevolucionesExport(Collection::make($datos), $detalles), $nombrearchivo . '.xlsx');
            } elseif ($tipo == 'pdf') {
                $pdf = PDF::loadView('cobranza.reportes.relaciondevoluciones.exportar', [
                    'datos' => \Illuminate\Support\Collection::make($datos),
                    'estilos' => true,
                    'detalles' => $detalles
                ]);
                $pdf->setPaper('a4', 'portrait');
                return $pdf->stream($nombrearchivo);
            }
        }
        return view('cobranza.reportes.relaciondevoluciones.index', [
            'datos' => \Illuminate\Support\Collection::make($datos),
            'mes' => $mes,
            'anio' => $anio,
            'vendedores' => $vendedores,
            'cobradores' => $cobradores,
            'vendedor' => $vendedor,
            'cobrador' => $cobrador,
            'tipo' => $tipo,
        ]);
    }
    public function prontoPago(Request $request)
    {
        $cobrador = null;
        $vendedor = '';
        $mes = date('m');
        $anio = date('Y');
        $cobradores = cobrador::orderBy('nombres', 'ASC')->get();
        $vendedores = \DB::table('view_vendedores_cobranza')->orderBy('vendedor_nombre', 'ASC')->get();
        $datos = [];
        $tipo = '';
        // return dd($request->all());
        if (isset($request->consultar)) {
            $cobrador = $request->cobrador;
            $vendedor = $request->vendedor;
            $mes = $request->mes;
            $anio = $request->anio;
            $tipo = $request->tipo;
            $datos = [];
            $ultima_fecha_mes = Carbon::createFromDate($anio, $mes, 1)->endOfMonth();
            $mes_anterior = Carbon::createFromDate($anio, $mes, 1)
                ->addMonth(-1)
                ->endOfMonth();
            if ($cobrador == '' && $vendedor == '') {
                $sql = \App\Descuento::join('credito as c', 'c.id', '=', 'descuentos.credito_id')
                    ->join('pagos as p', 'p.id', '=', 'descuentos.pago_id')
                    ->whereMonth('descuentos.fecha', '=', $mes)
                    ->whereYear('descuentos.fecha', '=', $anio)
                    ->where('descuentos.tipo', 'PRONTO PAGO')
                    ->orderBy('descuentos.fecha', 'ASC')
                    ->select(
                        'descuentos.fecha',
                        'c.numcuenta',
                        'c.nombre_cliente',
                        'c.vendedor_nombre',
                        'c.id as credito_id',
                        'c.fechadoc',
                        'c.diacobrar',
                        'c.valor_venta',
                        'c.cuotainicial',
                        'c.numcuotas',
                        'c.montocuotas',
                        'descuentos.monto as desc_monto',
                        'p.monto as pago_monto',
                        'p.cobrador_id'
                    )
                    ->get();
            } elseif ($cobrador != '' && $vendedor == '') {
                $sql = \App\Descuento::join('credito as c', 'c.id', '=', 'descuentos.credito_id')
                    ->join('pagos as p', 'p.id', '=', 'descuentos.pago_id')
                    ->whereMonth('descuentos.fecha', '=', $mes)
                    ->whereYear('descuentos.fecha', '=', $anio)
                    ->where('descuentos.tipo', 'PRONTO PAGO')
                    ->where('p.cobrador_id', $cobrador)
                    ->orderBy('descuentos.fecha', 'ASC')
                    ->select(
                        'descuentos.fecha',
                        'c.numcuenta',
                        'c.nombre_cliente',
                        'c.vendedor_nombre',
                        'c.id as credito_id',
                        'c.fechadoc',
                        'c.diacobrar',
                        'c.valor_venta',
                        'c.cuotainicial',
                        'c.numcuotas',
                        'c.montocuotas',
                        'descuentos.monto as desc_monto',
                        'p.monto as pago_monto',
                        'p.cobrador_id'
                    )
                    ->get();
            } elseif ($cobrador == '' && $vendedor != '') {
                $sql = \App\Descuento::join('credito as c', 'c.id', '=', 'descuentos.credito_id')
                    ->join('pagos as p', 'p.id', '=', 'descuentos.pago_id')
                    ->whereMonth('descuentos.fecha', '=', $mes)
                    ->whereYear('descuentos.fecha', '=', $anio)
                    ->where('descuentos.tipo', 'PRONTO PAGO')
                    ->where('c.vendedor_nombre', $vendedor)
                    ->orderBy('descuentos.fecha', 'ASC')
                    ->select(
                        'descuentos.fecha',
                        'c.numcuenta',
                        'c.nombre_cliente',
                        'c.vendedor_nombre',
                        'c.id as credito_id',
                        'c.fechadoc',
                        'c.diacobrar',
                        'c.valor_venta',
                        'c.cuotainicial',
                        'c.numcuotas',
                        'c.montocuotas',
                        'descuentos.monto as desc_monto',
                        'p.monto as pago_monto',
                        'p.cobrador_id'
                    )
                    ->get();
            } elseif ($cobrador != '' && $vendedor != '') {
                $sql = \App\Descuento::join('credito as c', 'c.id', '=', 'descuentos.credito_id')
                    ->join('pagos as p', 'p.id', '=', 'descuentos.pago_id')
                    ->whereMonth('descuentos.fecha', '=', $mes)
                    ->whereYear('descuentos.fecha', '=', $anio)
                    ->where('descuentos.tipo', 'PRONTO PAGO')
                    ->where('p.cobrador_id', $cobrador)
                    ->where('c.vendedor_nombre', $vendedor)
                    ->orderBy('descuentos.fecha', 'ASC')
                    ->select(
                        'descuentos.fecha',
                        'c.numcuenta',
                        'c.nombre_cliente',
                        'c.vendedor_nombre',
                        'c.id as credito_id',
                        'c.fechadoc',
                        'c.diacobrar',
                        'c.valor_venta',
                        'c.cuotainicial',
                        'c.numcuotas',
                        'c.montocuotas',
                        'descuentos.monto as desc_monto',
                        'p.monto as pago_monto',
                        'p.cobrador_id'
                    )
                    ->get();
            }
            foreach ($sql as $k => $r) {
                $credito = Credito::find($r->credito_id);
                $pagos = $credito->saldoAcumuladoMesAnio($mes_anterior->month, $mes_anterior->year);
                $cobra = cobrador::find($r->cobrador_id);
                $nombre_cobrador = '';
                if (isset($cobra->nombre_completo)) {
                    $nombre_cobrador = $cobra->nombre_completo;
                }
                $datos[] = [
                    'cuenta' => $r->numcuenta,
                    'vendedor' => $r->vendedor_nombre,
                    'cliente' => $r->nombre_cliente,
                    'fechaventa' => $credito->fechadoc->format('d-m-Y'),
                    'valorventa' => $r->valor_venta,
                    'saldo' => $pagos['saldo'],
                    'diacobrar' => $r->diacobrar,
                    'fup' => $pagos['fup'],
                    'cuota' => $r->montocuotas,
                    'importecobrado' => $r->pago_monto,
                    'fechacobranza' => $r->fecha->format('d-m-Y'),
                    'descuentos' => $r->desc_monto,
                    'nombre_cobrador' => $nombre_cobrador,
                ];
            }
        }
        if (isset($request->tipoexportacion)) {
            $tipo = $request->tipoexportacion;
            $nombrearchivo = 'CuentasCanceladas-' . $mes . '-' . $anio;
            $detalles = [
                'mes' => $mes,
                'anio' => $anio,
                'vendedor' => $vendedor,
                'cobrador' => $cobrador,
            ];
            if ($tipo == 'excel') {
                return \Excel::download(new CobranzaRelacionProntoPagoExport(Collection::make($datos), $detalles), $nombrearchivo . '.xlsx');
            } elseif ($tipo == 'pdf') {
                $pdf = PDF::loadView('cobranza.reportes.prontopago.exportar', [
                    'datos' => \Illuminate\Support\Collection::make($datos),
                    'estilos' => true,
                    'detalles' => $detalles
                ]);
                $pdf->setPaper('a4', 'landscape');
                //            $pdf->setPaper([0, 0,650, 270], 'portrait');
                return $pdf->stream($nombrearchivo);
            }
        }
        return view('cobranza.reportes.prontopago.index', [
            'datos' => \Illuminate\Support\Collection::make($datos),
            'mes' => $mes,
            'anio' => $anio,
            'vendedores' => $vendedores,
            'cobradores' => $cobradores,
            'vendedor' => $vendedor,
            'cobrador' => $cobrador,
        ]);
    }
    public function cuentasNuevas(Request $request)
    {
        $cobrador = null;
        $vendedor = '';
        $mes = date('m');
        $anio = date('Y');
        $cobradores = cobrador::orderBy('nombres', 'ASC')->get();
        $vendedores = \DB::table('view_vendedores_cobranza')->orderBy('vendedor_nombre', 'ASC')->get();
        $datos = [];
        $tipo = '';
        if (isset($request->consultar)) {
            $cobrador = $request->cobrador;
            $vendedor = $request->vendedor;
            $mes = $request->mes;
            $anio = $request->anio;
            $tipo = $request->tipo;
            $datos = [];
            $ultima_fecha_mes = Carbon::createFromDate($anio, $mes, 1)->endOfMonth();
            $mes_anterior = Carbon::createFromDate($anio, $mes, 1)
                ->addMonth(-1)
                ->endOfMonth();
            if ($cobrador == '' && $vendedor == '') {
                $sql = \App\Pago::join('credito as c', 'c.id', '=', 'pagos.model_id')
                    ->whereMonth('pagos.fecha', '=', $mes)
                    ->whereYear('pagos.fecha', '=', $anio)
                    ->whereYear('c.fechadoc', '=', $anio)
                    ->whereMonth('c.fechadoc', '=', $mes)
                    ->where('pagos.model_type', '=', 'pago-cobranza')
                    ->orderBy('pagos.fecha', 'ASC')
                    ->select(
                        'c.numcuenta',
                        'c.nombre_cliente',
                        'c.vendedor_nombre',
                        'c.id as credito_id',
                        'c.fechadoc',
                        'c.saldo_inicial',
                        'c.diacobrar',
                        'c.valor_venta',
                        'c.cuotainicial',
                        'c.numcuotas',
                        'c.montocuotas',
                        'pagos.monto as pago_monto',
                        'pagos.fecha as fechacobro',
                        'pagos.cobrador_id'
                    )
                    ->get();
            } elseif ($cobrador != '' && $vendedor == '') {
                $sql = \App\Pago::join('credito as c', 'c.id', '=', 'pagos.model_id')
                    ->whereMonth('pagos.fecha', '=', $mes)
                    ->whereYear('pagos.fecha', '=', $anio)
                    ->whereYear('c.fechadoc', '=', $anio)
                    ->whereMonth('c.fechadoc', '=', $mes)
                    ->where('pagos.cobrador_id', '=', $cobrador)
                    ->where('pagos.model_type', '=', 'pago-cobranza')
                    ->orderBy('pagos.fecha', 'ASC')
                    ->select(
                        'c.numcuenta',
                        'c.nombre_cliente',
                        'c.vendedor_nombre',
                        'c.id as credito_id',
                        'c.fechadoc',
                        'c.saldo_inicial',
                        'c.diacobrar',
                        'c.valor_venta',
                        'c.cuotainicial',
                        'c.numcuotas',
                        'c.montocuotas',
                        'pagos.monto as pago_monto',
                        'pagos.fecha as fechacobro',
                        'pagos.cobrador_id'
                    )
                    ->get();
            } elseif ($cobrador == '' && $vendedor != '') {
                $sql = \App\Pago::join('credito as c', 'c.id', '=', 'pagos.model_id')
                    ->whereMonth('pagos.fecha', '=', $mes)
                    ->whereYear('pagos.fecha', '=', $anio)
                    ->whereYear('c.fechadoc', '=', $anio)
                    ->whereMonth('c.fechadoc', '=', $mes)
                    ->where('c.vendedor_nombre', '=', $vendedor)
                    ->where('pagos.model_type', '=', 'pago-cobranza')
                    ->orderBy('pagos.fecha', 'ASC')
                    ->select(
                        'c.numcuenta',
                        'c.nombre_cliente',
                        'c.vendedor_nombre',
                        'c.id as credito_id',
                        'c.fechadoc',
                        'c.saldo_inicial',
                        'c.diacobrar',
                        'c.valor_venta',
                        'c.cuotainicial',
                        'c.numcuotas',
                        'c.montocuotas',
                        'pagos.monto as pago_monto',
                        'pagos.fecha as fechacobro',
                        'pagos.cobrador_id'
                    )
                    ->get();
            } elseif ($cobrador != '' && $vendedor != '') {
                $sql = \App\Pago::join('credito as c', 'c.id', '=', 'pagos.model_id')
                    ->whereMonth('pagos.fecha', '=', $mes)
                    ->whereYear('pagos.fecha', '=', $anio)
                    ->whereYear('c.fechadoc', '=', $anio)
                    ->whereMonth('c.fechadoc', '=', $mes)
                    ->where('c.vendedor_nombre', '=', $vendedor)
                    ->where('pagos.cobrador_id', '=', $cobrador)
                    ->where('pagos.model_type', '=', 'pago-cobranza')
                    ->orderBy('pagos.fecha', 'ASC')
                    ->select(
                        'c.numcuenta',
                        'c.nombre_cliente',
                        'c.vendedor_nombre',
                        'c.id as credito_id',
                        'c.fechadoc',
                        'c.saldo_inicial',
                        'c.diacobrar',
                        'c.valor_venta',
                        'c.cuotainicial',
                        'c.numcuotas',
                        'c.montocuotas',
                        'p.monto as pago_monto',
                        'p.fecha as fechacobro',
                        'p.cobrador_id'
                    )
                    ->get();
            }
            foreach ($sql as $k => $r) {
                $cobra = cobrador::find($r->cobrador_id);
                $nombre_cobrador = '';
                if (isset($cobra->nombre_completo)) {
                    $nombre_cobrador = $cobra->nombre_completo;
                }
                $datos[] = [
                    'cuenta' => $r->numcuenta,
                    'vendedor' => $r->vendedor_nombre,
                    'cliente' => $r->nombre_cliente,
                    'fechaventa' => $r->fechadoc,
                    'valorventa' => $r->valor_venta,
                    'saldo' => $r->saldo_inicial,
                    'diacobrar' => $r->diacobrar,
                    'fup' => $r->fechadoc,
                    'cuota' => $r->montocuotas,
                    'importecobrado' => $r->pago_monto,
                    'fechacobranza' => $r->fecha_cobro,
                    'nuevosaldo' => round($r->saldo_inicial - $r->pago_monto, 2),
                    'nombre_cobrador' => $nombre_cobrador,
                ];
            }
        }
        return view('cobranza.reportes.cuentasnuevas.index', [
            'datos' => \Illuminate\Support\Collection::make($datos),
            'mes' => $mes,
            'anio' => $anio,
            'vendedores' => $vendedores,
            'cobradores' => $cobradores,
            'vendedor' => $vendedor,
            'cobrador' => $cobrador,
        ]);
    }
    public function relacionPagos(Request $request)
    {
        $cobrador = null;
        $numreporte = '';
        $mes = date('m');
        $anio = date('Y');
        $fecha_ini = Carbon::now();
        $fecha_fin = Carbon::now();
        $fecha_ref = Carbon::now();
        $cobradores = cobrador::orderBy('nombres', 'ASC')->get();
        $datos = [];
        $filtro = '';
        if (isset($request->consultar)) {
            $cobrador = $request->cobrador;
            $numreporte = $request->numreporte;
            $mes = $request->mes;
            $anio = $request->anio;
            $tipo = $request->tipo;
            $filtro = $request->filtro;
            $datos = [];
            $fecha_ini = Carbon::createFromFormat('d/m/Y', $request->fecha_ini);
            $fecha_fin = Carbon::createFromFormat('d/m/Y', $request->fecha_fin);
            $fecha_ref = Carbon::createFromFormat('d/m/Y', $request->fecha_ref);
            if ($filtro == 'MES') {
                if ($cobrador == '' && $numreporte == '') {
                    $datos = Pago::join('credito as c', 'c.id', '=', 'pagos.model_id')
                        ->where('pagos.model_type', 'pago-cobranza')
                        ->whereMonth('pagos.fecha', '=', $mes)
                        ->whereYear('pagos.fecha', '=', $anio)
                        ->where('pagos.estado', 'T')
                        ->select('c.numcuenta', 'c.nombre_cliente', 'c.vendedor_nombre', 'pagos.fecha', 'pagos.monto', 'pagos.numrecibo', 'pagos.num_reporte', 'pagos.cobrador_id')
                        ->orderBy('pagos.fecha', 'ASC')
                        ->get();
                } elseif ($cobrador != '' && $numreporte == '') {
                    $datos = Pago::join('credito as c', 'c.id', '=', 'pagos.model_id')
                        ->where('pagos.model_type', 'pago-cobranza')
                        ->whereMonth('pagos.fecha', '=', $mes)
                        ->whereYear('pagos.fecha', '=', $anio)
                        ->where('pagos.estado', 'T')
                        ->where('pagos.cobrador_id', $cobrador)
                        ->select('c.numcuenta', 'c.nombre_cliente', 'c.vendedor_nombre', 'pagos.fecha', 'pagos.monto', 'pagos.numrecibo', 'pagos.num_reporte', 'pagos.cobrador_id')
                        ->orderBy('pagos.fecha', 'ASC')
                        ->get();
                } elseif ($cobrador == '' && $numreporte != '') {
                    $datos = Pago::join('credito as c', 'c.id', '=', 'pagos.model_id')
                        ->where('pagos.model_type', 'pago-cobranza')
                        ->whereMonth('pagos.fecha', '=', $mes)
                        ->whereYear('pagos.fecha', '=', $anio)
                        ->where('pagos.estado', 'T')
                        ->where('pagos.num_reporte', $numreporte)
                        ->select('c.numcuenta', 'c.nombre_cliente', 'c.vendedor_nombre', 'pagos.fecha', 'pagos.monto', 'pagos.numrecibo', 'pagos.num_reporte', 'pagos.cobrador_id')
                        ->orderBy('pagos.fecha', 'ASC')
                        ->get();
                }
            } elseif ($filtro == 'RANGO') {
                if ($cobrador == '' && $numreporte == '') {
                    $datos = Pago::join('credito as c', 'c.id', '=', 'pagos.model_id')
                        ->where('pagos.model_type', 'pago-cobranza')
                        ->whereBetween('pagos.fecha', [$fecha_ini->format('Y-m-d'), $fecha_fin->format('Y-m-d')])
                        ->where('pagos.estado', 'T')
                        ->select('c.numcuenta', 'c.nombre_cliente', 'c.vendedor_nombre', 'pagos.fecha', 'pagos.monto', 'pagos.numrecibo', 'pagos.num_reporte', 'pagos.cobrador_id')
                        ->orderBy('pagos.fecha', 'ASC')
                        ->get();
                } elseif ($cobrador != '' && $numreporte == '') {
                    $datos = Pago::join('credito as c', 'c.id', '=', 'pagos.model_id')
                        ->where('pagos.model_type', 'pago-cobranza')
                        ->whereBetween('pagos.fecha', [$fecha_ini->format('Y-m-d'), $fecha_fin->format('Y-m-d')])
                        ->where('pagos.cobrador_id', $cobrador)
                        ->where('pagos.estado', 'T')
                        ->select('c.numcuenta', 'c.nombre_cliente', 'c.vendedor_nombre', 'pagos.fecha', 'pagos.monto', 'pagos.numrecibo', 'pagos.num_reporte', 'pagos.cobrador_id')
                        ->orderBy('pagos.fecha', 'ASC')
                        ->get();
                } elseif ($cobrador == '' && $numreporte != '') {
                    $datos = Pago::join('credito as c', 'c.id', '=', 'pagos.model_id')
                        ->where('pagos.model_type', 'pago-cobranza')
                        ->whereBetween('pagos.fecha', [$fecha_ini->format('Y-m-d'), $fecha_fin->format('Y-m-d')])
                        ->where('pagos.num_reporte', $numreporte)
                        ->where('pagos.estado', 'T')
                        ->select('c.numcuenta', 'c.nombre_cliente', 'c.vendedor_nombre', 'pagos.fecha', 'pagos.monto', 'pagos.numrecibo', 'pagos.num_reporte', 'pagos.cobrador_id')
                        ->orderBy('pagos.fecha', 'ASC')
                        ->get();
                }
            } elseif ($filtro == 'ACUMULADO') {
                if ($cobrador == '' && $numreporte == '') {
                    $datos = Pago::join('credito as c', 'c.id', '=', 'pagos.model_id')
                        ->where('pagos.model_type', 'pago-cobranza')
                        ->where('pagos.fecha', $fecha_ref->format('Y-m-d'))
                        ->where('pagos.estado', 'T')
                        ->select('c.numcuenta', 'c.nombre_cliente', 'c.vendedor_nombre', 'pagos.fecha', 'pagos.monto', 'pagos.numrecibo', 'pagos.num_reporte', 'pagos.cobrador_id')
                        ->orderBy('pagos.fecha', 'ASC')
                        ->get();
                } elseif ($cobrador != '' && $numreporte == '') {
                    $datos = Pago::join('credito as c', 'c.id', '=', 'pagos.model_id')
                        ->where('pagos.model_type', 'pago-cobranza')
                        ->where('pagos.fecha', $fecha_ref->format('Y-m-d'))
                        ->where('pagos.cobrador_id', $cobrador)
                        ->where('pagos.estado', 'T')
                        ->select('c.numcuenta', 'c.nombre_cliente', 'c.vendedor_nombre', 'pagos.fecha', 'pagos.monto', 'pagos.numrecibo', 'pagos.num_reporte', 'pagos.cobrador_id')
                        ->orderBy('pagos.fecha', 'ASC')
                        ->get();
                } elseif ($cobrador == '' && $numreporte != '') {
                    $datos = Pago::join('credito as c', 'c.id', '=', 'pagos.model_id')
                        ->where('pagos.model_type', 'pago-cobranza')
                        ->where('pagos.fecha', $fecha_ref->format('Y-m-d'))
                        ->where('pagos.num_reporte', $numreporte)
                        ->where('pagos.estado', 'T')
                        ->select('c.numcuenta', 'c.nombre_cliente', 'c.vendedor_nombre', 'pagos.fecha', 'pagos.monto', 'pagos.numrecibo', 'pagos.num_reporte', 'pagos.cobrador_id')
                        ->orderBy('pagos.fecha', 'ASC')
                        ->get();
                }
            }
        }
        return view('cobranza.reportes.relacionpagos.index', [
            'datos' => $datos,
            'filtro' => $filtro,
            'mes' => $mes,
            'anio' => $anio,
            'fecha_ini' => $fecha_ini->format('d/m/Y'),
            'fecha_fin' => $fecha_fin->format('d/m/Y'),
            'fecha_ref' => $fecha_ref->format('d/m/Y'),
            'numreporte' => $numreporte,
            'cobrador' => $cobrador,
            'cobradores' => $cobradores
        ]);
    }
    function incobrables(Request $request)
    {
        $mes = date('m');
        $anio = date('Y');
        $datos = [];
        if (isset($request->consultar)) {
            $mes = $request->mes;
            $anio = $request->anio;
        }
        // $datos = Deudor::leftjoin('credito as c','c.id','=','deudores.credito_id')
        //     ->whereMonth('deudores.fecha_ingreso_vencida', '=', $mes)
        //     ->whereYear('deudores.fecha_ingreso_vencida', '=', $anio)
        //     ->select()
        //     ->orderBy('deudores.fecha_ingreso_vencida', 'DESC')
        //     ->get();
        $credito = credito::leftjoin('deudores as d', 'd.credito_id', '=', 'credito.id')
            ->join('cobradores as co', 'co.id', '=', 'credito.cobrador_id')
            ->whereMonth('d.fecha_ingreso_vencida', '=', $mes)
            ->whereYear('d.fecha_ingreso_vencida', '=', $anio)
            ->where('credito.estado', '=', 'I')
            ->select(
                'credito.numcuenta',
                'credito.vendedor_nombre',
                'credito.montocuotas',
                'credito.nombre_cliente',
                'credito.fechadoc',
                'credito.valor_venta',
                'credito.id',
                'credito.diacobrar',
                'co.nombres',
                'co.apellidos',
                'd.saldo_deuda_vencida',
                'd.fecha_ingreso_vencida'
            )
            ->orderBy('d.fecha_ingreso_vencida', 'DESC')
            ->get();
        foreach ($credito as $key => $c) {
            $cred = Credito::find($c->id);
            $saldo = $cred->saldoMesAnio2($mes, $anio);
            // $saldo=$c->saldoAcumuladoMesAnio($mes, $anio);
            $datos[] = [
                'cod_cli' => $c->numcuenta,
                'vendedor' => $c->vendedor_nombre,
                'nombre_cliente' => $c->nombre_cliente,
                'fecha_venta' => $c->fechadoc->format('d-m-Y'),
                'valor_venta' => $c->valor_venta,
                'saldo_ant' => $saldo['saldo'],
                'dia' => $c->diacobrar,
                'fup' => $saldo['fup'],
                'cuota' => $c->montocuotas,
                'saldo' => $c->saldo_deuda_vencida,
                'fecha_vencida' => $c->fecha_ingreso_vencida,
                'cobrador' => $c->nombres . ' ' . $c->apellidos
            ];
        }
        if (isset($request->tipoexportacion)) {
            $tipo = $request->tipoexportacion;
            $detalles = [
                'mes' => $request->mes,
                'anio' => $request->anio,
            ];
            $nombrearchivo = "CentralRiesgos-" . $mes . "-" . $anio;
            if ($tipo == 'excel') {
                return \Excel::download(new CobranzaIncobrablesExport(Collection::make($datos), $detalles), $nombrearchivo . '.xlsx');
            } elseif ($tipo == 'pdf') {
                $pdf = PDF::loadView('cobranza.reportes.deudores.exportar', [
                    'datos' => \Illuminate\Support\Collection::make($datos),
                    'estilos' => true,
                    'detalles' => $detalles
                ]);
                $pdf->setPaper('a4', 'portrait');
                return $pdf->stream("CentralRiesgos - " . $mes . " - " . $anio . '.pdf');
            }
        }
        // return dd($datos);
        return view('cobranza.reportes.deudores.index', [
            'datos' => Collection::make($datos),
            'mes' => $mes,
            'anio' => $anio
        ]);
    }
    public function relacionCambioObra(Request $request)
    {
        $cobrador = 0;
        $vendedor = '';
        $mes = date('m');
        $anio = date('Y');
        $cobradores = cobrador::orderBy('nombres', 'ASC')->get();
        $vendedores = \DB::table('view_vendedores_cobranza')->orderBy('vendedor_nombre', 'ASC')->get();
        $datos = [];
        $tipo = '';
        if (isset($request->consultar)) {
            $cobrador = $request->cobrador;
            $vendedor = $request->vendedor;
            $mes = $request->mes;
            $anio = $request->anio;
            if ($cobrador == '' && $vendedor == '') {
                $datos = CambioObra::leftjoin('credito as c', 'c.id', '=', 'cambioobra.credito_id')
                    ->where('cambioobra.estado', 'PROCESADO')
                    ->whereMonth('cambioobra.fecha', $mes)
                    ->whereYear('cambioobra.fecha', $anio)
                    ->select(
                        'c.numcuenta',
                        'c.cobrador_id',
                        'c.nombre_cliente',
                        'c.vendedor_nombre',
                        'c.id as credito_id',
                        'c.fechadoc',
                        'c.valor_venta',
                        'c.cuotainicial',
                        'c.numcuotas',
                        'c.montocuotas',
                        'c.saldo_inicial',
                        'c.saldo',
                        'cambioobra.*'
                    )
                    ->orderBy('cambioobra.fecha', 'ASC')
                    ->get();
            } elseif ($cobrador != '' && $vendedor == '') {
                $datos = CambioObra::leftjoin('credito as c', 'c.id', '=', 'cambioobra.credito_id')
                    ->where('cambioobra.estado', 'PROCESADO')
                    ->where('c.cobrador_id', $cobrador)
                    ->whereMonth('cambioobra.fecha', $mes)
                    ->whereYear('cambioobra.fecha', $anio)
                    ->select(
                        'c.numcuenta',
                        'c.cobrador_id',
                        'c.nombre_cliente',
                        'c.vendedor_nombre',
                        'c.id as credito_id',
                        'c.fechadoc',
                        'c.valor_venta',
                        'c.cuotainicial',
                        'c.numcuotas',
                        'c.montocuotas',
                        'c.saldo_inicial',
                        'c.saldo',
                        'cambioobra.*'
                    )
                    ->orderBy('cambioobra.fecha', 'ASC')
                    ->get();
            } elseif ($cobrador == '' && $vendedor != '') {
                $datos = CambioObra::leftjoin('credito as c', 'c.id', '=', 'cambioobra.credito_id')
                    ->where('cambioobra.estado', 'PROCESADO')
                    ->where('c.vendedor_nombre', $vendedor)
                    ->whereMonth('cambioobra.fecha', $mes)
                    ->whereYear('cambioobra.fecha', $anio)
                    ->select(
                        'c.numcuenta',
                        'c.cobrador_id',
                        'c.nombre_cliente',
                        'c.vendedor_nombre',
                        'c.id as credito_id',
                        'c.fechadoc',
                        'c.valor_venta',
                        'c.cuotainicial',
                        'c.numcuotas',
                        'c.montocuotas',
                        'c.saldo_inicial',
                        'c.saldo',
                        'cambioobra.*'
                    )
                    ->orderBy('cambioobra.fecha', 'ASC')
                    ->get();
            }
        }
        if (isset($request->tipoexportacion)) {
            $tipo = $request->tipoexportacion;
            $nombrearchivo = 'RelacionCambioObra-' . $mes . '-' . $anio;
            $detalles = [
                'cobrador' => $request->cobrador,
                'vendedor' => $request->vendedor,
                'mes' => Helper::mes($request->mes),
                'anio' => $request->anio,
            ];
            if ($tipo == 'excel') {
                return \Excel::download(new CobranzaCambioObrasExport($datos, $detalles), $nombrearchivo . '.xlsx');
            } elseif ($tipo == 'pdf') {
                $pdf = PDF::loadView('cobranza.reportes.relacioncambio.exportar', [
                    'datos' => $datos,
                    'estilos' => true,
                    'detalles' => $detalles
                ]);
                $pdf->setPaper('a4', 'portrait');
                return $pdf->stream($nombrearchivo);
            }
        }
        return view('cobranza.reportes.relacioncambio.index', [
            // 'datos' => \Illuminate\Support\Collection::make($datos),
            'datos' => $datos,
            'mes' => $mes,
            'anio' => $anio,
            'vendedores' => $vendedores,
            'cobradores' => $cobradores,
            'vendedor' => $vendedor,
            'cobrador' => $cobrador,
            'tipo' => $tipo,
        ]);
    }
}
