<?php

namespace App\Http\Controllers;

use App\Helper\Helper;
use App\Kardex;
use App\Libro;
//use Barryvdh\DomPDF\PDF;
use App\Vendedor;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Collection;
use Barryvdh\DomPDF\Facade as PDF;
use App\Exports\InventarioExport;
use App\Exports\InventarioPreciosExport;
use App\Exports\MovimientoExport;
use App\Exports\KardexMayorExport;
use App\Exports\CatalogoExport;
use App\Exports\CargosVendedorExport;

class ReportesAlmacenController extends Controller
{
    public function inventario(Request $request)
    {
        $fecha1 = Carbon::now();
        $datos = [];
        //        return dd($request->all());
        if (isset($request->fecha_ini)) {
            try {
                $fecha1 = Carbon::createFromFormat('d/m/Y', $request->fecha_ini);
            } catch (\Exception $e) {
                $fecha1 = Carbon::createFromFormat('dmY', $request->fecha_ini);
            }
        }
        $datos = Collection::make(Libro::inventario($fecha1));
        if (isset($request->tipo)) {
            $tipo = $request->tipo;
            $nombrearchivo = 'inventario-al-' . $fecha1->format('d/m/Y');
            if ($tipo == 'excel') {
                return \Excel::download(new InventarioExport($datos, $fecha1), 'inventario.xlsx');
            } elseif ($tipo == 'pdf') {
                $pdf = \PDF::loadView('almacen.reportes.inventario-exportar', [
                    'datos' => $datos,
                    'estilos' => true,
                    'fecha_ini' => $fecha1
                ]);
                $pdf->setPaper('a4', 'portrait');
                //            $pdf->setPaper([0, 0,650, 270], 'portrait');
                //            $pdf->output();
                //            $dom_pdf = $pdf->getDomPDF();
                //            $pdf->set_paper(array(0,0,1000,3000));
                //            return $pdf->download('saldos_socios.pdf');
                return $pdf->stream($nombrearchivo);
            }
        }
        return view('almacen.reportes.inventario', [
            'datos' => Collection::make($datos),
            'fecha_ini' => $fecha1,
        ]);
    }
    public function inventario2(Request $request)
    {
        $fecha1 = Carbon::now();
        $datos = [];
        //        return dd($request->all());
        if (isset($request->fecha_ini)) {
            try {
                $fecha1 = Carbon::createFromFormat('d/m/Y', $request->fecha_ini);
            } catch (\Exception $e) {
                $fecha1 = Carbon::createFromFormat('dmY', $request->fecha_ini);
            }
        }
        $datos = Collection::make(Libro::inventario($fecha1));
        if (isset($request->tipo)) {
            $tipo = $request->tipo;
            $nombrearchivo = 'inventario-al-' . $fecha1->format('d/m/Y');
            if ($tipo == 'excel') {
                return \Excel::download(new InventarioPreciosExport($datos, $fecha1), 'inventario.xlsx');
            } elseif ($tipo == 'pdf') {
                $pdf = PDF::loadView('almacen.reportes.inventario-exportar2', [
                    'datos' => $datos,
                    'estilos' => true,
                    'fecha_ini' => $fecha1
                ]);
                $pdf->setPaper('a4', 'portrait');
                return $pdf->stream($nombrearchivo);
            }
        }
        return view('almacen.reportes.inventario2', [
            'datos' => Collection::make($datos),
            'fecha_ini' => $fecha1,
        ]);
    }
    public function movimiento(Request $request)
    {
        $fecha1 = Carbon::now();
        $fecha2 = Carbon::now();
        $datos = [];
        if (isset($request->fecha_ini)) {
            try {
                $fecha1 = Carbon::createFromFormat('d/m/Y', $request->fecha_ini);
                $fecha2 = Carbon::createFromFormat('d/m/Y', $request->fecha_fin);
            } catch (\Exception $e) {
                $fecha1 = Carbon::createFromFormat('dmY', $request->fecha_ini);
                $fecha2 = Carbon::createFromFormat('dmY', $request->fecha_fin);
            }
            $datos = Collection::make(Libro::movimientos($fecha1->format('d/m/Y'), $fecha2));
            //        return dd($datos);
        }
        if (isset($request->tipo)) {
            $tipo = $request->tipo;
            $nombrearchivo = 'movimiento-almacen-' . $fecha1->format('d/m/Y') . '-' . $fecha2->format('d/m/Y');
            if ($tipo == 'excel') {
                return \Excel::download(new MovimientoExport($datos, $fecha1, $fecha2), 'movimiento.xlsx');
            } elseif ($tipo == 'pdf') {
                $pdf = PDF::loadView('almacen.reportes.movimiento-exportar', [
                    'datos' => $datos,
                    'estilos' => true,
                    'fecha_ini' => $fecha1,
                    'fecha_fin' => $fecha2
                ]);
                $pdf->setPaper('a4', 'portrait');
                //            $pdf->setPaper([0, 0,650, 270], 'portrait');
                //            $pdf->output();
                //            $dom_pdf = $pdf->getDomPDF();
                //            $pdf->set_paper(array(0,0,1000,3000));
                //            return $pdf->download('saldos_socios.pdf');
                return $pdf->stream($nombrearchivo);
            }
        }
        return view('almacen.reportes.movimiento', [
            'datos' => Collection::make($datos),
            'fecha_ini' => $fecha1,
            'fecha_fin' => $fecha2,
        ]);
    }
    public function movimiento2(Request $request)
    {
        $mes = date('m');
        $anio = date('Y');
        //        return dd($anio);
        $datos = [];
        if (isset($request->consulta)) {
            $mes = $request->mes;
            $anio = $request->anio;
            $datos = Collection::make(Libro::movimientos2($mes, $anio));
            //        return dd($datos);
        }
        if (isset($request->exportar)) {
            $tipo = $request->exportar;
            $nombrearchivo = 'movimiento-almacen-' . $mes . '-' . $anio;
            if ($tipo == 'excel') {
                return \Excel::download(new MovimientoExport($datos, $mes, $anio), 'movimiento-' . date('Y-m-d') . '.xlsx');
            } elseif ($tipo == 'pdf') {
                $pdf = PDF::loadView('almacen.reportes.movimiento-exportar', [
                    'datos' => $datos,
                    'estilos' => true,
                    'mes' => $mes,
                    'anio' => $anio
                ]);
                $pdf->setPaper('a4', 'portrait');
                return $pdf->stream($nombrearchivo);
            }
        }
        return view('almacen.reportes.movimiento', [
            'datos' => Collection::make($datos),
            'mes' => $mes,
            'anio' => $anio
        ]);
    }
    public function index()
    {
        return view('almacen.reportes.index');
    }
    public function kardexMayor(Request $request)
    {
        $mes = date('m');
        $anio = date('Y');
        $datos = [];
        $codigo = '';
        $libros = Libro::orderBy('codigo', 'ASC')->get();
        $saldo_ant = 0;
        $saldo_act = 0;
        $ventas_ant = 0;
        $diferidos_ant = 0;
        $libro = [];
        if (isset($request->consulta)) {
            //            return dd($request->all());
            $codigo = $request->codigo;
            $mes = $request->mes;
            $anio = $request->anio;
            $aux = Libro::kardexMayor($mes, $anio, $codigo);
            $datos = $aux['datos'];
            $saldo_ant = $aux['saldo_ant'];
            $saldo_act = $aux['saldo_act'];
            $libro = $aux['libro'];
            $ventas_ant = $aux['ventas_ant'];
            $diferidos_ant = $aux['diferidos_ant'];
            // dd($aux);
        }
        if (isset($request->exportar)) {
            $codigo = $request->codigo;
            $mes = $request->mes;
            $anio = $request->anio;
            $aux = Libro::kardexMayor($mes, $anio, $codigo);
            $datos = $aux['datos'];
            $saldo_ant = $aux['saldo_ant'];
            $saldo_act = $aux['saldo_act'];
            $ventas_ant = $aux['ventas_ant'];
            $diferidos_ant = $aux['diferidos_ant'];
            $saldo_act = $aux['saldo_act'];
            $libro = $aux['libro'];
            $tipo = $request->exportar;
            $nombrearchivo = 'kardexmayor-' . $codigo . '-' . $mes . '-' . $anio;
            if ($tipo == 'excel') {
                return \Excel::download(new KardexMayorExport($datos, $mes, $anio, $codigo, $saldo_ant, $saldo_act, $libro, $ventas_ant, $diferidos_ant), 'kardexMayor-' . date('Y-m-d') . '.xlsx');
            } elseif ($tipo == 'pdf') {
                //                return dd($datos);
                $pdf = PDF::loadView('almacen.reportes.kardexmayor-exportar', [
                    'datos' => $datos,
                    'estilos' => true,
                    'mes' => $mes,
                    'anio' => $anio,
                    'codigo' => $codigo,
                    'saldo_ant' => $saldo_ant,
                    'saldo_act' => $saldo_act,
                    'libro' => $libro,
                    'ventas_ant' => $ventas_ant,
                    'diferidos_ant' => $diferidos_ant,
                ]);
                $pdf->setPaper('a4', 'portrait');
                return $pdf->stream($nombrearchivo);
            }
        }
        return view('almacen.reportes.kardexmayor', [
            'mes' => $mes,
            'anio' => $anio,
            'codigo' => $codigo,
            'datos' => $datos,
            'libros' => $libros,
            'saldo_ant' => $saldo_ant,
            'saldo_act' => $saldo_act,
            'libro' => $libro,
            'ventas_ant' => $ventas_ant,
            'diferidos_ant' => $diferidos_ant,
        ]);
    }
    public function catalogo(Request $request)
    {
        $libros = Libro::orderBy('codigo', 'ASC')->get();
        if (isset($request->tipo)) {
            $tipo = $request->tipo;
            $nombrearchivo = 'Catalogo';
            if ($tipo == 'excel') {
                return \Excel::download(new CatalogoExport($libros), 'Catalogo-' . date('Y-m-d') . '.xlsx');
            } elseif ($tipo == 'pdf') {
                $pdf = PDF::loadView('almacen.reportes.catalogo-exportar', [
                    'libros' => $libros,
                    'estilos' => true,
                ]);
                $pdf->setPaper('a4', 'portrait');
                //            $pdf->setPaper([0, 0,650, 270], 'portrait');
                //            $pdf->output();
                //            $dom_pdf = $pdf->getDomPDF();
                //            $pdf->set_paper(array(0,0,1000,3000));
                //            return $pdf->download('saldos_socios.pdf');
                return $pdf->stream($nombrearchivo);
            }
        }
        return view('almacen.reportes.catalogo', [
            'libros' => $libros
        ]);
    }
    public function cargosVendedor(Request $request)
    {
        $mes = Carbon::now()->month;
        $anio = Carbon::now()->year;
        $vendedor = [];
        $vendedores = Vendedor::orderBy('nombres', 'ASC')->get();
        $datos = [];
        if (isset($request->vendedor_id)) {
            //            return dd($request->all());
            $mes = $request->mes;
            $anio = $request->anio;
            $vendedor = Vendedor::find($request->vendedor_id);
            $datos = Kardex::cargosVendedor($mes, $anio, $vendedor->id);
        }
        if (isset($request->tipo)) {
            $tipo = $request->tipo;
            $mes = Helper::mes($mes);
            $nombrearchivo = 'CARGOS-' . $vendedor->nombre_completo . '-' . $mes . '_' . $anio;
            if ($tipo == 'excel') {
                return \Excel::download(new CargosVendedorExport($datos, $mes, $anio, $vendedor), 'kardex-' . date('Y-m-d') . '.xlsx');
            } elseif ($tipo == 'pdf') {
                $pdf = PDF::loadView('almacen.reportes.cargos-exportar', [
                    'estilos' => true,
                    'mes' => $mes,
                    'anio' => $anio,
                    'vendedor' => $vendedor,
                    'datos' => $datos
                ]);
                $pdf->setPaper('a4', 'landscape');
                //            $pdf->setPaper([0, 0,650, 270], 'portrait');
                //            $pdf->output();
                //            $dom_pdf = $pdf->getDomPDF();
                //            $pdf->set_paper(array(0,0,1000,3000));
                //            return $pdf->download('saldos_socios.pdf');
                return $pdf->stream($nombrearchivo);
            }
        }
        return view('almacen.reportes.cargos', [
            'mes' => $mes,
            'anio' => $anio,
            'vendedor' => $vendedor,
            'vendedores' => $vendedores,
            'datos' => $datos
        ]);
    }
}
