<?php

namespace App\Http\Controllers;

use App\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class UserController extends Controller
{
    public function roles(){
        $roles=Role::orderBy('name','ASC')->get();
        $permisos=Permission::orderBy('name','ASC')->get();

        return view('roles.index',[
            'roles'=>$roles,
            'permisos'=>$permisos
        ]);


    }

    public function roleCreate(){
        $roles=Role::orderBy('name','ASC')->get();
        $permisos=Permission::orderBy('name','ASC')->get();
        return view('roles.create_edit',[
            'roles'=>$roles,
            'permisos'=>$permisos
        ]);
    }


    public function roleDelete(Role $role){

      
        try{


            DB::beginTransaction();
            $role->permissions()->sync([]);
            $role->delete();
            Session::flash('success','El rol se elimino corretamente');

            DB::commit();



        }

        catch (\Exception $e){
            DB::rollBack();
            return dd($e);
            Session::flash('error','Ocurrio un error en el servidor');

        }
        return redirect('roles');
    }
    public function roleEdit(Role $role){

        $permisos=Permission::orderBy('name','ASC')->get();
        return view('roles.create_edit',[
            'role'=>$role,
            'permisos'=>$permisos
        ]);
    }
    public function roleStore(Request $request){
//        return dd($request->all());
       try{



           DB::beginTransaction();

           if(isset($request->id)){
               $role=Role::find($request->id);
           }
           else{

           $role=new Role();
           }

           $role->name=$request->nombre;
           $role->save();
           if(isset($request->id))
           $role->permissions()->sync($request->permisos);
           else
           $role->permissions()->attach($request->permisos);
    //  $role->syncPermissions($request->permisos);
           Session::flash('success','El rol se guardo corretamente');
           DB::commit();

       }
       catch(\Exception $e){
           DB::rollBack();
           return dd($e);


           Session::flash('error','Ocurrio un error en el servidor');

       }

       return redirect('roles');
    }

    public function indexUser(){

                //    return dd(auth()->user()->can('contratos venta'));



        $users =User::orderBy('name','ASC')->get();
        $roles=Role::orderby('name','ASC')->get();
        return view('users.index',[
            'usuarios'=>$users,
            'roles'=>$roles
        ]);
    }

    public function storeUser(Request $request){
        try{
        
            // return dd(auth()->user()->getPermissionsViaRoles());
            //  return dd($request->all());
            
             $validator=\Validator::make($request->all(),[
                 'email'=>'required|unique:users',
                 'password'=>'required'
             ],[
                 'email.unique'=>'El email ya esta en unso en el sistema',
                 'email.required'=>'El emailes necesario'
             ]);

             if($validator->fails()){
                Session::flash('error', 'Los campos del formulario son invalidos, o el email ya se encuentra registrado');

                  return back();
             }

            
            DB::beginTransaction();

            $u=new User();
            $u->name=$request->name;
            $u->email=$request->email;
            $u->password=bcrypt($request->password);
            $u->save();
            $u->roles()->attach($request->role);
       
            DB::commit();
            Session::flash('success','El usuario se registro exitosamente');


        }
        catch (\Exception $e){
            DB::rollBack();
            Session::flash('error','Ocurrio un error inesperado');
        //    return dd($e);

        }
        return redirect('users');
}

    public function updateUser(Request $request){

//        return dd($request->all());
        try{
            DB::beginTransaction();

            $u=User::find($request->id);
            $u->name=$request->name;
            $u->email=$request->email;

            if(isset($request->cambiar))
            $u->password=bcrypt($request->password);

            $u->save();
            $u->roles()->sync($request->role);
            DB::commit();
            Session::flash('success','El usuario se registro exitosamente');



        }
        catch (\Exception $e){
            DB::rollBack();
            Session::flash('error','Ocurrio un error inesperado');
//            return dd($e);

        }
        return redirect('users');
    }

    public function deleteUser(User $user){
        try{
            $user->roles()->sync([]);
            $user->delete();
            Session::flash('success','El usuario se elimino exitosamente');

        }
        catch (\Exception $e){
            return dd($e);
            Session::flash('error','Ocurrio un error inesperado');
        }
        return redirect('users');
    }

}
