<?php

namespace App\Http\Controllers;

use App\NotasRemision;
use App\Vendedor;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Psy\Util\Str;
use Barryvdh\DomPDF\Facade as PDF;
use App\Exports\VendedoresExport;



class VendedorController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {


        $vendedores=Vendedor::orderBy('nombres','ASC')->get();
        if(isset($request->exportar)){
            if($request->exportar=='excel') {
                return \Excel::download(new VendedoresExport($vendedores), 'lista-vendedores.xlsx');

            }
            elseif ($request->exportar=='pdf'){
                $pdf = PDF::loadView('vendedores.exportar',[
                    'vendedores' => $vendedores,
                    'estilos'=>true,

                ]);
                $pdf->setPaper('a4', 'portrait');
               return $pdf->stream('Vendedores');

            }
        }
        return view('vendedores.index',[
            'vendedores'=>$vendedores
        ]);

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try{
            if(isset($request->id))
                $vendedor=Vendedor::find($request->id);
            else
                $vendedor= new Vendedor();


           $vendedor->codigo=substr($request->nombres,0,1).substr($request->apellidos,0,1).'-'.\Illuminate\Support\Str::random(4);
           $vendedor->nombres=$request->nombres;
       $vendedor->apellidos=$request->apellidos;
       $vendedor->carnet=$request->carnet;
       $vendedor->telefono=$request->telefono;
       $vendedor->email=$request->email;
       $vendedor->direccion=$request->direccion;
       $vendedor->estatus=$request->estado;
       $vendedor->nacionalidad=$request->nacionalidad;
       $vendedor->tipo_documento=$request->tipo_documento;
       $vendedor->supervisor=$request->supervisor;
       $vendedor->credito=$request->credito;
       $vendedor->tipocomisioncredito=$request->tipocomisioncredito;
       $vendedor->valorcomisioncredito=$request->valorcomisioncredito;
       $vendedor->tipocomisioncontado=$request->tipocomisioncontado;
       $vendedor->valorcomisioncontado=$request->valorcomisioncontado;
       $vendedor->save();

            Session::flash('success','El vendedor  se guardo correctamente.');

        }
        catch (\Exception $e){
            return $e;
            Session::flash('error','Existio un error al guardar el vendedor ');


        }

        return redirect('vendedores');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Vendedor  $vendedor
     * @return \Illuminate\Http\Response
     */
    public function show(Vendedor $vendedor)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Vendedor  $vendedor
     * @return \Illuminate\Http\Response
     */
    public function edit(Vendedor $vendedor)
    {
        $vendedores=Vendedor::orderBy('nombres','ASC')->get();
        return view('vendedores.create_edit',[
            'vendedor'=>$vendedor,
            'vendedores'=>$vendedores

        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Vendedor  $vendedor
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Vendedor $vendedor)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Vendedor  $vendedor
     * @return \Illuminate\Http\Response
     */
    public function destroy(Vendedor $vendedor)
    {
        try{
            
            $remis=NotasRemision::where('vendedor_id',$vendedor->id)->get();
            if(count($remis)>0)
            throw new \Exception('error');
            
            $vendedor->delete();
            Session::flash('success','El vendedor se Elimino correctamente');

        }
        catch (\Exception $e){

            Session::flash('warning','No se puede borrar este vendedor tiene registros asociados');
        }

        return  redirect('vendedores');

    }
}
