<?php

namespace App;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;

class Libro extends Model
{
    protected $table = 'libros';

    protected  $fillable = [
        'codigo',
        'titulo',
        'stock',
        'foto',
        'categoria_id',
        'precio_base',
        'precio_final',
        'tomo',
        'observacion',
        'editorial_id',
        'stock_minimo',

    ];
    public $timestamps = false;

    public function categoria()
    {
        return $this->belongsTo(Categoria::class, 'categoria_id');
    }
    public function editorial()
    {
        return $this->belongsTo(Editorial::class, 'editorial_id');
    }

    static function getDatosCodigo($codigo)
    {
        $query = self::where('codigo', $codigo)->first();
        return $query;
    }

    static function movimientos($fecha_ini, Carbon $fecha_fin)
    {

        $fecha_ini = Carbon::createFromFormat('d/m/Y', $fecha_ini);
        $libros = self::orderBy('codigo')->get();

        $datos = [];

        //        return dd($fecha_ini->addDays(-1));
        foreach ($libros as $l) {
            $ingresos_ant = DB::table('view_ingreso_detalle')
                ->select('cantidad')
                ->where('codigo', $l->codigo)->where('terminado', 1)->where('estado', 'T')
                ->whereBetween('fecha', ['2000-01-01', $fecha_ini->addDays(-1)])
                ->sum('cantidad');
            $egresos_ant = DB::table('view_egreso_detalle')->select('cantidad')
                ->where('codigo', $l->codigo)->where('terminado', 1)->where('estado', 'T')
                ->whereBetween('fecha', ['01-01-2000', $fecha_ini->addDays(-1)])
                ->sum('cantidad');
            $dev_ant = DB::table('view_devolucion_detalle')->select('cantidad')
                ->where('codigo', $l->codigo)->where('terminado', 1)->where('estado', 'T')
                ->whereBetween('fecha', ['01-01-2000', $fecha_ini->addDays(-1)])
                ->sum('cantidad');
            $remision_ant = DB::table('view_remision_detalle')->select('cantidad')
                ->where('codigo', $l->codigo)->where('estado', 'T')
                ->whereBetween('fecha', ['01-01-2000', $fecha_ini->addDays(-1)])
                ->sum('cantidad');


            $ingresos_act = DB::table('view_ingreso_detalle')
                ->select('cantidad')
                ->where('codigo', $l->codigo)->where('terminado', 1)->where('estado', 'T')
                ->whereBetween('fecha', [$fecha_ini, $fecha_fin])
                ->sum('cantidad');
            $egresos_act = DB::table('view_egreso_detalle')->select('cantidad')
                ->where('codigo', $l->codigo)->where('terminado', 1)->where('estado', 'T')
                ->whereBetween('fecha', [$fecha_ini, $fecha_fin])
                ->sum('cantidad');
            $dev_act = DB::table('view_devolucion_detalle')->select('cantidad')
                ->where('codigo', $l->codigo)->where('terminado', 1)->where('estado', 'T')
                ->whereBetween('fecha', [$fecha_ini, $fecha_fin])
                ->sum('cantidad');
            $remision_act = DB::table('view_remision_detalle')->select('cantidad')
                ->where('codigo', $l->codigo)->where('estado', 'T')
                ->whereBetween('fecha', [$fecha_ini, $fecha_fin])
                ->sum('cantidad');

            $saldo_ant = ($ingresos_ant + $dev_ant) - ($remision_ant + $egresos_ant);
            $saldo_act = ($saldo_ant + $ingresos_act + $dev_act) - ($remision_act + $egresos_act);

            // if($ingresos_act>0 || $dev_act>0 || $egresos_act>0 || $remision_act>0)
            // {

            $datos[] = [
                'codigo' => $l->codigo,
                'titulo' => $l->titulo,
                'saldo_ant' => $saldo_ant,
                'saldo_actual' => $saldo_act,
                'ingresos' => $ingresos_act,
                'egresos' => $egresos_act,
                'devoluciones' => $dev_act,
                'remisiones' => $remision_act


            ];
            // }
            //            $datos['totales']=['ingresos'=>0];
        }
        return $datos;
    }
    static function movimientos2($mes, $anio)
    {

        $libros = self::orderBy('codigo')->get();

        $datos = [];
        $mes_ant = $mes - 1;
        $anio_ant = $anio;
        if ($mes <= 1) {
            $mes_ant = 12;
            $anio_ant = $anio - 1;
        }
        $fecha_ant = $anio_ant . '-' . $mes_ant . '-31';

        //        return dd($fecha_ini->addDays(-1));
        foreach ($libros as $l) {
            $ingresos_ant = DB::table('view_ingreso_detalle')
                ->select('cantidad')
                ->where('codigo', $l->codigo)->where('terminado', 1)->where('estado', 'T')
                ->where('fecha', '<=', $fecha_ant)
                ->sum('cantidad');
            $egresos_ant = DB::table('view_egreso_detalle')->select('cantidad')
                ->where('codigo', $l->codigo)->where('terminado', 1)->where('estado', 'T')
                ->where('fecha', '<=', $fecha_ant)
                ->sum('cantidad');
            $dev_ant = DB::table('view_devolucion_detalle')->select('cantidad')
                ->where('codigo', $l->codigo)->where('terminado', 1)->where('estado', 'T')
                ->where('fecha', '<=', $fecha_ant)
                ->sum('cantidad');
            $remision_ant = DB::table('view_remision_detalle')->select('cantidad')
                ->where('codigo', $l->codigo)->where('estado', 'T')
                ->where('fecha', '<=', $fecha_ant)
                ->sum('cantidad');


            $ingresos_act = DB::table('view_ingreso_detalle')
                ->select('cantidad')
                ->where('codigo', $l->codigo)->where('terminado', 1)->where('estado', 'T')
                ->whereMonth('fecha', '=', $mes)
                ->whereYear('fecha', '=', $anio)
                ->sum('cantidad');
            $egresos_act = DB::table('view_egreso_detalle')->select('cantidad')
                ->where('codigo', $l->codigo)->where('terminado', 1)->where('estado', 'T')
                ->whereMonth('fecha', '=', $mes)
                ->whereYear('fecha', '=', $anio)
                ->sum('cantidad');
            $dev_act = DB::table('view_devolucion_detalle')->select('cantidad')
                ->where('codigo', $l->codigo)->where('terminado', 1)->where('estado', 'T')
                ->whereMonth('fecha', '=', $mes)
                ->whereYear('fecha', '=', $anio)
                ->sum('cantidad');
            $remision_act = DB::table('view_remision_detalle')->select('cantidad')
                ->where('codigo', $l->codigo)->where('estado', 'T')
                ->whereMonth('fecha', '=', $mes)
                ->whereYear('fecha', '=', $anio)
                ->sum('cantidad');

            $saldo_ant = ($ingresos_ant + $dev_ant) - ($remision_ant + $egresos_ant);
            $saldo_act = ($saldo_ant + $ingresos_act + $dev_act) - ($remision_act + $egresos_act);

            // if($ingresos_act>0 || $dev_act>0 || $egresos_act>0 || $remision_act>0)
            // {

            $datos[] = [
                'codigo' => $l->codigo,
                'titulo' => $l->titulo,
                'saldo_ant' => $saldo_ant,
                'saldo_actual' => $saldo_act,
                'ingresos' => $ingresos_act,
                'egresos' => $egresos_act,
                'devoluciones' => $dev_act,
                'remisiones' => $remision_act


            ];
            // }
            //            $datos['totales']=['ingresos'=>0];
        }
        return $datos;
    }

    static function inventario(Carbon $fecha_fin)
    {
        $libros = self::orderBy('codigo')->get();

        $datos = [];

        //        return dd($fecha_ini->addDays(-1));
        foreach ($libros as $l) {


            $ingresos_act = DB::table('view_ingreso_detalle')
                ->select('cantidad')
                ->where('codigo', $l->codigo)->where('terminado', 1)->where('estado', 'T')
                ->where('fecha', '<=', $fecha_fin)
                ->sum('cantidad');
            $egresos_act = DB::table('view_egreso_detalle')->select('cantidad')
                ->where('codigo', $l->codigo)->where('terminado', 1)->where('estado', 'T')
                ->where('fecha', '<=', $fecha_fin)
                ->sum('cantidad');
            $dev_act = DB::table('view_devolucion_detalle')->select('cantidad')
                ->where('codigo', $l->codigo)->where('terminado', 1)->where('estado', 'T')
                ->where('fecha', '<=', $fecha_fin)
                ->sum('cantidad');
            $remision_act = DB::table('view_remision_detalle')->select('cantidad')
                ->where('codigo', $l->codigo)->where('estado', 'T')
                ->where('fecha', '<=', $fecha_fin)
                ->sum('cantidad');


            $saldo_act = ($ingresos_act + $dev_act) - ($remision_act + $egresos_act);

            // if($saldo_act>0) {
            $editorial = '';
            if (isset($l->editorial->nombre))
                $editorial = $l->editorial->nombre;

            try {
                $total = round($saldo_act * $l->precio_base);
            } catch (\Exception $e) {
                $total = 0;
            }
        //     if($l->codigo=='19-0004')
        //    dd( $ingresos_act,$dev_act,$remision_act , $egresos_act,$saldo_act);

            $datos[] = [
                'codigo' => $l->codigo,
                'titulo' => $l->titulo,
                'vol' => $l->tomo,
                'editorial' => $editorial,
                'cu' => $l->precio_base,
                'saldo_actual' => $saldo_act,
                'total' => $total,
                'stock'=>$l->stock
            ];
            // }
        }
        return $datos;
    }


    public static function RegularizacionInventario(Carbon $fecha_fin)
    {
        $libros = self::orderBy('codigo')->get();

        $datos = [];

        //        return dd($fecha_ini->addDays(-1));
        foreach ($libros as $l) {


            $ingresos_act = DB::table('view_ingreso_detalle')
                ->select('cantidad')
                ->where('codigo', $l->codigo)->where('terminado', 1)->where('estado', 'T')
                ->where('fecha', '<=', $fecha_fin)
                ->sum('cantidad');
            $egresos_act = DB::table('view_egreso_detalle')->select('cantidad')
                ->where('codigo', $l->codigo)->where('terminado', 1)->where('estado', 'T')
                ->where('fecha', '<=', $fecha_fin)
                ->sum('cantidad');
            $dev_act = DB::table('view_devolucion_detalle')->select('cantidad')
                ->where('codigo', $l->codigo)->where('terminado', 1)->where('estado', 'T')
                ->where('fecha', '<=', $fecha_fin)
                ->sum('cantidad');
            $remision_act = DB::table('view_remision_detalle')->select('cantidad')
                ->where('codigo', $l->codigo)->where('estado', 'T')
                ->where('fecha', '<=', $fecha_fin)
                ->sum('cantidad');
                // if($l->codigo=='19-0004')
                // dd($ingresos_act ,$dev_act,$remision_act , $egresos_act);

            $saldo_act = ($ingresos_act + $dev_act) - ($remision_act + $egresos_act);
            // if ($saldo_act > 0) {
                $editorial = '';
                if (isset($l->editorial->nombre))
                    $editorial = $l->editorial->nombre;

                try {
                    $total = round($saldo_act * $l->precio_base);
                } catch (\Exception $e) {
                    $total = 0;
                }


                $l->stock = $saldo_act;
                $l->save();
            // }
        }
    }

    static function kardexMayor($mes, $anio, $codigo)
    {

        $datos = [];
        $libro = self::where('codigo', $codigo)->first();
        $mes_ant = $mes - 1;
        $anio_ant = $anio;
        if ($mes <= 1) {
            $mes_ant = 12;
            $anio_ant = $anio - 1;
        }
        $fecha_ant = $anio_ant . '-' . $mes_ant . '-31';

        $ingresos_ant = DB::table('view_ingreso_detalle')
            ->select('cantidad')
            ->where('codigo', $codigo)
            ->where('terminado', 1)
            ->where('estado', 'T')
            ->where('fecha', '<=', $fecha_ant)

            ->sum('cantidad');

        $egresos_ant = DB::table('view_egreso_detalle')->select('cantidad')
            ->where('codigo', $codigo)
            ->where('terminado', 1)
            ->where('estado', 'T')
            ->where('fecha', '<=', $fecha_ant)
            ->sum('cantidad');
        $dev_ant = DB::table('view_devolucion_detalle')
            ->select('cantidad')
            ->where('codigo', $codigo)
            ->where('terminado', 1)
            ->where('estado', 'T')
            ->where('fecha', '<=', $fecha_ant)
            ->sum('cantidad');
        $remision_ant = DB::table('view_remision_detalle')
            ->select('cantidad')
            ->where('codigo', $codigo)->where('estado', 'T')
            ->where('fecha', '<=', $fecha_ant)
            ->sum('cantidad');

        $ventas_ant = DB::table('view_contratos_detalle')
            ->select('cantidad')
            ->where('codigo', $codigo)
            ->whereIn('tipocontrato', ['VENTA'])
            ->where('fechacontrato', '<=', $fecha_ant)
            ->sum('cantidad');
        $diferidos_ant = DB::table('view_contratos_detalle')
            ->select('cantidad')
            ->where('codigo', $codigo)
            ->whereIn('tipocontrato', ['DIFERIDO'])
            ->where('fechacontrato', '<=', $fecha_ant)
            ->sum('cantidad');

        $saldo_ant = ($ingresos_ant + $dev_ant) - ($remision_ant + $egresos_ant);
        $ingresos_act = DB::table('view_ingreso_detalle')
            ->select('cantidad', 'id', 'fecha', 'envia')
            ->where('codigo', $codigo)
            ->where('terminado', 1)
            ->where('estado', 'T')
            ->whereMonth('fecha', '=', $mes)
            ->whereYear('fecha', '=', $anio)
            ->get();
        foreach ($ingresos_act as $r) {
            $datos[] = [
                'fecha' => $r->fecha,
                'procedencia' => $r->envia,
                'tipo_doc' => 'N.INGRESO',
                'tipo' => 'i',
                'num_doc' => $r->id,
                'cant' => $r->cantidad
            ];
        }
        $egresos_act = DB::table('view_egreso_detalle')
            ->select('cantidad', 'id', 'fecha', 'destino')
            ->where('codigo', $codigo)
            ->where('terminado', 1)
            ->where('estado', 'T')
            ->whereMonth('fecha', '=', $mes)
            ->whereYear('fecha', '=', $anio)
            ->get();
        foreach ($egresos_act as $r) {
            $datos[] = [
                'fecha' => $r->fecha,
                'procedencia' => $r->destino,
                'tipo_doc' => 'N.EGRESO',
                'tipo' => 'e',
                'num_doc' => $r->id,
                'cant' => $r->cantidad

            ];
        }
        $remisiones_act = DB::table('view_remision_detalle')
            ->select('cantidad', 'id', 'fecha', 'nombres', 'apellidos')
            ->where('codigo', $codigo)
            ->where('estado', 'T')
            ->whereMonth('fecha', '=', $mes)
            ->whereYear('fecha', '=', $anio)
            ->get();
        foreach ($remisiones_act as $r) {
            $datos[] = [
                'fecha' => $r->fecha,
                'procedencia' => $r->nombres . ' ' . $r->apellidos,
                'tipo_doc' => 'N.REMISION',
                'tipo' => 'e',
                'num_doc' => $r->id,
                'cant' => $r->cantidad
            ];
        }
        $devoluciones_act = DB::table('view_devolucion_detalle')
            ->select('cantidad', 'id', 'fecha', 'nombres')
            ->where('codigo', $codigo)->where('terminado', 1)->where('estado', 'T')
            ->whereMonth('fecha', '=', $mes)
            ->whereYear('fecha', '=', $anio)
            ->get();
        foreach ($devoluciones_act as $r) {
            $datos[] = [
                'fecha' => $r->fecha,
                'procedencia' => $r->nombres,
                'tipo_doc' => 'N.DEVOLUCION',
                'tipo' => 'i',
                'num_doc' => $r->id,
                'cant' => $r->cantidad

            ];
        }

        $venta_act = DB::table('view_contratos_detalle')
            ->select('cantidad', 'numcontrato', 'tipoventa', 'nombres', 'apellidomaterno', 'apellidopaterno', 'ci', 'fechacontrato', 'numcuenta', 'fechadoc')
            ->where('codigo', $codigo)
            ->whereIn('tipocontrato', ['VENTA'])
            ->where('terminado', 1)
            ->whereMonth('fechacontrato', '=', $mes)
            ->whereYear('fechacontrato', '=', $anio)
            ->get();
        foreach ($venta_act as $r) {
            $datos[] = [
                'fecha' => $r->fechacontrato,
                'procedencia' => $r->nombres . ' ' . $r->apellidopaterno . ' ' . $r->apellidomaterno,
                'tipo_doc' => 'VENTA',
                'tipo' => 'v',
                'num_doc' => $r->numcontrato,
                'cant' => $r->cantidad

            ];
        }
        $diferidos_act = DB::table('view_contratos_detalle')
            ->select('cantidad', 'numcontrato', 'tipoventa', 'nombres', 'apellidomaterno', 'apellidopaterno', 'ci', 'fechacontrato', 'numcuenta', 'fechadoc')
            ->where('codigo', $codigo)
            ->whereIn('tipocontrato', ['DIFERIDO'])
            ->where('terminado', 1)
            ->whereMonth('fechacontrato', '=', $mes)
            ->whereYear('fechacontrato', '=', $anio)
            ->get();
        // dd($diferidos_act);

        foreach ($diferidos_act as $r) {
            $datos[] = [
                'fecha' => $r->fechacontrato,
                'procedencia' => $r->nombres . ' ' . $r->apellidopaterno . ' ' . $r->apellidomaterno,
                'tipo_doc' => 'DIFERIDO',
                'tipo' => 'v',
                'num_doc' => $r->numcontrato,
                'cant' => $r->cantidad

            ];
        }

        $datos = Collection::make($datos)->sortBy('fecha');
        $datos2 = [];
        $saldo = $saldo_ant;
        foreach ($datos as $r) {
            if ($r['tipo'] == 'i') {
                $saldo += $r['cant'];
                $datos2[] = [
                    'fecha' => $r['fecha'],
                    'tipo' => $r['tipo'],
                    'procedencia' => $r['procedencia'],
                    'tipo_doc' => $r['tipo_doc'],
                    'num_doc' => $r['num_doc'],
                    'cant' => $r['cant'],
                    'saldo' => $saldo
                ];
            } elseif ($r['tipo'] == 'e') {
                $saldo -= $r['cant'];
                $datos2[] = [
                    'fecha' => $r['fecha'],
                    'tipo' => $r['tipo'],
                    'procedencia' => $r['procedencia'],
                    'tipo_doc' => $r['tipo_doc'],
                    'num_doc' => $r['num_doc'],
                    'cant' => $r['cant'],
                    'saldo' => $saldo
                ];
            } elseif ($r['tipo'] == 'v') {

                $datos2[] = [
                    'fecha' => $r['fecha'],
                    'tipo' => $r['tipo'],
                    'procedencia' => $r['procedencia'],
                    'tipo_doc' => $r['tipo_doc'],
                    'num_doc' => $r['num_doc'],
                    'cant' => $r['cant'],
                    'saldo' => $saldo
                ];
            }
        }
        return [
            'datos' => Collection::make($datos2),
            'saldo_ant' => $saldo_ant,
            'saldo_act' => $saldo,
            'ventas_ant' => $ventas_ant,
            'diferidos_ant' => $diferidos_ant,
            'libro' => $libro
        ];
    }
}