<?php

namespace App;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class NotasDevolucion extends Model
{
    protected $table='devolucion';
    protected $fillable=[
        'fecha',
        'cant_total',
        'estado',
        'vendedor_id',
        'almacen_id',
        'user_id',

        'obs',
        'terminado',
        'tipo',
        'numcontrato',
    ];

    protected $dates=['fecha'];

    public function contrato(){
        return $this->belongsTo(Contrato::class,'numcontrato','numcontrato');
    }

    public function detalle(){
        return $this->hasMany(DetalleDevolucion::class,'devolucion_id')->orderBy('codigo','ASC');
    }

    public function setFechaAttribute($fecha){
        $this->attributes['fecha']=Carbon::createFromFormat('d/m/Y',$fecha);
    }
    public function user(){
        return $this->belongsTo(User::class,'user_id');
    }
    public function vendedor(){
       return $this->belongsTo(Vendedor::class,'vendedor_id');
    }
    public function getEstadoAttribute()
    {
        switch ($this->attributes['estado']) {
            case 'G':
                return 'CREADO';
                break;
            case 'T':
                return 'PROCESADO';
                break;
            case 'A':
                return 'ANULADO';
                break;
        }
    }
    public function validarDisponibles(){

        $faltantes=[];

        if(count($this->detalle)>0){
            foreach($this->detalle as $d){
                $disponible=Kardex::select('id')
                               ->where('vendedor_id',$this->vendedor_id)
                               ->where('cod_libro',$d->codigo)
                               ->whereIn('estado',['Remitido'])
                               ->whereIn('cargo',[0,1])
                               ->whereMonth('fechakardex','=',$this->fecha->month)
                               ->whereYear('fechakardex','=',$this->fecha->year)
                               ->get()->count();
//                return dd($d->cantidad,$d->codigo);
                if($disponible<$d->cantidad){
                    $faltantes[]=[
                        'codigo'=>$d->codigo,
                        'titulo'=>$d->titulo,
                        'tomo'=>$d->volumen,
                        'cantidad_faltante'=>$d->cantidad-$disponible,
                        'cantidad'=>$d->cantidad,
                        'libro_id'=>$d->libro_id,
                    ];
                }
            }
        }

        return $faltantes;

    }
}
