<?php

namespace App;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class NotasEgreso extends Model
{
    protected  $table='egreso';
    protected  $fillable=[
        'envia',
        'fecha',
        'recibe',
        'destino',
        'cant_total',
        'precio_total',
        'estado',
        'user_id',
        'almacen_id',
        'terminado',
        'moneda',
        'valor_cambio',
        'obs',
    ];
    protected  $dates=['fecha'];

    public function setFechaAttribute($fecha){
         $this->attributes['fecha']=Carbon::createFromFormat('d/m/Y',$fecha);
    }
    public function detalle(){
        return $this->hasMany(DetalleEgreso::class,'egreso_id')->orderBy('codigo','ASC');

    }

    public function user(){
        return $this->belongsTo(User::class,'user_id');
    }
    public function getEstadoAttribute()
    {
        switch ($this->attributes['estado']) {
            case 'G':
                return 'CREADO';
                break;
            case 'T':
                return 'PROCESADO';
                break;
            case 'A':
                return 'ANULADO';
                break;
        }
    }
}
