<?php

namespace App;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class Pago extends Model
{
    protected $table='pagos';

    protected $fillable=[
            'monto',
            'fecha',
            'num_reporte',
            'estado',
            'numrecibo',
            'terminado',
            'obs',
            'model_type',
            'model_id',
            'tipo_documento',
             'cobrador_id'
    ];
    protected $dates=['fecha'];

    public function setFechaAttribute($fecha)
    {
        $this->attributes['fecha']=Carbon::createFromFormat('d/m/Y',$fecha);
    }
    public function credito(){
        return $this->hasOne(Credito::class,'id','model_id');
    }

    public function  recibo(){
       return  $this->hasOne(Recibo::class,'model_id','id');
    }
    public function  descuento(){
        return  $this->hasOne(Descuento::class,'credito_id','id');
     }
    public function cobrador(){
        return $this->belongsTo(cobrador::class,'cobrador_id');
    }

   


}
