@extends('layouts.admin')
@section('title') DEVOLUCION @stop
@section('titulo')CREAR NOTA DE DEVOLUCION  @stop
@section('menu-devolucion') active open @stop
{{--@section('libros-opcion')active  @stop--}}

@section('descripcion')
    <ol class="breadcrumb breadcrumb-arrow">
        <li class="breadcrumb-item"><a href="{{url('/')}}">Inicio</a></li>
        <li class="breadcrumb-item ">Almacenes</li>
        <li class="breadcrumb-item active"><a href="{{url('notas-devolucion')}}">Nota de Devolucion</a></li>
        <li class="breadcrumb-item active">Registrar Nota de Devolucion
        </li>

    </ol>
@stop
@section('content')

    <form style="border: 1px solid" autocomplete="off" method="post" action="{{url('notas-devolucion/store')}}" class="form col-lg-10">
        {!! csrf_field() !!}
        @if($edit)
            <input type="hidden" name="devolucion_id" value="{{$devolucion->id}}">
        @endif
        <div class="form-group  col-md-3">
            <label class="form-control-label" for="inputBasicFirstName"> <strong>FECHA</strong></label>
            <div class="input-group">
                      <span class="input-group-addon">
                        <i class="icon md-calendar text-danger" aria-hidden="true"></i>
                      </span>
                <input  name="fecha" readonly  value="{{$fecha->format('d/m/Y')}}"style="font-size: 16px; font-weight: bold;"  type="text" class=" datepicker2 password-strength-example2 form-control strength-input"  >
            </div>
        </div>
        <div class="form-row">
            <div class=" form-group col-md-4">
                <label class="form-control-label"><strong>VENDEDOR</strong></label>
                <input   readonly  value="{{$vendedor->nombre_completo}}"style="font-size: 16px; font-weight: bold;" type="text" class="password-strength-example2 form-control strength-input"  >
                <input  type="hidden" name="vendedor_id" value="{{$vendedor->id}}" >

            </div>

            <div class=" form-group col-md-6">
                <label   class="form-control-label" for=""><strong>OBSERVACIONES</strong></label>
                <textarea name="obs" class="form-control" id=""  placeholder="Observacion" rows="2">@if($edit) {{$devolucion->obs}} @endif</textarea>
            </div>
        </div>

        <div class="form-row" style="border-top:1px solid">
            <div class=" form-group col-md-7 col-sm-12">
                <label class="form-control-label "><strong>CODIGO</strong></label>
                <select  id="select3" name="libro_id" class="form-control select3"  >
                    <option value="">Seleccione</option>
                    @foreach($libros as $l)
                        <option  stock="{{$l['cantidad']}}" codigo="{{$l['codigo']}}" titulo="{{$l['titulo']}}" tomo="{{$l['tomo']}}" value="{{$l['id']}}"><strong> {{$l['codigo']}} - </strong>{{$l['titulo']}} [{{$l['cantidad']}}] </option>
                    @endforeach
                </select>
            </div>
            <div class=" form-group col-md-1 col-sm-3 col-xs-3">
                <label   class="form-control-label" for=""><strong>REMITIDO</strong></label>
                <input  readonly type="text"  class="stock limpiar  form-control">
            </div>
            <div class=" form-group col-md-2 col-sm-4 col-xs-4">
                <label   class="form-control-label" for=""><strong>CANTIDAD</strong></label>
                <input type="number"  id="cantidad" class="cantidad limpiar  solo-enteros form-control">
            </div>
            <div class=" form-group col-md-1 col-sm-1">
                <label class="form-control-label" for="">&nbsp;</label>
                <button  type="button" class=" btn-add btn    btn-outline-success "><i class="icon md-plus"></i> Adicionar</button>
            </div>

        </div>
        <hr>
        <div class="visible"  @if(!$edit) style="display: none" @endif>
            <table class="table table-detalle">
                <thead>
                <tr>
                    <th>No</th>
                    <th>Cantidad</th>
                    <th>Codigo</th>
                    <th>Titulo</th>
                    <th>Tomo</th>
                    <th>Observacion</th>
                    <th>Acciones</th>
                </tr>
                </thead>
                <tbody>
                @if($edit)
                    @foreach($devolucion->detalle as $k=>$d)
                        <tr>

                            <td>{{$k+1}}</td>
                            <td class=" text-left"><input type="text" class="td-cant" name="cant[]" readonly size="5%" value="{{$d->cantidad}}"></td>
                            <td ><strong class="td-codigo">{{$d->codigo}}</strong></td>
                            <td>{{$d->titulo}}</td>
                            <td>{{$d->volumen}}</td>
                            <td><input type="text" size="27%" name="observacion[]" value="{{$d->obs}}"/><input type="hidden" name="libro_id[]" value="{{$d->libro_id}}"></td>
                            <td><button type="button" class="brn btn-xs btn-danger" onclick="remove(this)"><i class="icon md-close"></i>Borrar</button></td>

                        </tr>
                    @endforeach

                @endif

                </tbody>
                <tfoot>
                <tr>
                    <th>Total</th>
                    <td><input  @if($edit) value="{{$devolucion->cant_total}}" @endif  type="text" name="cant_total"  size="5%" class="cant_total" readonly></td>
                </tr>
                </tfoot>
            </table>



            <div class="form-group form-material">
                <button type="submit" class=" btn-guardar btn btn-block btn-primary  btn-outline ">GUARDAR</button>
                <a href="{{url('notas-remision')}}" class="btn btn-block btn-default waves-effect waves-light waves-round">CANCELAR</a>
            </div>
        </div>
    </form>

@section('scripts')

    <script>
        var codigos=[]

        function buscarCodigo(codigo){
            var sw=false;
            if(codigos.indexOf(codigo)!=-1)
                sw=true;
            return sw;
        }

        function numerosTabla(){
            var cant=0;
            $('.table-detalle tbody tr').each(function(k,v){

                $(v).find('td:first').html(k+1)
                cant+=parseInt($(v).find('.td-cant').val())


            });
            return cant
        }

        function limpiar(){
            $('.limpiar').val('')
            $('#select3').val('').trigger('change');
            $('#select3').focus()



        }

        function addFila(datos){
            var fila='<tr>';
            fila+='<td></td><td class=" text-left   "><input type="text" class="td-cant" name="cant[]" readonly size="5%" value="'+datos.cantidad+'"></td><td ><strong class="td-codigo" ">'+datos.codigo+'</strong></td>'+
                '<td>'+datos.titulo+'</td><td>'+datos.tomo+'<td><input type="text" size="27%" name="observacion[]"/><input type="hidden" name="libro_id[]" value="'+datos.id+'"></td>'+
                '<td><button class="btn btn-xs btn-danger" onclick="remove(this)"><i class="icon md-close"></i></button></td>'+
                '</tr>';



            $('.table-detalle tbody').append(fila)
            codigos.push(datos.codigo)

            var _credito=(parseInt($('.credito').val())-parseInt(datos.cantidad));
            $('.credito').val(_credito)
            limpiar();
            $('.visible').show()
            $('.cant_total').val(numerosTabla())
// console.log(datos)
        }


        function remove(btn)
        {
            // alert('')
            limpiar();
            let codigo=$(btn).closest('tr').find('.td-codigo').html()
            let cant=$(btn).closest('tr').find('.td-cant').val()
            $(btn).closest('tr').remove()
            _cantfilas=$('.table-detalle tbody tr').length;
            if(_cantfilas<=0){
                $('.visible').hide();
            }

            var _credito=(parseInt($('.credito').val())+parseInt(cant));
            $('.credito').val(_credito)
            $('.cant_total').val(numerosTabla)
            borrarArray(codigo)

        }

        function borrarArray(valor){
            var index = codigos.indexOf(valor);
            if (index > -1) {
                codigos.splice(index, 1);
                return true;
            }
            return false;

        }

        $(document).ready(function(){

            $("#cantidad").keypress(function (e) {
                if(e.which == 13) {
                    $(".btn-add").trigger("click");
                }
            });

            var endDate={{$fecha->endOfMonth()->day}}+'/'+{{$fecha->format('m')}}+'/'+{{$fecha->format('Y')}}
            var startDate={{$fecha->firstOfMonth()->day}}+'/'+{{$fecha->format('m')}}+'/'+{{$fecha->format('Y')}}

            $('.datepicker2').datepicker({
                language: 'es',
                autoclose:true,
                format:'dd/mm/yyyy',
                showOn: "button",
                clearBtn:true,
                endDate:endDate,
                startDate:startDate,
                buttonText: '<i class="fa fa-calendar"></i>',

            });

            @if($edit)
            $('.table-detalle tbody tr').each(function(k,v){

                let codigo=$(v).find('.td-codigo').html()
                codigos.push(codigo)
            });
            @endif


            $('.btn-guardar').click(function(_evt){
                _evt.preventDefault();
                if($('.datepicker').val()==''){
                    swal('Alerta','Debe seleccionar una Fecha','warning')

                    return false;
                }

                swal({
                        title: "Guardar nota de devolucion",
                        text: "Revise que todos los campos esten llenados correctamente.",
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonClass: "btn-success",
                        confirmButtonText: "Si, Guardar!",
                        cancelButtonText:"Cancelar",
                        closeOnConfirm: false
                    },
                    function(){
                        $('.form').submit();
                    });


            })


            $('.btn-add').click(function(){
                let titulo =$('.select3').find(":selected").attr("titulo")
                let codigo =$('.select3').find(":selected").attr("codigo")
                let tomo =$('.select3').find(":selected").attr("tomo")
                let id =$('.select3').find(":selected").val()
                let stock =$('.stock').val()
                let cantidad=$('.cantidad').val()
                if(parseInt(cantidad)<=0 || (parseInt(cantidad)>parseInt(stock))){
                    swal('Alerta','No hay suficiente stock','warning')
                    return false;

                }

                if(buscarCodigo(codigo)){
                    swal('Alerta','Este codigo ya se encuentra registrado','warning')
                    return false;
                }
                if($('.vendedor').val()=='')
                {
                    swal('Alerta','Es necesario seleccionar un vendedor','warning')

                    return false
                }
                if($('.credito').val()=='' || parseInt($('.credito').val())<=0)
                {
                    swal('Alerta','El vendedor no cuenta con suficiente stock','warning')

                    return false
                }
                let datos={
                    titulo:titulo,
                    codigo:codigo,
                    tomo:tomo,
                    id:id,
                    cantidad:cantidad
                }

                addFila(datos)
                $('.select3').select2('open');


            })

            $('.select2').on('select2:selecting', function(e) {
                let cant=numerosTabla()

                let credito =e.params.args.data.element.attributes.credito.value;
                if(parseInt(credito)<parseInt(cant)){
                    swal('Alerta','El vendedor no cuenta con credito suficiente para asignarle items','warning')

                    return false;
                }


                if(parseInt(credito)<=0 || credito=='' || typeof(credito)=='undefined'){
                    $('.credito').val(0)
                }
                else{
                    $('.credito').val(credito)
                }

            });
            $('.select3').on('select2:selecting', function(e) {
                let stock =e.params.args.data.element.attributes.stock.value;

                if(parseInt(stock)<=0 || stock=='' || typeof(stock)=='undefined'){
                    $('.stock').val(0)
                }
                else{
                    $('.stock').val(stock)
                }
                $('#cantidad').focus()
            });
            $('.select3').on('select2:select', function(e) {

                $('#cantidad').focus();

            });

            $('.select2').select2({
                placeholder: 'Seleccione una opcion',
                multiple:false,
                width:'90%'
            });
            $('.select3').select2({
                placeholder: 'Seleccione una opcion',
                multiple:false,
                width:'90%'
            });

            var select2=function(){


                $('body .select2').select2({
                    placeholder: 'Seleccione una opcion',
                    multiple:false,
                    width:'90%'
                });

            }




        })
    </script>
@stop


@endsection