@extends('layouts.admin')
@section('title') PROCESAR DEVOLUCION @stop
@section('titulo') CREAR NOTA DE DEVOLUCION  @stop
{{--@section('libros-opcion')active  @stop--}}

@section('descripcion')
    <ol class="breadcrumb breadcrumb-arrow">
        <li class="breadcrumb-item"><a href="{{url('/')}}">Inicio</a></li>
        <li class="breadcrumb-item ">Almacenes</li>
        <li class="breadcrumb-item active"><a href="{{url('almacen/devolucion-ventas')}}">Devolucion Obras</a></li>
        <li class="breadcrumb-item active">Procesar Devolucion
        </li>

    </ol>
@stop
@section('content')


    <form style="border: 1px solid" autocomplete="off" method="post" action="{{url('almacen/devolucion-ventas/devolucion/store')}}" class="form col-lg-10">
        {!! csrf_field() !!}

        @if($devolucion->tipo_devolucion=='PARCIAL')

                <h4 class="alert alert-primary">NOTA DE REMISION</h4>
                <div class="col-md-10">
                    <table class="table table-bordered">
                        <tr>
                            <td><strong>VENDEDOR: </strong>{{$devolucion->contrato->vendedor->nombre_completo}}</td>
                            <td><strong>FECHA REMISION: </strong>{{$devolucion->fecha_remision->format('d/m/Y')}}</td>
                            <td>OBSERVACIONES <textarea class="form-control" name="remision_obs"></textarea></td>
                        </tr>
                    </table>
                </div>
                <div class="col-md-10">
                    <table class="table table-detalle">
                        <thead>
                        <tr>
                            <th>No</th>
                            <th>Cantidad</th>
                            <th>Codigo</th>
                            <th>Titulo</th>
                            <th>Tomo</th>
                            <th>Observacion</th>

                        </tr>
                        </thead>
                        <tbody>
                        @php $cont=0 @endphp

                        @foreach($devolucion->detalle->where('sw',0) as $k=>$d)
                         
                                <tr>

                                    <td>{{$cont+1}}</td>
                                    <td class=" text-center">{{$d->cantidad}}</td>
                                    <td ><strong class="td-codigo">{{$d->codigo}}</strong></td>
                                    <td>{{$d->titulo}}</td>
                                    <td>{{$d->volumen}}</td>
                                    <td>
                                        <input type="text" size="27%" name="remision_obs_detalle[]" value=""/>
                                        <input type="hidden" name="remision_detalle_cantidad[]" value="{{$d->cantidad}}">
                                        <input type="hidden" name="remision_detalle_codigo[]" value="{{$d->codigo}}">
                                        <input type="hidden" name="remision_detalle_titulo[]" value="{{$d->titulo}}">
                                        <input type="hidden" name="remision_detalle_volumen[]" value="{{$d->volumen}}">
                                        <input type="hidden" name="remision_detalle_libro_id[]" value="{{$d->libro_id}}">
                                    </td>


                                </tr>

                           
                        @endforeach



                        </tbody>
                        <tfoot>
                        <tr>
                            <th>Total</th>
                            <td><input  value="{{$devolucion->detalle->where('sw',0)->sum('cantidad')}}"   type="text" name="remision_cant_total"  size="5%" class="cant_total" readonly></td>
                        </tr>
                        </tfoot>
                    </table>
                </div>

        @endif
        <hr>
        <h4 class="alert alert-primary">NOTA DE DEVOLUCION</h4>
        <input type="hidden" name="devolucion_id" value="{{$devolucion->id}}">
        <input type="hidden" name="numcontrato" value="{{$contrato->numcontrato}}">
        <input type="hidden" name="contrato_id" value="{{$contrato->id}}">

        <div class="form-group  col-md-3">
            <label class="form-control-label" for="inputBasicFirstName">
                 <strong>FECHA  DE DEVOLUCION</strong></label>
            <div class="input-group">
                      <span class="input-group-addon">
                        <i class="icon md-calendar text-danger" aria-hidden="true"></i>
                      </span>
                    <input  name="fecha" readonly  value="{{date('d/m/Y')}}" style="font-size: 16px; font-weight: bold;"  type="text" class=" datepicker2 password-strength-example2 form-control strength-input"  >
            </div>
        </div>
        <div class="form-row">
            <div class=" form-group col-md-4">
                <label class="form-control-label"><strong>VENDEDOR</strong></label>
                <input   readonly  value="{{$vendedor->nombre_completo}}"style="font-size: 16px; font-weight: bold;" type="text" class="password-strength-example2 form-control strength-input"  >
                <input  type="hidden" name="vendedor_id" value="{{$vendedor->id}}" >

            </div>

            <div class=" form-group col-md-6">
                <label   class="form-control-label" for=""><strong>OBSERVACIONES</strong></label>
                <textarea name="obs" class="form-control" id=""  placeholder="Observacion" rows="2"></textarea>
            </div>
        </div>

        <hr>
        <div class="visible" >
            <table class="table table-detalle">
                <thead>
                <tr>
                    <th>No</th>
                    <th>Cantidad</th>
                    <th>Codigo</th>
                    <th>Titulo</th>
                    <th>Tomo</th>
                    <th>Observacion</th>

                </tr>
                </thead>
                <tbody>

                    @foreach($devolucion->detalle->where('sw',1) as $k=>$d)
                        <tr>

                            <td>{{$k+1}}</td>
                            <td class=" text-left"><input type="text" class="td-cant" name="cant[]" readonly size="5%" value="{{$d->cantidad}}"></td>
                            <td ><strong class="td-codigo">{{$d->codigo}}</strong></td>
                            <td>{{$d->titulo}}</td>
                            <td>{{$d->volumen}}</td>
                            <td><input type="text" size="27%" name="observacion[]" value="{{$d->obs}}"/><input type="hidden" name="libro_id[]" value="{{$d->libro_id}}"></td>

                        </tr>
                    @endforeach



                </tbody>
                <tfoot>
                <tr>
                    <th>Total</th>
                    <td><input  value="{{$devolucion->detalle->where('sw',1)->sum('cantidad')}}"   type="text" name="cant_total"  size="5%" class="cant_total" readonly></td>
                </tr>
                </tfoot>
            </table>



            <div class="form-group form-material">
                <button type="submit" class=" btn-guardar btn btn-block btn-primary  btn-outline ">GUARDAR</button>
                <a href="{{url('almacen/devolucion-ventas')}}" class="btn btn-block btn-default waves-effect waves-light waves-round">CANCELAR</a>
            </div>
        </div>
    </form>

@section('scripts')

    <script>




        $(document).ready(function(){




            $('.datepicker2').datepicker({
                language: 'es',
                autoclose:true,
                format:'dd/mm/yyyy',
                showOn: "button",
                clearBtn:true,

                buttonText: '<i class="fa fa-calendar"></i>',

            });


            $('.btn-guardar').click(function(_evt){
                _evt.preventDefault();
                if($('.datepicker2').val()==''){
                    swal('Alerta','Debe seleccionar una Fecha','warning')

                    return false;
                }

                  _fecha=$('.datepicker2').val()
         
         $.ajax({
             url:"{{url('common/validar-cierre')}}",
             data:{fecha:_fecha,modulo:'ALMACEN'},
             dataType:'json',
             method:'GET',
             async:false,
          

         }).done(function(res){
             if(!res){
                         swal('Alerta','No esta permitido registrar en la fecha seleccionada','warning')
                        return false;
                        
                    }      
                    else{
            

                swal({
                        title: "Guardar nota de devolucion",
                        text: "Revise que todos los campos esten llenados correctamente.",
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonClass: "btn-success",
                        confirmButtonText: "Si, Guardar!",
                        cancelButtonText:"Cancelar",
                        closeOnConfirm: false
                    },
                    function(){
                        $('.form').submit();
                    });
                      }
         }).fail(function(){
             alert('exisitio un error')
         })


            })


            $('.btn-add').click(function(){
                let titulo =$('.select3').find(":selected").attr("titulo")
                let codigo =$('.select3').find(":selected").attr("codigo")
                let tomo =$('.select3').find(":selected").attr("tomo")
                let id =$('.select3').find(":selected").val()
                let stock =$('.stock').val()
                let cantidad=$('.cantidad').val()
                if(parseInt(cantidad)<=0 || (parseInt(cantidad)>parseInt(stock))){
                    swal('Alerta','No hay suficiente stock','warning')
                    return false;

                }

                if(buscarCodigo(codigo)){
                    swal('Alerta','Este codigo ya se encuentra registrado','warning')
                    return false;
                }
                if($('.vendedor').val()=='')
                {
                    swal('Alerta','Es necesario seleccionar un vendedor','warning')

                    return false
                }
                if($('.credito').val()=='' || parseInt($('.credito').val())<=0)
                {
                    swal('Alerta','El vendedor no cuenta con suficiente stock','warning')

                    return false
                }
                let datos={
                    titulo:titulo,
                    codigo:codigo,
                    tomo:tomo,
                    id:id,
                    cantidad:cantidad
                }

                addFila(datos)
                $('.select3').select2('open');


            })





        })
    </script>
@stop


@endsection