@extends('layouts.admin')
@section('title')Nota Ingreso  @stop
@section('titulo')@if(isset($ingreso)) EDITAR @else CREAR @endif NOTA DE INGRESO  @stop
@section('menu-ingreso') active open @stop
{{--@section('libros-opcion')active  @stop--}}
@section('acciones')

@stop
@section('descripcion')
    <ol class="breadcrumb breadcrumb-arrow">
        <li class="breadcrumb-item"><a href="{{url('/')}}">Inicio</a></li>
        <li class="breadcrumb-item ">Almacen</li>
        <li class="breadcrumb-item active"><a href="{{url('notas-ingreso')}}">Nota de Ingreso</a></li>
        <li class="breadcrumb-item active">@if(isset($ingreso)) Editar @else Registrar @endif Nota de Ingreso</a></li>

    </ol>
@stop
@section('content')

    <form style="border: 1px solid" autocomplete="off" method="post" id="form" action="{{url('notas-ingreso/store')}}" class="form col-lg-10">
        {!! csrf_field() !!}
        @if(isset($ingreso))
            <input type="hidden" name="id" value="{{$ingreso->id}}">
        @endif
        <div class="form-group  col-md-3">
            <label class="form-control-label" for="inputBasicFirstName"> <strong>FECHA</strong></label>
            <div class="input-group">
                      <span class="input-group-addon">
                        <i class="icon md-calendar text-danger" aria-hidden="true"></i>
                      </span>
                <input  name="fecha" readonly style="font-size: 16px; font-weight: bold;" value="@if(isset($ingreso)) {{ $ingreso->fecha->format('d/m/Y')}} @else {{date('d/m/Y')}} @endif" type="text" class=" datepicker password-strength-example2 form-control strength-input"  >
                {{--<input type="text" class="form-control tt-input" id="exampleTypeaheadStyle" name="exampleTypeaheadStyle" placeholder="Search..." autocomplete="off" spellcheck="false" dir="auto" style="position: relative; vertical-align: top; background-color: transparent;">--}}
            </div>
        </div>
        <div class="form-row">
            <div class=" form-group col-md-3">
                <label class="form-control-label"><strong>ENVIA</strong></label>
                <input  name="envia"   value="@if(isset($ingreso)) {{ $ingreso->envia}} @endif" type="text" class="password-strengt h-example2 form-control strength-input"  >

            </div>
            <div class=" form-group col-md-4">
                <label class="form-control-label"><strong>CONCEPTO</strong></label>
                <select  name="concepto" id="" class="form-control">
                    <option @if(isset($ingreso) && $ingreso->concepto=='DEVOLUCION REGISTRO DE VENTA') selected @endif value="DEVOLUCION REGISTRO DE VENTA">DEVOLUCION REGISTRO DE VENTA</option>
                    <option @if(isset($ingreso) && $ingreso->concepto=='CAMBIO OBRA') selected @endif value="CAMBIO OBRA">CAMBIO OBRA</option>
                    <option @if(isset($ingreso) && $ingreso->concepto=='COMPRA MERCADERIA') selected @endif value="COMPRA MERCADERIA">COMPRA MERCADERIA</option>
                    <option @if(isset($ingreso) && $ingreso->concepto=='INVENTARIO INICIAL') selected @endif value="INVENTARIO INICIAL">INVENTARIO INICIAL</option>
                    <option @if(isset($ingreso) && $ingreso->concepto=='DEVOLUCION CONTRATO') selected @endif value="DEVOLUCION CONTRATO">DEVOLUCION CONTRATO</option>
                    <option @if(isset($ingreso) && $ingreso->concepto=='DONACIONES') selected @endif value="DONACIONES">DONACIONES</option>
                    <option @if(isset($ingreso) && $ingreso->concepto=='TRASPASO ALMACEN') selected @endif value="TRASPASO ALMACEN">TRASPASO ALMACEN</option>
                    <option @if(isset($ingreso) && $ingreso->concepto=='REGULARIZACION INVENTARIO') selected @endif value="REGULARIZACION INVENTARIO">REGULARIZACION INVENTARIO</option>
                    <option @if(isset($ingreso) && $ingreso->concepto=='OTROS') selected @endif value="OTROS">OTROS</option>

                </select>

            </div>
            <div class=" form-group col-md-2">
                <label   class="form-control-label" for="" style="color:brown"><strong>DOCUMENTO RESPALDO</strong></label>
                <input type="text" required name="glosa" class=" glosa form-control" id=""  placeholder="Glosa" value="@if(isset($ingreso)) {{$ingreso->glosa}} @endif" >
            </div>

            <div class=" form-group col-md-3">
                <label   class="form-control-label" for=""><strong>OBSERVACIONES</strong></label>
                <textarea name="obs" class="form-control" id=""  placeholder="Observacion" rows="2">@if(isset($ingreso)) {{$ingreso->obs}} @endif</textarea>
            </div>

        </div>

        <div class="form-row" style="border-top:1px solid">
            <div class=" form-group col-md-6 col-sm-12">
                <label class="form-control-label "><strong>CODIGO</strong></label>
                <select  id="select3" name="libro_id" class="form-control select3"  >
                    <option value="">Seleccione</option>
                    @foreach($libros as $r)
                        <option  stock="{{$r->stock}}" codigo="{{$r->codigo}}" titulo="{{$r->titulo}}" tomo="{{$r->tomo}}" precio="{{$r->precio_base}}" value="{{$r->id}}"><strong>{{$r->codigo}} - </strong>{{$r->titulo}}</option>
                    @endforeach
                </select>
            </div>

            <div class=" form-group col-md-2 col-sm-4 col-xs-4">
                <label   class="form-control-label" for=""><strong>P.UNIT</strong></label>
                <input type="number"  step="0.0001" id="precio" class="precio_unit limpiar numeroscondecimales  form-control">
            </div>

            <div class=" form-group col-md-2 col-sm-4 col-xs-4">
                <label   class="form-control-label" for=""><strong>CANTIDAD</strong></label>
                <input type="number"  id="cantidad" class="cantidad limpiar solo-enteros form-control">
            </div>
            <div class=" form-group col-md-1 col-sm-1">
                <label class="form-control-label" for="">&nbsp;</label>
                <button  type="button" class=" btn-add btn    btn-outline-success "><i class="icon md-plus"></i> Adicionar</button>
            </div>

        </div>
        <hr>
        <div class="visible table-responsive"  @if(!isset($ingreso)) style="display: none" @endif>
            <table class="table table-detalle">
                <thead>
                <tr>
                    <th>No</th>
                    <th>Cant</th>
                    <th width="15%">Codigo</th>
                    <th width="75%">Titulo</th>
                    <th>Tomo</th>
                    <th>P/Unitario</th>
                    <th>P/Total</th>
                    <th>Observacion</th>
                    <th>Acciones</th>
                </tr>
                </thead>
                <tbody>
                @if(isset($ingreso))
                    @foreach($ingreso->detalle as $k=>$d)
                        <tr>

                            <td>{{$k+1}}</td>
                         <td class=" text-left   "><input type="text" class="td-cant" name="cant[]" readonly size="5%" value="{{$d->cantidad}}"></td>
                         <td  ><strong class="td-codigo" >{{$d->codigo}}</strong></td>
                         <td>{{$d->titulo}}</td>
                         <td>{{$d->tomo}}</td>
                         <td><input type="text"  class="pu" value="{{$d->precio_unitario}}"   size="7%" name="precio_unitario[]"/></td>
                         <td><input type="text" class="td-pt" value="{{$d->precio_total}}"  readonly size="7%" name="precio_total[]"/></td>
                         <td><input type="text" size="10%" value="{{$d->obs}}" name="observacion[]"/><input type="hidden" name="libro_id[]" value="{{$d->libro_id}}"></td>
                         <td><button class="btn btn-xs btn-danger" onclick="remove(this)"><i class="icon md-close"></i></button></td>


                        </tr>
                    @endforeach

                @endif

                </tbody>
                <tfoot>
                <tr>
                    <th>Total</th>
                    <td><input  @if(isset($ingreso)) value="{{$ingreso->cant_total}}" @endif  type="text" name="cant_total"  size="5%" class="cant_total" readonly></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <th>Total</th>
                    <td><input  @if(isset($ingreso)) value="{{$ingreso->precio_total}}" @endif  type="text" name="precio_total"  size="7%" class="precio_total" readonly></td>
                    <td></td>
                    <td></td>
                </tr>
                </tfoot>
            </table>



            <div class="form-group form-material">
                <button type="submit" class=" btn-guardar btn btn-block btn-primary  btn-outline ">GUARDAR</button>
                <a href="{{url('notas-ingreso')}}" class="btn btn-block btn-default waves-effect waves-light waves-round">CANCELAR</a>
            </div>
        </div>
    </form>

@section('scripts')

    <script>
        var codigos=[]

        function buscarCodigo(codigo){
            var sw=false;
            if(codigos.indexOf(codigo)!=-1)
                sw=true;
            return sw;
        }

        function numerosTabla(){
            var cant=0;
            var pt=0;
            $('.table-detalle tbody tr').each(function(k,v){

                $(v).find('td:first').html(k+1)
                cant+=parseInt($(v).find('.td-cant').val())
                pt+=parseFloat($(v).find('.td-pt').val())

            });


            return {
                cant:cant,
                pt:pt
            }
        }

        function limpiar(){
            $('.limpiar').val('')
            $('#select3').val('').trigger('change');
            $('#select3').focus()



        }

        function addFila(datos){
            var fila='<tr>';
            fila+='<td></td>'+
                '<td class=" text-left   "><input type="text" class="td-cant" name="cant[]" readonly size="5%" value="'+datos.cantidad+'"></td>'+
                '<td  ><strong class="td-codigo" ">'+datos.codigo+'</strong></td>'+
                '<td>'+datos.titulo+'</td>'+
                '<td>'+datos.tomo+'</td>'+
                 '<td><input type="text" class="pu" value="'+datos.precio+'"   size="7%" name="precio_unitario[]"/></td>'+
                 '<td><input type="text" class="td-pt" value="'+datos.precio_total+'"  readonly size="7%" name="precio_total_detalle[]"/></td>'+
                 '<td><input type="text" size="10%" name="observacion[]"/><input type="hidden" name="libro_id[]" value="'+datos.id+'"></td>'+
                '<td><button class="btn btn-xs btn-danger" onclick="remove(this)"><i class="icon md-close"></i></button></td>'+
                '</tr>';

            $('.table-detalle tbody').append(fila)
            codigos.push(datos.codigo)


            limpiar();
            $('.visible').show()
            $('.cant_total').val(numerosTabla().cant)

            $('.precio_total').val(numerosTabla().pt)


        }


        function remove(btn)
        {
            limpiar();
            let codigo=$(btn).closest('tr').find('.td-codigo').html()
            let cant=$(btn).closest('tr').find('.td-cant').val()
            $(btn).closest('tr').remove()
            _cantfilas=$('.table-detalle tbody tr').length;
            if(_cantfilas<=0){
                $('.visible').hide();
            }


            $('.cant_total').val(numerosTabla().cant)
            $('.precio_total').val(numerosTabla().pt)
            borrarArray(codigo)

        }

        function borrarArray(valor){
            var index = codigos.indexOf(valor);
            if (index > -1) {
                codigos.splice(index, 1);
                return true;
            }
            return false;

        }

        $(document).ready(function(){

            $('body .table-detalle').on('change','.pu',function(){
                let cantidad=$(this).closest('tr').find('.td-cant').val()
                let pt=$(this).closest('tr').find('.td-pt')
                let pu=$(this).val()
                let aux=(parseInt(cantidad)*parseFloat(pu))
                pt.val(aux.toFixed(2))
                let sum=0;
                $('body .table-detalle tbody>tr').each(function(k,v){
                    let aux2=$(v).find('.td-pt').val()
                    sum+=parseFloat(aux2)

                })
                $('.precio_total').val(sum.toFixed(2))

            })

            @if(isset($ingreso))
            $('.table-detalle tbody tr').each(function(k,v){

                let codigo=$(v).find('.td-codigo').html()
                codigos.push(codigo)
            });
            @endif

            $('.select3').on('select2:selecting', function(e) {
                let pu =e.params.args.data.element.attributes.precio.value;


                if(parseInt(pu)<=0 || pu=='' || typeof(pu)=='undefined'){
                    $('.precio_unit').val(0)
                }
                else{
                    $('.precio_unit').val(pu)
                }
            });

            $('.select3').on('select2:select', function(e) {

                $('#cantidad').focus();

            });

            $('.btn-guardar').click(function(_evt){
                _evt.preventDefault();
                if($('.datepicker').val()==''){
                    swal('Alerta','Debe seleccionar una Fecha','warning');

                    return false;
                }
                if($('.glosa').val()==''){
                    swal('Alerta','Debe completar el campo glosa','warning');

                    return false;
                }


                 _fecha=$('.datepicker').val()
         
         $.ajax({
             url:"{{url('common/validar-cierre')}}",
             data:{fecha:_fecha,modulo:'ALMACEN'},
             dataType:'json',
             method:'GET',
             async:false,
          

         }).done(function(res){
             if(!res){
                         swal('Alerta','No esta permitido registrar en la fecha seleccionada','warning')
                        return false;
                        
                    }      
                    else{

                swal({
                        title: "Guardar nota de ingreso",
                        text: "Revise que todos los campos esten llenados correctamente.",
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonClass: "btn-success",
                        confirmButtonText: "Si, Guardar!",
                        cancelButtonText:"Cancelar",
                        closeOnConfirm: false
                    },
                    function(){
                        $('#form').submit();
                    });
                    }
                     }).fail(function(){
             alert('exisitio un error')
         })


            })

            $("#cantidad").keypress(function (e) {
                if(e.which == 13) {
                    $(".btn-add").trigger("click");
                }
            });
            $('.btn-add').click(function(){
                let titulo =$('.select3').find(":selected").attr("titulo")
                let codigo =$('.select3').find(":selected").attr("codigo")
                let tomo =$('.select3').find(":selected").attr("tomo")
                let precio=$('.precio_unit').val()
                let id =$('.select3').find(":selected").val()
                let cantidad=$('.cantidad').val()


                if(buscarCodigo(codigo)){
                    swal('Alerta','Este codigo ya se encuentra registrado','warning')
                    return false;
                }
                if(cantidad=='' || parseInt(cantidad)<=0){
                    swal('Alerta','Ingrese una cantidad valida','warning')
                    return false;
                }
                if(precio=='' || parseInt(cantidad)<=0){
                    swal('Alerta','Ingrese un precio valido','warning')
                    return false;
                }
                var precio_total=(parseInt(cantidad)*parseFloat(precio)).toFixed(2);

                let datos={
                    titulo:titulo,
                    codigo:codigo,
                    tomo:tomo,
                    id:id,
                    cantidad:cantidad,
                    precio:precio,
                    precio_total:precio_total
                }

                addFila(datos)
                $('.select3').select2('open');


            })

            $('.select3').select2({
                placeholder: 'Seleccione una opcion',
                multiple:false,
                width:'90%'
            });

        })
    </script>
@stop


@endsection