@extends('layouts.admin')
@section('title')kardex Vendedor @stop
@section('titulo')KAREX  DEL VENDEDOR @stop
@section('menu-kardex')active open @stop

{{--@section('libros-opcion')active  @stop--}}
@section('acciones')
{{--    <a href="{{url('notas-remision/create')}}" class=" btn-create btn btn-primary waves-effect waves-light waves-round"  type="button"> <i class="icon md-plus"></i>Nueva Remision</a>--}}


@stop
@section('descripcion')
    <ol class="breadcrumb breadcrumb-arrow">
        <li class="breadcrumb-item"><a href="{{url('/')}}">Inicio</a></li>
        <li class="breadcrumb-item ">Almacenes</li>
        <li class="breadcrumb-item active"><a href="{{url('/kardex')}}">Kardex Vendedor</a></li>
    </ol>
@stop
@section('content')

    <div class="nav navbar-nav col-md-6">
        <form class="form-inline " method="get" action="{{url('kardex')}}" >
            @include('includes.form-periodo')

            <div class="form-group">
                {{--<label for="" class="control-label">Vendedor</label>--}}
                <select name="vendedor" id="vendedor"   size="50%" class=" select2 form-control">
                    <option value="">Seleccione Vendedor</option>
                    @foreach($vendedores as $v)
                        <option @if($vendedor==$v->id) selected @endif value="{{$v->id}}">{{$v->nombre_completo}}</option>
                    @endforeach
                </select>
            </div>
            <div class="form-group form-material">
                <button type="submit" class="btn btn-outline-info waves-effect waves-light waves-round"> <i class="icon md-search"></i>Consultar</button>
            </div>
        </form>

    </div>
    @if(count($datos)>0)
    <div class="btn-group col-md-4" role="group" >
        {{-- <a href="{{url('kardex/exportar/excel/'.$mes.'/'.$anio.'/'.$vendedor.'')}}" class="btn btn-outline-success">EXCEL</a> --}}
        {{-- <a href="{{url('kardex/exportar/pdf/'.$mes.'/'.$anio.'/'.$vendedor.'')}}" class="btn btn-outline-danger">PDF</a> --}}
        {{--<button type="button" class="btn btn-outline-info">IMPRIMIR</button><div class="btn-group" role="group">--}}
            <button id="btnGroupDrop1" type="button" class="  btn btn-outline-primary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                <i class="icon md-wrench"></i>Acciones
            </button>
            <div class="dropdown-menu" aria-labelledby="btnGroupDrop1">
                @if($pasarcargos )
                <a class=" btn-pasar dropdown-item btn-warning" href="{{url('kardex/pasar-cargos/'.$mes.'/'.$anio.'/'.$vendedor.'')}}" ><i class="icon md-arrow-right"></i>Pasar cargos al siguiente mes</a>
                @endif
                <a class=" btn-resumen dropdown-item  btn-info" href="#"   onclick="resumen({{$mes}},{{$anio}},{{$vendedor}})"><i class="icon md-file"></i>Resumen cargos</a>
            </div>
        </div>

    </div>
    @endif


    <div class="table-responsive">
        @if(!is_null($datos) && count($datos)>0)

        @if(!$pasarcargos)
			
        <h4  class="alert alert-warning">YA SE PASARON LOS CARGOS A {{\App\Helper\Helper::mes($mes+1)}}</h4>
        @endif
            <hr>

        @include('almacen.kardex.tabla-kardex')
            @else
            <h4 class="text text-primary text-center">NO SE ENCONTRARON REGISTROS.</h4>

        @endif
    </div>
    <div class="modal-ver modal fade modal-slide-in-right" tabindex="-1" style="z-index:99999 !important;"  role="dialog" aria-labelledby="myModalLabel" data-backdrop="false" style="background-color: rgba(0, 0, 0, 0.5);">
        <div class="modal-dialog" role="document">
        <div class="modal-dialog modal-simple">
            <div class="modal-content">
                             <div class="modal-body">

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" data-dismiss="modal">Cerrar</button>
                </div>
            </div>
        </div>
    </div>



@section('scripts')


    <script src="{{asset('assets/js/jquery.PrintArea.js')}}" type="text/javascript"></script>
    
<script src="{{asset('assets/librerias/datatables-buttons/dataTables.buttons.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('assets/librerias/datatables-buttons/buttons.flash.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('assets/librerias/datatables-buttons/jszip.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('assets/librerias/datatables-buttons/pdfmake.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('assets/librerias/datatables-buttons/vfs_fonts.js')}}" type="text/javascript"></script>
    <script src="{{asset('assets/librerias/datatables-buttons/buttons.html5.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('assets/librerias/datatables-buttons/buttons.print.min.js')}}" type="text/javascript"></script>
    

    <script>

        function imprimir(){
            var options = { mode : "iframe", popClose : close,  retainAttr : ['class','style','id'] };

            $('#nota').printArea(options);
        }
function resumen(mes , anio, vendedor){

    $.ajax({
    url:'./kardex/resumen/',
    type:'GET',
        dataType:'html',
    data:{id:vendedor,mes:mes,anio:anio}


    }).then(function(res){
        $('.modal-ver').find('.modal-body').empty();
        $('.modal-ver').find('.modal-body').html(res)
        $('.modal-ver').modal('show')
    })
}

        $(document).ready(function(){


              // DataTable
            var table = $('.table-kardex').DataTable({
                 dom: 'Bfrtip',
       buttons: [
           {
   extend: 'pdfHtml5',
    orientation: 'landscape',
   pageSize: 'A4',
         title: 'kardex-{{$nombre_vendedor}} ' + "{{\App\Helper\Helper::mes($mes)}}"+"-"+"{{$anio}}",
   customize: function(doc) {

     doc.styles.title = {
       color: 'black',
       fontSize: '9',
      alignment: 'center'
     }
     doc.styles.tableHeader = {
       color: '#333',
        fontSize: '6',      
       
       alignment: 'center'
     },
      doc.styles.tableBodyEven = {
      fontSize: '6',
     }
     doc.styles.tableBodyOdd = {
     fontSize: '6',
     }
    doc.styles.tableFooter = {
       fontSize: '6',
     }
     
    
    doc.styles['td:nth-child(2)'] = { 
       width: '100px',
       'max-width': '100px'
     }
   } 

 },
 {
      extend: 'excel',
         title: 'kardex-{{$nombre_vendedor}} ' + "{{\App\Helper\Helper::mes($mes)}}"+"-"+"{{$anio}}",

 },
 
 
 ],
                "lengthMenu": [ [50, 100, 300, 500, -1], [50, 100, 300, 500, "Todos"] ],
                'iDisplayLength': -1,
                "aaSorting": []
            });



            $('.remision_id').click(function(){
                let url='./notas-remision/'+$(this).html()+'/ver'
                $.ajax({
                    url:url,
                    method:'GET',
                    dataType:'HTML',
                    async:false,
                    cache:false,
                    success:function(res)
                    {

                        $('.modal-ver').find('.modal-body').empty();
                        $('.modal-ver').find('.modal-body').html(res)
                        $('.modal-ver').modal('show')

                    }
                })
            })
            $('.devolucion_id').click(function(){

                let id=$(this).html()
                let url='./notas-devolucion/'+id+'/ver'
                $.ajax({
                    url:url,
                    method:'GET',
                    dataType:'html',
                    success:function(res)
                    {
                        $('.modal-ver').find('.modal-body').empty();
                        $('.modal-ver').find('.modal-body').html(res)
                        $('.modal-ver').modal('show')
                    }
                })

            })
              $('.contrato_id').click(function(){

                let id=$(this).html()
             
                let url='./common/contratos/'+id+'/ver'
                $.ajax({
                    url:url,
                    method:'GET',
                    dataType:'html',
                    success:function(res)
                    {
                        $('.modal-ver').find('.modal-body').empty();
                        $('.modal-ver').find('.modal-body').html(res)
                        $('.modal-ver').modal('show')
                    }
                })

            })

            $('.select2').select2({
                placeholder: 'Seleccione un Vendedor',
                multiple:false,

                // width:'100%'
            });

            $('.btn-pasar').click(function (_evt) {
                _evt.preventDefault();
                var _href=$(this).attr('href')
                swal({
                        title: "Esta seguro?",
                        text: "Se pasaran todos los libros remitidos como cargos al siguiente mes.",
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonClass: "btn-warning",
                        confirmButtonText: "Si, Procesar!",
                        cancelButtonText:"Cancelar",
                        closeOnConfirm: false
                    },
                    function() {
                        window.location=_href

                    });

            })



           
            });




    </script>
@stop


@endsection