<style type="text/css">
    table {
        border-collapse: collapse;
        border: 0.5px solid #afafaf;
        font: normal 11px verdana, arial, helvetica, sans-serif;
        color: #363636;
        background: #FFF;
        text-align: left;
    }
    caption {
        text-align: center;
        font: bold 16px arial, helvetica, sans-serif;
        background: transparent;
        padding: 6px 4px 8px 0px;
        color: #CC00FF;
        text-transform: uppercase;
    }
    thead,
    tfoot {
        background: url(bg1.png) repeat-x;
        text-align: left;
        height: 30px;
    }
    thead th,
    tfoot th {
        padding: 5px;
    }
    table a {
        color: #333333;
        text-decoration: none;
    }
    table a:hover {
        text-decoration: underline;
    }
    table tr {
        /*border: 0.5px solid #afafaf;*/
    }
    tr.odd {
        background: #f1f1f1;
    }
    tbody th,
    tbody td {
        padding: 5px;
    }
    .negrita {
        font-weight: bold;
    }
    .titulo {
        font-size: 18px;
        font-weight: bold;
        text-decoration: underline;
    }
</style>
<style media="print">
    @page {
        size: auto;
        margin: 0;
    }
</style>
<div class="acciones">
    <button onclick="imprimir()" class="btn btn-outline-primary btn-xs "><i class="icon md-print"></i>IMPRIME</button>
</div>
<div id="nota" class="table-responsive" style="width:100%; margin:auto 0;">
    @if($ingreso->estado=="ANULADO")
    <img src="{{asset('/public/images/anulado.png')}}" alt="" width="60%" style="position:absolute; top:10%; left:5%; z-index:0">
    @endif
    <table id="exportar" border="0" style="font-family:calibri; font-size:10px;">
        <tr>
            <td>
                <div class="d-flex justify-content-between">
                    @php
                    $logo=\DB::table('config')->first()->logo;
                    @endphp
                    <img class="navbar-brand-logo navbar-brand-logo-normal" src="{{asset('assets/images/')}}/{{$logo}} " title="">
                    <p style=" font-size:18px; font-family:calibri; font-weight:bold; text-decoration:underline;">NOTA DE INGRESO</p>
                    <span style="font-size:18px; font-weight:bold;">N&ordm;:{{sprintf('%06d', $ingreso->id)}}</span>
                </div>
                <table width="100%" border="0" align="center" style="font-family:calibri; font-size:10px; ">
                    <tr>
                        <td><span class="negrita">RECIBE</span> : {{$ingreso->recibe}} </td>
                        <td align="right" width="50%" align="left"><span class="negrita">ENVIA:</span> {{$ingreso->envia}}</td>
                    </tr>
                    <tr>
                        <td><span class="negrita">FECHA :</span> {{$ingreso->fecha->format('d/m/Y')}}</td>
                        <td align="right"><span class="negrita">CONCEPTO:</span>{{$ingreso->concepto}}</td>
                    </tr>
                    <tr>
                        <td><span class="negrita">GLOSA :</span> {{$ingreso->glosa}}</td>
                        <td align="right" class="negrita">
                            @if(isset($contrato) && !empty($contrato))
                            <span class="negrita">CONTRATO/CODCLI:</span> {{$contrato->numcontrato}}/{{$contrato->credito->numcuenta}} CLIENTE:{{$contrato->nombre_completo}}
                            @endif
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td>
                <table width="100%" border="1" style="font-family:calibri; font-size:10px;" cellspacing="0" cellpadding="0">
                    <thead>
                        <tr style="font-weight: bolder">
                            <td align="center" width="33" class="negrita">N</td>
                            <td style=" background-color:#EFEFEF;" align="center" width="35" class="negrita">CODIGO</td>
                            <td align="center" width="47" class="negrita">CANTIDAD</td>
                            <td align="center" width="347" class="negrita">TITULO</td>
                            <td align="center" width="25" class="negrita">VOL</td>
                            <td width="56" align="center" class="negrita">P.UNITARIO</td>
                            <td width="61" align="center" class="negrita">P.TOTAL</td>
                            <td width="61" align="center" class="negrita">OBS</td>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($ingreso->detalle as $k=>$v)
                        <tr align="center" class="detalle">
                            <td>{{$k+1}}</td>
                            <td style="background-color:#EFEFEF;">{{$v->codigo}}</td>
                            <td align="center" style="padding-right: 3px">{{$v->cantidad}}</td>
                            <td align="left" style="padding-left: 3px">{{$v->titulo}}</td>
                            <td style="padding-right: 3px">{{$v->volumen}}</td>
                            <td align="center" style="padding-right: 3px">{{number_format($v->precio_unitario,2,',','.')}}</td>
                            <td align="center" style="padding-right: 3px">{{number_format($v->precio_total,2,',','.')}}</td>
                            <td>{{$v->obs}}</td>
                        </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr align="center" class="detalle">
                            <td style="font-weight:bold; padding-right: 3px; background-color:#EFEFEF;" align="right" colspan="2" class="negrita">TOTAL</td>
                            <td style="padding-right: 3px; font-weight:bold; background-color:#EFEFEF;" align="center"><span class="negrita">{{$ingreso->detalle()->sum('cantidad')}}</span></td>
                            <td>&nbsp;</td>
                            <td>&nbsp;</td>
                            <td></td>
                            <td class="negrita" style=" padding-right:3px;font-weight:bold; background-color:#EFEFEF;" align="center">{{ number_format($ingreso["precio_total"], 2,',','.') }}</td>
                        </tr>
                    </tfoot>
                </table>
            </td>
        </tr>
        <tr>
            <td>
                <table width="100%" border="0">
                    <tr>
                        <td>
                            <p style="margin:auto 0; text-align:left; font-size:9px;">Usuario:{{$ingreso->user->name}}</p>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="3" align="center">
                            <div style=" width:260px; float:left;">
                                <p style="margin:auto 0; text-align:left;margin-left:15px; ">&nbsp;</p>
                                <p style="margin:auto 0; text-align:left;margin-left:15px; ">&nbsp;</p>
                                <p style="margin:auto 0; text-align:left;margin-left:15px; ">&nbsp;</p>
                                <p style="margin:auto 0; text-align:center;margin-left:15px; ">--------------------------------------</p>
                                <p style="margin:auto 0; text-align:center
;  font-size:10px;">RECIBI CONFORME</br>
                                    </br>ENCARGADO DE ALMACEN</p>
                            </div>
                        </td>
                        <td>
                            <div style=" width:260px; float:right;">
                                <p style="margin:auto 0; text-align:left;margin-left:15px; ">&nbsp;</p>
                                <p style="margin:auto 0; text-align:left;margin-left:15px; ">&nbsp;</p>
                                <p style="margin:auto 0; text-align:left;margin-left:15px; ">&nbsp;</p>
                                <p style="margin:auto 0; text-align:left;margin-left:15px; ">----------------------------------------</p>
                                <p style="margin:auto 0; text-align:center
;  font-size:10px;">ENTREGUE CONFORME</p>
                                <p style="margin:auto 0; text-align:center; font-size:10px;">&nbsp;</p>
                                <p style="margin:auto 0; text-align:center;">&nbsp;</p>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="5">
                            <p style="font-family:calibri; font-size:10px;"><b>obs:</b>{{$ingreso->obs}}</p>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
</div>