@extends('layouts.master')
@section ('styles')
    <link rel="stylesheet" href="{{asset('assets/css/login-v3.min.css')}}">
@stop
@section('class_body')
    animsition page-login-v3 layout-full
@stop

@section('body')
    <div class="page vertical-align text-center" data-animsition-in="fade-in" data-animsition-out="fade-out">>
        <div class="page-content vertical-align-middle">
            <div class="panel">
                <div class="panel-body">
                    <div class="brand">
                    @include('includes.logo',['width'=>150])

                        <br>
                        <h2 class="brand-text font-size-18">CREDENCIALES</h2>
                    </div>
                    <form class="form-horizontal" method="POST" action="{{ route('login') }}">
                        {{ csrf_field() }}
                        <div class="form-group{{ $errors->has('email') ? ' has-error' : '' }}">

                        <div class="form-group form-material floating" data-plugin="formMaterial">
                            <input type="email" class="form-control" name="email" />
                            <label class="floating-label">Email</label>
                            @if ($errors->has('email'))
                                <span class="help-block">
                                        <strong>{{ $errors->first('email') }}</strong>
                                    </span>
                            @endif
                        </div>
                        </div>
                        <div class="form-group{{ $errors->has('password') ? ' has-error' : '' }}">

                        <div class="form-group form-material floating" data-plugin="formMaterial">
                            <input type="password" class="form-control" name="password" />
                            <label class="floating-label">Contraseña</label>
                            @if ($errors->has('password'))
                                <span class="help-block">
                                        <strong>{{ $errors->first('password') }}</strong>
                                    </span>
                            @endif
                        </div>
                        </div>
                        <div class="form-group clearfix">
                            <div class="checkbox-custom checkbox-inline checkbox-primary checkbox-lg float-left">
                                <input type="checkbox" id="inputCheckbox" name="remember">
                                <label for="inputCheckbox">Recuerdame</label>
                            </div>
                            {{--<a class="float-right" href="forgot-password.html">Forgot password?</a>--}}
                        </div>
                        <button type="submit" class="btn btn-primary btn-block btn-lg mt-40">Ingresar</button>
                    </form>
                </div>
            </div>

            <footer class="page-copyright page-copyright-inverse">
                <p>Aplicacion creada por Ing Elver H. Vasquez</p>
                <p>vasquezelver@gmail.com</p>
                <p>© 2018. All RIGHT RESERVED.</p>
  
            </footer>
        </div>
    </div>

@stop



