@extends('layouts.admin')
@section('title') Central riego @stop
@section('titulo') CENTRAL DE RIESGO @stop
@section('acciones')

<div class="d-flex">

    <button class=" btn-create btn btn-outline-primary waves-effect waves-light waves-round" type="button"> <i
            class="icon md-plus"></i>Nuevo Registro</button>
    <a href="{{url('central-riesgos/mantenimiento')}}" class=" btn btn-primary waves-effect waves-light waves-round"
        type="button"> <i class="icon md-account"></i>Mantenimiento</a>
</div>
@stop
@section('descripcion')
<ol class="breadcrumb breadcrumb-arrow">
    <li class="breadcrumb-item"><a href="{{url('/')}}">Inicio</a></li>
    <li class="breadcrumb-item active">Central de Riesgo</li>
</ol>

@stop
@section('content')
{{--modal--}}
<div class=" float-right d-flex" style="font-size:11px">
    <a href="{{asset('plantilla_deudas.xlsx')}}" download class="btn btn-success mr-2"><i
            class="fa fa-download"></i>Descargar pantilla</a>
    <form class="bg-primary form-inline" enctype="multipart/form-data" method="POST"
        action="{{url('central-riesgos/importar')}}">
        <input type="hidden" name="_token" value="{{ csrf_token() }}">
        <div class="form-group">
            <label for="exampleFormControlFile1" class="text-light">Seleccione archivo excel</label>
            <input name="file" type="file" class="form-control-file" id="exampleFormControlFile1">
            <button class="btn btn-primary">Importar</button>
        </div>
    </form>
</div>
@include('central_riesgo.create_edit')
<div class="modales">
</div>

<div style="font-size: 11px" class=" col-lg-12 table-responsive">

    <table id="table" class="data-table table table-hover  table-striped ">
        <thead>
            <tr>
                <th>NUM</th>
                <th>NUM <br> CI</th>
                <th>EXP</th>
                <th>NUM<BR>CONTRATO</th>
                <th>CUENTA</th>
                <th>NOMBRES</th>
                <th>APELLIDOS</th>
                <th>APELLIDO <BR>CASADO</th>
                <th>MONTO <BR> ORIGINAL</th>
                <th>MONTO <BR> DEUDA</th>

                <th>MORA DESDE</th>
                <th>OBSERVACIONES</th>
                <th>ESTADO</th>
                <th>ACCIONES</th>
                {{-- <th>RAZON SOCIAL</th> --}}
                {{-- <th>CONCEPTO</th> --}}
                {{-- <th>TIPO <BR>DOCUMENTO</th> --}}
                {{-- <th>SALDO<BR>DEUDA <BR>VENCIDA</th> --}}
                {{-- <th>TIPO <BR> DOCUMENTO</th> --}}

            </tr>
        </thead>
        <tbody>
            @foreach($deudores as $f=>$r)
            <tr>
                <td>{{$f+1}}</td>
                {{-- <td>{{$r->tipo_documento}}</td> --}}
                <td>{{$r->num_documento}}</td>
                <td>{{$r->lugar_doc}}</td>
                <td>{{$r->num_doc_deuda}}</td>
                <td>{{$r->tipo_operacion}}</td>
                {{-- <td>{{$r->razon_social}}</td> --}}
                <td>{{$r->nombres}}</td>
                <td>{{$r->apellidos}}</td>
                <td>{{$r->ape_casado}}</td>
                <td>{{$r->monto_original_deuda}}</td>
                <td>{{$r->saldo_deuda_vigente}}</td>
                <td>{{$r->fecha_ingreso_vencida}}</td>
                <td>{{$r->obs}}</td>
                {{-- <td>{{$r->tipo_doc_deuda}}</td> --}}
                {{-- <td>{{$r->saldo_deuda_vencida}}</td> --}}
                {{-- <td>{{$r->cobrador}}</td> --}}
                <TD>
                    @if($r->estado=="T")
                    <span class="badge badge-success">DEUDA PAGADA</span>
                    @endif
                </TD>
                <td>
                    @if($r->estado!="T")
                    <button type="button" onclick="editar({{$r->id}})"
                        class=" btn btn-sm btn-icon btn-pure btn-warning on-default edit-row waves-effect waves-light waves-round"
                        data-toggle="tooltip" data-original-title="Editar"><i class="icon md-edit"
                            aria-hidden="true"></i></button>
                    <a href="central-riesgos/{{$r->id}}/delete"
                        class="btn-delete btn btn-sm btn-icon btn-pure btn-danger on-default remove-row waves-effect waves-light waves-round"
                        data-toggle="tooltip" data-original-title="Eliminar"><i class="icon md-delete"
                            aria-hidden="true"></i></a>
                    @endif
                </td>

            </tr>
            @endforeach
        </tbody>
    </table>
</div>

@section('scripts')

<script>
    function editar(id)
        {
            $.ajax({
                url:'./central-riesgos/'+id+'/edit',
                method:'GET',
                dataType:'html',
                success:function(res){
                    $('.modales').empty();
                    $('.modales').append(res)
                    $('.modal-edit').modal('show')

                },
                error:function(){
                    alert('ocurrio un error')
                }
            })

        }


        $(document).ready(function(){



            var select2=function(){


                $('body .select2').select2({
                    placeholder: 'Seleccione una opcion',
                    multiple:false,
                    width:'90%'
                });

            }


            $('.btn-delete').click(function(_evt){
                _evt.preventDefault();

                var _href=$(this).prop('href')

                swal({
                        title: "Esta seguro?",
                        text: "Se eliminara el registro!",
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonClass: "btn-danger",
                        confirmButtonText: "Si, Eliminar!",
                        cancelButtonText:"Cancelar",
                        closeOnConfirm: false
                    },
                    function(){
                        window.location=_href
                    });

            })





            $('.btn-create').click(function(){
                $('.modal-create').modal('show')
                select2()
            })


        })


</script>
@stop


@endsection