@extends('layouts.admin')
@section('title') CAMBIO OBRAS @stop
@section('titulo')  CAMBIO OBRAS  COBRANZA @stop

{{--@section('libros-opcion')active  @stop--}}
@section('acciones')
    <a href="{{url('cambio-obras/create')}}"  class=" btn btn-primary waves-effect waves-light waves-round"  type="button"> <i class="icon md-plus"></i>Registrar Cambio Obra</a>


@stop
@section('descripcion')
    <ol class="breadcrumb breadcrumb-arrow">
        <li class="breadcrumb-item"><a href="{{url('/')}}">Inicio</a></li>
        <li class="breadcrumb-item ">Cobranza</li>
        <li class="breadcrumb-item active"><a href="{{url('/cambio-obra')}}">Cambio de Obras</a></li>
    </ol>
@stop
@section('content')
    @include('includes.modal-ver')

    <div class="col-md-12 nav navbar-nav ">
        <form class="row col-md-12  " method="get" action="{{url('cambio-obras')}}" >


            <div class=" col-md-2 form-group ">

                <select name="tipo" id=""  class=" tipo-filtro form-control">
                    <option value="">Seleccione Filtro</option>
                    <option @if(isset($tipo) && $tipo=='mes') selected @endif value="mes">FILTRO POR MES</option>
                    <option @if(isset($tipo) && $tipo=='rango') selected @endif value="rango">FILTRO POR RANGO DE FECHAS</option>
                    <option @if(isset($tipo) && $tipo=='acumulado') selected @endif value="acumulado">FILTRO ACUMULADO</option>
                </select>
            </div>

            <div class="filtro-mes col-md-3" @if(isset($tipo) && $tipo=='mes') style="display:block" @else style="display: none" @endif>
                <div class="input-group ">
                    {{--<span class="icon md-calendar"></span></label>--}}
                    <select name="mes"  class="form-control" id="mes">
                        <option value="1"  @if(isset($mes) && $mes==1) selected @endif>ENERO</option>
                        <option value="2"  @if(isset($mes) && $mes==2) selected @endif>FEBRERO</option>
                        <option value="3"  @if(isset($mes) && $mes==3) selected @endif>MARZO</option>
                        <option value="4"  @if(isset($mes) && $mes==4) selected @endif>ABRIL</option>
                        <option value="5"  @if(isset($mes) && $mes==5) selected @endif>MAYO</option>
                        <option value="6"  @if(isset($mes) && $mes==6) selected @endif>JUNIO</option>
                        <option value="7"  @if(isset($mes) && $mes==7) selected @endif>JULIO</option>
                        <option value="8"  @if(isset($mes) && $mes==8) selected @endif>AGOSTO</option>
                        <option value="9"  @if(isset($mes) && $mes==9) selected @endif>SEPTIEMBRE</option>
                        <option value="10"  @if(isset($mes) && $mes==10) selected @endif>OCTUBRE</option>
                        <option value="11"  @if(isset($mes) && $mes==11) selected @endif>NOVIEMBRE</option>
                        <option value="12"  @if(isset($mes) && $mes==12) selected @endif>DICIEMBRE</option>
                    </select>
                    <label class="input-group-addon bg-info"for="date">
                        <span class="">De</span></label>
                    <select name="anio" id="anio" class="form-control">
                        @for($i=2016; $i<=2030; $i++)
                            <option value="{{$i}}" @if(isset($anio) && $anio==$i) selected @endif>{{$i}}</option>
                        @endfor
                    </select>
                </div>
                {{--            @include('includes.form-periodo')--}}
            </div>
            <div class="  filtro-rango" @if(isset($tipo) && $tipo=='rango') style="display:block" @else style="display: none" @endif>
                <div class="input-group ">
                    {{--<span class="icon md-calendar"></span></label>--}}
                    <input @if(isset($fecha_ini) ) value="{{$fecha_ini->format('d/m/Y')}}" @endif readonly name="fecha_ini" type="text" class="datepicker input-group-addon form-control">
                    <label class="input-group-addon bg-info" for="date">
                        <span class="">hasta</span></label>
                    <input @if(isset($fecha_fin) )value="{{$fecha_fin->format('d/m/Y')}}" @endif readonly name="fecha_fin" type="text" class="datepicker input-group-addon form-control">
                </div>

            </div>
            <div class="filtro-acumulado" @if(isset($tipo) && $tipo=='acumulado') style="display:block" @else style="display: none" @endif>
                <div class="form-group">

                    <input type="text" readonly name="fecha_acumulado" value="{{$fecha_acumulado->format('d/m/Y')}}" class="form-control datepicker" >
                </div>

            </div>



            <div class="form-group form-material">
                <button type="submit" name="buscar" value="buscar" class="btn btn-outline-info waves-effect waves-light waves-round"> <i class="icon md-search"></i>Consultar</button>
            </div>
        </form>
    </div>

    <div class="table-responsive">

        @if(count($datos)>0)

            <table  id="table"  class=" data-table table table-hover  table-striped  table-condensed table-inverse" >
                <thead>
                <tr>
                    <th>ID</th>
                    <th>FECHA  </th>
                    <th>NUMERO <BR>CAMBIO OBRA</th>
                    <th>FECHA <BR> DE VENTA </th>
                    <th>NUMERO <BR>CUENTA </th>
                   
                    <th>CLIENTE</th>
                    <th>VENDEDOR</th>
                    <th>COBRADOR</th>
                    <th>N° INGRESO</th>
                    <th>N° EGRESO</th>

                    <th>ESTADO</th>
                    <th>ACCIONES</th>
                </tr>
                </thead>
                <tbody>
                @foreach($datos as $f=>$r)
                    <tr>

                        <td  width="1%">{{$r->id}}</td>
                        <td width="4%">{{$r->fecha->format('d/m/Y')}}</td>
                        <td width="4%">{{$r->id}}</td>
                        <td width="4%">{{$r->credito->fechadoc->format('d/m/Y')}}</td>
                        <td width="4%">{{$r->credito->numcuenta}}</td>
                        <td width="20%">{{$r->credito->nombre_cliente}}</td>
                        <td width="20%">{{$r->credito->vendedor_nombre}}</td>
                        <td width="20%">{{$r->credito->cobrador->nombre_completo}}</td>
                         <td width="10%">{{$r->numingreso}}</td>
                        <td width="10%">{{$r->numegreso}}</td>
                        <td>{{$r->estado}}</td>

                        <td width="20%">
                            <div class="btn-toolbar" role="toolbar">


                                <a href="cambio-obras/{{$r->id}}/ver" class="btn-ver-nota btn btn-icon btn-pure btn-default on-default remove-row waves-effect waves-light waves-round" data-toggle="tooltip" data-original-title="Ver nota "><i class="icon md-open-in-new" aria-hidden="true"></i></a>
                                @if($r->estado=='ALMACEN')
                                    <a href="devolucion-cobranza/{{$r->id}}/delete" id="{{$r->id}}"  class="btn-delete btn  btn-icon btn-pure btn-danger on-default remove-row waves-effect waves-light waves-round" data-toggle="tooltip" data-original-title="Eliminar"><i class="icon md-delete" aria-hidden="true"></i></a>

                                @endif
                            </div>


                            {{--<a href="notas-ingreso/{{$r->id}}/procesar" class="btn-procesar btn btn-icon btn-pure btn-default on-default remove-row waves-effect waves-light waves-round" data-toggle="tooltip" data-original-title="Procesar"><i class="icon md-check-circle" aria-hidden="true"></i></a>--}}
                        </td>

                    </tr>
                @endforeach
                </tbody>
            </table>
        @endif
    </div>
@section('scripts')
    <script src="{{asset('assets/js/jquery.PrintArea.js')}}" type="text/javascript"></script>

    <script>
function imprimir(){ var options = { mode : "iframe", popClose : close, retainAttr : ['class','style','id'] }; $('#myPrintArea').printArea();
}



        $(document).ready(function(){




            $('.btn-baja').click(function(_evt){
                _evt.preventDefault();
                var _id=$(this).attr('id');
                var _href=$(this).attr('href')


                swal({
                        title: "Baja de contrato",
                        text: "Este contrato sera anulado. Desea continuar?",
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonClass: "btn-danger",
                        confirmButtonText: "Si, Anular!",
                        cancelButtonText:"Cancelar",
                        closeOnConfirm: false
                    },
                    function(){



                        window.location=_href
                    });

            })
            $('.btn-cancelar-cuota').click(function(){
                $('.form-cuota-inicial').hide();
                $('.form-procesar').show();
                $('.btn-cuota-ini ').show();


            })



            $('.select2').select2({
                placeholder: 'Seleccione un vendedor',
                multiple:false,
                width:'100%'
            })
            var select2=function(){
                $('body .select2').select2({
                    placeholder: 'Seleccione un vendedor',
                    multiple:false,
                    width:'100%'
                });

            }

            $('.tipo-filtro').change(function(){

                let valor=$(this).val();

                switch(valor){
                    case 'mes': $('.filtro-mes').show(); $('.filtro-acumulado').hide(); $('.filtro-rango').hide();  $('.filtro-buscar').hide();break;
                    case 'rango': $('.filtro-rango').show(); $('.filtro-acumulado').hide(); $('.filtro-mes').hide(); $('.filtro-buscar').hide(); break;
                    case 'acumulado': $('.filtro-acumulado').show(); $('.filtro-mes').hide(); $('.filtro-rango').hide(); $('.filtro-buscar').hide(); break;
                    case 'buscar': $('.filtro-acumulado').hide(); $('.filtro-mes').hide(); $('.filtro-rango').hide(); $('.filtro-buscar').show(); break;
                }

            })

            $('.btn-tarjeta-cobranza').click(function(_evt){
                _evt.preventDefault();
                let _url=$(this).attr('href')

                $.ajax({
                    url:_url,
                    method:'GET',
                    dataType:'html',
                    success:function(res)
                    {
                        $('.modal-ver').find('.modal-body').empty();
                        $('.modal-ver').find('.modal-body').append(res)
                        $('.modal-ver').modal('show')

                    }
                })
            })

            $('.btn-ver-nota').click(function(_evt){
                _evt.preventDefault();
                let _url=$(this).attr('href')

                $.ajax({
                    url:_url,
                    method:'GET',
                    dataType:'html',
                    success:function(res)
                    {
                        $('.modal-ver').find('.modal-body').empty();
                        $('.modal-ver').find('.modal-body').append(res)
                        $('.modal-ver').modal('show')

                    }
                })
            })
            $('.btn-ver-pagos').click(function(_evt){
                _evt.preventDefault();
                let _url=$(this).attr('href')

                $.ajax({
                    url:_url,
                    method:'GET',
                    dataType:'html',
                    success:function(res)
                    {
                        $('.modal-ver').find('.modal-body').empty();
                        $('.modal-ver').find('.modal-body').append(res)
                        $('.modal-ver').modal('show')

                    }
                })
            })
            $('.btn-devolucion').click(function(_evt){
                _evt.preventDefault();
                let _url=$(this).attr('href')

                $.ajax({
                    url:_url,
                    method:'GET',
                    dataType:'html',
                    success:function(res)
                    {
                        $('.modal-ver').find('.modal-body').empty();
                        $('.modal-ver').find('.modal-body').append(res)
                        $('.modal-ver').modal('show')

                    }
                })
            })
        })


    </script>
@stop


@endsection