@extends('layouts.admin')
@section('title') REFERENCIAS @stop
@section('titulo')  REFERENCIAS CONTRATOS @stop
@section('styles')
    <link rel="stylesheet" href="{{asset('assets/librerias/easy-autocomplete/easy-autocomplete.css')}}">
    <link rel="stylesheet" href="{{asset('assets/librerias/easy-autocomplete/easy-autocomplete.themes.css')}}">
   
@stop



@section('descripcion')
    <ol class="breadcrumb breadcrumb-arrow">
        <li class="breadcrumb-item"><a href="{{url('/')}}">Inicio</a></li>
        <li class="breadcrumb-item ">Cobranza</li>
        <li class="breadcrumb-item active"><a href="{{url('referencias')}}">REFERENCIAS CONTRATOS </a></li>
    </ol>
@stop
@section('content')
    @include('includes.modal-ver')

    <form class="form-inline"  method="POST" action="{{url('/referencias')}}">
        {!! csrf_field() !!}

        <div class="form-group col-md-4 ">
            <div class="row">
                <div class="form-row col-md-12">
                    <input type="text" name="numcuenta" @if(isset($criterio)) value="{{$criterio}}" @endif placeholder="Criterio de busqueda"  style="width:150%" class="numcuenta  form-control" >
                    <input type="hidden" name="credito_id" class="credito_id" value=""  >
                </div>
                <div class="form-row col-md-12">
                    <label for="">Numero de  Cuenta  <input type="radio"  class=" radio-inline tipo_numero" CHECKED    name="tipo" value="numcuenta"></label>
                    <label for="">Nombres <input type="radio"  class=" radio-inline tipo_apellidos" name="tipo" value="apellidos"></label>
                </div>

            </div>
        </div>
        <div class="form-group ">
            <button type="submit" name="buscar"  style="margin-top: -23px;" value="buscar" class="btn btn-outline-info waves-effect waves-light waves-round"> <i class="icon md-search"></i>Consultar</button>
        </div>
    </form>

    @if(isset($credito) && !is_null($credito))
        <hr>
        @include('cobranza.includes.detalle-cuenta')
        @include('cobranza.includes.fotos')

          
          <br>
        <div class="table-responsive col-md-12">

            <form method="POST" action="{{url('referencias/store')}}">
                {!! csrf_field() !!}
                <input type="hidden" name="credito_id" value="{{$credito->id}}">
                <div class="panel panel-primary">
                    <div class="panel-heading panel-success">
                        <h4 class="panel-title" align="center">DATOS DEL CLIENTE</h4>
                    </div>
                    <div class="panel-body ">
                        <div class="form-group form-row">
                        <div class="col-md-2">
                            <label for="">Nombres</label>
                            <input type="text" @isset($credito->contrato) value="{{$credito->contrato->nombres}}"   @endisset name="nombres_titular" class="form-control">
                        </div>
                        <div class="col-md-2">
                            <label for="">Apellido Paterno</label>
                            <input type="text"  @isset($credito->contrato) value="{{$credito->contrato->apellidopaterno}}" @endisset name="apellidopaterno_titular" class="form-control">
                        </div>
                            <div class="col-md-2">
                                <label for="">Apellido Materno</label>
                                <input type="text" @isset($credito->contrato)  value="{{$credito->contrato->apellidomaterno}}" @endisset name="apellidomaterno_titular" class="form-control">
                            </div>
                        <div class="col-md-1">
                            <label for="">Edad</label>
                            <input type="number" @isset($ref->edad) value="{{$ref->edad}}" @endisset  name="edad" class="form-control">
                        </div>
                        <div class="col-md-1">
                            <label for="">C.I.</label>
                            <input type="text" name="ci_titular" @isset($credito->contrato) value="{{$credito->contrato->ci}}" @endisset class="form-control">
                        </div>
                        <div class="col-md-2">
                            <label for="">Expedido en</label>
                            <input type="text" name="expedidoci"  @isset($ref->expedidoci) value="{{$ref->expedidoci}}" @endisset class="form-control">
                        </div>
                        </div>
                        <div class="form-group form-row">
                            <div class="col-md-1">
                                <label for="">Telefono</label>
                                <input type="text" name="telf"  @isset($ref->telf) value="{{$ref->telf}}" @endisset class="form-control">
                            </div>
                            <div class="col-md-1">
                                <label for="">Celular</label>
                                <input type="text" name="cel" @isset($ref->cel) value="{{$ref->cel}}" @endisset class="form-control">
                            </div>
                            <div class="col-md-2">
                                <label for="">Correo electronico</label>
                                <input type="text"   name="email"  @isset($ref->email) value="{{$ref->email}}" @endisset class="form-control">
                            </div>
                            <div class="col-md-3">
                                <label for="">Domicilio(Calle o Av).</label>
                                <input type="text" name="direccion" @isset($ref->direccion) value="{{$ref->direccion}}" @endisset class="form-control">
                            </div>
                            <div class="col-md-1">
                                <label for="">N°</label>
                                <input type="text" name="dir_num" @isset($ref->dir_num) value="{{$ref->dir_num}}" @endisset class="form-control">
                            </div>
                        </div>
                        <div class="form-group form-row">
                            <div class="col-md-2">
                                <label for="">Barrio</label>
                                <input type="text" name="barrio" @isset($ref->barrio) value="{{$ref->barrio}}" @endisset class="form-control">
                            </div>
                            <div class="col-md-2">
                                <label for="">Zona</label>
                                <input type="text" name="zona" @isset($ref->zona) value="{{$ref->zona}}" @endisset class="form-control">
                            </div>
                            <div class="col-md-2">
                                <label for="">Centro trabajo</label>
                                <input type="number"   name="centrotrabajo" @isset($ref->centrotrabajo) value="{{$ref->centrotrabajo}}" @endisset class="form-control">
                            </div>
                            <div class="col-md-3">
                                <label for="">Cargo que ocupa.</label>
                                <input type="text" name="cargoocupa" @isset($ref->cargoocupa) value="{{$ref->cargoocupa}}" @endisset class="form-control">
                            </div>
                            <div class="col-md-1">
                                <label for="">Antiguedad</label>
                                <input type="text" name="antiguedad" @isset($ref->antiguedad) value="{{$ref->antiguedad}}" @endisset class="form-control">
                            </div>
                        </div>
                        <div class="form-group form-row">
                            <div class="col-md-4">
                                <label for="">Direccion</label>
                                <input type="text" name="direcciontrabajo" @isset($ref->direcciontrabajo) value="{{$ref->direcciontrabajo}}" @endisset class="form-control">
                            </div>
                            <div class="col-md-1">
                                <label for="">N°</label>
                                <input type="text" name="numtrabajo" @isset($ref->numtrabajo) value="{{$ref->numtrabajo}}" @endisset class="form-control">
                            </div>
                            <div class="col-md-1">
                                <label for="">Telefono</label>
                                <input type="number"   name="telftrabajo" @isset($ref->telftrabajo) value="{{$ref->telftrabajo}}" @endisset class="form-control">
                            </div>
                            <div class="col-md-2">
                                <label for="">Barrio.</label>
                                <input type="text" name="barriotrabajo" @isset($ref->barriotrabajo) value="{{$ref->barriotrabajo}}" @endisset class="form-control">
                            </div>
                            <div class="col-md-2">
                                <label for="">Zona</label>
                                <input type="text" name="zonatrabajo" @isset($ref->zonatrabajo) value="{{$ref->zonatrabajo}}" @endisset  class="form-control">
                            </div>
                        </div>

                    </div>
                </div>

                <div class="panel panel-primary">
                    <div class="panel-heading panel-success">
                        <h4 class="panel-title" align="center">DATOS DEL CONYUGE</h4>
                    </div>
                    <div class="panel-body ">
                        <div class="form-group form-row">
                            <div class="col-md-2">
                                <label for="">Nombres</label>
                                <input type="text" name="nombresconyuge" @isset($ref->nombresconyuge) value="{{$ref->nombresconyuge}}" @endisset class="form-control">
                            </div>
                            <div class="col-md-1">
                                <label for="">C.I.</label>
                                <input type="text" name="ciconyuge" @isset($ref->ciconyuge) value="{{$ref->ciconyuge}}" @endisset class="form-control">
                            </div>
                            <div class="col-md-2">
                                <label for="">Celular</label>
                                <input type="text" name="celconyuge" @isset($ref->celconyuge) value="{{$ref->celconyuge}}" @endisset class="form-control">
                            </div>
                        </div>
                        <div class="form-group form-row">
                            <div class="col-md-2">
                                <label for="">Centro  de Trabajo</label>
                                <input type="text" name="trabajoconyuge" @isset($ref->trabajoconyuge) value="{{$ref->trabajoconyuge}}" @endisset class="form-control">
                            </div>
                            <div class="col-md-2">
                                <label for="">Ocupacion</label>
                                <input type="text" name="ocupacionconyuge" @isset($ref->ocupacionconyuge) value="{{$ref->ocupacionconyuge}}" @endisset class="form-control">
                            </div>
                            <div class="col-md-1">
                                <label for="">Antiguedad</label>
                                <input type="number"   name="antiguedadconyuge" @isset($ref->antiguedadconyuge) value="{{$ref->antiguedadconyuge}}" @endisset class="form-control">
                            </div>

                        </div>
                        <div class="form-group form-row">
                            <div class="col-md-3">
                                <label for="">Direccion</label>
                                <input type="text" name="dirtrabajoconyuge"  @isset($ref->dirtrabajoconyuge) value="{{$ref->dirtrabajoconyuge}}" @endisset class="form-control">
                            </div>
                            <div class="col-md-1">
                                <label for="">N°</label>
                                <input type="text" name="numtrabajoconyuge" @isset($ref->numtrabajoconyuge) value="{{$ref->numtrabajoconyuge}}" @endisset class="form-control">
                            </div>
                            <div class="col-md-1">
                                <label for="">Telefono</label>
                                <input type="number"   name="telftrabajoconyuge" @isset($ref->telftrabajoconyuge) value="{{$ref->telftrabajoconyuge}}" @endisset class="form-control">
                            </div>
                            <div class="col-md-2">
                                <label for="">Barrio.</label>
                                <input type="text" name="barriotrabajoconyuge" @isset($ref->barriotrabajoconyuge) value="{{$ref->barriotrabajoconyuge}}" @endisset class="form-control">
                            </div>
                            <div class="col-md-2">
                                <label for="">Zona</label>
                                <input type="text" name="zonatrabajoconyuge" @isset($ref->zonatrabajoconyuge) value="{{$ref->zonatrabajoconyuge}}" @endisset class="form-control">
                            </div>
                        </div>
                    </div>
                </div>

                <div class="panel panel-primary">
                    <div class="panel-heading panel-success">
                        <h4 class="panel-title" align="center">REFERENCIAS PERSONALES Y/O FAMILIARES</h4>
                    </div>
                    <div class="panel-body ">
                        <div class="form-group form-row">
                            <div class="col-md-3">
                                <label for="">Nombres</label>
                                <input type="text" name="nombresgarante" @isset($ref->nombresgarante) value="{{$ref->nombresgarante}}" @endisset class="form-control">
                            </div>
                            <div class="col-md-1">
                                <label for="">Celular.</label>
                                <input type="text" name="celgarante" @isset($ref->celgarante) value="{{$ref->celgarante}}" @endisset class="form-control">
                            </div>
                            <div class="col-md-1">
                                <label for="">Telefono</label>
                                <input type="text" name="telfgarante" @isset($ref->telfgarante) value="{{$ref->telfgarante}}" @endisset class="form-control">
                            </div>
                            <div class="col-md-2">
                                <label for="">Direccion</label>
                                <input type="text" name="dirgarante" @isset($ref->dirgarante) value="{{$ref->dirgarante}}" @endisset class="form-control">
                            </div>
                            <div class="col-md-1">
                                <label for="">N°</label>
                                <input type="text" name="numgarante" @isset($ref->numgarante) value="{{$ref->numgarante}}" @endisset class="form-control">
                            </div>
                            <div class="col-md-2">
                                <label for="">Zona</label>
                                <input type="text" name="zonagarante" @isset($ref->zonagarante) value="{{$ref->zonagarante}}" @endisset class="form-control">
                            </div>
                        </div>
                        <div class="form-group form-row">
                            <div class="col-md-3">
                                <label for="">Centro  de Trabajo</label>
                                <input type="text" name="trabajogarante" @isset($ref->trabajogarante) value="{{$ref->trabajogarante}}" @endisset class="form-control">
                            </div>
                            <div class="col-md-3">
                                <label for="">Barrio</label>
                                <input type="text" name="barriotrabajogarante" @isset($ref->barriotrabajogarante) value="{{$ref->barriotrabajogarante}}" @endisset class="form-control">
                            </div>


                        </div>
                        <div class="form-group form-row">
                            <div class="col-md-3">
                                <label for="">Nombre del Estudiante</label>
                                <input type="text" name="nombrehijos1" @isset($ref->nombrehijos1) value="{{$ref->nombrehijos1}}" @endisset class="form-control">
                            </div>
                            <div class="col-md-2">
                                <label for="">Curso</label>
                                <input type="text" name="cursohijos1" @isset($ref->cursohijos1) value="{{$ref->cursohijos1}}" @endisset class="form-control">
                            </div>
                            <div class="col-md-3">
                                <label for="">Colegio</label>
                                <input type="text"   name="colegiohijos1" @isset($ref->colegiohijos1) value="{{$ref->colegiohijos1}}" @endisset class="form-control">
                            </div>

                        </div>
                        <div class="form-group form-row">
                            <div class="col-md-3">
                                <label for="">Nombre del Estudiante</label>
                                <input type="text" name="nombrehijos2" @isset($ref->nombrehijos2) value="{{$ref->nombrehijos2}}" @endisset class="form-control">
                            </div>
                            <div class="col-md-2">
                                <label for="">Curso</label>
                                <input type="text" name="cursohijos2" @isset($ref->cursohijos2) value="{{$ref->cursohijos2}}" @endisset class="form-control">
                            </div>
                            <div class="col-md-3">
                                <label for="">Colegio</label>
                                <input type="text"   name="colegiohijos2" @isset($ref->colegiohijos2) value="{{$ref->colegiohijos2}}" @endisset class="form-control">
                            </div>

                        </div>
                    </div>
                </div>
                <button class="btn btn-success btn-block">GUARDAR</button>

            </form>

        </div>

    @endif
@section('scripts')
    <script src="{{asset('assets/librerias/easy-autocomplete/jquery.easy-autocomplete.js')}}"></script>

    <script>
        var options = {
            theme:'dark',
            url: "./common/buscar-cuenta",


            getValue: function(element) {
                console.log(element);
                return 'Cuenta:'+element.numcuenta+' Cliente: '+element.nombre_cliente;
            },

            ajaxSettings: {
                dataType: "json",
                method: "GET",
                data: {
                    dataType: "json"
                }
            },
            list: {
                onSelectItemEvent: function() {
                    var value = $(".numcuenta").getSelectedItemData().id;

                    $(".credito_id").val(value);
                }
            },

            preparePostData: function(data) {

                let tipo='numero';
                if($('.tipo_apellidos').is(':checked')){
                    tipo='apellidos'
                }
                else {
                    tipo='numero';
                }
                data.term = $(".numcuenta").val();
                data.tipo = tipo;
                return data;
            },

            requestDelay: 400
        };

      

        $('.btn-registrar-descuento').click(function(){
            $(this).hide();
            $('.div-descuento').show()
            $('.monto-descuento').focus()

        })
        $('.btn-cancelar-descuento').click(function(){
            $('.div-descuento').hide()
            $('.btn-registrar-descuento').show()
            $('.monto-descuento').val('')
        })


        $(".numcuenta").easyAutocomplete(options);
        $(".numcuenta").focus(function(){
            $(this).val('')
        });
        $('.select2').select2({
            placeholder: 'Seleccione una opcion',
            multiple:false,
            width:'90%'
        });
        $('.btn-guardar').click(function(_evt){
            _evt.preventDefault();
            if($('.monto').val()==''){
                swal('Alerta','Ingrese un monto para el pago','warning')
                return false;

            }
            if($('.fecha').val()==''){
                swal('Alerta','Ingrese una fecha','warning')
                return false;

            }


            swal({
                    title: "Registro de Pago",
                    text: "Se registrara el pago?",
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonClass: "btn-danger",
                    confirmButtonText: "Si, Registrar",
                    cancelButtonText:"Cancelar",
                    closeOnConfirm: false
                },
                function(){
                    $('.form').submit()
                });
        })

        $('.btn-eliminar').click(function(_evt){
            _evt.preventDefault()
            let url=$(this).attr('href')
            swal({
                    title: "Eliminar Pago",
                    text: "Se eliminara el pago. Esta Seguro?",
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonClass: "btn-danger",
                    confirmButtonText: "Si, Eliminar",
                    cancelButtonText:"Cancelar",
                    closeOnConfirm: false
                },
                function(){
                    window.location=url
                });
        })





    </script>
@stop


@endsection