

<div class="@if(isset($libro)) modal-edit @else modal-create @endif modal-form modal fade modal-fade-in-scale-up" id="form" aria-labelledby="exampleModalTitle" role="dialog"  aria-hidden="true" style="display: none;">
    <div class="modal-dialog modal-simple">


        <form class="form-horizontal" method="POST"  enctype="multipart/form-data" action="{{url('libros')}}">
            {!! csrf_field() !!}
            @isset($libro)
                <input type="hidden" name="id" value="{{$libro->id}}">
                @endisset

            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                    <h4 class="modal-title">@isset($libro) Editar Libro @else Registrar Libro @endif</h4>
                </div>
                <div class="modal-body">
                    <div class="form-group row form-material row">
                        <label class="col-md-3 form-control-label">Categoria: </label>
                        <div class="col-md-9">
                            <select  name="categoria_id" class="form-control select2"  >
                                <option value="">Seleccione</option>
                                @foreach($categorias as $r)
                                    <option  @if(isset($libro) && $libro->categoria_id==$r->id) selected  @endif value="{{$r->id}}">{{$r->codigo}} - {{$r->descripcion}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="form-group row form-material row">
                        <label class="col-md-3 form-control-label">Editorial: </label>
                        <div class="col-md-9">
                            <select  name="editorial_id" class="form-control select2" >
                                <option value="">Seleccione</option>
                                @foreach($editoriales as $r)
                                    <option @if(isset($libro) && $libro->editorial_id==$r->id) selected @endif value="{{$r->id}}">{{$r->nombre}}</option>
                                @endforeach


                            </select>
                        </div>
                    </div>
                    <div class="form-group row form-material row">
                        <label class="col-md-3 form-control-label">Codigo: </label>
                        <div class="col-md-9">
                            <input type="text"  required class="codigo form-control"   @if(isset($libro)) value="{{$libro->codigo}}" @endif name="codigo" placeholder="Codigo" autocomplete="off">
                        </div>
                    </div>
                    <div class="form-group row form-material row">
                        <label class="col-md-3 form-control-label">Titulo: </label>
                        <div class="col-md-9">
                            <input type="text" class="form-control" name="titulo" @if(isset($libro)) value="{{$libro->titulo}}" @endif required placeholder="Titulo del libro" autocomplete="off">
                        </div>
                    </div>
                    <div class="form-group row form-material row">
                        <label class="col-md-3 form-control-label">Tomo: </label>
                        <div class="col-md-9">
                            <input type="text" class="form-control" name="tomo" @if(isset($libro)) value="{{$libro->tomo}}" @endif placeholder="Numero de tomo" autocomplete="off">
                        </div>
                    </div>
                    <div class="form-group row form-material row">
                        <label class="col-md-3 form-control-label">Precio base: </label>
                        <div class="col-md-9">
                            <input type="number" step="0.0001"  class="form-control" @if(isset($libro)) value="{{$libro->precio_base}}" @endif name="precio_base" placeholder="Precio base " autocomplete="off">
                        </div>
                    </div>
                    <div class="form-group row form-material row">
                        <label class="col-md-3 form-control-label">Precio Final: </label>
                        <div class="col-md-9">
                            <input type="number"  step="0.0001" class="form-control" @if(isset($libro)) value="{{$libro->precio_final}}" @endif name="precio_final" placeholder="Precio Final" autocomplete="off">
                        </div>
                    </div>
                    <div class="form-group row form-material row">
                        <label class="col-md-3 form-control-label">foto </label>
                        <div class="col-md-9">
                            @include('libros.fotos')
                        </div>
                    </div>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default btn-pure waves-effect waves-light waves-round" data-dismiss="modal">Cerrar</button>
                    <button type="submit" class="btn btn-primary waves-effect waves-light waves-round">Guardar</button>
                </div>
            </div>
        </form>
    </div>
</div>
