@extends('layouts.admin')
@section('title') Devolucion Ventas @stop
@section('titulo') DEVOLUCION DE VENTAS @stop

{{--@section('libros-opcion')active  @stop--}}
@section('acciones')
    {{--<a href="{{url('notas-ingreso/create')}}" class=" btn-create btn btn-primary waves-effect waves-light waves-round"  type="button"> <i class="icon md-plus"></i>Nuevo Ingreso</a>--}}


@stop
@section('descripcion')
    <ol class="breadcrumb breadcrumb-arrow">
        <li class="breadcrumb-item"><a href="{{url('/')}}">Inicio</a></li>
        <li class="breadcrumb-item "><a href="{{url('/diferidos')}}">Ventas</a></li>
        <li class="breadcrumb-item active"><a href="{{url('/devolucion-ventas')}}">Devolucion Ventas</a></li>
    </ol>
@stop
@section('content')

    <div class="nav navbar-nav float-xs-right">
        <form class="form-inline pull-right" method="get" action="{{url('devolucion-contratos')}}" >
            @include('includes.form-periodo')
            <div class="form-group form-material">
                <button type="submit" class="btn btn-outline-info waves-effect waves-light waves-round"> <i class="icon md-search"></i>Consultar</button>
            </div>
        </form>
    </div>

    <div class="table-responsive">

        <table  id=""  class=" data-table table table-hover  table-striped " >
            <thead>
            <tr>
                <th>NUMERO</th>
                <th>FECHA <br>DEVOLUCION</th>
                <th>FECHA <br>CONTRATO</th>
                <th>NUM CONTRATO</th>
                <th>CLIENTE</th>
                <th>VENDEDOR</th>
                <th>CHOFER</th>
                <th>ESTADO</th>
                <th>ACCIONES</th>
            </tr>
            </thead>
            <tbody>
            @foreach($devoluciones as $k=>$r)
                <tr>
                    <td width="1%">{{$r->id}}</td>

               
                 
                    <td>{{$r->fecha->format('d/m/Y')}}</td>
                    
                    <td>{{$r->contrato->fechacontrato->format('d/m/Y')}}</td>
                    <td><a href="{{url('almacen/devolucion-ventas/vercontrato')}}/{{$r->contrato->id}}" class="btn-ver" data-toggle="tooltip" data-original-title="Ver detalle contrato" >{{$r->contrato->numcontrato}}</a></td>
                    <td >{{$r->contrato->nombre_completo}}</td>
                    <td >{{$r->contrato->vendedor->nombre_completo}}</td>
                    <td >{{$r->contrato->chofer->nombre_completo}}</td>
                    <TD>{{$r->estado}}</TD>
                    <td>

                        @if($r->tipo_devolucion=='PARCIAL')

                        <a  href="{{url('devolucion-contratos/'.$r->id.'/ver-notas')}}" class=" btn  btn-icon btn-pure btn-default on-default edit-row waves-effect waves-light waves-round" data-toggle="tooltip" data-original-title="Ver nota"><i class="icon  md-file" aria-hidden="true"></i></a>
                        @endif
                        <a  href="{{url('devolucion-contratos/'.$r->id.'/ver')}}" class=" btn btn-ver  btn-icon btn-pure btn-default on-default edit-row waves-effect waves-light waves-round" data-toggle="tooltip" data-original-title="Ver nota de devolucion"><i class="icon  md-open-in-new" aria-hidden="true"></i></a>
                        @if($r->estado!=='PROCESADO')

                        <a href="devolucion-contratos/{{$r->id}}/delete" id="{{$r->id}}"  class="btn-delete btn  btn-icon btn-pure btn-default on-default remove-row waves-effect waves-light waves-round" data-toggle="tooltip" data-original-title="Eliminar nota de devolucion"><i class="icon md-delete" aria-hidden="true"></i></a>
                            @endif




                    </td>
                


                </tr>
            @endforeach
            </tbody>
        </table>
    </div>
    <div class="modal-ver modal fade modal-slide-in-right" id="exampleNiftySlideFromRight" aria-hidden="true"
         aria-labelledby="exampleModalTitle" role="dialog" tabindex="-1">
        <div class="modal-dialog modal-simple">
            <div class="modal-content">

                <div class="modal-body">

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger " data-dismiss="modal">Cerrar</button>
                </div>
            </div>
        </div>
    </div>



@section('scripts')
    <script src="{{asset('assets/js/jquery.PrintArea.js')}}" type="text/javascript"></script>

    <script>



        function imprimir(){
            var options = { mode : "iframe", popClose : close,  retainAttr : ['class','style','id'] };

            $('#myPrintArea').printArea();


        }



        $(document).ready(function(){


            $('.btn-ver').click(function(_evt){
                _evt.preventDefault();
                let url=$(this).attr('href')
                $.ajax({
                    url:url,
                    method:'GET',
                    dataType:'html',
                    success:function(res)
                    {
                        $('.modal-ver').find('.modal-body').empty();
                        $('.modal-ver').find('.modal-body').append(res)
                        $('.modal-ver').modal('show')

                    }
                })
            });


            $('.btn-delete').click(function(_evt){
                _evt.preventDefault();

                var _href=$(this).attr('href')
                var _id=$(this).attr('id')


                swal({
                        title: "Esta seguro?",
                        text: "Se eliminara la nota de Devolucion  Num:"+_id,
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonClass: "btn-danger",
                        confirmButtonText: "Si, Eliminar!",
                        cancelButtonText:"Cancelar",
                        closeOnConfirm: false
                    },
                    function(){
                        window.location=_href
                    });

            })




        })


    </script>
@stop


@endsection