@extends('layouts.admin')
@section('title') Registrar Venta @stop
@section('titulo') REGISTRAR VENTA @stop
{{--@section('libros-opcion')active @stop--}}
@section('descripcion')
<ol class="breadcrumb breadcrumb-arrow">
    <li class="breadcrumb-item"><a href="{{url('/')}}">Inicio</a></li>
    <li class="breadcrumb-item ">CONTRATOS </li>
    <li class="breadcrumb-item active"><a href="{{url('/diferidos')}}">Registrar Venta</a></li>
</ol>
@stop
@section('content')
<div class="panel panel-default row ">
    <div class="panel-body">
        <table class=" col-md-12 table table-bordered table-inbox   ">
            <tr class="modo2">
                <th>NUM <br> CONTRATO</th>
                <th width="280">CLIENTE</th>
                <th>MONTO <br /> CONTRATO</th>
                <th>MONTO <BR />CUOTA INICIAL</th>
                <th>SALDO ACTUAL<BR />CUOTA INICIAL</th>
            </tr>
            <tr>
                <td>{{ $contrato["numcontrato"]}}</td>
                <TD>{{ $contrato->nombre_completo}}</TD>
                <td>{{ $contrato->preciototal}}</td>
                <td>{{ $contrato->credito->cuotainicial}}</td>
                <td><input class="monto_cuota_ini" id="saldo" size="7" readonly value="{{$contrato->credito->saldoCuotaInicial()}}" /></td>
            </tr>
        </table>
    </div>
</div>
@if($contrato->credito->cuotainicial>0 )
<div class="panel panel-default row " style="margin-top: -4%">
    <div class="panel-body">
        <form method="post" action="{{url('diferidos/registrar-pago')}}" name="FORM" id="form" class="form-pago">
            {!! csrf_field() !!}
            <input type="hidden" name="contrato_id" value="{{$contrato->id}}">
            <div class="row">
                <table class="table table-bordered ">
                    <thead>
                        <tr style="font-weight: bold">
                            <th>Num</th>
                            <th>Descripcion</th>
                            <th>Documento</th>
                            <th>Num Documento</th>
                            <th>Fecha</th>
                            <th>Monto</th>
                            <th>Opciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        @if($contrato->credito->cuotainicial>0)
                        @foreach($contrato->credito->PagosCuotainicial() as $k=>$v)
                        @if($v->tipo_documento=="FACTURA" )
                        @php $factura=\App\Factura::pagosCuotaInicial($v->id); @endphp
                        <tr>
                            <td>{{$k+1}}</td>
                            <td>{{$factura->descripcion}}</td>
                            <td>{{$v->tipo_documento}}</td>
                            <td>{{$factura->numero}}</td>
                            <td>{{$v->fecha->format('d-m-Y')}}</td>
                            <td align="right">{{$v->monto}}</td>
                            <td align="center"> <a id="{{$v->id}}" href="{{url('/diferidos')}}/{{$v->id}}/eliminar-pago" title="Borrar" class="btn btn-xs btn-danger"><i class="icon md-close"></i></a></td>
                        </tr>
                        @endif
                        @if($v->tipo_documento=="RECIBO")
                        @php $recibo=\App\Recibo::pagosCuotaInicial($v->id);@endphp
                        <tr>
                            <td>{{$k+1}}</td>
                            <td>{{ $recibo->descripcion}}</td>
                            <td>{{ $v->tipodocumento}}</td>
                            <td>{{ $recibo->numero}}</td>
                            <td>{{ $v->fecha->format('d-m-Y')}}</td>
                            <td align="right">{{ $v->monto}}</td>
                            <td align="center"> <a id="{{$v->id}}" href="{{url('/diferidos')}}/{{$v->id}}/eliminar-pago" title="Borrar" class="btn btn-xs btn-danger"><i class="icon md-close"></i></a></td>
                        </tr>
                        @endif
                        @if($v->tipo_documento=="SINDOC")
                        <tr>
                            <td>{{$k+1}}</td>
                            <td>-------------</td>
                            <td>{{$v->tipo_documento}}</td>
                            <td>------------</td>
                            <td>{{ $v->fecha->format('d-m-Y')}}</td>
                            <td align="right">{{ $v->monto}}</td>
                            <td align="center"> <a id="{{$v->id}}" href="{{url('/diferidos')}}/{{$v->id}}/eliminar-pago" title="Borrar" class="btn btn-xs btn-danger"><i class="icon md-close"></i></a></td>
                        </tr>
                        @endif
                        @endforeach
                        @endif
                    </tbody>
                </table>
            </div>
            <h5>Registro de pagos a cuenta de la cuota inicial</h5>
            <hr>
            <table class="detalleContrato col-md-12" border="0" cellpadding="0" cellspacing="0">
                <tr>
                    <td>
                        <label>MONTO</label>
                        <input type="text" required class="numeroscondecimales form-control" name="monto" id="monto" />
                    </td>
                    <td>
                        <label>FECHA</label>
                        <input type="text" required readonly class="fecha form-control datepicker" id="fecha" name="fecha" />
                    </td>
                    <td>
                        <label>TIPO DOC</label><select class="form-control" name="tipodoc" id="tipodoc">
                            <option value="SINDOC" selected="selected">SIN DOCUMENTO</option>
                            <option value="RECIBO">RECIBO</option>
                            <option value="FACTURA">FACTURA</option>
                        </select>
                    </td>
                    <td>
                        <table id="tablarecibo">
                            <tr>
                                <TD><label>NUM RECIBO</label><input class="form-control" type="text" name="numrecibo" id="numrecibo" size="12" /></TD>
                                <TD><label>NOMBRE</label><input class="form-control" type="text" value="{{$contrato->nombre_completo}}" name="nombresrecibo" id="nombresrecibo" size="20" /></TD>
                                <TD><label>DESCRIPCION</label><input class="form-control" type="text" value="CUOTA INICIAL" name="descripcionrecibo" id="descripcionrecibo" size="20" /></TD>
                            </tr>
                        </table>
                    </td>
                    <td>
                        <table id="tablafactura" style="display:none">
                            <tr>
                                <TD><label>NUM FACTURA</label><input type="text" class="form-control" name="numfactura" id="numfactura" size="4" /></TD>
                                <TD><label>NOMBRES</label><input type="text" class="form-control" name="nombresfactura" value="{{$contrato->nombre_completo}}" id="nombresfactura" size="20" /></TD>
                                <TD><label>CARNET</label><input type="text" class="form-control" name="carnetfactura" id="carnetfactura" value="{{$contrato->ci}}" size="8" /></TD>
                                <TD><label>DESCRIPCION</label><input type="text" class="form-control" name="descripcionfactura" id="descripcionfactura" value="CUOTA INICIAL" size="20" /></TD>
                            </tr>
                        </table>
                    </td>
                </tr>
                <tr class="fila-cobro" style="display:none">
                    <TD><label>NUM REPORTE</label><input type="text" class="form-control" name="num_reporte" id="numreporte" size="4" /></TD>
                    <TD>
                        <label>DIA DE COBRO</label><input type="text" class="form-control" name="diacobrar" id="diacobrar" size="4" />
                    </TD>
                    <td><input type="hidden" name="procesar" id="procesar" value="0">
                    </td>
                </tr>
            </table>
            <button type="submit" class="btn-guardar-pago btn-block btn btn-primary ">GUARDAR</button>
            <input type="hidden" name="enviar" value="enviar" />
            <input type="hidden" name="credito_idcredito" value="{{ $contrato->credito->id}}" />
            <input type="hidden" name="idcontrato" value="{{ $contrato->credito->contrato_id}}" />
        </form>
        @else
        <form method="post" action="{{url('diferidos/registrar-pago')}}" name="FORM" id="form" class="form-pago">
            {!! csrf_field() !!}
            <input type="hidden" name="contrato_id" value="{{$contrato->id}}">
            <input type="hidden" name="enviar" value="enviar" />
            <input type="hidden" name="credito_idcredito" value="{{ $contrato->credito->id}}" />
            <input type="hidden" name="idcontrato" value="{{ $contrato->credito->contrato_id}}" />
            <input type="hidden" name="cuota_inicial" value="0" />
            <div class="form-group">
                <div class="col-md-2">
                    <label for="">Fecha</label>
                    <label>FECHA</label>
                    <input type="text" required readonly class="fecha form-control datepicker" id="fecha" name="fecha" /></td>
                    <button type="submit" class="btn-guardar-pago btn-block btn btn-primary ">GUARDAR</button>
                </div>
            </div>
        </form>
    </div>
</div>
@endif
@section('scripts')
<script type="text/javascript">
    var sw_addfila;
    $(document).ready(function($) {
        $('.fecha').change(function() {
            var _fecha = $(this)
            $.ajax({
                    url: "{{url('common/validar-cierre')}}",
                    data: {
                        fecha: _fecha.val(),
                        modulo: 'VENTAS'
                    },
                    dataType: 'json',
                    method: 'GET',
                    async: false,
                })
                .done(function(res) {
                    if (!res) {
                        swal('Alerta', 'No esta permitido registrar en la fecha seleccionada', 'warning')
                        _fecha.val('')
                        return false;
                    }
                }).fail(function() {
                    alert('exisitio un error')
                })
        })
        $('#monto').change(function() {
            let saldo = parseFloat($('#saldo').val())
            let monto = parseFloat($(this).val())
            if (monto >= saldo) {
                $('.fila-cobro').show()
                $('#procesar').val(1)
            } else {
                $('.fila-cobro').hide()
                $('#procesar').val(0)
            }
        })
        $('.btn-guardar-pago').click(function(_evt) {
            _evt.preventDefault();
            let ci = parseFloat($('.monto_cuota_ini').val());
            let monto = $(this).closest('form').find('#monto')
            let fecha = $(this).closest('form').find('#fecha')
            if (monto.val() == '') {
                swal('Alerta', 'Ingrese un monto', 'warning');
                return false;
            } else {
                if (parseFloat(monto.val()) > ci) {
                    swal('Alerta', 'El monto no puede ser mayor al saldo de la cuota inicial', 'warning');
                    monto.val('')
                    monto.focus()
                    return false;
                }
            }
            if (fecha.val() == '') {
                swal('Alerta', 'Ingrese una fecha de pago', 'warning');
                return false;
            }
            if ($('#procesar').val() == 1) {
                if ($('#numreporte').val() == '') {
                    swal('Alerta', 'Ingrese un numero de reporte', 'warning');
                    return false;
                }
                if ($('#diacobrar').val() == '') {
                    swal('Alerta', 'Ingrese un dia de cobro', 'warning');
                    return false;
                }
            }
            if ($('#procesar').val() == 1) {
                swal({
                        title: "Esta seguro?",
                        text: "Se procesara la venta como facturada y ya no se podra modificar",
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonClass: "btn-warning",
                        confirmButtonText: "Si, Procesar!",
                        cancelButtonText: "Cancelar",
                        closeOnConfirm: false
                    },
                    function() {
                        $('.form-pago').submit()
                    })
            } else {
                $('.form-pago').submit()
            }
        })
        $("#tipodoc").change(function() {
            if ($(this).val() == "FACTURA") {
                $("#tablafactura").css({
                    display: "block"
                });
                $("#tablarecibo").css({
                    display: "none"
                });
            }
            if ($(this).val() == "RECIBO") {
                $("#tablafactura").css({
                    display: "none"
                });
                $("#tablarecibo").css({
                    display: "block"
                });
            }
            if ($(this).val() == "SINDOC") {
                $("#tablafactura").css({
                    display: "none"
                });
                $("#tablarecibo").css({
                    display: "none"
                });
            }
        });
        $("#tipodocventa").change(function() {
            if ($(this).val() == "FACTURA") {
                $("#tablafacturaventa").css({
                    display: "block"
                });
                $("#tablareciboventa").css({
                    display: "none"
                });
            }
            if ($(this).val() == "RECIBO") {
                $("#tablafacturaventa").css({
                    display: "none"
                });
                $("#tablareciboventa").css({
                    display: "block"
                });
            }
            if ($(this).val() == "SINDOC") {
                $("#tablafacturaventa").css({
                    display: "none"
                });
                $("#tablareciboventa").css({
                    display: "none"
                });
            }
        });
        $("#monto").change(function() {
            if (parseFloat($(this).val()) > parseFloat($("#saldo").val())) {
                mensaje("El monto no pude ser mayor al saldo restante", "warning");
                $(this).val(0);
            }
        });
        //CONDICIONES INICIALIES
        if (parseFloat($("#saldo").val()) <= 0) {
            $("#wizard").css({
                display: "block"
            });
        }
        $("#tablafactura").css({
            display: "none"
        });
        $("#tablarecibo").css({
            display: "none"
        });
        $("#tablafacturaventa").css({
            display: "none"
        });
        $("#tablareciboventa").css({
            display: "none"
        });
    });

    function validarFacturacion() {
        var f = $("#fecha2").val();
        var m = $("#montoventa").val();
        if ($("#tipodocventa").val() == "SIN DOCU") {
            mensaje("ERROR:: Eliga un documento para facturar.", "error");
            return false;
        } else {
            if ($("#tipocuota").val() == 'cc') {
                confirmForm($("#wizard"), "Esta facturando con los siguientes datos.<br> <b class='resaltar'> Monto :" + m + "(Bs)<br> fecha: " + f + "</b><br>Desea continuar?");
            }
            if ($("#tipocuota").val() == 'sc') {
                confirmForm($("#wizard"), "Esta facturando con los siguientes datos.<br> <b class='resaltar'>  fecha: " + f + "</b><br>Desea continuar?");
            }
        }
    }
</script>
@stop
@endsection