@extends('layouts.admin')
@section('title') PLANILLA DE COMISIONES DE VENTAS  @stop
@section('titulo') PLANILLA DE COMISIONES DE VENTAS @stop

{{--@section('libros-opcion')active  @stop--}}
@section('acciones')
    {{--    <a href="{{url('notas-remision/create')}}" class=" btn-create btn btn-primary waves-effect waves-light waves-round"  type="button"> <i class="icon md-plus"></i>Nueva Remision</a>--}}


@stop
@section('descripcion')
    <ol class="breadcrumb breadcrumb-arrow">
        <li class="breadcrumb-item"><a href="{{url('/')}}">Inicio</a></li>
        <li class="breadcrumb-item ">Ventas</li>
        <li class="breadcrumb-item active"><a href="{{url('/reportes-ventas')}}">Reportes</a></li>
        <li class="breadcrumb-item active">PLANILLA DE COMISIONES DE VENTAS</li>
    </ol>
@stop
@section('content')
    <div class="nav navbar-nav float-xs-right">
        <form class="form-inline pull-right" method="POST" action="{{url('reportes-ventas/comisiones-organizacion')}}" >
            {!! csrf_field() !!}
            @include('includes.form-periodo')
            <div class="form-group">

                    <label for="">Vendedores</label>
                <select name="vendedor"  class="form-control"id="">
                    <option value="">Todos</option>
                        @foreach($vendedores as $v)
                        <option value="{{$v->id}}" @if($vendedor==$v->id) selected @endif>{{$v->nombre_completo}}</option>
                            @endforeach

                </select>
            </div>
            <div class="form-group form-material">
                <button name="consultar" value="consultar" class="btn btn-info "><i class="icon md-search"></i> Consultar</button>

            </div>
        </form>
    </div>
    <div class="clearfix"></div>

    @if(count($datos)>0)
        <hr>
        <div class="btn-group col-md-2 float-right ">

            <form method="POST" action="{{url('reportes-ventas/comisiones-organizacion')}}">
                {{ csrf_field()}}
                <input type="hidden" name="mes" value="{{$mes}}">
                <input type="hidden" name="anio" value="{{$anio}}">
                <input type="text" name="vendedor" value="{{$vendedor}}">
                <input type="hidden" name="consultar" value="consultar">
                <button name="tipoexportacion" value="excel" class="btn btn-outline-success">EXCEL</button>
                <button name="tipoexportacion" value="pdf" class="btn btn-outline-danger">PDF</button>
            </form>
        </div>

        </div>
    @endif

    <div class="table-responsive">

        @if(count($datos)>0)
            @include('ventas.reportes.comisiones_organizacion.tabla')
        @else
            <h4 class="text text-primary text-center">NO SE ENCONTRARON REGISTROS.</h4>
        @endif
    </div>



@section('scripts')

    <script>




        $(document).ready(function() {

            $('#filtro').change(function(){
                if($(this).val()=='MES'){
                    $('.div-mes').show()
                    $('.div-anio').show()
                    $('.div-fecha-ini').hide()
                    $('.div-fecha-fin').hide()
                    $('.div-fecha-acumulado').hide()
                }
                if($(this).val()=='RANGO'){
                    $('.div-mes').hide()
                    $('.div-anio').hide()
                    $('.div-fecha-ini').show()
                    $('.div-fecha-fin').show()
                    $('.div-fecha-acumulado').hide()
                }
                if($(this).val()=='ACUMULADO'){
                    $('.div-mes').hide()
                    $('.div-anio').hide()
                    $('.div-fecha-ini').hide()
                    $('.div-fecha-fin').hide()
                    $('.div-fecha-acumulado').show()
                }
            })

            $('.select2').select2({
                placeholder: 'Seleccione una opcion',
                multiple:false,
                width:'90%'
            });

        })
    </script>
@stop


@endsection