<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/



Auth::routes();

Route::get('/', 'HomeController@index')->name('home');

Route::middleware(['auth'])->prefix('libros')->group(function () {

    Route::resource('/', 'LibroController');
    Route::get('{libro}/edit', 'LibroController@edit');
    Route::get('{exportar}', 'LibroController@index');
    Route::get('{libro}/delete', 'LibroController@destroy');
    Route::get('validar-codigo/{codigo}', 'LibroController@validarCodigo');
});

Route::middleware(['auth'])->prefix('categorias')->group(function () {

    Route::get('/', 'CategoriaController@index');
    Route::get('{exportar}', 'CategoriaController@index');
    Route::post('/store', 'CategoriaController@store');
    Route::get('{categoria}/edit', 'CategoriaController@edit');

    Route::get('/{categoria}/delete', 'CategoriaController@destroy');
});

Route::middleware(['auth'])->prefix('editoriales')->group(function () {

    Route::get('/', 'EditorialController@index');
    Route::post('/store', 'EditorialController@store');
    Route::get('{editorial}/edit', 'EditorialController@edit');
    Route::get('{exportar}', 'EditorialController@index');

    Route::get('/{editorial}/destroy', 'EditorialController@destroy');
});

Route::middleware(['auth'])->prefix('vendedores')->group(function () {

    Route::get('/', 'VendedorController@index');
    Route::post('/store', 'VendedorController@store');
    Route::get('/{vendedor}/edit', 'VendedorController@edit');

    Route::get('/{vendedor}/delete', 'VendedorController@destroy');
    Route::get('{exportar}', 'VendedorController@index');
});

Route::middleware(['auth'])->prefix('users')->group(function () {

    Route::get('/', 'UserController@indexUser');
    Route::post('/store', 'UserController@storeUser');
    Route::post('/update', 'UserController@updateUser');
    Route::get('/{user}/delete', 'UserController@deleteUser');
});


Route::middleware(['auth'])->prefix('notas-remision')->group(function () {

    Route::get('/', 'NotasRemisionController@index');
    Route::get('/create', 'NotasRemisionController@create');
    Route::post('/store', 'NotasRemisionController@store');
    Route::get('{remision}/editar', 'NotasRemisionController@edit');
    Route::get('/{remision}/delete', 'NotasRemisionController@destroy');
    Route::get('/{remision}/procesar', 'NotasRemisionController@procesar');
    Route::get('/{remision}/ver', 'NotasRemisionController@show');
    Route::get('/{remision}/anular', 'NotasRemisionController@anular');
    Route::get('/{remision}/validar-anular', 'NotasRemisionController@validarAnular');
    Route::get('/relacion', 'NotasRemisionController@relacion');
    Route::get('/relacion/{mes}/{anio}/{tipo}', 'NotasRemisionController@relacion');
    Route::get('/imprimir/{remision}', 'NotasRemisionController@imprimir');
});

Route::middleware(['auth'])->prefix('notas-ingreso')->group(function () {

    Route::get('/', 'NotasIngresoController@index');
    Route::get('/create', 'NotasIngresoController@create');
    Route::post('/store', 'NotasIngresoController@store');
    Route::get('{ingreso}/editar', 'NotasIngresoController@edit');
    Route::get('/{ingreso}/delete', 'NotasIngresoController@destroy');
    Route::get('/{ingreso}/procesar', 'NotasIngresoController@procesar');
    Route::get('/{ingreso}/ver', 'NotasIngresoController@show');
    Route::get('/{ingreso}/anular', 'NotasIngresoController@anular');
    Route::get('/relacion', 'NotasIngresoController@relacion');
    Route::get('/relacion/{mes}/{anio}/{tipo}', 'NotasIngresoController@relacion');
});

Route::middleware(['auth'])->prefix('notas-egreso')->group(function () {

    Route::get('/', 'NotasEgresoController@index');
    Route::get('/create', 'NotasEgresoController@create');
    Route::post('/store', 'NotasEgresoController@store');
    Route::get('{egreso}/editar', 'NotasEgresoController@edit');
    Route::get('/{egreso}/delete', 'NotasEgresoController@destroy');
    Route::get('/{egreso}/procesar', 'NotasEgresoController@procesar');
    Route::get('/{egreso}/ver', 'NotasEgresoController@show');
    Route::get('/{egreso}/anular', 'NotasEgresoController@anular');
    Route::get('/relacion', 'NotasEgresoController@relacion');
    Route::get('/relacion/{mes}/{anio}/{tipo}', 'NotasEgresoController@relacion');
});


Route::middleware(['auth'])->prefix('reportes-almacen')->group(function () {

    Route::get('/', 'ReportesAlmacenController@index');
    Route::get('/inventario', 'ReportesAlmacenController@inventario');
    Route::get('/inventario/{fecha_ini}/{tipo}', 'ReportesAlmacenController@inventario');

    Route::get('/inventario2', 'ReportesAlmacenController@inventario2');
    Route::get('/inventario2/{fecha_ini}/{tipo}', 'ReportesAlmacenController@inventario2');

    Route::get('/movimiento', 'ReportesAlmacenController@movimiento2');
    Route::post('/movimiento', 'ReportesAlmacenController@movimiento2');
    Route::get('/movimiento/{fecha_ini}/{fecha_fin}/{tipo}', 'ReportesAlmacenController@movimiento');
    Route::get('/catalogo', 'ReportesAlmacenController@catalogo');
    Route::get('/catalogo/{tipo}', 'ReportesAlmacenController@catalogo');
    Route::get('/kardexmayor', 'ReportesAlmacenController@kardexMayor');
    Route::post('/kardexmayor', 'ReportesAlmacenController@kardexMayor');
    Route::get('/kardexmayor/{fecha_ini}/{fecha_fin}/{codigo}/{tipo}', 'ReportesAlmacenController@kardexMayor');
    Route::get('/cargos', 'ReportesAlmacenController@cargosVendedor');
    Route::get('/cargos/{mes}/{anio}/{vendedor_id}/{tipo}', 'ReportesAlmacenController@cargosVendedor');;
});



Route::middleware(['auth'])->prefix('kardex')->group(function () {

    Route::get('/', 'KardexController@index');
    Route::get('/exportar/{tipo}/{mes}/{anio}/{vendedor}', 'KardexController@exportar');
    Route::get('/pasar-cargos/{mes}/{anio}/{vendedor}', 'KardexController@pasarCargos');
    Route::get('/resumen', 'KardexController@resumenCargos');
    Route::get('/cargosvendedores', 'KardexController@cargosVendedores');
});

Route::middleware(['auth'])->prefix('diferidos')->group(function () {

    Route::get('', 'ContratoController@diferidos');
    Route::get('create', 'ContratoController@diferidosCreate');
    Route::get('{contrato}/editar', 'ContratoController@diferidosEditar');
    Route::get('{contrato}/ver', 'ContratoController@diferidosVer');
    Route::get('{contrato}/borrar', 'ContratoController@diferidosBorrar');
    Route::get('{contrato}/devolucion-create', 'ContratoController@diferidosDevolucionCreate');
    Route::post('devolucion/store', 'ContratoController@diferidosDevolucionStore');
    Route::post('store', 'ContratoController@diferidosStore');
    Route::get('validar-contrato/{num}', 'ContratoController@validarNumContrato');
    Route::get('validar-carnet/{num}', 'ContratoController@validarCarnet');
    Route::get('{contrato}/validar-disponible', 'ContratoController@validarDisponible');
    Route::get('{contrato}/procesar', 'ContratoController@procesar');
    Route::post('procesar-diferido', 'ContratoController@procesarDiferido');
    Route::get('{contrato}/registrarventa', 'ContratoController@registrarVenta');
    Route::post('registrar-pago', 'ContratoController@registrarPagoCuotaInicial');
    Route::post('procesar-venta-post', 'ContratoController@procesarVentaPost');
    Route::post('procesar-venta', 'ContratoController@procesarVenta');
    Route::get('{contrato}/ver-kardex', 'ContratoController@verKardex');
    Route::get('{contrato}/baja', 'ContratoController@diferidosBaja');
    Route::get('{pago}/eliminar-pago', 'ContratoController@eliminarPago');
});
Route::middleware(['auth'])->prefix('contratos-venta')->group(function () {

    Route::get('/', 'ContratoController@contratosVenta');
});
Route::middleware(['auth'])->prefix('contratos-anulados')->group(function () {

    Route::get('/', 'ContratoController@contratosAnulados');
    Route::get('/{contrato}/ver-devolucion', 'ContratoController@verNotaDevolucion');
});
Route::middleware(['auth'])->prefix('contratos-baja')->group(function () {

    Route::get('/', 'ContratoController@contratosBaja');
});



Route::middleware(['auth'])->prefix('common')->group(function () {

    Route::get('/ver-kardex/{tipo}/{documento}', 'CommonController@verKardex');
    Route::get('buscar-cuenta', 'CommonController@buscarCuenta');
    Route::get('buscar-cuenta-antigua', 'CommonController@buscarCuentaAntigua');
    Route::get('buscar-deudor', 'CommonController@buscarDeudor');
    Route::get('plan-pagos', 'CommonController@calcularPlanPagos');
    Route::get('get-stock', 'CommonController@getStock');


    Route::get('validar-cierre', 'CommonController@validarCierre');
    Route::get('contratos/{contrato}/ver', 'ContratoController@diferidosVerNumContrato');
    Route::get('ver-nota', 'CommonController@verNota');



    // rutas auxiliares

    Route::get('regularizacion-inventario', 'CommonController@regularizacionInventario');
    Route::get('regularizacion-ventakardex/{numcontrato}', 'ContratoController@asignarVentaKardex');
});
Route::middleware(['auth'])->prefix('roles')->group(function () {

    Route::get('/', 'UserController@roles');
    Route::get('/create', 'UserController@roleCreate');
    Route::get('/{role}/edit', 'UserController@roleEdit');
    Route::get('/{role}/delete', 'UserController@roleDelete');
    Route::post('/store', 'UserController@roleStore');


    Route::get('/exportar/{tipo}/{mes}/{anio}/{vendedor}', 'KardexController@exportar');
    Route::get('/pasar-cargos/{mes}/{anio}/{vendedor}', 'KardexController@pasarCargos');
});

Route::middleware(['auth'])->prefix('almacen')->group(function () {

    Route::get('/devolucion-ventas', 'DevolucionObrasController@devolucionVentasAlmacen');
    Route::get('/devolucion-ventas/vercontrato/{contrato}', 'ContratoController@diferidosVer');
    Route::get('/devolucion-ventas/{devolucion}/create-devolucion', 'DevolucionObrasController@devolucionCreate');
    Route::get('/devolucion-ventas/{devolucion}/rechazar', 'DevolucionObrasController@rechazarDeVentas');
    Route::post('/devolucion-ventas/devolucion/store', 'DevolucionObrasController@devolucionStore');


    Route::get('/devolucion-cobranza', 'DevolucionCobranzaController@devolucionVentasAlmacen');
    Route::get('/devolucion-cobranza/{devolucion}/create-ingreso', 'DevolucionCobranzaController@ingresoCreate');
    Route::post('/devolucion-cobranza/ingreso/store', 'DevolucionCobranzaController@ingresoStore');
    Route::get('/devolucion-cobranza/vercontrato/{contrato}', 'ContratoController@diferidosVer');
    Route::get('/devolucion-cobranza/{devolucion}/rechazar', 'DevolucionCobranzaController@rechazar');



    Route::get('/cambio-obra', 'CambioObraController@almacenCambioObra');
    Route::post('/cambio-obra/procesar', 'CambioObraController@procesarAlmacen');
    Route::get('/cambio-obra/{cambio}/registrar-notas', 'CambioObraController@registrarNotasAlmacen');


    Route::get('/cambiarmonto', 'CuentaController@cambiarMontoCuotas');
});




Route::middleware(['auth'])->prefix('notas-devolucion')->group(function () {

    Route::get('/', 'NotasDevolucionController@index');
    Route::post('/create', 'NotasDevolucionController@create');
    Route::post('/store', 'NotasDevolucionController@store');
    Route::get('{devolucion}/editar', 'NotasDevolucionController@edit');
    Route::get('/{devolucion}/delete', 'NotasDevolucionController@destroy');
    Route::get('/{devolucion}/procesar', 'NotasDevolucionController@procesar');
    Route::get('/{devolucion}/validar-disponible', 'NotasDevolucionController@validarDisponibles');
    Route::get('/{devolucion}/ver', 'NotasDevolucionController@show');
    Route::get('/{devolucion}/anular', 'NotasDevolucionController@anular');
    Route::get('/relacion', 'NotasDevolucionController@relacion');
    Route::get('/relacion/{mes}/{anio}/{tipo}', 'NotasDevolucionController@relacion');
});


Route::middleware(['auth'])->prefix('reportes-ventas')->group(function () {

    Route::get('/', 'ReporteVentasController@index');
    Route::get('/agenda', 'ReporteVentasController@agenda');
    Route::post('/agenda', 'ReporteVentasController@agenda');
    Route::get('/agenda/{fecha_ini}/{fecha_fin}/{fecha_ref}/{vendedor}/{tipo}', 'ReporteVentasController@agenda');

    //    PLANILLA PRODUCCION
    Route::get('/planilla-produccion', 'ReporteVentasController@planillaProduccion');
    Route::post('/planilla-produccion', 'ReporteVentasController@planillaProduccion');
    Route::get('/produccion-diaria', 'ReporteVentasController@produccionDiaria');
    Route::post('/produccion-diaria', 'ReporteVentasController@produccionDiaria');
    Route::get('/produccion-organizacion', 'ReporteVentasController@produccionOrganizacion');
    Route::post('/produccion-organizacion', 'ReporteVentasController@produccionOrganizacion');

    Route::get('/produccion-mensual', 'ReporteVentasController@produccionMensual');
    Route::post('/produccion-mensual', 'ReporteVentasController@produccionMensual');

    Route::get('/comportamiento-ventas', 'ReporteVentasController@comportamientoVentas');
    Route::post('/comportamiento-ventas', 'ReporteVentasController@comportamientoVentas');

    Route::get('/relacion-vendidas', 'ReporteVentasController@relacionVendidas');
    Route::post('/relacion-vendidas', 'ReporteVentasController@relacionVendidas');



    Route::get('/comisiones-organizacion', 'ReporteVentasController@comisionesOrganizacion');
    Route::post('/comisiones-organizacion', 'ReporteVentasController@comisionesOrganizacion');
});

Route::middleware(['auth'])->prefix('devolucion-contratos')->group(function () {

    Route::get('/', 'DevolucionObrasController@devolucionVentas');
    Route::get('{devolucion}/delete', 'DevolucionObrasController@devolucionVentasDelete');
    Route::get('{devolucion}/ver', 'DevolucionObrasController@devolucionVentasVer');
    Route::get('{devolucion}/ver-notas', 'DevolucionObrasController@devolucionVentasVerNotas');
});

Route::middleware(['auth'])->prefix('central-riesgos')->group(function () {

    Route::get('/', 'CentralRiesgoController@index');
    Route::get('{deudor}/edit', 'CentralRiesgoController@edit');
    Route::get('{deudor}/delete', 'CentralRiesgoController@delete');
    Route::get('/mantenimiento', 'CentralRiesgoController@mantenimiento');
    Route::post('/store', 'CentralRiesgoController@store');
    Route::post('/pago-store', 'CentralRiesgoController@pagoStore');
    Route::post('/importar', 'CentralRiesgoController@importar');
});

//MODULO DE COBRANZAS
Route::middleware(['auth'])->prefix('cuentas')->group(function () {
    Route::get('/', 'CuentaController@index');
    Route::get('{credito}/editar', 'CuentaController@editar');
    Route::get('{credito}/ver-foto', 'CuentaController@verFoto');
    Route::post('editar', 'CuentaController@editarPost');
    Route::get('{credito}/ver-tarjeta', 'CuentaController@verTarjetaCobranza');
    Route::get('{credito}/ver-contrato', 'CuentaController@verContrato');
    Route::get('{credito}/ver-pagos', 'CuentaController@verPagos');
});

Route::middleware(['auth'])->prefix('cobradores')->group(function () {
    Route::get('/', 'CobradorController@index');
    Route::post('/', 'CobradorController@index');
    Route::get('{cobrador}/edit', 'CobradorController@edit');
    Route::get('{cobrador}/delete', 'CobradorController@destroy');
    Route::post('/store', 'CobradorController@store');
});

Route::middleware(['auth'])->prefix('pagos-cobranza')->group(function () {
    Route::get('/', 'PagoCobranzaController@index');
    Route::get('/registrar', 'PagoCobranzaController@registrar');
    Route::post('registrar', 'PagoCobranzaController@registrarPost');
    Route::post('store', 'PagoCobranzaController@store');
    Route::get('delete/{pago}', 'PagoCobranzaController@destroy');
    Route::post('editar', 'PagoCobranzaController@editar');
});

Route::middleware(['auth'])->prefix('devolucion-cobranza')->group(function () {
    Route::get('/', 'DevolucionCobranzaController@index');
    Route::get('create', 'DevolucionCobranzaController@create');
    Route::post('create', 'DevolucionCobranzaController@createPost');
    Route::post('store', 'DevolucionCobranzaController@store');
    Route::get('{devolucion}/delete', 'DevolucionCobranzaController@delete');
    Route::get('{devolucion}/ver', 'DevolucionCobranzaController@ver');
});

Route::middleware(['auth'])->prefix('cambio-obras')->group(function () {
    Route::get('/', 'CambioObraController@index');
    Route::get('create', 'CambioObraController@create');
    Route::post('create', 'CambioObraController@createPost');
    Route::post('store', 'CambioObraController@store');
    Route::get('/{cambio}/ver', 'CambioObraController@verNota');
});

Route::middleware(['auth'])->prefix('reportes-cobranza')->group(function () {
    Route::get('/', 'ReporteCobranzaController@index');
    Route::get('asignaciones-cobrador', 'ReporteCobranzaController@asignacionesCobrador');
    Route::post('asignaciones-cobrador', 'ReporteCobranzaController@asignacionesCobrador');

    Route::get('asignaciones-diaria', 'ReporteCobranzaController@asignacionesDiaria');
    Route::post('asignaciones-diaria', 'ReporteCobranzaController@asignacionesDiaria');

    Route::get('cuadro-produccion', 'ReporteCobranzaController@cuadroProduccion');
    Route::post('cuadro-produccion', 'ReporteCobranzaController@cuadroProduccion');

    Route::get('consolidado-cartera', 'ReporteCobranzaController@consolidadoCartera');
    Route::post('consolidado-cartera', 'ReporteCobranzaController@consolidadoCartera');

    Route::get('relacion-nuevas', 'ReporteCobranzaController@relacionNuevas');
    Route::post('relacion-nuevas', 'ReporteCobranzaController@relacionNuevas');


    Route::get('cuentas-canceladas', 'ReporteCobranzaController@cuentasCanceladas');
    Route::post('cuentas-canceladas', 'ReporteCobranzaController@cuentasCanceladas');

    Route::get('relacion-devoluciones', 'ReporteCobranzaController@relacionDevoluciones');
    Route::post('relacion-devoluciones', 'ReporteCobranzaController@relacionDevoluciones');

    Route::get('prontopago', 'ReporteCobranzaController@prontoPago');
    Route::post('prontopago', 'ReporteCobranzaController@prontoPago');

    Route::get('cuentas-nuevas', 'ReporteCobranzaController@cuentasNuevas');
    Route::post('cuentas-nuevas', 'ReporteCobranzaController@cuentasNuevas');

    Route::get('pagos', 'ReporteCobranzaController@relacionPagos');
    Route::post('pagos', 'ReporteCobranzaController@relacionPagos');


    Route::get('incobrables', 'ReporteCobranzaController@incobrables');
    Route::post('incobrables', 'ReporteCobranzaController@incobrables');

    Route::get('relacion-cambio-obra', 'ReporteCobranzaController@relacionCambioObra');
    Route::post('relacion-cambio-obra', 'ReporteCobranzaController@relacionCambioObra');
});

Route::middleware(['auth'])->prefix('referencias')->group(function () {
    Route::get('/', 'CuentaController@referencias');
    Route::get('/descargar-foto/{foto}', 'CuentaController@descargarFoto');
    Route::post('/', 'CuentaController@referencias');
    Route::post('/store', 'CuentaController@referenciasStore');
    Route::post('/store-image', 'CuentaController@referenciasStoreImage');
});

Route::middleware(['auth'])->prefix('cierres')->group(function () {
    Route::get('/', 'CierreAperturaController@index');
    Route::get('{cierre}/edit', 'CierreAperturaController@edit');
    Route::get('{cierre}/delete', 'CierreAperturaController@destroy');
    Route::post('/store', 'CierreAperturaController@store');
});


Route::middleware(['auth'])->prefix('mantenimiento-cuentas')->group(function () {
    Route::get('/', 'MantenimientoCuentasController@index');
    Route::post('/procesar', 'MantenimientoCuentasController@procesar');
});


Route::middleware(['auth'])->prefix('refinanciamiento-cuentas')->group(function () {
    Route::get('/', 'RefinanciamientoController@index');
    Route::get('/guardar', 'RefinanciamientoController@guardarRefinanciamiento');
    Route::get('/guardar-diaspago', 'RefinanciamientoController@cambiarDiaCobro');
    Route::post('/procesar', 'MantenimientoCuentasController@procesar');
});


Route::middleware(['auth'])->prefix('backups')->group(function () {

    Route::get('/', 'BackupController@index');
    Route::get('/create', 'BackupController@create');

    Route::get('/download-local/{backup}', 'BackupController@downloadLocal');
    Route::get('/download-nube/{id}', 'BackupController@downloadNube');
    Route::get('/cloud', 'BackupController@cloud');
});
Route::get('/configuraciones', 'ConfiguracionController@index');
Route::post('/configuraciones', 'ConfiguracionController@store');


Route::get('cloud', 'BackupController@prueba');
Route::get('oauth', function () {
    return 'asd';
});











Route::get('regularizar-inventario', function () {
    $libros = \App\Libro::orderBy('codigo', 'ASC')->get();
    $datos = [];
    foreach ($libros as $k => $v) {
        $ingresos = \DB::table('view_ingreso_detalle')
            ->where('terminado', '1')
            ->where('codigo', $v->codigo)
            ->where('estado', 'T')->sum('cantidad');
        $egresos = \DB::table('view_egreso_detalle')
            ->where('terminado', '1')
            ->where('codigo', $v->codigo)
            ->where('estado', 'T')->sum('cantidad');
        $devoluciones = \DB::table('view_devolucion_detalle')
            ->where('terminado', '1')
            ->where('codigo', $v->codigo)
            ->where('estado', 'T')->sum('cantidad');

        $remisiones = \DB::table('view_remision_detalle')

            ->where('codigo', $v->codigo)
            ->where('estado', 'T')->sum('cantidad');
        $stock = ($ingresos + $devoluciones) - ($remisiones + $egresos);
        $v->stock = $stock;
        $v->save();
        //        $datos[]=[
        //            $v->codigo,
        //            $stock,
        //            $ingresos,
        //            $egresos,
        //            $devoluciones,
        //            $remisiones
        //        ];

    }
    //    return dd($datos);
});

Route::get('regularizar-credito', function () {
    \Excel::load('CONSOLIDADO.xlsx', function ($reader) {

        try {

            $f = [];
            \Illuminate\Support\Facades\DB::beginTransaction();

            foreach ($reader->get() as $k => $filas) {
                foreach ($filas as $k2 => $fila) {


                    if (!is_null($fila->cod_cl)) {

                        // return dd($fila->dia_de_cobranza);


                        $c = new \App\Credito();

                        $c->cuotainicial = 0;
                        $c->numcuotas = 1;
                        $c->montocuotas = $fila->cuota_mensual;
                        $c->montocomision = 0;
                        $c->saldo = $fila->saldo_ini;
                        $c->saldocuota = 0;
                        $c->numreporte = 0;
                        $c->valorcomisionable = 0;
                        $c->contrato_id = 0;
                        $c->numcuenta = round($fila->cod_cl, 0);
                        $c->numdocumento = 0;
                        $c->tipodoc = 'RECIBO';
                        if (!is_null($fila->fecha_de_venta))
                            $c->fechadoc = $fila->fecha_de_venta->format('d/m/Y');

                        $c->montodoc = 0;
                        if (!is_null($fila->fecha_de_venta))
                            $c->fechacobranza = $fila->fecha_de_venta->format('d/m/Y');
                        $c->cuentacomision = 0;
                        $c->estado = 'C';
                        if (!is_null($fila->fecha_de_venta))
                            $c->fechacuotas = $fila->fecha_de_venta->format('d/m/Y');
                        $c->dias = 30;
                        $c->saldo_inicial = $fila->valor_de_la_venta;
                        $c->diacobrar = round($fila->dia_de_cobranza, 0);
                        $c->valor_venta = $fila->valor_de_la_venta;
                        $c->nombre_cliente = $fila->nombre_del_cliente;
                        $c->tiene_contrato = 0;
                        $c->vendedor_id = 0;
                        $c->vendedor_nombre = $fila->vendedor;



                        switch ($fila->cobrador) {
                            case 'C. WILLIS':
                                $c->cobrador_id = 4;
                                break;
                            case 'G. FLORES':
                                $c->cobrador_id = 5;
                                break;
                            case 'J. GAMBOA':
                                $c->cobrador_id = 15;
                                break;
                            case 'J. ZEBALLO':
                                $c->cobrador_id = 7;
                                break;
                            case 'L. PEREZ':
                                $c->cobrador_id = 16;
                                break;
                            case 'M. ROJAS':
                                $c->cobrador_id = 17;
                                break;
                            case 'OFICINA':
                                $c->cobrador_id = 19;
                                break;
                            case 'R. CHOQUE':
                                $c->cobrador_id = 11;
                                break;
                            case 'R. FERNANDEZ':
                                $c->cobrador_id = 12;
                                break;
                            case 'P. DIAZ':
                                $c->cobrador_id = 9;
                                break;
                            case 'R. ROJAS':
                                $c->cobrador_id = 10;
                                break;
                            default:
                                $c->cobrador_id = 0;
                        }


                        $c->save();

                        $pago = new \App\Pago();
                        $pago->monto = round($fila->valor_de_la_venta - $fila->saldo_final, 2);
                        if (!is_null($fila->fup))
                            $pago->fecha = $fila->fup->format('d/m/Y');
                        $pago->num_reporte = '';
                        $pago->estado = 'T';
                        $pago->numrecibo = '';
                        $pago->terminado = 1;
                        $pago->obs = '';
                        $pago->model_type = 'pago-cobranza';
                        $pago->model_id = $c->id;
                        $pago->cobrador_id = $c->cobrador_id;
                        $pago->save();

                        //   \DB::rollBack();
                    }
                }
            }

            \DB::commit();

            return dd('bien');
        } catch (Exception $e) {

            \DB::rollBack();

            return dd($e);
        }
    });
});

Route::get('importar-deudas', function () {
    \Excel::load('deudas.xlsx', function ($reader) {

        foreach ($reader->get() as $fila) {


            try {

                \Illuminate\Support\Facades\DB::beginTransaction();

                $d = new \App\Deudor();
                $d->nombres = $fila->primer_nombre . ' ' . $fila->segundo_nombre;
                $d->apellidos = $fila->apellido_paterno . ' ' . $fila->apellido_materno;
                $d->tipo_documento = $fila->tipo_documento;
                $d->num_documento = $fila->nro_documento;
                $d->lugar_doc = $fila->ext;
                $d->ape_casado = $fila->apellido_casada;
                $d->tipo_operacion = $fila->tipo_operacion;
                $d->tipo_cambio = $fila->tipo_cambio;
                $d->moneda = $fila->moneda;
                $d->monto_original_deuda = $fila->monto_original;
                $d->concepto = $fila->concepto;
                $d->tipo_doc_deuda = $fila->tipo_doc_deuda;
                $d->num_doc_deuda = $fila->nro_doc_deuda;
                $d->saldo_deuda_vigente = $fila->vigente;
                $d->saldo_deuda_vencida = $fila->vencida;
                $d->fecha_ingreso_vencida = $fila->fecha_ing_vencida->format('Y-m-d');
                $d->razon_social = $fila->razon_social;
                $d->save();
                \DB::commit();
            } catch (Exception $e) {
                \DB::rollBack();
            }
        }
    });
});