<?php $__env->startSection('title'); ?> PAGOS <?php $__env->stopSection(); ?>
<?php $__env->startSection('titulo'); ?> REGISTRAR PAGOS <?php $__env->stopSection(); ?>
<?php $__env->startSection('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/librerias/easy-autocomplete/easy-autocomplete.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/librerias/easy-autocomplete/easy-autocomplete.themes.css')); ?>">

<?php $__env->stopSection(); ?>


<?php $__env->startSection('descripcion'); ?>
<ol class="breadcrumb breadcrumb-arrow">
    <li class="breadcrumb-item"><a href="<?php echo e(url('/')); ?>">Inicio</a></li>
    <li class="breadcrumb-item ">Cobranza</li>
    <li class="breadcrumb-item "><a href="<?php echo e(url('/pagos-cobranza')); ?>">Pagos</a></li>
    <li class="breadcrumb-item active"><a href="<?php echo e(url('/cuentas')); ?>">Registrar Pago</a></li>
</ol>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<?php echo $__env->make('includes.modal-ver', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<form class="form-inline" method="GET" action="<?php echo e(url('pagos-cobranza/registrar')); ?>">


    <div class="form-group col-md-4 ">
        <div class="row">
            <div class="form-row col-md-12">
                <input type="text" name="numcuenta" <?php if(isset($criterio)): ?> value="<?php echo e($criterio); ?>" <?php endif; ?>
                    placeholder="Criterio de busqueda" style="width:150%" class="numcuenta  form-control">
                <input type="hidden" name="credito_id" class="credito_id" value="">
            </div>
            <div class="form-row col-md-12">
                <label for="">Numero de Cuenta <input type="radio" class=" radio-inline tipo_numero" CHECKED name="tipo"
                        value="numcuenta"></label>
                <label for="">Nombres <input type="radio" class=" radio-inline tipo_apellidos" name="tipo"
                        value="apellidos"></label>
            </div>

        </div>
    </div>
    <div class="form-group ">
        <button type="submit" name="buscar" style="margin-top: -23px;" value="buscar"
            class="btn btn-outline-info waves-effect waves-light waves-round"> <i
                class="icon md-search"></i>Consultar</button>
    </div>
</form>

<?php if(isset($credito) && !is_null($credito)): ?>
<hr>
<div class="table-responsive col-md-10">
    <?php echo $__env->make('cobranza.includes.detalle-cuenta', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

</div>
<hr>
<div class="row">



    <div class="col-md-6 row">
        <div class="col-md-6">
            <h5 class="alert alert-info text-primary text-center">HISTORIAL DE PAGOS</h5>
            <table class="table table-condensed" style="font-size: 10px;">
                <thead>
                    <tr style="font-weight: bolder">
                        <td>FECHA</td>
                        <td>NUM RECIBO</td>
                        <td>NUM REPORTE</td>
                        <td>MONTO</td>
                        <td>SALDO</td>
                        <td>ACCIONES</td>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $saldo=$credito->saldo_inicial;
                    ?>
                    <?php $__currentLoopData = $pagos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($p->fecha->format('d/m/Y')); ?></td>
                        <td align="center">
                            <?php if(isset($p->recibo)): ?>
                            <?php echo e($p->recibo->numero); ?>

                            <?php endif; ?>
                        </td>
                        <td>
                            <?php echo e($p->num_reporte); ?>

                        </td>
                        <td align="right">

                            <?php echo e($p->monto); ?>


                        </td>
                        <?php $saldo-=$p->monto ?>
                        <td align="right"><?php echo e(round($saldo,2)); ?></td>
                        <td>
                            <div class="btn-group" role="group" aria-label="Basic example">

                                <a href="<?php echo e(url('pagos-cobranza/delete')); ?>/<?php echo e($p->id); ?>"
                                    class="btn-eliminar btn btn-xs btn-danger"><i class="icon md-delete"></i></a>
                                <a href="#modal-<?php echo e($p->id); ?>" data-toggle="modal" class="btn btn-xs btn-primary"><i
                                        class="icon md-edit"></i></a>

                            </div>
                            

                            <div id="modal-<?php echo e($p->id); ?>" class="modal fade" style="z-index: 10000" role="dialog"
                                aria-labelledby="my-modal-title" aria-hidden="true">
                                <div class="modal-dialog" role="document">
                                    <form action="<?php echo e(url('pagos-cobranza/editar')); ?>" method="POST">
                                        <input type="hidden" name="id" value="<?php echo e($p->id); ?>">
                                        <?php echo e(csrf_field()); ?>

                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="my-modal-title">Editar Pago</h5>
                                                <button class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body ">
                                                <div class="form-group  form-row">
                                                    <div class="col-md-12">
                                                        <label for="">A NOMBRE DE QUIEN ES EL RECIBO</label>
                                                        <input type="text" name="nombres"
                                                            value="<?php if(isset($p->recibo->nombres)): ?> <?php echo e($p->recibo->nombres); ?> <?php endif; ?>"
                                                            class="nombres form-control">
                                                    </div>
                                                </div>
                                                <div class="form-group  form-row">
                                                    <div class="col-md-2">
                                                        <label for="">NUM RECIBO</label>
                                                        <input type="text" autofocus
                                                            value="<?php if(isset($p->recibo->numero)): ?> <?php echo e($p->recibo->numero); ?> <?php endif; ?>"
                                                            name="numrecibo" class="recibo form-control">
                                                    </div>
                                                    <div class="col-md-2">
                                                        <label for="">FECHA RECIBO</label>
                                                        <input type="text" name="fecha"
                                                            value="<?php echo e($p->fecha->format('d/m/Y')); ?>"
                                                            class="fecha datepicker form-control">
                                                    </div>
                                                    <div class="col-md-3">
                                                        <label for="">IMPORTE PAGADO</label>
                                                        <input type="text" name="monto" value="<?php echo e($p->monto); ?>"
                                                            class="monto numeroscondecimales form-control">
                                                    </div>
                                                    <div class="col-md-2">
                                                        <label for="">N° REPORTE</label>
                                                        <input type="text" name="reporte" value="<?php echo e($p->num_reporte); ?>"
                                                            class="reporte form-control">
                                                    </div>

                                                </div>
                                                <div class="form-group  form-row">
                                                    <div class="col-md-6">
                                                        <label for="">QUIEN COBRO</label>
                                                        <select name="cobrador" class="form-control " id="">
                                                            <option value="">SELECCIONE</option>
                                                            <?php $__currentLoopData = $cobradores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($c->id); ?>" <?php if($p->cobrador_id==$c->id): ?>
                                                                selected <?php endif; ?>><?php echo e($c->nombre_completo); ?></option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </select>
                                                    </div>


                                                    <div class="col-md-6">
                                                        <label for="">OBSERVACIONES</label>
                                                        <textarea name="obs" class="form-control"><?php echo e($p->obs); ?></textarea>
                                                    </div>
                                                </div>



                                            </div>
                                            <div class="modal-footer">
                                                <button class="btn btn-dark" data-dismiss="modal"
                                                    type="button">Cerrar</button>
                                                <button class="btn btn-primary" type="submit">Guardar</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
        </div>
        </td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
        </table>

    </div>
    <div class="col-md-6">

        <h5 class="alert alert-info text-primary text-center">PLAN DE PAGOS</h5>
        <table class="table table-condensed">
            <thead>
                <tr style="font-weight: bolder">
                    <td>FECHA</td>
                    <td>CUOTA</td>
                    <td>MONTO</td>
                    <td>SALDO</td>
                </tr>
            </thead>
            <tbody>
                <?php $saldo=$credito->saldo_inicial;
                ?>
                <?php $__currentLoopData = $cuotas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e(\Carbon\Carbon::createFromFormat('Y-m-d',$p['fecha'])->format('d/m/Y')); ?></td>
                    <td align="center"><?php echo e($p['numcuota']); ?></td>
                    <td align="right"><?php echo e($p['monto']); ?></td>
                    <td align="right"><?php echo e(round($saldo-$p['monto'],2)); ?></td>

                </tr>
                <?php
                $saldo-=$p['monto'];
                ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
    <?php if(count($descuentos)>0): ?>

    <div class="col-md-6">

        <h5 class="alert alert-info text-primary text-center">DESCUENTOS</h5>
        <table class="table table-condensed" style="font-size: 10px;">
            <thead>
                <tr style="font-weight: bolder">
                    <td>FECHA</td>
                    <td>NUMRECIBO</td>
                    <td>NUMREPORTE</td>
                    <td>MONTO</td>

                </tr>
            </thead>
            <tbody>

                <?php $__currentLoopData = $descuentos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($p->fecha->format('d-m-Y')); ?></td>
                    <td align="center"><?php echo e($p->pago->numrecibo); ?></td>
                    <td align="right"><?php echo e($p->pago->num_reporte); ?></td>
                    <td align="right"><?php echo e(round($p->monto,2)); ?></td>

                </tr>

                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
    <?php endif; ?>

    <?php if(count($devoluciones)>0): ?>

    <div class="col-md-6">

        <h5 class="alert alert-info text-primary text-center">DEVOLUCIONES</h5>
        <table class="table table-condensed" style="font-size: 10px;">
            <thead>
                <tr style="font-weight: bolder">
                    <td>FECHA</td>
                    <td>TIPO</td>
                    <td>MONTO</td>

                </tr>
            </thead>
            <tbody>

                <?php $__currentLoopData = $devoluciones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($d->fecha->format('d-m-Y')); ?></td>
                    <td align="center"><?php echo e($d->tipo); ?></td>
                    <td align="right"><?php echo e(round($d->monto_devolucion,2)); ?></td>

                </tr>

                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
    <?php endif; ?>
    <?php if(count($cambio_obras)>0): ?>

    <div class="col-md-6">

        <h5 class="alert alert-warning text-center">CAMBIO OBRAS</h5>
        <table class="table table-condensed" style="font-size: 10px;">
            <thead>
                <tr style="font-weight: bolder">
                    <td>NUMERO</td>
                    <td>FECHA</td>
                    <td>#INGRESO</td>
                    <td>#EGRESO</td>
                    <td>TIPO SALDO</td>
                    <td>MONTO </td>


                </tr>
            </thead>
            <tbody>

                <?php $__currentLoopData = $cambio_obras; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($c->id); ?><a href="<?php echo e(url('cambio-obras/'.$c->id.'/ver')); ?>"
                            class="btn-ver-nota btn btn-icon btn-pure btn-default on-default remove-row waves-effect waves-light waves-round"
                            data-toggle="tooltip" data-original-title="Ver nota "><i class="icon md-open-in-new"
                                aria-hidden="true"></i></a></td>
                    <td><?php echo e($c->fecha->format('d-m-Y')); ?></td>
                    <td align="center"><strong><?php echo e($c->numingreso); ?><strong>
                    </td>
                    <td align="center"><strong><?php echo e($c->numegreso); ?><strong>
                    </td>
                    <td align="center" class=""><strong><?php echo e($c->tipo_saldo); ?><strong>
                    </td>
                    <td align="center"><strong><?php echo e($c->monto_tipo_saldo); ?></<strong>
                    </td>


                </tr>

                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
    <?php endif; ?>
</div>
<div class="col-md-6">
    <?php if($credito->saldo>0): ?>
    <form action="<?php echo e(url('pagos-cobranza/store')); ?>" method="POST" class="form" style="font-size: 0.9em">
        <?php echo csrf_field(); ?>

        <input type="hidden" name="credito_id" value="<?php echo e($credito->id); ?>">
        <div class="form-group  form-row">
            <div class="col-md-12">
                <label for="">A NOMBRE DE QUIEN ES EL RECIBO</label>
                <input type="text" name="nombres" value="<?php echo e($credito->nombre_cliente); ?>" class="nombres form-control">
            </div>
        </div>
        <div class="form-group  form-row">
            <div class="col-md-2">
                <label for="">NUM RECIBO</label>
                <input type="text" autofocus name="numrecibo" class="recibo form-control">
            </div>
            <div class="col-md-2">
                <label for="">FECHA RECIBO</label>
                <input type="text" name="fecha" class="fecha fecha-recibo datepicker form-control">
            </div>
            <div class="col-md-3">
                <label for="">IMPORTE PAGADO</label>
                <input type="text" name="monto" class="monto-pago numeroscondecimales form-control">
            </div>
            <div class="col-md-2">
                <label for="">N° REPORTE</label>
                <input type="text" name="reporte" class="reporte form-control">
            </div>

        </div>
        <div class="form-group  form-row">
            <div class="col-md-6" style="z-index=-1000">
                <label for="">QUIEN COBRO</label>
                <select name="cobrador" class="form-control select2" id="">
                    <option value="">SELECCIONE</option>
                    <?php $__currentLoopData = $cobradores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($c->id); ?>" <?php if(isset($credito->cobrador) && $credito->cobrador->id==$c->id): ?> selected
                        <?php endif; ?>><?php echo e($c->nombre_completo); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>


            <div class="col-md-6">
                <label for="">OBSERVACIONES</label>
                <textarea name="obs" class="form-control"></textarea>
            </div>
        </div>

        <button type="button" class="btn btn-info btn-registrar-descuento"> + Registrar Descuento</button>

        <div class="div-descuento form-row" style="display: none">
            <div class="col-md-12">
                <h5 class="label label-primary text-center"><strong>REGISTRAR DESCUENTO</strong></h5>
            </div>
            <div class="col-md-4">
                <label for="">TIPO DESCUENTO</label>
                <input type="text" READONLY value="PRONTO PAGO" name="tipo_descuento"
                    class="tipo-descuento form-control">
            </div>

            <div class="col-md-2">
                <label for="">MONTO PAGO</label>
                <input type="text" name="monto_descuento" class="monto-descuento  numeroscondecimales form-control">
            </div>
            <div class="col-md-2">
                <label for="">&nbsp;</label>
                <button type="button" class="btn btn-danger btn-cancelar-descuento"
                    style="margin-top: 20px">Cancelar</button>
            </div>

        </div>
        <hr>

        <button type="submit" class="btn btn-guardar btn-primary btn-block"> GUARDAR</button>


    </form>
    <?php else: ?>
    <h4 class="alert alert-info"> LA CUENTA NO TIENE SALDO PENDIENTE</h4>
    <?php endif; ?>
</div>



</div>
<?php endif; ?>
<?php $__env->startSection('scripts'); ?>
<script src="<?php echo e(asset('assets/librerias/easy-autocomplete/jquery.easy-autocomplete.js')); ?>"></script>

<script>
    var pagos=[];

        <?php if(isset($pagos)): ?>

                        <?php $__currentLoopData = $pagos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                            <?php if(isset($p->recibo)): ?>
                        pagos.push('<?php echo e($p->recibo->numero); ?>')
                            <?php endif; ?>


                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <?php endif; ?>





        var options = {
             theme:'dark',
            url: "../common/buscar-cuenta",


            getValue: function(element) {
                console.log(element);
                return 'Cuenta:'+element.numcuenta+' Cliente: '+element.nombre_cliente;
            },

            ajaxSettings: {
                dataType: "json",
                method: "GET",
                data: {
                    dataType: "json"
                }
            },
            list: {
                maxNumberOfElements: 1000,
                onSelectItemEvent: function() {
                    var value = $(".numcuenta").getSelectedItemData().id;

                    $(".credito_id").val(value);
                }
            },

            preparePostData: function(data) {

                let tipo='numero';
                if($('.tipo_apellidos').is(':checked')){
                    tipo='apellidos'
                }
                else {
                    tipo='numero';
                }
                data.term = $(".numcuenta").val();
                data.tipo = tipo;
                return data;
            },

            requestDelay: 200
        };

         $('.btn-registrar-descuento').click(function(){
             $(this).hide();
             $('.div-descuento').show()
             $('.monto-descuento').focus()

         })
        $('.btn-cancelar-descuento').click(function(){
            $('.div-descuento').hide()
            $('.btn-registrar-descuento').show()
            $('.monto-descuento').val('')
        })


        $(".numcuenta").easyAutocomplete(options);
        $(".numcuenta").focus(function(){
            $(this).val('')
        });
        $('.select2').select2({
            placeholder: 'Seleccione una opcion',
            multiple:false,
            width:'90%'
        });

            $('.fecha').change(function(){

                var _fecha=$(this)
             $.ajax({
             url:"<?php echo e(url('common/validar-cierre')); ?>",
             data:{fecha:_fecha.val(),modulo:'COBRANZA'},
             dataType:'json',
             method:'GET',
             async:false,
        

         })
         .done(function(res){
             if(!res){
                         swal('Alerta','No esta permitido registrar en la fecha seleccionada','warning')
                         _fecha.val('')
                        return false;
                        
                    }      
              
         }).fail(function(){
             alert('exisitio un error')
         })

            })

            $('.btn-ver-nota').click(function(_evt){
            _evt.preventDefault();
            let _url=$(this).attr('href')
            
            $.ajax({
            url:_url,
            method:'GET',
            dataType:'html',
            success:function(res)
            {
            $('.modal-ver').find('.modal-body').empty();
            $('.modal-ver').find('.modal-body').append(res)
            $('.modal-ver').modal('show')
            
            }
            })
            })

        $('.btn-guardar').click(function(_evt){
            _evt.preventDefault();
            <?php if(isset($credito)): ?>
            var saldo=parseFloat(<?php echo e($credito->saldo); ?>)
          
            <?php endif; ?>

            var monto =parseFloat($('.monto-pago').val());
                 
            let recibo=$('.recibo').val();
            if($('.monto-pago').val()==''){
                swal('Alerta','Ingrese un monto para el pago','warning')
                return false;

            }
            if($('.fecha-recibo').val()==''){
                swal('Alerta','Ingrese una fecha de recibo','warning')
                return false;

            }
              if(monto>saldo){
                     swal('Alerta','el monto del pago no puede ser mayor al saldo actual','warning')
                        return false;
                   }
            if($('.fecha').val()==''){
                swal('Alerta','Ingrese una fecha','warning')
                return false;

            }
              console.log(pagos.indexOf(recibo),recibo,pagos)


            if(pagos.indexOf(recibo)!=-1){
                 swal('Alerta','El numero de recibo ya se encuentra registrado','warning')
                return false;
            }


            swal({
                    title: "Registro de Pago",
                    text: "Se registrara el pago?",
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonClass: "btn-danger",
                    confirmButtonText: "Si, Registrar",
                    cancelButtonText:"Cancelar",
                    closeOnConfirm: false
                },
                function(){
                    $('.form').submit()
                });
        })

        $('.btn-eliminar').click(function(_evt){
            _evt.preventDefault()
            let url=$(this).attr('href')
            swal({
                    title: "Eliminar Pago",
                    text: "Se eliminara el pago. Esta Seguro?",
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonClass: "btn-danger",
                    confirmButtonText: "Si, Eliminar",
                    cancelButtonText:"Cancelar",
                    closeOnConfirm: false
                },
                function(){
                    window.location=url
                });
        })





</script>
<?php $__env->stopSection(); ?>


<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\libros\resources\views/cobranza/pagos/registrar.blade.php ENDPATH**/ ?>