<?php $__env->startSection('styles'); ?>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('title'); ?>NOTAS DE REMISION <?php $__env->stopSection(); ?>
<?php $__env->startSection('titulo'); ?>NOTAS DE REMISION <?php $__env->stopSection(); ?>
<?php $__env->startSection('menu-remision'); ?>active open <?php $__env->stopSection(); ?>


<?php $__env->startSection('acciones'); ?>
<a href="<?php echo e(url('notas-remision/create')); ?>" class=" btn-create btn btn-primary waves-effect waves-light waves-round" type="button"> <i class="icon md-plus"></i>Nueva Remision</a>


<?php $__env->stopSection(); ?>
<?php $__env->startSection('descripcion'); ?>
<ol class="breadcrumb breadcrumb-arrow">
    <li class="breadcrumb-item"><a href="<?php echo e(url('/')); ?>">Inicio</a></li>
    <li class="breadcrumb-item ">Almacenes</li>
    <li class="breadcrumb-item active"><a href="<?php echo e(url('/notas-remision')); ?>">Notas de Remision</a></li>
</ol>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>



<div class="nav navbar-nav float-xs-right">
    <form class="form-inline pull-right" method="get" action="<?php echo e(url('notas-remision')); ?>">
        <?php echo $__env->make('includes.form-periodo', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="form-group form-material">
            <button type="submit" class="btn btn-outline-info waves-effect waves-light waves-round"> <i class="icon md-search"></i>Consultar</button>
        </div>
    </form>
</div>
<?php if(Session::has('errorLibros')): ?>
<BR>
<h4>LISTA DE LIBROS QUE NO TIENEN INVENTARIO</h4>
<ul class="alert alert-warning list-unstyled">
    <?php $__currentLoopData = Session::get('errorLibros'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <li><?php echo e($error['libro']->codigo); ?> <?php echo e($error['libro']->titulo); ?> - <strong>CANTIDAD SOBRE EL INVENTARIO</strong> : <?php echo e($error['overqty']); ?></li>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</ul>
<?php endif; ?>

<div class="table-responsive">

    <table id="table" class="data-table table table-hover  table-striped">
        <thead>
            <tr>
                <th>FECHA</th>
                <th>NUMERO</th>
                <th>VENDEDOR</th>
                <th>ESTADO</th>
                <th>ACCIONES</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $datos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $f=>$r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($r->fecha->format('d/m/Y')); ?></td>
                <td width="1%"><?php echo e($r->id); ?></td>
                <td><?php echo e($r->vendedor->nombre_completo); ?></td>
                <td><?php echo e($r->estado); ?></td>
                <td>
                    <?php if($r->estado=='CREADO'): ?>
                    <a a href="notas-remision/<?php echo e($r->id); ?>/editar" class=" btn  btn-icon btn-pure btn-warning on-default edit-row waves-effect waves-light waves-round" data-toggle="tooltip" data-original-title="Editar"><i class="icon md-edit" aria-hidden="true"></i></a>
                    <a href="notas-remision/<?php echo e($r->id); ?>/delete" id="<?php echo e($r->id); ?>" class="btn-delete btn  btn-icon btn-pure btn-default on-default remove-row waves-effect waves-light waves-round" data-toggle="tooltip" data-original-title="Eliminar"><i class="icon md-delete" aria-hidden="true"></i></a>
                    <a href="notas-remision/<?php echo e($r->id); ?>/procesar" class="btn-procesar btn btn-icon btn-pure btn-success on-default remove-row waves-effect waves-light waves-round" data-toggle="tooltip" data-original-title="Procesar"><i class="icon md-check-circle" aria-hidden="true"></i></a>
                    <?php endif; ?>
                    <a href="notas-remision/<?php echo e($r->id); ?>/ver" class="btn-ver btn btn-icon btn-pure btn-primary on-default remove-row waves-effect waves-light waves-round" data-toggle="tooltip" data-original-title="Ver Nota"><i class="icon md-open-in-new" aria-hidden="true"></i></a>
                    <?php if($r->estado=='PROCESADO'): ?>
                    <a href="notas-remision/<?php echo e($r->id); ?>/anular" id="<?php echo e($r->id); ?>" class="btn-anular btn btn-icon btn-pure btn-danger on-default remove-row waves-effect waves-light waves-round" data-toggle="tooltip" data-original-title="Anular Nota"><i class="icon md-block" aria-hidden="true"></i></a>
                    <button onclick="cargarModalKardex('remision',<?php echo e($r->id); ?>)" class=" btn-verkardex  btn btn-info btn-icon btn-pure btn-dark on-default remove-row waves-effect waves-light waves-round" data-target="#" data-toggle="modal" type="button">K</button>


                    <?php endif; ?>

                </td>

            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>


<div class="modal-ver modal fade modal-slide-in-right" id="exampleNiftySlideFromRight" aria-hidden="true" aria-labelledby="exampleModalTitle" role="dialog" tabindex="-1">
    <div class="modal-dialog modal-simple">
        <div class="modal-content">

            <div class="modal-body">

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-danger " data-dismiss="modal">Cerrar</button>

            </div>
        </div>
    </div>
</div>

<?php echo $__env->make('includes.modal-kardex', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->startSection('scripts'); ?>
<script src="<?php echo e(asset('assets/js/jquery.PrintArea.js')); ?>" type="text/javascript"></script>

<script>
    function alerta(id) {
        $.ajax({
            url: './libros/' + id + '/edit',
            method: 'GET',
            dataType: 'html',
            success: function(res) {
                $('.modales').empty();
                $('.modales').append(res)
                $('.modal-edit').modal('show')
                select2();
            },
            error: function() {
                alert('ocurrio un error')
            }
        })

    }

    function imprimir() {
        var options = {
            mode: "iframe",
            popClose: close,
            retainAttr: ['class', 'style', 'id']
        };

        $('#myPrintArea').printArea();


    }


    function imprimirNota(id) {
        let url = 'notas-remision/' + id + '/ver'
        $.ajax({
            url: url,
            method: 'GET',
            dataType: 'HTML',
            async: false,
            cache: false,
            success: function(res) {

                $('.modal-ver').find('.modal-body').empty();
                $('.modal-ver').find('.modal-body').html(res)
                $('.modal-ver').modal('show')

            }
        })
    }
    $(document).ready(function() {
        // $(".data-table").tableHeadFixer();




        <?php if(isset($imprimir) && $imprimir): ?>
        imprimirNota(<?php echo e($remision); ?>)
        <?php endif; ?>


        $('.btn-anular').click(function(_evt) {
            _evt.preventDefault();
            let _href = $(this).attr('href')
            let _id = $(this).attr('id')
            swal({
                    title: "Esta seguro?",
                    text: "Se anulara la Remision Num:" + _id,
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonClass: "btn-warning",
                    confirmButtonText: "Si, Anular!",
                    cancelButtonText: "Cancelar",
                    closeOnConfirm: false
                },
                function() {
                    $.ajax({
                        url: './notas-remision/' + _id + '/validar-anular',
                        method: 'get',
                        dataType: 'json',
                        success: function(res) {
                            if (res.status) {

                                swal('Alerta', 'No se puede anular la nota. Existen items  asociados a otras notas', 'warning')

                            } else {
                                window.location = _href

                            }

                        },
                        error: function() {
                            alert('Ocurrio un error en el servidor')
                        }
                    })



                });


        });

        $('.btn-ver').click(function(_evt) {
            _evt.preventDefault();
            let url = $(this).attr('href')
            $.ajax({
                url: url,
                method: 'GET',
                dataType: 'HTML',
                async: false,
                cache: false,
                success: function(res) {

                    $('.modal-ver').find('.modal-body').empty();
                    $('.modal-ver').find('.modal-body').html(res)
                    $('.modal-ver').modal('show')

                }
            })
        });

        $('.btn-procesar').click(function(_evt) {
            _evt.preventDefault();
            _href = $(this).attr('href')

            swal({
                    title: "Esta seguro?",
                    text: "Se Procesara esta nota de remision  y ya no  podra editar:",
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonClass: "btn-danger",
                    confirmButtonText: "Si, Procesar!",
                    cancelButtonText: "Cancelar",
                    closeOnConfirm: false
                },
                function() {
                    window.location = _href
                });

        })



        var select2 = function() {


            $('body .select2').select2({
                placeholder: 'Seleccione una opcion',
                multiple: false,
                width: '90%'
            });

        }


        $('.btn-delete').click(function(_evt) {
            _evt.preventDefault();

            var _href = $(this).attr('href')
            var _id = $(this).attr('id')


            swal({
                    title: "Esta seguro?",
                    text: "Se eliminara la nota de remision Num:" + _id,
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonClass: "btn-danger",
                    confirmButtonText: "Si, Eliminar!",
                    cancelButtonText: "Cancelar",
                    closeOnConfirm: false
                },
                function() {
                    window.location = _href
                });

        })





        $('.btn-create').click(function() {
            $('.modal-create').modal('show')
            select2()
        })



        $('body .btn-edit').on('click', function() {
            var id = $(this).attr('id')


            $.ajax({
                url: './libros/' + id + '/edit',
                method: 'GET',
                dataType: 'html',
                success: function(res) {
                    $('.modales').empty();
                    $('.modales').append(res)
                    $('.modal-edit').modal('show')
                    select2();
                },
                error: function() {
                    alert('ocurrio un error')
                }
            })
        })
    })
</script>
<?php $__env->stopSection(); ?>


<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\libros\resources\views/almacen/remision/index.blade.php ENDPATH**/ ?>