@extends('layouts.admin') 
@section('styles') 
@stop 
@section('title') BACKUPS 
@stop 
@section('titulo') BACKUPS / NUBE 
@stop

@section('acciones')
<a href="{{url('backups/create')}}" class=" btn-create btn btn-primary waves-effect waves-light waves-round" type="button"> <i class="icon md-plus"></i>HACER UN BACKUP</a>{{--
<a href="{{url('backups/cloud')}}" class=" btn-create btn btn-default waves-effect waves-light waves-round" type="button"> <i class="icon md-cloud"></i>Ver backups en la nube</a>--}}

@stop 
@section('descripcion')
<ol class="breadcrumb breadcrumb-arrow">
    <li class="breadcrumb-item"><a href="{{url('/')}}">Inicio</a></li>
    <li class="breadcrumb-item ">Administracion</li>
    <li class="breadcrumb-item active"><a href="{{url('/backups')}}">Backups/NUBE </a></li>
</ol>






@stop 
@section('content') {{--
<div class="nav navbar-nav float-xs-right">
    <form class="form-inline pull-right" method="get" action="{{url('backups')}}">
    @include('includes.form-periodo')
        <div class="form-group form-material">
            <button type="submit" name="consulta" value="consulta" class="btn btn-outline-info waves-effect waves-light waves-round"> <i class="icon md-search"></i>Consultar</button>
        </div>
    </form>
</div> --}}

<div class="table-responsive">

    <table id="table" class="data-table table table-hover  table-striped">
        <thead>
            <tr>
                <th>NUMERO</th>
                <th>FECHA</th>
                <th>ARCHIVO</th>
                <th>ACCIONES</th>
            </tr>
        </thead>
        <tbody>
            @foreach($datos as $f=>$r)
            <tr>
                <td width="1%">{{$f+1}}</td>
                <td>{{$r->modifiedTime}}</td>
                <td>{{$r->name}}</td>
                <td>
                    <a href="{{url('backups/download-nube')}}/{{$r->id}}"><i class=" icon md-download"></i> Descargar</a>
                </td>

            </tr>
            @endforeach
        </tbody>
    </table>
</div>


<div class="modal-ver modal fade modal-slide-in-right" id="exampleNiftySlideFromRight" aria-hidden="true" aria-labelledby="exampleModalTitle"
    role="dialog" tabindex="-1">
    <div class="modal-dialog modal-simple">
        <div class="modal-content">

            <div class="modal-body">

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-danger " data-dismiss="modal">Cerrar</button>

            </div>
        </div>
    </div>
</div>
    @include('includes.modal-kardex') 
@section('scripts')
<script src="{{asset('assets/js/jquery.PrintArea.js')}}" type="text/javascript"></script>

<script>
    function alerta(id)
        {
             $.ajax({
               url:'./libros/'+id+'/edit',
                method:'GET',
                dataType:'html',
                success:function(res){
                    $('.modales').empty();
                    $('.modales').append(res)
                    $('.modal-edit').modal('show')
                    select2();
                },
                error:function(){
                    alert('ocurrio un error')
                }
            })

        }

        function imprimir(){
            var options = { mode : "iframe", popClose : close,  retainAttr : ['class','style','id'] };

            $('#myPrintArea').printArea();


        }


function imprimirNota(id){
            let url='notas-remision/'+id+'/ver'
    $.ajax({
        url:url,
        method:'GET',
        dataType:'HTML',
        async:false,
        cache:false,
        success:function(res)
        {

            $('.modal-ver').find('.modal-body').empty();
            $('.modal-ver').find('.modal-body').html(res)
            $('.modal-ver').modal('show')

        }
    })
}
        $(document).ready(function(){
    // $(".data-table").tableHeadFixer();


    

            @if(isset($imprimir) && $imprimir )
                    imprimirNota({{$remision}})
                    @endif


            $('.btn-anular').click(function(_evt){
                _evt.preventDefault();
                let _href=$(this).attr('href')
                let _id=$(this).attr('id')
                swal({
                        title: "Esta seguro?",
                        text: "Se anulara la Remision Num:"+_id,
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonClass: "btn-warning",
                        confirmButtonText: "Si, Anular!",
                        cancelButtonText:"Cancelar",
                        closeOnConfirm: false
                    },
                    function() {
                        $.ajax({
                            url: './notas-remision/' + _id + '/validar-anular',
                            method: 'get',
                            dataType: 'json',
                            success: function (res) {
                                if (res.status) {

                                    swal('Alerta', 'No se puede anular la nota. Existen items  asociados a otras notas', 'warning')

                                }
                                else {
                                    window.location = _href

                                }

                            },
                            error: function () {
                                alert('Ocurrio un error en el servidor')
                            }
                        })



                    });


            });

            $('.btn-ver').click(function(_evt){
                _evt.preventDefault();
                let url=$(this).attr('href')
                $.ajax({
                    url:url,
                    method:'GET',
                    dataType:'HTML',
                    async:false,
                    cache:false,
                    success:function(res)
                    {

                        $('.modal-ver').find('.modal-body').empty();
                        $('.modal-ver').find('.modal-body').html(res)
                $('.modal-ver').modal('show')

                    }
                })
            });

            $('.btn-procesar').click(function(_evt){
                _evt.preventDefault();
                _href=$(this).attr('href')

                swal({
                        title: "Esta seguro?",
                        text: "Se Procesara esta nota de remision  y ya no  podra editar:",
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonClass: "btn-danger",
                        confirmButtonText: "Si, Procesar!",
                        cancelButtonText:"Cancelar",
                        closeOnConfirm: false
                    },
                    function(){
                        window.location=_href
                    });

            })



            var select2=function(){


                $('body .select2').select2({
                    placeholder: 'Seleccione una opcion',
                    multiple:false,
                    width:'90%'
                });

            }


            $('.btn-delete').click(function(_evt){
                _evt.preventDefault();

                var _href=$(this).attr('href')
                var _id=$(this).attr('id')


                swal({
                        title: "Esta seguro?",
                        text: "Se eliminara la nota de remision Num:"+_id,
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonClass: "btn-danger",
                        confirmButtonText: "Si, Eliminar!",
                        cancelButtonText:"Cancelar",
                        closeOnConfirm: false
                    },
                    function(){
                        window.location=_href
                    });

            })





            $('.btn-create').click(function(){
                $('.modal-create').modal('show')
                select2()
            })



            $('body .btn-edit').on('click',function(){
                            var id=$(this).attr('id')


                $.ajax({
                   url:'./libros/'+id+'/edit',
                    method:'GET',
                    dataType:'html',
                    success:function(res){
                        $('.modales').empty();
                        $('.modales').append(res)
                        $('.modal-edit').modal('show')
                        select2();
                    },
                    error:function(){
                        alert('ocurrio un error')
                    }
                })
            })
        })

</script>
































@stop
@endsection