@extends('layouts.admin')
@section('title')Categorias @stop
@section('titulo')CATEGORIAS @stop
@section('menu-catalogo')active open @stop
@section('categorias-opcion')active  @stop
@section('acciones')
    <button class=" btn-create btn btn-primary waves-effect waves-light waves-round"  type="button"> <i class="icon md-plus"></i>Registrar categoria</button>

@stop
@section('descripcion')
    <ol class="breadcrumb breadcrumb-arrow">
        <li class="breadcrumb-item"><a href="{{url('/')}}">Inicio</a></li>
        <li class="breadcrumb-item active">Categorias</li>
    </ol>
@stop
@section('content')
    {{--modal--}}
    @include('categorias.create_edit')
    <div class="modales">
    </div>

    <div class=" btn-group col-md-2 float-right ">
        <a href="{{url('categorias/excel/')}}" class="btn btn-outline-success">EXCEL</a>
        <a href="{{url('categorias/pdf/')}}" class="btn btn-outline-danger">PDF</a>
    </div>
    <div class="clearfix"></div>
    <br>

    <div class="col-md-12 table-responsive">
@include('categorias.table')
    </div>

    {{--</div>--}}

@section('scripts')

    <script>

        function editar(id)
        {

            $.ajax({
                url:'./categorias/'+id+'/edit',
                method:'GET',
                dataType:'html',
                success:function(res){
                    $('.modales').empty();
                    $('.modales').append(res)
                    $('.modal-edit').modal('show')

                },
                error:function(){
                    alert('ocurrio un error')
                }
            })

        }



        $(document).ready(function(){


            $('.btn-delete').click(function(_evt){
                _evt.preventDefault();

                var _href=$(this).prop('href')

                swal({
                        title: "Esta seguro?",
                        text: "Se eliminara la categoria de los registros!. ademas tambien eliminaran los libros asociados a esta categoria",
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonClass: "btn-danger",
                        confirmButtonText: "Si, Eliminar!",
                        cancelButtonText:"Cancelar",
                        closeOnConfirm: false
                    },
                    function(){
                        window.location=_href
                    });

            })





            $('.btn-create').click(function(){
                $('.modal-create').modal('show')

            })

        })


    </script>
@stop


@endsection