@extends('layouts.admin')
@section('title')Editoriales @stop
@section('titulo')EDITORIALES @stop
@section('menu-catalogo')active open @stop
@section('editoriales-opcion')active  @stop
@section('acciones')
    <button class=" btn-create btn btn-primary waves-effect waves-light waves-round"  type="button"> <i class="icon md-plus"></i>Registrar editorial</button>

@stop
@section('descripcion')
    <ol class="breadcrumb breadcrumb-arrow">
        <li class="breadcrumb-item"><a href="{{url('/')}}">Inicio</a></li>
        <li class="breadcrumb-item active">Editoriales</li>
    </ol>
@stop
@section('content')
    {{--modal--}}
    @include('editoriales.create_edit')
    <div class="modales">
    </div>
    <div class=" btn-group col-md-2 float-right ">
        <a href="{{url('editoriales/excel/')}}" class="btn btn-outline-success">EXCEL</a>
        <a href="{{url('editoriales/pdf/')}}" class="btn btn-outline-danger">PDF</a>
    </div>

    <div class="table-responsive">

    <table  id="table"  class="table table-hover  table-striped " >
        <thead>
        <tr>
            <th>N°</th>
            <th>NOMBRE</th>
            <th>DIRECCION</th>
            <th>TELEFONO</th>
            <th>EMAIL</th>

            <th>ACCIONES</th>
        </tr>
        </thead>
        <tbody>
        @foreach($editoriales as $f=>$r)
            <tr>
                <td>{{$f+1}}</td>
                <td>{{$r->nombre}}</td>
                <td>{{$r->direccion}}</td>
                <td>{{$r->telefono}}</td>
                <td>{{$r->email}}</td>

                <td>
                    <button  type="button"     onclick="editar({{$r->id}})" class=" btn btn-sm btn-icon btn-pure btn-default on-default edit-row waves-effect waves-light waves-round" data-toggle="tooltip" data-original-title="Editar"><i class="icon md-edit" aria-hidden="true"></i></button>
                    <a href="editoriales/{{$r->id}}/destroy" class="btn-delete btn btn-sm btn-icon btn-pure btn-default on-default remove-row waves-effect waves-light waves-round" data-toggle="tooltip" data-original-title="Eliminar"><i class="icon md-delete" aria-hidden="true"></i></a>
                </td>

            </tr>
        @endforeach
        </tbody>
    </table>
    </div>

@section('scripts')

    <script>

        function editar(id)
        {

            $.ajax({
               url:'./editoriales/'+id+'/edit',
                method:'GET',
                dataType:'html',
                success:function(res){
                    $('.modales').empty();
                    $('.modales').append(res)
                    $('.modal-edit').modal('show')

                },
                error:function(){
                    alert('ocurrio un error')
                }
            })

        }



        $(document).ready(function(){

            $('.btn-delete').click(function(_evt){
                _evt.preventDefault();

                var _href=$(this).prop('href')

                swal({
                        title: "Esta seguro?",
                        text: "Se eliminara la editorial de los registros!",
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonClass: "btn-danger",
                        confirmButtonText: "Si, Eliminar!",
                        cancelButtonText:"Cancelar",
                        closeOnConfirm: false
                    },
                    function(){
                        window.location=_href
                    });

            })





            $('.btn-create').click(function(){
                $('.modal-create').modal('show')
            })

        })

        $('#table').dataTable({

        })
    </script>
@stop


@endsection