@extends('layouts.admin')
@section('title') permisos @stop
@section('titulo')Registro de permisos  @stop
@section('menu-egreso') active open @stop
{{--@section('libros-opcion')active  @stop--}}
@section('acciones')

@stop
@section('descripcion')
    <ol class="breadcrumb breadcrumb-arrow">
        <li class="breadcrumb-item"><a href="{{url('/')}}">Inicio</a></li>
        <li class="breadcrumb-item ">Administracion</li>
        <li class="breadcrumb-item active"><a href="{{url('roles')}}">Roles de usuario</a></li>
        <li class="breadcrumb-item active">Registrar Rol de usuario
    </ol>
@stop
@section('content')

    {{-- <form style="border: 1px solid" autocomplete="off" method="post" action="{{url('roles/store')}}" class="form row">
        {!! csrf_field() !!}

        @if(isset($role))
            <input type="hidden" name="id" value="{{$role->id}}">
            @endif
        <div class=" col-md-12 form-group-material">
            <label for="" class="control-label"><strong>NOMBRE DEL ROL</strong></label>
            <input type="text" @if(isset($role)) value="{{$role->name}}" @endif required class="form-control form-material" name="nombre">
        </div>


        <div class=" col-md-3 ">
            <div class="heading">
                <h4>MODULO ALMACEN</h4>
            </div>
            <div class="">
                <ul class="list-unstyled">
                   @foreach($permisos->where('modulo','almacen')->sortBy('name') as $k)
                    <li><input type="checkbox" @if (isset($role) && $role->permissions->contains('id',$k->id)) checked @endif  name="permisos[]" value="{{$k->id}}"> {{strtoupper($k->name)}} {{$k->id}}</li>
                       @endforeach
                </ul>
            </div>
        </div>
        <div class=" col-md-3 ">
            <div class="heading">
                <h4>MODULO VENTAS</h4>
            </div>
            <div class="">
                <ul class="list-unstyled">
                    @foreach($permisos->where('modulo','ventas')->sortBy('name') as $k)
                        <li><input type="checkbox" @if (isset($role) && $role->permissions->contains('id',$k->id)) checked @endif name="permisos[]" value="{{$k->id}}"> {{strtoupper($k->name)}}</li>
                    @endforeach
                </ul>
            </div>
        </div>
        <div class=" col-md-3 ">
            <div class="heading">
                <h4>MODULO COBRANZA</h4>
            </div>
            <div class="">
                <ul class="list-unstyled">
                    @foreach($permisos->where('modulo','cobranza')->sortBy('name') as $k)
                        <li><input type="checkbox"  @if (isset($role) && $role->permissions->contains('id',$k->id)) checked @endif name="permisos[]" value="{{$k->id}}"> {{strtoupper($k->name)}}</li>
                    @endforeach
                </ul>
            </div>
        </div>
        <div class=" col-md-3">
            <div class="heading">
                <h4>MODULO ADMINISTRACION</h4>
            </div>
            <div class="">
                <ul class="list-unstyled">
                    @foreach($permisos->where('modulo','admin')->sortBy('name') as $k)
                        <li><input type="checkbox"@if (isset($role) && $role->permissions->contains('id',$k->id)) checked @endif  name="permisos[]" value="{{$k->id}}"> {{strtoupper($k->name)}}</li>
                    @endforeach

                </ul>
            </div>
        </div>
        <hr>
        <button  type="submit" class="btn  btn-block btn-outline-success"><i class="icon md-save"></i> Guardar</button>




    </form> --}}
  <form style="border: 1px solid" autocomplete="off" method="post" action="{{url('roles/store')}}" class="form row">
        {!! csrf_field() !!}

        @if(isset($role))
            <input type="hidden" name="id" value="{{$role->id}}">
            @endif
        <div class=" col-md-12 form-group-material">
            <label for="" class="control-label"><strong>NOMBRE DEL ROL</strong></label>
            <input type="text" @if(isset($role)) value="{{$role->name}}" @endif required class="form-control form-material" name="nombre">
        </div>


        <div class=" col-md-3 ">
            <div class="heading">
                <h4>MODULO ALMACEN</h4>
            </div>
            <div class="">
                <ul class="list-unstyled">
                   @foreach($permisos->where('modulo','almacen')->sortBy('name') as $k)
                    <li><input type="checkbox" @if (isset($role) && $role->permissions->contains('id',$k->id)) checked @endif  name="permisos[]" value="{{$k->id}}"> {{strtoupper($k->name)}} {{$k->id}}</li>
                       @endforeach
                </ul>
            </div>
        </div>
        <div class=" col-md-3 ">
            <div class="heading">
                <h4>MODULO VENTAS</h4>
            </div>
            <div class="">
                <ul class="list-unstyled">
                    @foreach($permisos->where('modulo','ventas')->sortBy('name') as $k)
                        <li><input type="checkbox" @if (isset($role) && $role->permissions->contains('id',$k->id)) checked @endif name="permisos[]" value="{{$k->id}}"> {{strtoupper($k->name)}}</li>
                    @endforeach
                </ul>
            </div>
        </div>
        <div class=" col-md-3 ">
            <div class="heading">
                <h4>MODULO COBRANZA</h4>
            </div>
            <div class="">
                <ul class="list-unstyled">
                    @foreach($permisos->where('modulo','cobranza')->sortBy('name') as $k)
                        <li><input type="checkbox"  @if (isset($role) && $role->permissions->contains('id',$k->id)) checked @endif name="permisos[]" value="{{$k->id}}"> {{strtoupper($k->name)}}</li>
                    @endforeach
                </ul>
            </div>
        </div>
        <div class=" col-md-3">
            <div class="heading">
                <h4>MODULO ADMINISTRACION</h4>
            </div>
            <div class="">
                <ul class="list-unstyled">
                    @foreach($permisos->where('modulo','admin')->sortBy('name') as $k)
                        <li><input type="checkbox"@if (isset($role) && $role->permissions->contains('id',$k->id)) checked @endif  name="permisos[]" value="{{$k->id}}"> {{strtoupper($k->name)}}</li>
                    @endforeach

                </ul>
            </div>
        </div>
        <hr>
        <button  type="submit" class="btn  btn-block btn-outline-success"><i class="icon md-save"></i> Guardar</button>




    </form>

@section('scripts')

    <script>
        var codigos=[]

        function buscarCodigo(codigo){
            var sw=false;
            if(codigos.indexOf(codigo)!=-1)
                sw=true;
            return sw;
        }

        function numerosTabla(){
            var cant=0;
            var pt=0;
            $('.table-detalle tbody tr').each(function(k,v){

                $(v).find('td:first').html(k+1)
                cant+=parseInt($(v).find('.td-cant').val())
                pt+=parseFloat($(v).find('.td-pt').val())


            });
            return {
                cant:cant,
                pt:pt
            }
        }

        function limpiar(){
            $('.limpiar').val('')
            $('#select3').val('').trigger('change');
            $('#select3').focus()



        }

        function addFila(datos){
            var fila='<tr>';
            fila+='<td></td>'+
                '<td class=" text-left   "><input type="text" class="td-cant" name="cant[]" readonly size="5%" value="'+datos.cantidad+'"></td>'+
                '<td  ><strong class="td-codigo" ">'+datos.codigo+'</strong></td>'+
                '<td>'+datos.titulo+'</td>'+
                '<td>'+datos.tomo+'</td>'+
                '<td><input type="text" value="'+datos.precio+'"  readonly size="7%" name="precio_unitario[]"/></td>'+
                '<td><input type="text" class="td-pt" value="'+datos.precio_total+'"  readonly size="7%" name="precio_total_detalle[]"/></td>'+
                '<td><input type="text" size="10%" name="observacion[]"/><input type="hidden" name="libro_id[]" value="'+datos.id+'"></td>'+
                '<td><button class="brn btn-xs btn-danger" onclick="remove(this)"><i class="icon md-close"></i>Borrar</button></td>'+
                '</tr>';

            $('.table-detalle tbody').append(fila)
            codigos.push(datos.codigo)


            limpiar();
            $('.visible').show()
            $('.cant_total').val(numerosTabla().cant)
            $('.precio_total').val(numerosTabla().pt)

        }


        function remove(btn)
        {
            limpiar();
            let codigo=$(btn).closest('tr').find('.td-codigo').html()
            let cant=$(btn).closest('tr').find('.td-cant').val()
            $(btn).closest('tr').remove()
            _cantfilas=$('.table-detalle tbody tr').length;
            if(_cantfilas<=0){
                $('.visible').hide();
            }


            $('.cant_total').val(numerosTabla().cant)
            $('.precio_total').val(numerosTabla().pt)
            borrarArray(codigo)

        }

        function borrarArray(valor){
            var index = codigos.indexOf(valor);
            if (index > -1) {
                codigos.splice(index, 1);
                return true;
            }
            return false;

        }

        $(document).ready(function(){

            @if(isset($egreso))
            $('.table-detalle tbody tr').each(function(k,v){

                let codigo=$(v).find('.td-codigo').html()
                codigos.push(codigo)
            });
            @endif

            $('.select3').on('select2:selecting', function(e) {
                let pu =e.params.args.data.element.attributes.precio.value;
                let stock =e.params.args.data.element.attributes.stock.value;


                if(parseInt(pu)<=0 || pu=='' || typeof(pu)=='undefined'){
                    $('.pu').val(0)
                }
                else{
                    $('.pu').val(pu)
                }
                $('#stock').val(stock)

                $('#cantidad').focus()
            });
            $('.btn-guardar').click(function(){
                if($('.datepicker').val()==''){
                    swal('Alerta','Debe seleccionar una Fecha','warning')

                    return false;
                }

                swal({
                        title: "Guardar nota de egreso",
                        text: "Revise que todos los campos esten llenados correctamente.",
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonClass: "btn-success",
                        confirmButtonText: "Si, Guardar!",
                        cancelButtonText:"Cancelar",
                        closeOnConfirm: false
                    },
                    function(){
                        $('.form').submit();
                    });


            })


            $('.btn-add').click(function(){
                let titulo =$('.select3').find(":selected").attr("titulo")
                let codigo =$('.select3').find(":selected").attr("codigo")
                let tomo =$('.select3').find(":selected").attr("tomo")
                let stock =$('.select3').find(":selected").attr("stock")
                let precio=$('.select3').find(":selected").attr('precio')
                let id =$('.select3').find(":selected").val()
                let cantidad=$('.cantidad').val()


                if(buscarCodigo(codigo)){
                    swal('Alerta','Este codigo ya se encuentra registrado','warning')
                    return false;
                }
                if(cantidad=='' || parseInt(cantidad)<=0){
                    swal('Alerta','Ingrese una cantidad valida','warning')
                    return false;
                }
                if(parseInt(cantidad)>parseInt(stock)){
                    swal('Alerta','No hay suficiente stock','warning')
                    return false;
                }


                var precio_total=(parseInt(cantidad)*parseFloat(precio)).toFixed(2);

                let datos={
                    titulo:titulo,
                    codigo:codigo,
                    tomo:tomo,
                    id:id,
                    cantidad:cantidad,
                    precio:precio,
                    precio_total:precio_total
                }

                addFila(datos)

            })

            $('.select3').select2({
                placeholder: 'Seleccione una opcion',
                multiple:false,
                width:'90%'
            });

        })
    </script>
@stop


@endsection