@extends('layouts.admin')
@section('title') Contratos Anulados @stop
@section('titulo') CONTRATOS ANULADOS @stop


@section('descripcion')
    <ol class="breadcrumb breadcrumb-arrow">
        <li class="breadcrumb-item"><a href="{{url('/')}}">Inicio</a></li>
        <li class="breadcrumb-item ">Ventas</li>
        <li class="breadcrumb-item active"><a href="{{url('/contratos-anulados')}}">Contratos anulados</a></li>
    </ol>
@stop
@section('content')
    @include('includes.modal-ver')

    <div class="col-md-12 nav navbar-nav ">
        <form class="row col-md-12  " method="get" action="{{url('contratos-anulados')}}" >


            <div class=" col-md-2 form-group ">

                <select name="tipo" id=""  class=" tipo-filtro form-control">
                    <option value="">Seleccione Filtro</option>
                    <option @if(isset($tipo) && $tipo=='mes') selected @endif value="mes">FILTRO POR MES</option>
                    <option @if(isset($tipo) && $tipo=='rango') selected @endif value="rango">FILTRO POR RANGO DE FECHAS</option>
                    <option @if(isset($tipo) && $tipo=='acumulado') selected @endif value="acumulado">FILTRO ACUMULADO</option>
                </select>
            </div>

            <div class="filtro-mes col-md-3" @if(isset($tipo) && $tipo=='mes') style="display:block" @else style="display: none" @endif>
                <div class="input-group ">
                    {{--<span class="icon md-calendar"></span></label>--}}
                    <select name="mes"  class="form-control" id="mes">
                        <option value="1"  @if(isset($mes) && $mes==1) selected @endif>ENERO</option>
                        <option value="2"  @if(isset($mes) && $mes==2) selected @endif>FEBRERO</option>
                        <option value="3"  @if(isset($mes) && $mes==3) selected @endif>MARZO</option>
                        <option value="4"  @if(isset($mes) && $mes==4) selected @endif>ABRIL</option>
                        <option value="5"  @if(isset($mes) && $mes==5) selected @endif>MAYO</option>
                        <option value="6"  @if(isset($mes) && $mes==6) selected @endif>JUNIO</option>
                        <option value="7"  @if(isset($mes) && $mes==7) selected @endif>JULIO</option>
                        <option value="8"  @if(isset($mes) && $mes==8) selected @endif>AGOSTO</option>
                        <option value="9"  @if(isset($mes) && $mes==9) selected @endif>SEPTIEMBRE</option>
                        <option value="10"  @if(isset($mes) && $mes==10) selected @endif>OCTUBRE</option>
                        <option value="11"  @if(isset($mes) && $mes==11) selected @endif>NOVIEMBRE</option>
                        <option value="12"  @if(isset($mes) && $mes==12) selected @endif>DICIEMBRE</option>
                    </select>
                    <label class="input-group-addon bg-info"for="date">
                        <span class="">De</span></label>
                    <select name="anio" id="anio" class="form-control">
                        @for($i=2016; $i<=2030; $i++)
                            <option value="{{$i}}" @if(isset($anio) && $anio==$i) selected @endif>{{$i}}</option>
                        @endfor
                    </select>
                </div>
                {{--            @include('includes.form-periodo')--}}
            </div>
            <div class="  filtro-rango" @if(isset($tipo) && $tipo=='rango') style="display:block" @else style="display: none" @endif>
                <div class="input-group ">
                    {{--<span class="icon md-calendar"></span></label>--}}
                    <input @if(isset($fecha_ini) ) value="{{$fecha_ini->format('d/m/Y')}}" @endif readonly name="fecha_ini" type="text" class="datepicker input-group-addon form-control">
                    <label class="input-group-addon bg-info" for="date">
                        <span class="">hasta</span></label>
                    <input @if(isset($fecha_fin) )value="{{$fecha_fin->format('d/m/Y')}}" @endif readonly name="fecha_fin" type="text" class="datepicker input-group-addon form-control">
                </div>

            </div>
            <div class="filtro-acumulado" @if(isset($tipo) && $tipo=='acumulado') style="display:block" @else style="display: none" @endif>
                <div class="form-group">

                    <input type="text" readonly name="fecha_acumulado"  value="{{$fecha_acumulado->format('d/m/Y')}}" class="form-control datepicker" >
                </div>

            </div>

            <div class="form-group form-material">
                <button type="submit" name="buscar" value="buscar" class="btn btn-outline-info waves-effect waves-light waves-round"> <i class="icon md-search"></i>Consultar</button>
            </div>
        </form>
    </div>

    <div class="table-responsive">

        <table  id="table"  class=" data-table table table-hover  table-striped " >
            <thead>
            <tr>
                <th>ID</th>
                <th>FECHA <br> CONTRATO</th>
                <th>NUM CONTRATO</th>
                <th>TIPO VENTA</th>
                <th>MONTO CONTRATO</th>
                <th>TIPO CONTRATO</th>
                <th>VENDEDOR</th>
                <th>CHOFER</th>
                <th>NOMBRE CLIENTE</th>
                <th>APELLIDOS CLIENTE</th>
                <th>ACCIONES</th>
            </tr>
            </thead>
            <tbody>
            @foreach($datos as $f=>$r)
                <tr>

                    <td width="1%">{{$r->id}}</td>
                    <td>{{$r->fechacontrato->format('d/m/Y')}}</td>
                    <td>{{$r->numcontrato}}</td>
                    <td>{{$r->tipoventa}}</td>
                    <td >{{$r->preciototal}}</td>
                    <td >{{$r->tipocontrato}}</td>
                    <td >@if(isset($r->vendedor))
                        {{$r->vendedor->nombre_completo}}
                        @endif
                    </td>
                    <td >
                    @if(isset($r->chofer))
                        {{$r->chofer->nombre_completo}}
                    @endif
                    </td>
                    <td>{{$r->nombres}}</td>
                    <td>{{$r->apellidos}}</td>
                    <td>
                        <div class="btn-toolbar" role="toolbar">
                            <a href="diferidos/{{$r->id}}/ver" class="btn-ver btn btn-icon btn-pure btn-default on-default remove-row waves-effect waves-light waves-round" data-toggle="tooltip" data-original-title="Ver Contrato"><i class="icon md-open-in-new" aria-hidden="true"></i></a>

                            {{-- <a  href="{{url('contratos-anulados/'.$r->id.'/ver-devolucion')}}" class=" btn btn-ver-devolucion  btn-icon btn-pure btn-default on-default edit-row waves-effect waves-light waves-round" data-toggle="tooltip" data-original-title="Ver nota de devolucion">ND</a> --}}


                        </div>
                    </td>

                </tr>
            @endforeach
            </tbody>
        </table>
    </div>


@section('scripts')
    <script src="{{asset('assets/js/jquery.PrintArea.js')}}" type="text/javascript"></script>

    <script>
        function imprimir(){
            var options = { mode : "iframe", popClose : close,  retainAttr : ['class','style','id'] };

            $('#myPrintArea').printArea();


        }
        $(document).ready(function(){

            $('.btn-ver-devolucion').click(function(_evt){
                _evt.preventDefault();
                let url=$(this).attr('href')
                $.ajax({
                    url:url,
                    method:'GET',
                    dataType:'html',
                    success:function(res)
                    {
                        $('.modal-ver').find('.modal-body').empty();
                        $('.modal-ver').find('.modal-body').append(res)
                        $('.modal-ver').modal('show')

                    }
                })
            });

            $('.tipo-filtro').change(function(){

                let valor=$(this).val();

                switch(valor){
                    case 'mes': $('.filtro-mes').show(); $('.filtro-acumulado').hide(); $('.filtro-rango').hide(); break;
                    case 'rango': $('.filtro-rango').show(); $('.filtro-acumulado').hide(); $('.filtro-mes').hide(); break;
                    case 'acumulado': $('.filtro-acumulado').show(); $('.filtro-mes').hide(); $('.filtro-rango').hide(); break;
                }

            })

            $('.btn-ver').click(function(_evt){
                _evt.preventDefault();
                let _url=$(this).attr('href')

                $.ajax({
                    url:_url,
                    method:'GET',
                    dataType:'html',
                    success:function(res)
                    {
                        $('.modal-ver').find('.modal-body').empty();
                        $('.modal-ver').find('.modal-body').append(res)
                        $('.modal-ver').modal('show')

                    }
                })
            })


        })


    </script>
@stop


@endsection