@extends('layouts.admin')
@section('title') Agenda @stop
@section('titulo') AGENDA @stop

{{--@section('libros-opcion')active @stop--}}
@section('acciones')
{{-- <a href="{{url('notas-remision/create')}}" class=" btn-create btn btn-primary waves-effect waves-light waves-round" type="button"> <i class="icon md-plus"></i>Nueva Remision</a>--}}


@stop
@section('descripcion')
<ol class="breadcrumb breadcrumb-arrow">
    <li class="breadcrumb-item"><a href="{{url('/')}}">Inicio</a></li>
    <li class="breadcrumb-item ">Ventas</li>
    <li class="breadcrumb-item active"><a href="{{url('/reportes-ventas')}}">Reportes</a></li>
    <li class="breadcrumb-item active">COBRO CUOTAS INICIALES</li>
</ol>
@stop
@section('content')

<div class="col-md-12">
    <form class="form-inline " method="POST" action="{{url('reportes-ventas/agenda')}}">
        {!! csrf_field() !!}
        <div class=" col-md-2">
            <label for="name" class="control-label">FILTRO</label>
            <select name="filtro" id="filtro" class="form-control">
                <option value="MES" @if($filtro=='MES' ) selected @endif>POR MES</option>
                <option value="RANGO" @if ($filtro=='RANGO' ) selected @endif>RANGO DE FECHAS</option>
                <option value="ACUMULADO" @if ($filtro=='ACUMULADO' ) selected @endif>ACUMULADO</option>
            </select>
        </div>
        <div class=" div-mes col-md-1">
            <label for="name" class="control-label">MES</label>
            <select name="mes" class="form-control form-control-sm" id="mes">
                <option value="1" @if(isset($mes) && $mes==1) selected @endif>ENERO</option>
                <option value="2" @if(isset($mes) && $mes==2) selected @endif>FEBRERO</option>
                <option value="3" @if(isset($mes) && $mes==3) selected @endif>MARZO</option>
                <option value="4" @if(isset($mes) && $mes==4) selected @endif>ABRIL</option>
                <option value="5" @if(isset($mes) && $mes==5) selected @endif>MAYO</option>
                <option value="6" @if(isset($mes) && $mes==6) selected @endif>JUNIO</option>
                <option value="7" @if(isset($mes) && $mes==7) selected @endif>JULIO</option>
                <option value="8" @if(isset($mes) && $mes==8) selected @endif>AGOSTO</option>
                <option value="9" @if(isset($mes) && $mes==9) selected @endif>SEPTIEMBRE</option>
                <option value="10" @if(isset($mes) && $mes==10) selected @endif>OCTUBRE</option>
                <option value="11" @if(isset($mes) && $mes==11) selected @endif>NOVIEMBRE</option>
                <option value="12" @if(isset($mes) && $mes==12) selected @endif>DICIEMBRE</option>
            </select>
        </div>
        <div class=" div-anio col-md-1">
            <label for="name" class="control-label">AÑO</label>
            <select name="anio" id="anio" class="form-control form-control-sm">
                @for($i=2016; $i<=2030; $i++) <option value="{{$i}}" @if(isset($anio) && $anio==$i) selected @endif>{{$i}}</option>
                    @endfor
            </select>
        </div>
        <div class="div-fecha-ini col-md-2" @if($filtro=="rango" ) style="display: block" @else style="display: none;" @endif>
            <label for="name" class="control-label">FECHA INICIAL </label>
            <input type="text" name="fecha_ini" readonly value="{{$fecha_ini->format('d/m/Y')}}" class="datepicker  fecha_ini form-control form-control-sm">
        </div>
        <div class=" div-fecha-fin col-md-2" @if($filtro=='rango' ) style="display: block" @else style="display: none" @endif>
            <label for="name" class="control-label">FECHA FIN</label>
            <input type="text" name="fecha_fin" readonly value="{{$fecha_fin->format('d/m/Y')}}" class="datepicker fecha_fin form-control form-control-sm">
        </div>
        <div class=" div-fecha-acumulado col-md-2" @if($filtro=='acumulado' ) style="display: block" @else style="display: none" @endif>
            <label for="name" class="control-label">FECHA ACUMULADO</label>
            <input type="text" name="fecha_acumulado" readonly value="{{$fecha_acumulado->format('d/m/Y')}}" class="datepicker fecha_acumulado form-control form-control-sm">
        </div>
        <div class=" col-md-2 ">

            <label for="">Referencia</label>
            <input readonly type="text" class="datepicker form-control" value="{{$fecha_ref->format('d/m/Y')}}" name="fecha_ref">
        </div>
        <div class=" col-md-3  ">
            <label for="">VENDEDORES</label>
            <select name="vendedor" id="" class="form-control">
                <option value="0">TODOS</option>
                @foreach($vendedores as $k=>$v)
                <option value="{{$v->id}}" @if($vendedor==$v->id) selected @endif>{{$v->nombre_completo}}</option>
                @endforeach

            </select>
        </div>

        <div class=" col-md-2 mt-3 ">

        <button type="submit" name="consultar" value="consultar" class="btn btn-outline-info waves-effect waves-light waves-round"> <i class="icon md-search"></i>Consultar</button>

        </div>


    </form>
</div>
@if(count($datos)>0)
<div class="btn-group col-md-2 float-right " role="group">
    <form method="POST" action="{{url('reportes-ventas/agenda')}}">
        {{ csrf_field()}}

        <input type="hidden" name="filtro" value="{{$filtro}}">
        <input type="hidden" name="mes" value="{{$mes}}">
        <input type="hidden" name="anio" value="{{$anio}}">
        <input type="hidden" name="fecha_ini" value="{{$fecha_ini->format('d/m/Y')}}">
        <input type="hidden" name="fecha_fin" value="{{$fecha_fin->format('d/m/Y')}}">
        <input type="hidden" name="fecha_acumulado" value="{{$fecha_acumulado->format('d/m/Y')}}">
        <input type="hidden" name="fecha_ref" value="{{$fecha_ref->format('d/m/Y')}}">
        <input type="hidden" name="vendedor" value="{{$vendedor}}">
        <input type="hidden" name="consultar" value="consultar">
        <button name="tipoexportacion" value="excel" class="btn btn-outline-success">EXCEL</button>
        <button name="tipoexportacion" value="pdf" class="btn btn-outline-danger">PDF</button>
    </form>

</div>

</div>
@endif

<div class="table-responsive">

    @if(count($datos)>0)
    @include('ventas.reportes.agenda.tabla-agenda')

    {{-- @include('almacen.reportes.tabla-movimiento')--}}
    @else
    <h4 class="text text-primary text-center">NO SE ENCONTRARON REGISTROS.</h4>
    @endif
</div>



@section('scripts')

<script>
    $(document).ready(function() {
        $('#filtro').change(function() {
            if ($(this).val() == 'MES') {
                $('.div-mes').show()
                $('.div-anio').show()
                $('.div-fecha-ini').hide()
                $('.div-fecha-fin').hide()
                $('.div-fecha-acumulado').hide()
            }
            if ($(this).val() == 'RANGO') {
                $('.div-mes').hide()
                $('.div-anio').hide()
                $('.div-fecha-ini').show()
                $('.div-fecha-fin').show()
                $('.div-fecha-acumulado').hide()
            }
            if ($(this).val() == 'ACUMULADO') {
                $('.div-mes').hide()
                $('.div-anio').hide()
                $('.div-fecha-ini').hide()
                $('.div-fecha-fin').hide()
                $('.div-fecha-acumulado').show()
            }
        })

        $('.select2').select2({
            placeholder: 'Seleccione una opcion',
            multiple: false,
            width: '90%'
        });

    })
</script>
@stop


@endsection