@extends('layouts.admin')
@section('title') Planilla Produccion @stop
@section('titulo') PLANILLA DE PRODUCCION @stop

{{--@section('libros-opcion')active  @stop--}}
@section('acciones')
    {{--    <a href="{{url('notas-remision/create')}}" class=" btn-create btn btn-primary waves-effect waves-light waves-round"  type="button"> <i class="icon md-plus"></i>Nueva Remision</a>--}}


@stop
@section('descripcion')
    <ol class="breadcrumb breadcrumb-arrow">
        <li class="breadcrumb-item"><a href="{{url('/')}}">Inicio</a></li>
        <li class="breadcrumb-item ">Ventas</li>
        <li class="breadcrumb-item active"><a href="{{url('/reportes-ventas')}}">Reportes</a></li>
        <li class="breadcrumb-item active">PLANILLA PRODUCCION</li>
    </ol>
@stop
@section('content')



        <form class="form-inline" method="post" action="{{url('reportes-ventas/planilla-produccion')}}" >
            {!! csrf_field() !!}
            <div class="form-group col-md-12">
                <div class="d-flex flex-column d" >
                    <label for="name" class="control-label">FILTRO</label>
                    <select name="filtro" id="filtro" class="form-control">
                        <option value="mes">POR MES</option>
                        <option value="rango">RANGO DE FECHAS</option>
                        <option value="acumulado">ACUMULADO</option>
                    </select>
                </div>
                <div class="flex-column div-fecha-ini" @if($filtro=="rango") style="display: block" @else style="display: none;"     @endif>
                    <label for="name" class="control-label">FECHA INICIAL {{$filtro}} </label>
                    <input type="text" name="fecha_ini" readonly value="{{$fecha_ini->format('d/m/Y')}}" class="datepicker  fecha_ini form-control">
                </div>
                <div class=" flex-column div-fecha-fin" @if($filtro=='rango') style="display: block" @else style="display: none" @endif>
                    <label for="name" class="control-label">FECHA FIN</label>
                    <input type="text" name="fecha_fin" readonly value="{{$fecha_fin->format('d/m/Y')}}" class="datepicker fecha_fin form-control">
                </div>
                <div class=" flex-column div-fecha-acumulado" @if($filtro=='acumulado') style="display: block" @else style="display: none" @endif>
                    <label for="name" class="control-label">FECHA REFERENCIA</label>
                    <input type="text"  name="fecha_acumulado" readonly value="{{$fecha_acumulado->format('d/m/Y')}}" class="datepicker fecha_acumulado form-control">
                </div>
                <div class= "">

                </div>

                    <div class="d-flex flex-column div-mes">
                        <label for="name" class="control-label">MES</label>
                        <select name="mes" class="form-control" id="mes">
                            <option value="1"  @if(isset($mes) && $mes==1) selected @endif>ENERO</option>
                            <option value="2"  @if(isset($mes) && $mes==2) selected @endif>FEBRERO</option>
                            <option value="3"  @if(isset($mes) && $mes==3) selected @endif>MARZO</option>
                            <option value="4"  @if(isset($mes) && $mes==4) selected @endif>ABRIL</option>
                            <option value="5"  @if(isset($mes) && $mes==5) selected @endif>MAYO</option>
                            <option value="6"  @if(isset($mes) && $mes==6) selected @endif>JUNIO</option>
                            <option value="7"  @if(isset($mes) && $mes==7) selected @endif>JULIO</option>
                            <option value="8"  @if(isset($mes) && $mes==8) selected @endif>AGOSTO</option>
                            <option value="9"  @if(isset($mes) && $mes==9) selected @endif>SEPTIEMBRE</option>
                            <option value="10"  @if(isset($mes) && $mes==10) selected @endif>OCTUBRE</option>
                            <option value="11"  @if(isset($mes) && $mes==11) selected @endif>NOVIEMBRE</option>
                            <option value="12"  @if(isset($mes) && $mes==12) selected @endif>DICIEMBRE</option>
                        </select>
                    </div>
                    <div class="d-flex flex-column div-anio">
                    <label for="name" class="control-label">AÑO</label>
                    <select name="anio" id="anio" class="form-control">
                        @for($i=2016; $i<=2030; $i++)
                            <option value="{{$i}}" @if(isset($anio) && $anio==$i) selected @endif>{{$i}}</option>
                        @endfor
                    </select>
                    </div>
                <div class="d-flex flex-column col-md-2">
                    <label for="name" class="control-label">TIPO CONTRATO</label>
                    <select name="contrato" id="contrato" class="form-control">
                        <option value="diferidos">VENTAS DE DIFERIDOS</option>
                        <option value="credito">VENTAS DE CREDITO</option>
                        <option value="contado">VENTAS DE CONTADO</option>
                        <option value="contado-credito">VENTAS DE CONTADO Y CREDITO</option>
                    </select>
                </div>
                <div class="d-flex flex-column col-md-3">
                    <label for="name" class="control-label">FILTRO COBRADOR</label>
                    <select name="cobrador" id="cobrador" class="form-control select2">
                        <option value="">SELECCIONE CONBRADOR</option>
                        @foreach($cobradores as $c)
                            <option value="{{$c->id}}">{{$c->nombre_completo}}</option>
                            @endforeach

                    </select>
                </div>
                <div class="d-flex flex-column col-md-3">
                    <label for="name" class="control-label">FILTRO VENDEDOR</label>
                    <select name="vendedor" id="vendedor" class="form-control select2">
                        <option value="">SELECCIONE VENDEDOR</option>
                        @foreach($vendedores as $v)
                            <option value="{{$v->id}}">{{$v->nombre_completo}}</option>
                        @endforeach

                    </select>
                </div>



            </div>
                <button name="consultar" value="consultar" class="btn btn-info btn-block"><i class="icon md-search"></i> Consultar</button>




        </form>

    @if(count($datos)>0)
        <div class="btn-group col-md-2 float-right " role="group" >
            <a href="{{url('reportes-ventas/agenda/'.$fecha_ini->format('dmY').'/'.$fecha_fin->format('dmY').'/'.$fecha_ref->format('dmY').'/excel')}}" class="btn btn-outline-success">EXCEL</a>
            <a href="{{url('reportes-ventas/agenda/'.$fecha_fin->format('dmY').'/'.$fecha_fin->format('dmY').'/'.$fecha_ref->format('dmY').'/pdf')}}" class="btn btn-outline-danger">PDF</a>

        </div>

        </div>
    @endif

    <div class="table-responsive">

        @if(count($datos)>0)
        @else
            <h4 class="text text-primary text-center">NO SE ENCONTRARON REGISTROS.</h4>
        @endif
    </div>



@section('scripts')

    <script>




        $(document).ready(function() {

            $('.select2').select2({
                placeholder: 'Seleccione una opcion',
                multiple:false,
                width:'90%'
            });

        })
    </script>
@stop


@endsection