@extends('layouts.admin')
@section('title') Relacion obras vendidas  @stop
@section('titulo') RELACION OBRAS VENDIDAS @stop


@section('descripcion')
    <ol class="breadcrumb breadcrumb-arrow">
        <li class="breadcrumb-item"><a href="{{url('/')}}">Inicio</a></li>
        <li class="breadcrumb-item ">Ventas</li>
        <li class="breadcrumb-item active"><a href="{{url('/reportes-ventas')}}">Reportes</a></li>
        <li class="breadcrumb-item active">RELACION OBRAS VENDIDAS</li>
    </ol>
@stop
@section('content')



    <div class="nav navbar-nav float-xs-right">
        <form class="form-inline pull-right" method="get" action="{{url('reportes-ventas/relacion-vendidas')}}" >
            @include('includes.form-periodo')
            <div class="form-group form-material">
                <button type="submit" name="consulta"  value="consulta" class="btn btn-outline-info waves-effect waves-light waves-round"> <i class="icon md-search"></i>Consultar</button>
            </div>
        </form>
    </div>
    <hr>
    @if(count($datos)>0)

        <div class="nav navbar-nav float-right">
            <form class="form-inline pull-right" method="post" action="{{url('reportes-ventas/relacion-vendidas')}}" >
                {!! csrf_field() !!}

                <input type="hidden" name="mes" value="{{$mes}}">
                <input type="hidden" name="anio" value="{{$anio}}">
                <input type="hidden" name="consulta" value="consulta">

                <button name="tipoexportacion" value="excel" class="btn btn-outline-success">EXCEL</button>
                <button name="tipoexportacion" value="pdf" class="btn btn-outline-danger">PDF</button>
            </form>
        </div>
    @endif

    <div class="table-responsive">

        @if(count($datos)>0)
            @include('ventas.reportes.relacion_vendidas.tabla')
        @else
            <h4 class="text text-primary text-center">NO SE ENCONTRARON REGISTROS.</h4>
        @endif
    </div>



@section('scripts')

    <script>

        $(document).ready(function() {


        })
    </script>
@stop


@endsection